/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMTrayIcon.cpp

Description:

    This file implements class PMTrayIcon.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif
#include "ENMApi.h"

#include "include/PMTrayIcon.h"
#include <X11/Xatom.h>
#include <gdk/gdkx.h>



enum {
    PU_EXIT = 10001,
    TIMER_BALLOON,
    TIMER_BATTERY,
    TIMER_POWER_CHANG,
    TIMER_IDLE,
    TIMER_SUSPNED,
    TIMER_CLICK,
    TIMER_LAN
};


FILE *fp = NULL;
static const int TIME_BALLOON_DISAPPEAR = 4000;
static const int TIME_BATTERY_INFO = 5000;
static const int LANTIME = 5000;

wxString LAN_MESSAGE;// = _("Shut down LAN/WiFi interface failed! Please make sure EasyNetwork application is running!");
//static const int DOUBLE_CLICK_TIME = 500;

BEGIN_EVENT_TABLE(PMTrayIcon, wxTaskBarIcon)
   // EVT_TASKBAR_LEFT_DCLICK  (PMTrayIcon::OnLeftButtonDClick)
    EVT_TASKBAR_LEFT_UP (PMTrayIcon::OnLeftButtonUp)
    EVT_TASKBAR_RIGHT_UP (PMTrayIcon::OnRightButtonUp)
    EVT_TASKBAR_MOVE (PMTrayIcon::OnMouseOver)
    EVT_TIMER(TIMER_BALLOON,PMTrayIcon::OnTimerTick)
    EVT_TIMER(TIMER_BATTERY,PMTrayIcon::GetBatteryInfo)
    EVT_TIMER(TIMER_POWER_CHANG,PMTrayIcon::PowerChangeEvent)
    EVT_TIMER(TIMER_IDLE,PMTrayIcon::IdleTimeEvent)
    EVT_TIMER(TIMER_SUSPNED,PMTrayIcon::SuspendEvent)
    EVT_TIMER(TIMER_LAN,PMTrayIcon::LANOverTimeHandler)
END_EVENT_TABLE()

bool PMTrayIcon::m_initState = false;

//constructor
PMTrayIcon::PMTrayIcon(bool bAutoStart):m_bAutoStart(bAutoStart), m_lan_timer(this, TIMER_LAN)
{
    LAN_MESSAGE = _("Shut down LAN/WiFi interface failed! Please make sure EasyNetwork application is running!");
    DialogRegister* reg = DialogRegister::GetInstance();
    reg->SetPtrTask(this);
    m_batteryInfoTimer = new wxTimer(this, TIMER_BATTERY);
    m_batteryInfoTimer->Start(TIME_BATTERY_INFO, wxTIMER_CONTINUOUS);
    m_ptrBalloonInfo = NULL;
    m_ptrBatteryDialog = NULL;
    m_ptrDeviceListBall = NULL;
    m_ptrMenu = NULL;
    m_switchPower = NULL;
    m_Timer = NULL;
    m_switchTimer = NULL;
    m_idleTimer_closelcd = NULL;
    m_idleTimer_suspend = NULL;
    m_clickTimer = new wxTimer(this, TIMER_CLICK);
    m_isAC = 1;
    m_firstnotray = false;
    m_bDoubleClick = false;

    m_ptrPMDialog = new PMDialog(NULL, wxID_ANY);
    m_ptrPMDialog->Show(false);

    DCS_RegisterLanDisabledCallback(ENM_shutdown_lan_interface);
    DCS_RegisterWLanDisabledCallback(ENM_shutdown_wlan_interface);

}

//destructor
PMTrayIcon::~PMTrayIcon()
{

    if (m_ptrPMDialog != NULL)
    {
        m_ptrPMDialog->Destroy();
        delete m_ptrPMDialog;
        m_ptrPMDialog = NULL;
    }
    if (m_ptrBatteryDialog != NULL)
    {
        m_ptrBatteryDialog->Destroy();
        delete m_ptrBatteryDialog;
        m_ptrBatteryDialog = NULL;
    }
    if (m_ptrMenu != NULL)
    {
        m_ptrMenu->DestroyItems();
        delete m_ptrMenu;
        m_ptrMenu = NULL;
    }
    if (m_batteryInfoTimer != NULL)
    {
        m_batteryInfoTimer->Stop();
        delete m_batteryInfoTimer;
        m_batteryInfoTimer = NULL;
    }
    if (m_idleTimer_closelcd != NULL)
    {
        m_idleTimer_closelcd->Stop();
        delete m_idleTimer_closelcd;
        m_idleTimer_closelcd = NULL;
    }
    if (m_idleTimer_suspend != NULL)
    {
        m_idleTimer_suspend->Stop();
        delete m_idleTimer_suspend;
        m_idleTimer_suspend = NULL;
    }


    if (m_clickTimer != NULL)
    {
        m_clickTimer->Stop();
        delete m_clickTimer;
        m_clickTimer = NULL;
    }

    DCS_UnregisterLanDisabledCallback();
    DCS_UnregisterWLanDisabledCallback();
    CloseBalloonStatus();
    CloseBalloonList();
    ClosePowerSwitchBalloon();
}

//the mouse over event handler
void PMTrayIcon::OnMouseOver(wxTaskBarIconEvent&)
{
    if (NULL == m_ptrBalloonInfo && NULL == m_ptrDeviceListBall)
    {
        m_ptrBalloonInfo = new PMBalloonWnd(NULL, wxT("balloon"));
        m_Timer = new wxTimer(this,TIMER_BALLOON);
        m_ptrBalloonInfo->InitStatusBalloon();
        m_ptrBalloonInfo->Show();
        m_Timer->Start(TIME_BALLOON_DISAPPEAR, wxTIMER_CONTINUOUS);
    }

}

//the mouse left click tray icon up event handler
void PMTrayIcon::OnLeftButtonUp(wxTaskBarIconEvent& event)
{
    CloseBalloonStatus();
    CloseBalloonList();
    ShowMenu();

//    if(m_clickTimer->IsRunning())
//    {
//        m_bDoubleClick = true;
//    }
//    else
//    {
//        m_bDoubleClick = false;
//        m_clickTimer->Start(DOUBLE_CLICK_TIME, wxTIMER_ONE_SHOT);
//    }
}

//the mouse right click tray icon up event handler
void PMTrayIcon::OnRightButtonUp(wxTaskBarIconEvent& event)
{
    CloseBalloonStatus();
    CloseBalloonList();
    ShowMenu();
}

// Overridables
wxMenu *PMTrayIcon::CreatePopupMenu()
{
    return NULL;
}

//void PMTrayIcon::OnLeftButtonDClick(wxTaskBarIconEvent&)
//{
//    //ShowPMDlg();
//}

//timer event handler to close balloon
void PMTrayIcon::OnTimerTick(wxTimerEvent & event)
{
    CloseBalloonStatus();
    CloseBalloonList();
}

//click the balloon link to see the disabled devices
void PMTrayIcon::ChangeBalloonToList()
{
    if ( NULL == m_ptrBalloonInfo )
    {
        return;
    }

    wxPoint position = m_ptrBalloonInfo->GetScreenPosition();
    CloseBalloonStatus();
    m_ptrDeviceListBall = new PMBalloonWnd(NULL, wxT("balloon"));
    m_ptrDeviceListBall->InitDeviceListBalloon();
    m_Timer = new wxTimer(this,TIMER_BALLOON);
    m_ptrDeviceListBall->Move(position);
    m_ptrDeviceListBall->Show();
    m_Timer->Start(TIME_BALLOON_DISAPPEAR, wxTIMER_CONTINUOUS);
}

//click the balloon link to see the power info
void PMTrayIcon::ChangeBalloonToStatus()
{
    if ( NULL == m_ptrDeviceListBall )
    {
        return;
    }

    wxPoint position = m_ptrDeviceListBall->GetScreenPosition();
    CloseBalloonList();
    m_ptrBalloonInfo = new PMBalloonWnd(NULL, wxT("balloon"));
    m_ptrBalloonInfo->InitStatusBalloon();
    m_Timer = new wxTimer(this,TIMER_BALLOON);
    m_ptrBalloonInfo->Move(position);
    m_ptrBalloonInfo->Show();
    m_Timer->Start(TIME_BALLOON_DISAPPEAR, wxTIMER_ONE_SHOT);
}

//close the power info balloon
void PMTrayIcon::CloseBalloonStatus()
{
    if (m_ptrBalloonInfo != NULL)
    {
        if (m_ptrBalloonInfo->HasCapture())
        {
            return ;
        }
        m_ptrBalloonInfo->Destroy();
        m_ptrBalloonInfo = NULL;
        if (m_Timer != NULL)
        {
            m_Timer->Stop();
            delete m_Timer;
            m_Timer = NULL;
        }

    }
}

//close the disabled devices balloon
void PMTrayIcon::CloseBalloonList()
{
    if (m_ptrDeviceListBall != NULL)
    {
        if (m_ptrDeviceListBall->HasCapture())
        {
            return;
        }
        m_ptrDeviceListBall->Destroy();
        m_ptrDeviceListBall = NULL;
        if (m_Timer != NULL)
        {
            m_Timer->Stop();
            delete m_Timer;
            m_Timer = NULL;
        }
    }
}

//show the PM dialog
void PMTrayIcon::ShowPMDlg()
{
    if (NULL == m_ptrPMDialog)
    {
        m_ptrPMDialog = new PMDialog(NULL, wxID_ANY);
    }

    if (m_ptrPMDialog->IsShown())
    {
        m_ptrPMDialog->Raise();
    }
    else
    {
        m_ptrPMDialog->Init();
        m_ptrPMDialog->Show();
    }
}

//show the menu
void PMTrayIcon::ShowMenu()
{
    if (NULL == m_ptrMenu)
    {
        m_ptrMenu = new PMMenu();
    }

    m_ptrMenu->InitMenu();
    this->PopupMenu(m_ptrMenu);
}

//show battery info dialog
void PMTrayIcon::ShowBatteryDlg()
{
    if (NULL == m_ptrBatteryDialog)
    {
        m_ptrBatteryDialog = new BatteryInfoDialog(NULL, wxID_ANY);
    }
    if (m_ptrBatteryDialog->IsShown())
    {
        m_ptrBatteryDialog->Raise();
    }
    else
    {
        m_ptrBatteryDialog->InitDlg();
        m_ptrBatteryDialog->Show();
    }
}

//timer event handler to get battery info
void PMTrayIcon::GetBatteryInfo(wxTimerEvent& event)
{
    if(m_firstnotray)
    {
        if(IsProtocolSupported() == true)
        {
            m_firstnotray = false;
        }
    }
    else
    {
        if(IsProtocolSupported() == false)
        {
            if (this->m_ptrBatteryDialog != NULL && this->m_ptrBatteryDialog->IsShown())
            {
            }
            else if (this->m_ptrPMDialog != NULL && this->m_ptrPMDialog->IsShown())
            {
            }
            else
            {
                if (m_ptrMenu != NULL)
                {
                    m_ptrMenu->DestroyItems();
                    delete m_ptrMenu;
                    m_ptrMenu = NULL;
                }

                if (m_idleTimer_closelcd != NULL)
                {
                    m_idleTimer_closelcd->Stop();
                    delete m_idleTimer_closelcd;
                    m_idleTimer_closelcd = NULL;
                }
                return;
            }
        }
    }


    DCS_Battery_Info batteryInfo;
    int index = 0;

    BatteryInfoMgmtProxy::PM_GetBatteriesInfo(&batteryInfo, index);

    if (m_ptrBatteryDialog != NULL && m_ptrBatteryDialog->IsShownOnScreen())
    {
        m_ptrBatteryDialog->UpdateInfo(&batteryInfo, index);
    }

//    if (m_ptrMenu != NULL)
//    {
//        m_ptrMenu->InitMenu();
//        m_ptrMenu->UpdateUI();
//    }

    int ac_adapter = BatteryInfoMgmtProxy::PM_GetACAdapterStatus();
    if (ac_adapter != m_isAC)
    {
        vector<string> devicesVec;
        int schemeId = 0;
        PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(schemeId);
        int isAC = 0;
        if (1 == ac_adapter)
        {
            isAC = 1;
        }


        PowerSchemeMgmtProxy::GetInstance()->GetDisabledDevices(schemeId, isAC, devicesVec);

        if (devicesVec.size() != 0)
        {
            SwitchPower();
        }

        PowerSchemeMgmtProxy::GetInstance()->ApplyPwrScheme(schemeId);

        m_isAC = ac_adapter;
    }

    if (IsProtocolSupported())
    {
        m_initState = UpdateIcon(&batteryInfo);
    }
    else
    {
        ::wxSleep(10);
    }
}

//update the tray icon
bool PMTrayIcon::UpdateIcon(PDCS_Battery_Info batteryInfo)
{
    bool initState = false;
    if (NULL == batteryInfo)
    {
        this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_AC_black.png")), wxT(""));
        initState = this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_AC.png")), wxT(""));
    }
    else
    {
        if (1 == m_isAC)
        {
            if (batteryInfo->RemainPercent >= BAT_NULL_CAP && batteryInfo->RemainPercent < BAT_FULL_CAP)
            {
                this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_Charge_black.png")), wxT(""));
                initState = this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_Charge.png")), wxT(""));
            }
            else
            {
                this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_AC_black.png")), wxT(""));
                initState = this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_AC.png")), wxT(""));
            }
        }
        else
        {
            if (batteryInfo->RemainPercent == INVALID_VALUE)
            {
                this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_Low_black.png")), wxT(""));
                initState = this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_Low.png")), wxT(""));
            }
            else if (batteryInfo->RemainPercent >= HIGHPOINT)
            {
                this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_High_black.png")), wxT(""));
                initState = this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_High.png")), wxT(""));
            }
            else if (batteryInfo->RemainPercent >= MIDPOINT && batteryInfo->RemainPercent < HIGHPOINT)
            {
                this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_Mid_black.png")), wxT(""));
                initState = this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_Mid.png")), wxT(""));
            }
            else
            {
                this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_Low_black.png")), wxT(""));
                initState = this->SetIcon(wxIcon(PIC_PATH + wxT("Tray_Low.png")), wxT(""));
            }
        }
    }

    return initState;

}

//close the balloon
void PMTrayIcon::ClosePowerSwitchBalloon()
{
    if (NULL != m_switchPower)
    {
         if (m_switchPower->HasCapture())
        {
            m_switchPower->ReleaseMouse();
        }
        m_switchPower->Destroy();
        m_switchPower = NULL;
        if (m_switchTimer != NULL)
        {
            m_switchTimer->Stop();
            delete m_switchTimer;
            m_switchTimer = NULL;
        }
    }
}

//when power type changed, pop up a balloon
void PMTrayIcon::SwitchPower()
{
    ClosePowerSwitchBalloon();
    m_switchPower = new PMBalloonWnd(NULL, wxT("balloon"));
    m_switchTimer = new wxTimer(this,TIMER_POWER_CHANG);
    m_switchPower->InitDeviceListBalloon(1);
    int width = 0;
    int height = 0;
    ::wxDisplaySize(&width, &height);
    wxPoint pos(width - 260, height - 110);
    m_switchPower->Move(pos);
    m_switchPower->Show();
    m_switchTimer->Start(TIME_BALLOON_DISAPPEAR, wxTIMER_CONTINUOUS);
}

//timer event handler to close balloon
void PMTrayIcon::PowerChangeEvent(wxTimerEvent & event)
{
    ClosePowerSwitchBalloon();
}

//initial tray icon
void PMTrayIcon::Init()
{

    DCS_Battery_Info batteryInfo;
    int ac_adapter = BatteryInfoMgmtProxy::PM_GetACAdapterStatus();

    m_isAC = ac_adapter;

    int index = 0;

    BatteryInfoMgmtProxy::PM_GetBatteriesInfo(&batteryInfo, index);

    // verify where the application is launched
    // if it has param, the application is launched while loginning
    // otherwise, user directly runs it
    //

    if(m_bAutoStart)
    {
        int iCount = 0;
        bool bNoPanel = false;
        do
        {
            if (iCount >= 60)
            {
                exit(0);
            }

            if(bNoPanel = IsProtocolSupported())
            {
                m_initState = UpdateIcon(&batteryInfo);

                break;
            }
            wxMilliSleep(500);
            iCount++;
        }
        while (false == bNoPanel);
    }
    else
    {
        // once we found no plan while the application is launched by user
        // we directly show the main dialog
        //
       if(IsProtocolSupported())
       {
           m_initState = UpdateIcon(&batteryInfo);
       }
       else
       {
            m_initState = false;
            m_firstnotray = true;

            ShowPMDlg();;
       }
    }

}

//check the system notification area exist
bool PMTrayIcon::IsProtocolSupported()
{
    bool bsupported = false;


    Display *display = GDK_DISPLAY();
    Screen *screen = DefaultScreenOfDisplay(display);

    char name[32];
    g_snprintf(name, sizeof(name), "_NET_SYSTEM_TRAY_S%d",
        XScreenNumberOfScreen(screen));
    Atom atom = XInternAtom(display, name, False);
    Window manager = XGetSelectionOwner(display, atom);

    bsupported = (manager != None);

    return bsupported;
}

//close the display event handler
void PMTrayIcon::IdleTimeEvent(wxTimerEvent & event)
{
    if (0 == PowerSchemeMgmtProxy::g_CloseLCDTime)
    {
        return;
    }

    unsigned long idleTime = PowerSchemeMgmtProxy::GetInstance()->GetIdleTime();

    static unsigned long times  = 0 ;
    static unsigned long lastIdleTime = 0;

    if (2 == times && idleTime < PowerSchemeMgmtProxy::g_CloseLCDTime * 1000)
    {
        times = 0 ;
    }

    if ( (1 == times) && idleTime < PowerSchemeMgmtProxy::g_CloseLCDTime * 1000 )
    {
        if(lastIdleTime > idleTime )
        {
            times = 0;

            lastIdleTime = 0;
        }

        lastIdleTime = idleTime;
    }
    if ( (1 == times || 2 ==  times) && idleTime >= PowerSchemeMgmtProxy::g_CloseLCDTime * 1000 )
    {
        times = 2;

        lastIdleTime = 0 ;

        return ;
    }

    if ( idleTime >= PowerSchemeMgmtProxy::g_CloseLCDTime * 1000 )
    {
//        fprintf(fp, "Turn off display. \n");
//        fflush(fp);
        wxExecute(wxT("xset dpms force off"));

        times = 1;
    }
}

//start the close display and suspend timer
void PMTrayIcon::StartIdleTimer()
{
    if (NULL == m_idleTimer_closelcd)
    {
        m_idleTimer_closelcd = new wxTimer(this, TIMER_IDLE);
    }

    if (NULL == m_idleTimer_suspend)
    {
        m_idleTimer_suspend = new wxTimer(this, TIMER_SUSPNED);
    }

    m_idleTimer_closelcd->Start(10000, wxTIMER_CONTINUOUS);
    m_idleTimer_suspend->Start(10000, wxTIMER_CONTINUOUS);
}

//suspend event handler
void PMTrayIcon::SuspendEvent(wxTimerEvent & event)
{
    if (0 == PowerSchemeMgmtProxy::g_SuspendTime)
    {
        return;
    }

    static unsigned long lastIdleTime = 0;
    static unsigned long times  = 0 ;
    unsigned long idleTime = PowerSchemeMgmtProxy::GetInstance()->GetIdleTime();

    if (2 == times && idleTime < PowerSchemeMgmtProxy::g_SuspendTime * 1000)
    {
        times = 0 ;
    }

    if ( (1 == times) && idleTime < PowerSchemeMgmtProxy::g_SuspendTime * 1000 )
    {
        if(lastIdleTime > idleTime )
        {
            times = 0;

            lastIdleTime = 0;
        }

        lastIdleTime = idleTime;
    }
    if ( (1 == times || 2 == times) && idleTime >= PowerSchemeMgmtProxy::g_SuspendTime * 1000 )
    {
        times = 2;

        lastIdleTime = 0 ;

        return ;
    }

    if (PowerSchemeMgmtProxy::g_SuspendTime * 1000 <= idleTime)
    {
        times = 1;
//        fflush(fp);
        //wxMessageBox(wxString::Format(wxT("Suspend idle time=%d"), idleTime));
        PowerSchemeMgmtProxy::EnterSuspend();
    }
}

//show some info
void PMTrayIcon::ShowMessageDialog(wxString message)
{
    wxMessageDialog dialog(NULL, message, _T(""), wxOK, wxDefaultPosition);
    dialog.ShowModal();
}


//ENM response the LAN status
void CALLBACK ENM_shutdown_lan_interface(int *result)
{
    if (NULL == result)
    {
        PowerSchemeMgmtProxy::g_LanOvertime = 0;
        PMTrayIcon::ShowMessageDialog(LAN_MESSAGE);
        return;
    }

    if (1 == *result)
    {
        DCS_SetLANStatus(0);
    }
    else
    {
        PMTrayIcon::ShowMessageDialog(LAN_MESSAGE);
    }
    PowerSchemeMgmtProxy::g_LanOvertime = 0;
    return ;
}

//ENM response the WLAN status
void CALLBACK ENM_shutdown_wlan_interface(int *result)
{
    if (NULL == result)
    {
        PowerSchemeMgmtProxy::g_LanOvertime = 0;
        PMTrayIcon::ShowMessageDialog(LAN_MESSAGE);
        return;
    }

    if (1 == *result)
    {
        DCS_SetWirelessStatus(0);
    }
    else
    {
        PMTrayIcon::ShowMessageDialog(LAN_MESSAGE);
    }
    PowerSchemeMgmtProxy::g_LanOvertime = 0;
    return ;
}

//start timer for ENM
void PMTrayIcon::StartLANTimer()
{
    m_lan_timer.Start(LANTIME, wxTIMER_ONE_SHOT);
}

//the action when ENM time out,
void PMTrayIcon::LANOverTimeHandler(wxTimerEvent& event)
{
    if (1 == PowerSchemeMgmtProxy::g_LanOvertime)
    {
        PMTrayIcon::ShowMessageDialog(LAN_MESSAGE);
    }
    PowerSchemeMgmtProxy::g_LanOvertime = 0;
}
