/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMUtility.cpp

Description:

    This file implements class PMUtility.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/PMUtility.h"
#include <wx/utils.h>
#include <fcntl.h>
#include <fstream>
using namespace std;

//convert string to wxString
wxString PMUtility::StringToWxString(string stringValue)
{
    wxString temp(stringValue.c_str(), wxConvUTF8);
    return temp;
}

//convert wxString to string
string PMUtility::WxStringToString(wxString wxStringValue)
{
    string temp(wxStringValue.mb_str(wxConvUTF8));
    return temp;
}

//chekc the special character in scheme name
int PMUtility::CheckSchemeName(wxString schemeName)
{
    if (schemeName.Find('<') >= 0)
    {
        return 1;
    }

    if (schemeName.Find('>') >= 0)
    {
        return 1;
    }

    if (schemeName.Find('"') >= 0)
    {
        return 1;
    }

    if (schemeName.Find('&') >= 0)
    {
        return 1;
    }

    if (schemeName.Find('\'') >=0)
    {
        return 1;
    }

    return 0;
}

//get the current user home dir
string PMUtility::GetHomeDir()
{
    return WxStringToString(wxGetHomeDir());

}

//check the sington instance
int PMUtility::GetLock()
{
    struct flock fl;
    int fdlock = 0;
    fl.l_type = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start = 0;
    fl.l_len = 1;

    string file =GetHomeDir()  + "/.pm_lock";

    if((fdlock = open(file.c_str(), O_WRONLY|O_CREAT, 0666)) == -1)
    {
        return 0;
    }

    if(fcntl(fdlock, F_SETLK, &fl) == -1)
    {
        return 0;
    }

    return 1;
}

//get the mo file
int PMUtility::GetLocaleFileName(int langCode, wxString& fileName)
{
    string mapfile = "/etc/ipower-management/resource/langToFile";
//    fileName = wxT("en");
    fileName = wxT("EN");
    ifstream in(mapfile.c_str());
    if (!in)
    {
        return -1;
    }
    char langCodeStr[10] = {'\0'};
    snprintf(langCodeStr, 10, "%d", langCode);
    string line;
    while(getline(in, line))
    {
        string::size_type index = line.find(":");
        if (index == string::npos || index == 0)
        {
            continue;
        }
        if (0 == line.compare(0, index, langCodeStr))
        {
            fileName = PMUtility::StringToWxString(line.substr(index + 1));
            in.close();
            return 1;
        }
    }

    in.close();
    return -1;

}
