/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_TABLETSENSOR_API_H
#define DCS_TABLETSENSOR_API_H

#include "DCSCommon.h"
#include "tablet/TabletDef.h"

#ifdef __cplusplus
extern "C" {
#endif

/** 
 * Typedef of the callback function to be notified when the 
 * classmate PC changes the clamshell/tablet modes. 
 *
 * @param pData		pointer to the tablet sensor data
 */
typedef void (CALLBACK *DCS_TabletSensor_Callback) (DCS_Tablet_Sensor_Data *pData);

/**
 * Registers the callback function to be notified  when the
 * classmate PC changes the clamshell/tablet modes. 
 *
 * @param pCallback		pointer to the callback function of tablet sensor
 */
DCSAPI DCS_Return_Code DCS_RegisterTabletSensorCallback(DCS_TabletSensor_Callback pCallback);

/** 
 * Unregisters the callback function for mode-change notifications. 
 */
DCSAPI DCS_Return_Code DCS_UnregisterTabletSensorCallback();

/** 
 * Get current Tablet Sensor mode. 
 *
 * @param pData		pointer to the tablet sensor data got
 */
DCSAPI DCS_Return_Code DCS_GetTabletSensorMode(DCS_Tablet_Sensor_Data *pData);  

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DCS_TABLETSENSOR_API_H */
