/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          DeviceDisableDialog.h

Description:

    This file defines class DeviceDisableDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef DEVICEDISABLEDIALOG_H
#define DEVICEDISABLEDIALOG_H

//(*Headers(DeviceDisableDialog)
#include <wx/stattext.h>
#include <wx/checklst.h>
#include <wx/checkbox.h>
#include <wx/statline.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

#include "PowerSchemeMgmtProxy.h"
#include "PMUtility.h"
#include "ConfigurationFileEditor.h"
#include "PMGlobalConstant.h"

class DeviceDisableDialog: public wxDialog
{
	public:
        //constructor
		DeviceDisableDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		//destructor
		virtual ~DeviceDisableDialog();

		//(*Declarations(DeviceDisableDialog)
		wxCheckListBox* DeviceCheckListBox;
		wxStaticText* StaticText2;
		wxStaticBitmap* StaticBitmap1;
		wxCheckBox* RecordCheckBox;
		wxStaticText* StaticText1;
		wxButton* Button_OK;
		wxStaticLine* StaticLine1;
		//*)

        //intial the dialog
		bool InitDlg(int schemeId, int isAC, vector<string>& devicesVec);

		static bool m_IsExist;

	protected:

		//(*Identifiers(DeviceDisableDialog)
		static const long ID_STATICBITMAP1;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_CHECKBOX1;
		static const long ID_CHECKLISTBOX1;
		static const long ID_STATICLINE1;
		static const long ID_BUTTON_OK;
		//*)

	private:

		//(*Handlers(DeviceDisableDialog)
		void OnButton_OKClick(wxCommandEvent& event);
		//window close event handler
		void OnClose(wxCloseEvent& event);
		//*)

        int m_SchemeId;
        int m_IsAC;
        vector<string> m_DevicesVec;
        map<string, string> m_DeviceDescMap;

        //map event
		DECLARE_EVENT_TABLE()
};

#endif
