/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          OptionsDialog.h

Description:

    This file defines class OptionsDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

//(*Headers(OptionsDialog)
#include <wx/stattext.h>
#include <wx/checkbox.h>
#include <wx/statbox.h>
#include <wx/panel.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

#include "ConfigurationFileEditor.h"
#include "PMUtility.h"

const int MAX_SCHEME_NUM = 6;

class OptionsDialog: public wxDialog
{
	public:
        //constructor
		OptionsDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		//destructor
		virtual ~OptionsDialog();
		//initial dialog
		void IniDlg();


        wxCheckBox* CheckBox_AutoStart;
        wxStaticText* StaticTextAutoStart;
        wxStaticText* StaticTextPopDlg;
		//(*Declarations(OptionsDialog)
		wxStaticText* StaticText1;
		wxCheckBox* CheckBox_Ask;
		wxStaticBox* StaticBox_UI_DeviceDisableSetting;
		wxButton* Button_OK;
		wxButton* Button_Cancel;
		wxPanel* CheckBoxListPanel;
		wxStaticBitmap* TitleStaticBitmap;
		//*)

	protected:

		//(*Identifiers(OptionsDialog)
		static const long ID_STATICTEXT1;
		static const long ID_PANEL1;
		static const long ID_STATICBOX1;
		static const long ID_CHECKBOX1;
		static const long ID_BUTTON1;
		static const long ID_BUTTON2;
		static const long ID_STATICBITMAP1;
		//*)

	private:

		//(*Handlers(OptionsDialog)
		//ok button event
		void OnButton_OKClick(wxCommandEvent& event);
		//cancen button event
		void OnButton_CancelClick(wxCommandEvent& event);
		//window close event
		void OnClose(wxCloseEvent& event);
		//*)

        ConfigurationFileEditor *m_FileEditor;
        vector<PSchemeList_t> m_SchemeList;
        vector<wxCheckBox*> m_CheckboxList;
        //map event
		DECLARE_EVENT_TABLE()
};

#endif
