/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          CMPC_QCPMain.cpp

Description:
    This file implements CMPC_QCPMain.h.
        This QCPVolumeIF class has following functions.

         1.QCP_GetVolume         Get current volume
         2.QCP_SetVolume         Set the volume
         3.QCP_SetVolumeMute     Set the mute

         This CQCPScreenRotation class has following property:

         1.QCP_RotationDegreeToIndexCW   Get the rotation degree of left
         2.QCP_RotationDegreeToIndexCCW  Get the rotation degree of right

        This QCPLinuxIF class has following property:

         1.Onm_pBitmapCloseClick             Exit the Quick Controller
         2.Onm_pBitmapAboutClick             Open the About dialog
         3.Onm_pBitmapVolumeUpClick          Adjust volume up
         4.Onm_pBitmapVolumeDownClick        Adjust volume down
         5.Onm_pBitmapBrightnessUpClick      Adjust brightness up
         6.Onm_pBitmapBrightnessDownClick    Adjust brightness down
         7.Onm_pBitMuteClick                 Set the mute
         8.Onm_pBitShowCursorClick           Launch the show cursor tool
         9.Onm_pBitSwitchDisplayClick        Launch the Switch Display tool
         10.Onm_pBitCalScreenClick           Launch the Screen calibrate
         11.Onm_pBitmapCWClick               Right direction rotation
         12.Onm_pBitmapCCWClick              Left direction rotation
         13.Onm_pBtnRotationClick   Switch rotation mode

         14.OnLeftDown
         15.OnLeftUp
         16.OnMouseMove                      Get mouse move event
         17.OnMouseOver                      Get mouse over event
	     18.OnMouseLeave                     Get mouse leave event
	     19.OnTimer                          Get timer event
	     20.OnButtonMouseMove                Get button mouse move event
	     21 OnActivate                       Get widows activeate event
         22 OnActivateApp

         23 Initialize                       Get initialize information
	     24 UpdateVolumeUI                   Update current volume UI
	     25 UpdateBrightUI                   Update current Brightness UI
	     26 UpdateRotationUI                 Update current Rotation UI

Environment (opt):
    OS: Windows XP table and Ubuntu
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================

  0.1        Create                Li Zhong Fu || Chen Dequan   2008-7-20

  =====================================================================

****************************************************************************/
#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif
#include <wx/filefn.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#include "CMPC_QCPApp.h"
#include "CMPC_QCPMain.h"
#include "CMPC_QCPLinuxIF.h"
#if defined(__WXMSW__)
#include "CMPC_QCPWindowIF.h"
#endif
#include "CMPC_QCPAboutDialog.h"

#include "DcsSDK/SDK/plugins/FnKeyApi.h"
#include "DcsSDK/SDK/TabletApi.h"

#ifdef QCP_DEBUG
#include <fstream>
using namespace std;
ofstream dcsLog;
#endif //QCP_DEBUG

const long CMPC_QCPDialog::ID_STATICTEXTTITLE = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONCLOSE = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONABOUT = wxNewId();

const long CMPC_QCPDialog::ID_STATICBITMAPBRIGHTSTATUS = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONBRIGHTNESSDOWN = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONBRIGHTNESSUP = wxNewId();
const long CMPC_QCPDialog::ID_STBITMAPBTNBRIGHTNESS0 = wxNewId();
const long CMPC_QCPDialog::ID_STBITMAPBTNBRIGHTNESS1 = wxNewId();
const long CMPC_QCPDialog::ID_STBITMAPBTNBRIGHTNESS2 = wxNewId();
const long CMPC_QCPDialog::ID_STBITMAPBTNBRIGHTNESS3 = wxNewId();
const long CMPC_QCPDialog::ID_STBITMAPBTNBRIGHTNESS4 = wxNewId();
const long CMPC_QCPDialog::ID_STBITMAPBTNBRIGHTNESS5 = wxNewId();
const long CMPC_QCPDialog::ID_STBITMAPBTNBRIGHTNESS6 = wxNewId();

const long CMPC_QCPDialog::ID_BITMAPBUTTONVOLUMESTATUS = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONVOLUMEDOWN = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONVOLUMEUP = wxNewId();

const long CMPC_QCPDialog::ID_STBTNMAPVOLUMELEVEL0 = wxNewId();
const long CMPC_QCPDialog::ID_STBTNMAPVOLUMELEVEL1 = wxNewId();
const long CMPC_QCPDialog::ID_STBTNMAPVOLUMELEVEL2 = wxNewId();
const long CMPC_QCPDialog::ID_STBTNMAPVOLUMELEVEL3 = wxNewId();
const long CMPC_QCPDialog::ID_STBTNMAPVOLUMELEVEL4 = wxNewId();
const long CMPC_QCPDialog::ID_STBTNMAPVOLUMELEVEL5 = wxNewId();
const long CMPC_QCPDialog::ID_STBTNMAPVOLUMELEVEL6 = wxNewId();

const long CMPC_QCPDialog::ID_STBITMAPMUTESTATUS = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONMUTE = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONSHOWCURSOR = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONSWITCHDISPLAY = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONCALSCREEN = wxNewId();

#if defined(__UNIX__)
const long CMPC_QCPDialog::ID_STATICBITMAPBRIGHTNESS0 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPBRIGHTNESS1 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPBRIGHTNESS2 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPBRIGHTNESS3 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPBRIGHTNESS4 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPBRIGHTNESS5 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPBRIGHTNESS6 = wxNewId();

const long CMPC_QCPDialog::ID_STATICBITMAPVOLUME0 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPVOLUME1 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPVOLUME2 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPVOLUME3 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPVOLUME4 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPVOLUME5 = wxNewId();
const long CMPC_QCPDialog::ID_STATICBITMAPVOLUME6 = wxNewId();

const long CMPC_QCPDialog::ID_STATICTEXTMUTE = wxNewId();
const long CMPC_QCPDialog::ID_STATICTEXTSHOWCURSOR = wxNewId();
const long CMPC_QCPDialog::ID_STATICTEXTSWITCHDISPLAY = wxNewId();
const long CMPC_QCPDialog::ID_STATICTEXTCALSCREEN = wxNewId();
const long CMPC_QCPDialog::ID_STATICTEXTMANUALROTATION = wxNewId();

const long CMPC_QCPDialog::ID_STATICTBITMAPMUTE = wxNewId();
const long CMPC_QCPDialog::ID_STATICTBITMAPSHOWCURSOR = wxNewId();
const long CMPC_QCPDialog::ID_STATICTBITMAPSWITCHDISPLAY = wxNewId();
const long CMPC_QCPDialog::ID_STATICTBITMAPCALSCREEN = wxNewId();
const long CMPC_QCPDialog::ID_STATICTBITMAPMANUALROTATION = wxNewId();
const long CMPC_QCPDialog::ID_STATICTBITMAPCW = wxNewId();
const long CMPC_QCPDialog::ID_STATICTBITMAPCCW = wxNewId();
const long CMPC_QCPDialog::ID_STBIT180DEGREE = wxNewId();
#endif

const long CMPC_QCPDialog::ID_BITMAPBUTTONMANUALROTATION = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONCW = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBUTTONCCW = wxNewId();
const long CMPC_QCPDialog::ID_BITMAPBTN180DEGREE = wxNewId();

BEGIN_EVENT_TABLE(CMPC_QCPDialog, wxBitmapDialog)
    EVT_ENTER_WINDOW(CMPC_QCPDialog::OnMouseOver)
    EVT_LEAVE_WINDOW(CMPC_QCPDialog::OnMouseLeave)

    EVT_LEFT_DOWN(CMPC_QCPDialog::OnLeftDown)
    EVT_LEFT_UP(CMPC_QCPDialog::OnLeftUp)
    EVT_MOTION(CMPC_QCPDialog::OnMouseMove)

    #if defined(__WXMSW__)
    //Control the mouse event of button
    EVT_ENTER_WINDOW(CMPC_QCPDialog::OnMouseEnter)
    EVT_ENTER_WINDOW(CMPC_QCPDialog::OnMouseLeaveButton)
    #endif

    EVT_TIMER(REFRESH_UI_TIMER_ID, CMPC_QCPDialog::OnRefreshUITimer)
    EVT_TIMER(EXIT_TIMER_ID, CMPC_QCPDialog::OnTimer)

    //Control the position of QCP and volume synchronization
    EVT_TIMER(RESOLUTION_TIMER_ID, CMPC_QCPDialog::OnResolution)

    EVT_ACTIVATE(CMPC_QCPDialog::OnActivate)
    EVT_ACTIVATE_APP(CMPC_QCPDialog::OnActivateApp)

    EVT_SCAN_BRIGHTNESS(ID_SCAN_BRIGHTNESS, CMPC_QCPDialog::OnUpdateBrightUIForSyn)

END_EVENT_TABLE()

/*Control the UI of brightness when QCP adjust the level of brightness*/
static bool g_bBrightSynControlUI = false;

/*Calling the QCP interfaces*/
static QCPBasicIF *g_pQCPInterface;// = new QCPInterface();

/**************************************************************************************************
* Function Name : CMPC_QCPDialog                                                                  *
* Description  	:                                                                                 *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
CMPC_QCPDialog::CMPC_QCPDialog(wxBitmapDialog *dlg, const wxString &title)
    :wxBitmapDialog(wxBitmap(::wxGetApp().GetImageFilePath() + wxT("image/qcp_panel.png"), wxBITMAP_TYPE_PNG),
        (wxWindow*)dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{
    g_pQCPInterface = new QCPInterface();
    if (!g_pQCPInterface)
    {
        return;
    }

    #ifdef QCP_DEBUG
    #if defined(__UNIX__)
    dcsLog.open("/home/QCP_Log", ios_base::app);
    #elif defined(__WXMSW__)
    dcsLog.open("c:/QCP_Log/Log.txt", ios_base::app);
    #endif
    dcsLog << "Open Test" << endl;
    dcsLog << "Close Test" << endl;
    dcsLog << "Log Open" << endl;
    #endif
    //Create the timer for QCP fade in
    m_iFadeInCounter = 0;
    m_pTRefreshUI = new wxTimer(this, REFRESH_UI_TIMER_ID);
    if (NULL == m_pTRefreshUI)
    {
        return;
    }

    m_pTimer = new wxTimer(this, EXIT_TIMER_ID);// The QCP will be closed after 15 seconds
    m_pResolutionTimer = new wxTimer(this, RESOLUTION_TIMER_ID);//Update the position of QCP on screen
    if ((NULL == m_pTimer) || (NULL == m_pResolutionTimer))
    {
        return;
    }

    m_bMoving = false;
    m_bControlClick = true;  //Spring the click event of button
	m_bCursorState  = false;  //Switch the UI of Show/Hide Cursor
    m_bAboutState   = false; //Cotrol time of About Dialog show
    m_bNeedUpdate = false;
    m_bMuteState    = false;
    m_bVolumeSynControl = false;//Control the disable status of QCP UI
    m_bNeedEnableBar = false;
    #if defined(__WXMSW__)
    m_bPreventExit  = true; //Prevent the close event of QCP when switch display
    m_bRotationIcon = false;
    #endif
    m_iBrightLevel  = 0;     //Count current brightness level
    m_iVolLevel     = 0;

    m_iScreenWidth  = 0;     //the width of screen rotation
    m_iScreenHeight = 0;     //the height of screen rotation

    m_AppShowCursorExePath    = wxEmptyString;
    m_AppSwitchDisplayExePath = wxEmptyString;
    m_AppTouchToolExePath     = wxEmptyString;

    m_ResourcefilePath = ::wxGetApp().GetImageFilePath(); //Getting the image file path

#if defined(__WXMSW__)
    //Language localization
    m_locale.AddCatalogLookupPathPrefix(m_ResourcefilePath + wxT("resource"));
    if (true == wxFileExists(m_ResourcefilePath + wxT("resource/resource.mo")))
    {
        m_locale.AddCatalog(wxT("resource"));
    }
#elif defined (__UNIX__)
    SetLocale();
#endif

    //Common code of Windows and Linux, show current level of brightness and volume
    m_pStBitmapBtnBrightnessLevel[6] = new wxBitmapButton(this, ID_STBITMAPBTNBRIGHTNESS6, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS6Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID6"));
    m_pStBitmapBtnBrightnessLevel[5] = new wxBitmapButton(this, ID_STBITMAPBTNBRIGHTNESS5, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS5Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID5"));
    m_pStBitmapBtnBrightnessLevel[4] = new wxBitmapButton(this, ID_STBITMAPBTNBRIGHTNESS4, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS4Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID4"));
    m_pStBitmapBtnBrightnessLevel[3] = new wxBitmapButton(this, ID_STBITMAPBTNBRIGHTNESS3, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS3Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID3"));
    m_pStBitmapBtnBrightnessLevel[2] = new wxBitmapButton(this, ID_STBITMAPBTNBRIGHTNESS2, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS2Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID2"));
    m_pStBitmapBtnBrightnessLevel[1] = new wxBitmapButton(this, ID_STBITMAPBTNBRIGHTNESS1, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS1Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID1"));
    m_pStBitmapBtnBrightnessLevel[0] = new wxBitmapButton(this, ID_STBITMAPBTNBRIGHTNESS0, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS0Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID0"));

    m_pStBitmapBtnVolumeLevel[6] = new wxBitmapButton(this, ID_STBTNMAPVOLUMELEVEL6, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS6Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID6"));
    m_pStBitmapBtnVolumeLevel[5] = new wxBitmapButton(this, ID_STBTNMAPVOLUMELEVEL5, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS5Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID5"));
    m_pStBitmapBtnVolumeLevel[4] = new wxBitmapButton(this, ID_STBTNMAPVOLUMELEVEL4, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS4Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID4"));
    m_pStBitmapBtnVolumeLevel[3] = new wxBitmapButton(this, ID_STBTNMAPVOLUMELEVEL3, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS3Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID3"));
    m_pStBitmapBtnVolumeLevel[2] = new wxBitmapButton(this, ID_STBTNMAPVOLUMELEVEL2, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS2Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID2"));
    m_pStBitmapBtnVolumeLevel[1] = new wxBitmapButton(this, ID_STBTNMAPVOLUMELEVEL1, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS1Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID1"));
    m_pStBitmapBtnVolumeLevel[0] = new wxBitmapButton(this, ID_STBTNMAPVOLUMELEVEL0, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS0Y), wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y),
        wxBU_AUTODRAW, wxDefaultValidator, _T("ID0"));

    m_pStMapMute = new wxStaticBitmap(this, ID_STBITMAPMUTESTATUS,
        wxBitmap(m_ResourcefilePath + wxT("image/unmute.png"), wxBITMAP_TYPE_PNG), wxPoint(90, 49),
        wxSize(28, 30), 0, _T("ID_STBITMAPMUTESTATUS"));
    #if defined(__UNIX__)
    //Show the image of progress bar
    m_pStaticBitmapBrightness[6] = new wxStaticBitmap(this, ID_STATICBITMAPBRIGHTNESS6, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS6Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID6"));
    m_pStaticBitmapBrightness[5] = new wxStaticBitmap(this, ID_STATICBITMAPBRIGHTNESS5, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS5Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID5"));
    m_pStaticBitmapBrightness[4] = new wxStaticBitmap(this, ID_STATICBITMAPBRIGHTNESS4, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS4Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID4"));
    m_pStaticBitmapBrightness[3] = new wxStaticBitmap(this, ID_STATICBITMAPBRIGHTNESS3, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS3Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID3"));
    m_pStaticBitmapBrightness[2] = new wxStaticBitmap(this, ID_STATICBITMAPBRIGHTNESS2, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS2Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID2"));
    m_pStaticBitmapBrightness[1] = new wxStaticBitmap(this, ID_STATICBITMAPBRIGHTNESS1, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS1Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID1"));
    m_pStaticBitmapBrightness[0] = new wxStaticBitmap(this, ID_STATICBITMAPBRIGHTNESS0, wxNullBitmap,
        wxPoint(BRIGHT_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS0Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID0"));

    m_pStaticBitmapVolume[6] = new wxStaticBitmap(this, ID_STATICBITMAPVOLUME6, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS6Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID6"));
    m_pStaticBitmapVolume[5] = new wxStaticBitmap(this, ID_STATICBITMAPVOLUME5, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS5Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID5"));
    m_pStaticBitmapVolume[4] = new wxStaticBitmap(this, ID_STATICBITMAPVOLUME4, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS4Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID4"));
    m_pStaticBitmapVolume[3] = new wxStaticBitmap(this, ID_STATICBITMAPVOLUME3, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS3Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID3"));
    m_pStaticBitmapVolume[2] = new wxStaticBitmap(this, ID_STATICBITMAPVOLUME2, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS2Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID2"));
    m_pStaticBitmapVolume[1] = new wxStaticBitmap(this, ID_STATICBITMAPVOLUME1, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS1Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID1"));
    m_pStaticBitmapVolume[0] = new wxStaticBitmap(this, ID_STATICBITMAPVOLUME0, wxNullBitmap,
        wxPoint(VOL_PRO_BAR_POS_X, BRIGHTVOL_PRO_BAR_POS0Y),
        wxSize(PRO_BAR_SIZE_X, PRO_BAR_SIZE_Y), 0, _T("ID0"));
    #endif

    #if defined(__WXMSW__)
    //The QCP don't display on taskbar
    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);

    m_pStaticTextTitle = new wxCustomStatic(this, ID_STATICTEXTTITLE, wxEmptyString, wxPoint(10, 7),
        wxSize(45, 30), wxTRANSPARENT_WINDOW, _T("ID_STATICTEXTTITLE"));
    wxFont m_pStaticTextTitleFont(12, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);

    m_pBitmapClose = new wxBitmapButton(this, ID_BITMAPBUTTONCLOSE,
        wxBitmap(m_ResourcefilePath + wxT("image/close_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(233, 7), wxSize(32, 32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONCLOSE"));
    m_pBitmapAbout = new wxBitmapButton(this, ID_BITMAPBUTTONABOUT,
        wxBitmap(m_ResourcefilePath + wxT("image/about_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(198, 7), wxSize(32, 32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONABOUT"));
    m_pBitmapBrightnessUp = new wxBitmapButton(this, ID_BITMAPBUTTONBRIGHTNESSUP,
        wxBitmap(m_ResourcefilePath + wxT("image/up_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(20, 85), wxSize(41, 24), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONBrightnessUp"));
    m_pBitmapBrightnessDown = new wxBitmapButton(this, ID_BITMAPBUTTONBRIGHTNESSDOWN,
        wxBitmap(m_ResourcefilePath + wxT("image/down_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(20, 227), wxSize(41, 24), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONBrightnessDown"));
    m_pBitmapVolumeUp   = new wxBitmapButton(this, ID_BITMAPBUTTONVOLUMEUP,
        wxBitmap(m_ResourcefilePath + wxT("image/up_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(81, 85), wxSize(41, 24), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONBrightnessUp"));
    m_pBitmapVolumeDown = new wxBitmapButton(this, ID_BITMAPBUTTONVOLUMEDOWN,
        wxBitmap(m_ResourcefilePath + wxT("image/down_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(81, 227), wxSize(41, 24), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONBrightnessDown"));

    m_pBkmapnormal = new wxBitmap(m_ResourcefilePath + wxT("image/button_normal.png"), wxBITMAP_TYPE_PNG);
    m_pBkmapover = new wxBitmap(m_ResourcefilePath + wxT("image/button_over.png"), wxBITMAP_TYPE_PNG);
    m_pBkmapdown = new wxBitmap(m_ResourcefilePath + wxT("image/button_down.png"), wxBITMAP_TYPE_PNG);
    m_pBkmapdisable = new wxBitmap(m_ResourcefilePath + wxT("image/button_disable.png"), wxBITMAP_TYPE_PNG);

    //Setting status of Rotation button
    m_pBkmapRotationnormal = new wxBitmap(m_ResourcefilePath + wxT("image/rotation_normal.png"), wxBITMAP_TYPE_PNG);
    m_pBkmapRotationover = new wxBitmap(m_ResourcefilePath + wxT("image/rotation_over.png"), wxBITMAP_TYPE_PNG);
    m_pBkmapRotationdown = new wxBitmap(m_ResourcefilePath + wxT("image/rotation_down.png"), wxBITMAP_TYPE_PNG);
    m_pBkmapRotationdisable = new wxBitmap(m_ResourcefilePath + wxT("image/rotation_disable.png"), wxBITMAP_TYPE_PNG);

    wxMemoryDC dc;
    m_pBkmapMute = new wxBitmap(121, 49);
    m_pBkmapUnMute = new wxBitmap(121, 49);
    m_pBkmapShowCursor = new wxBitmap(121, 49);
    m_pBkmapHideCursor = new wxBitmap(121, 49);
    m_pBkmapSwitchExternal = new wxBitmap(121, 49);
    m_pBkmapSwitchInternal = new wxBitmap(121, 49);
    m_pBkmapCalScreen = new wxBitmap(121, 49);
    m_pBkmapRotation = new wxBitmap(103, 49);

	m_pBitMute = new wxBitmapButton(this, ID_BITMAPBUTTONMUTE, *m_pBkmapMute,
        wxPoint(139, 156), wxSize(121, 49), wxNO_BORDER, wxDefaultValidator, _T("ID_BTNMUTE"));
    m_pBitShowCursor = new wxBitmapButton(this, ID_BITMAPBUTTONSHOWCURSOR, *m_pBkmapShowCursor,
        wxPoint(139, 211), wxSize(121, 49), wxNO_BORDER, wxDefaultValidator, _T("ID_BTNCURSOR"));
    m_pBitSwitchDisplay = new wxBitmapButton(this, ID_BITMAPBUTTONSWITCHDISPLAY, *m_pBkmapSwitchExternal,
        wxPoint(139, 46), wxSize(121, 49), wxNO_BORDER, wxDefaultValidator, _T("ID_BTNSWITCH"));
    m_pBitCalScreen = new wxBitmapButton(this, ID_BITMAPBUTTONCALSCREEN, *m_pBkmapCalScreen,
        wxPoint(139, 101), wxSize(121, 49), wxNO_BORDER, wxDefaultValidator, _T("ID_BTNCAL"));
    m_pBtnRotation = new wxBitmapButton(this, ID_BITMAPBUTTONMANUALROTATION, *m_pBkmapRotation,
        wxPoint(7, 279), wxSize(103, 49), wxNO_BORDER, wxDefaultValidator, _T("ID_BTNROTATION"));

    wxString stIconDisable;

/**************************************************************************************************
* Function Name : ~CMPC_QCPDialog                                                                 *
* Description  	:                                                                                 *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
    stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
    RedrawBitmapBtn(_("Mute"), m_ResourcefilePath +
        wxT("image/status_yes.png"), stIconDisable, m_pBitMute, m_pBkmapMute, &dc);
    RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath +
        wxT("image/status_no.png"), stIconDisable, m_pBitShowCursor, m_pBkmapShowCursor, &dc);

    stIconDisable = m_ResourcefilePath + wxT("image/display_disable.png");
    RedrawBitmapBtn(_("Switch\nDisplay"), m_ResourcefilePath +
        wxT("image/display.png"), stIconDisable, m_pBitSwitchDisplay, m_pBkmapSwitchInternal, &dc);
    stIconDisable = m_ResourcefilePath + wxT("image/calibrate_screen_disable.png");
    RedrawBitmapBtn(_("Calibrate\nScreen"), m_ResourcefilePath +
        wxT("image/calibrate_screen.png"), stIconDisable, m_pBitCalScreen, m_pBkmapCalScreen, &dc);
    RedrawRotationBitmapBtn(_("Auto\nRotation"), m_ResourcefilePath +
        wxT("image/status_yes.png"), m_pBtnRotation, m_pBkmapRotation, &dc);

    //Setting status of close and about buttons
    m_pBitmapClose->SetBitmapSelected(wxBitmap(m_ResourcefilePath +
        wxT("image/close_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapClose->SetBitmapHover(wxBitmap(m_ResourcefilePath +
        wxT("image/close_over.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapAbout->SetBitmapSelected(wxBitmap(m_ResourcefilePath +
        wxT("image/about_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapAbout->SetBitmapHover(wxBitmap(m_ResourcefilePath +
        wxT("image/about_over.png"), wxBITMAP_TYPE_PNG));

    m_pBitmapBrightnessUp->SetBitmapDisabled(wxBitmap(m_ResourcefilePath +
        wxT("image/up_disable.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessUp->SetBitmapSelected(wxBitmap(m_ResourcefilePath +
        wxT("image/up_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessUp->SetBitmapHover(wxBitmap(m_ResourcefilePath +
        wxT("image/up_over.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessDown->SetBitmapDisabled(wxBitmap(m_ResourcefilePath +
        wxT("image/down_disable.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessDown->SetBitmapSelected(wxBitmap(m_ResourcefilePath +
        wxT("image/down_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessDown->SetBitmapHover(wxBitmap(m_ResourcefilePath +
        wxT("image/down_over.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeUp->SetBitmapDisabled(wxBitmap(m_ResourcefilePath +
        wxT("image/up_disable.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeUp->SetBitmapSelected(wxBitmap(m_ResourcefilePath +
        wxT("image/up_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeUp->SetBitmapHover(wxBitmap(m_ResourcefilePath +
        wxT("image/up_over.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeDown->SetBitmapDisabled(wxBitmap(m_ResourcefilePath +
        wxT("image/down_disable.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeDown->SetBitmapSelected(wxBitmap(m_ResourcefilePath +
        wxT("image/down_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeDown->SetBitmapHover(wxBitmap(m_ResourcefilePath +
        wxT("image/down_over.png"), wxBITMAP_TYPE_PNG));

    m_pBkCWmap = new wxBitmap(48, 49);
    wxBitmap *CWIcon = new wxBitmap(m_ResourcefilePath +
        wxT("image/left90_normal.png"), wxBITMAP_TYPE_PNG);
    wxBitmap *CWIconDisable = new wxBitmap(m_ResourcefilePath +
        wxT("image/left90_disable.png"), wxBITMAP_TYPE_PNG);
    m_pBitmapCW  = new wxBitmapButton(this, ID_BITMAPBUTTONCW, *m_pBkCWmap,
        wxPoint(113, 279), wxSize(48, 49), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONCW"));
    //m_pBitmapCW->Disable();

    m_pBkCCWmap = new wxBitmap(48, 49);
    wxBitmap *CCWIcon = new wxBitmap(m_ResourcefilePath +
        wxT("image/right90_normal.png"), wxBITMAP_TYPE_PNG);
    wxBitmap *CCWIconDisable = new wxBitmap(m_ResourcefilePath +
        wxT("image/right90_disable.png"), wxBITMAP_TYPE_PNG);
    m_pBitmapCCW = new wxBitmapButton(this, ID_BITMAPBUTTONCCW, *m_pBkCCWmap,
        wxPoint(163, 279), wxSize(48, 49), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONCCW"));

    m_pBk180Degree = new wxBitmap(48, 49);
    wxBitmap *Bk180DegreeIcon = new wxBitmap(m_ResourcefilePath +
        wxT("image/180_normal.png"), wxBITMAP_TYPE_PNG);
    wxBitmap *Bk180DegreeIconDisable = new wxBitmap(m_ResourcefilePath +
        wxT("image/180_disable.png"), wxBITMAP_TYPE_PNG);
    m_pBitmapBtn180Degree = new wxBitmapButton(this, ID_BITMAPBTN180DEGREE, *m_pBk180Degree,
        wxPoint(213, 279), wxSize(48, 49), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBTN180DEGREE"));

    m_bRotationIcon = true;
    //draw CW button;
    ButtonState(_T(""), m_pBkCWmap, CWIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_normal.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapCW->SetBitmapLabel(*m_pBkCWmap);
    ButtonState(_T(""), m_pBkCWmap, CWIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_over.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapCW->SetBitmapHover(*m_pBkCWmap);
    ButtonState(_T(""), m_pBkCWmap, CWIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_down.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapCW->SetBitmapSelected(*m_pBkCWmap);
    ButtonState(_T(""), m_pBkCWmap, CWIconDisable, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_disable.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapCW->SetBitmapDisabled(*m_pBkCWmap);
    if (CWIcon)
    {
        delete CWIcon;
        CWIcon = NULL;
    }
    if (CWIconDisable)
    {
        delete CWIconDisable;
        CWIconDisable = NULL;
    }
    //draw CCW button;
    ButtonState(_T(""), m_pBkCCWmap, CCWIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_normal.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapCCW->SetBitmapLabel(*m_pBkCCWmap);
    ButtonState(_T(""), m_pBkCCWmap, CCWIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_over.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapCCW->SetBitmapHover(*m_pBkCCWmap);
    ButtonState(_T(""), m_pBkCCWmap, CCWIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_down.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapCCW->SetBitmapSelected(*m_pBkCCWmap);
    ButtonState(_T(""), m_pBkCCWmap, CCWIconDisable, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_disable.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapCCW->SetBitmapDisabled(*m_pBkCCWmap);
    if (CCWIcon)
    {
        delete CCWIcon;
        CCWIcon = NULL;
    }
    if (CCWIconDisable)
    {
        delete CCWIconDisable;
        CCWIconDisable = NULL;
    }
    //draw 180 button;
    ButtonState(_T(""), m_pBk180Degree, Bk180DegreeIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_normal.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapBtn180Degree->SetBitmapLabel(*m_pBk180Degree);
    ButtonState(_T(""), m_pBk180Degree, Bk180DegreeIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_over.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapBtn180Degree->SetBitmapHover(*m_pBk180Degree);
    ButtonState(_T(""), m_pBk180Degree, Bk180DegreeIcon, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_down.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapBtn180Degree->SetBitmapSelected(*m_pBk180Degree);
    ButtonState(_T(""), m_pBk180Degree, Bk180DegreeIconDisable, &wxBitmap(m_ResourcefilePath +
        wxT("image/button90_disable.png"), wxBITMAP_TYPE_PNG), &dc);
    m_pBitmapBtn180Degree->SetBitmapDisabled(*m_pBk180Degree);
    if (Bk180DegreeIcon)
    {
        delete Bk180DegreeIcon;
        Bk180DegreeIcon = NULL;
    }
    if (Bk180DegreeIconDisable)
    {
        delete Bk180DegreeIconDisable;
        Bk180DegreeIconDisable = NULL;
    }

    m_bRotationIcon = false;

    #elif defined(__UNIX__)

    //Create title bar an setting the title format
    m_pStaticTextTitle = new wxStaticText(this, ID_STATICTEXTTITLE, wxEmptyString, wxPoint(8, 4),
        wxSize(45, 20), wxTRANSPARENT_WINDOW, _T("ID_STATICTEXTTITLE"));
    wxFont m_pStaticTextTitleFont(12, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Rasheeq"), wxFONTENCODING_DEFAULT);

    m_pBitmapClose = new wxBitmapButton(this, ID_BITMAPBUTTONCLOSE, wxBitmap(m_ResourcefilePath +
        wxT("image/linuxclose_normal.png"), wxBITMAP_TYPE_PNG), wxPoint(231, 5),
        wxSize(32, 32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONCLOSE"));
    m_pBitmapAbout = new wxBitmapButton(this, ID_BITMAPBUTTONABOUT, wxBitmap(m_ResourcefilePath +
        wxT("image/linuxabout_normal.png"), wxBITMAP_TYPE_PNG), wxPoint(196, 5),
        wxSize(32, 32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONABOUT"));
    m_pBitmapBrightnessUp = new wxBitmapButton(this, ID_BITMAPBUTTONBRIGHTNESSUP, wxBitmap(m_ResourcefilePath +
        wxT("image/linuxup_normal.png"), wxBITMAP_TYPE_PNG), wxPoint(20, 85),
        wxSize(41, 24), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONBrightnessUp"));
    m_pBitmapBrightnessDown = new wxBitmapButton(this, ID_BITMAPBUTTONBRIGHTNESSDOWN, wxBitmap(m_ResourcefilePath +
        wxT("image/linuxdown_normal.png"), wxBITMAP_TYPE_PNG), wxPoint(20, 227),
        wxSize(41, 24), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONBrightnessDown"));
    m_pBitmapVolumeUp   = new wxBitmapButton(this, ID_BITMAPBUTTONVOLUMEUP, wxBitmap(m_ResourcefilePath +
        wxT("image/linuxup_normal.png"), wxBITMAP_TYPE_PNG), wxPoint(82, 85),
        wxSize(41, 24), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONBrightnessUp"));
    m_pBitmapVolumeDown = new wxBitmapButton(this, ID_BITMAPBUTTONVOLUMEDOWN, wxBitmap(m_ResourcefilePath +
        wxT("image/linuxdown_normal.png"), wxBITMAP_TYPE_PNG), wxPoint(82, 227),
        wxSize(41, 24), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONBrightnessDown"));

    m_pBitSwitchDisplay = new wxBitmapButton(this, ID_BITMAPBUTTONSWITCHDISPLAY,
        wxBitmap(m_ResourcefilePath + wxT("image/button_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(140, 46), wxSize(120, 50), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONSWITCHDISPLAY"));
    m_pBitCalScreen = new wxBitmapButton(this, ID_BITMAPBUTTONCALSCREEN,
        wxBitmap(m_ResourcefilePath + wxT("image/button_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(140, 101), wxSize(120, 50), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONCALSCREEN"));
    m_pBitMute = new wxBitmapButton(this, ID_BITMAPBUTTONMUTE,
        wxBitmap(m_ResourcefilePath + wxT("image/button_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(140, 156), wxSize(120, 50), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONMUTE"));
    m_pBitShowCursor = new wxBitmapButton(this, ID_BITMAPBUTTONSHOWCURSOR,
        wxBitmap(m_ResourcefilePath + wxT("image/button_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(140, 211), wxSize(120, 50), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONSHOWCURSOR"));
    m_pBtnRotation = new wxBitmapButton(this, ID_BITMAPBUTTONMANUALROTATION,
        wxBitmap(m_ResourcefilePath + wxT("image/rotation_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(7, 277), wxSize(103, 50), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONMANUALROTATION"));
    m_pBitmapCW  = new wxBitmapButton(this, ID_BITMAPBUTTONCW,
        wxBitmap(m_ResourcefilePath + wxT("image/button90_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(113, 277), wxSize(48, 50), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONCW"));
    m_pBitmapCCW = new wxBitmapButton(this, ID_BITMAPBUTTONCCW,
        wxBitmap(m_ResourcefilePath + wxT("image/button90_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(163, 277), wxSize(48, 50), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTONCCW"));
    m_pBitmapBtn180Degree = new wxBitmapButton(this, ID_BITMAPBTN180DEGREE,
        wxBitmap(m_ResourcefilePath + wxT("image/button90_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(213, 277), wxSize(48, 50), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBTN180DEGREE"));

    //The StaticBitmap show image of buttons
    m_pStaticBitmapSwitchDisplay = new wxStaticBitmap(this, ID_STATICTBITMAPSWITCHDISPLAY,
        wxBitmap(m_ResourcefilePath + wxT("image/display.png"), wxBITMAP_TYPE_PNG), wxPoint(147, 54),
        wxSize(111, 41), wxTRANSPARENT_WINDOW, _T("ID_STATICTBITMAPSWITCHDISPLAY"));
    m_pStaticBitmapCalScreen = new wxStaticBitmap(this, ID_STATICTBITMAPCALSCREEN,
        wxBitmap(m_ResourcefilePath + wxT("image/calibrate_screen.png"), wxBITMAP_TYPE_PNG), wxPoint(147, 109),
        wxSize(111, 41), wxTRANSPARENT_WINDOW, _T("ID_STATICTBITMAPCALSCREEN"));
    m_pStaticBitmapMute = new wxStaticBitmap(this, ID_STATICTBITMAPMUTE, wxNullBitmap,
        wxPoint(147, 166), wxSize(111, 41), 0, _T("ID_STATICTBITMAPMUTE"));
    m_pStaticBitmapShowCursor = new wxStaticBitmap(this, ID_STATICTBITMAPSHOWCURSOR, wxNullBitmap,
        wxPoint(147, 219), wxSize(111, 41), wxTRANSPARENT_WINDOW, _T("ID_STATICTBITMAPSHOWCURSOR"));
    m_pStaticBitmapManualRotation = new wxStaticBitmap(this, ID_STATICTBITMAPMANUALROTATION,
        wxBitmap(m_ResourcefilePath + wxT("image/status_no.png"), wxBITMAP_TYPE_PNG),
        wxPoint(12, 287), wxSize(111, 41), wxTRANSPARENT_WINDOW, _T("ID_STATICTBITMAPMANUALROTATION"));
    m_pStaticBitMapCW = new wxStaticBitmap(this, ID_STATICTBITMAPCW,
        wxBitmap(m_ResourcefilePath + wxT("image/left90_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(122, 284), wxSize(48, 50), 0, _T("ID_STATICTBITMAPCW"));
    m_pStaticBitMapCCW = new wxStaticBitmap(this, ID_STATICTBITMAPCCW,
        wxBitmap(m_ResourcefilePath + wxT("image/right90_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(172, 284), wxSize(48, 50), 0, _T("ID_STATICTBITMAPCCW"));
    m_pStaticBitMap180Degree = new wxStaticBitmap(this, ID_STBIT180DEGREE,
        wxBitmap(m_ResourcefilePath + wxT("image/180_normal.png"), wxBITMAP_TYPE_PNG),
        wxPoint(222, 285), wxSize(48, 50), 0, _T("ID_STBIT180DEGREE"));
    //Setting the status of buttons
    m_pBitmapClose->SetBitmapSelected(wxBitmap(m_ResourcefilePath + wxT("image/linuxclose_down.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapClose->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/linuxclose_over.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapAbout->SetBitmapSelected(wxBitmap(m_ResourcefilePath + wxT("image/linuxabout_down.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapAbout->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/linuxabout_over.png"),
        wxBITMAP_TYPE_PNG));

    m_pBitmapBrightnessUp->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/linuxup_disable.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessUp->SetBitmapSelected(wxBitmap(m_ResourcefilePath + wxT("image/linuxup_down.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessUp->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/linuxup_over.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessDown->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/linuxdown_disable.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessDown->SetBitmapSelected(wxBitmap(m_ResourcefilePath + wxT("image/linuxdown_down.png"),
         wxBITMAP_TYPE_PNG));
    m_pBitmapBrightnessDown->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/linuxdown_over.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeUp->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/linuxup_disable.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeUp->SetBitmapSelected(wxBitmap(m_ResourcefilePath + wxT("image/linuxup_down.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeUp->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/linuxup_over.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeDown->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/linuxdown_disable.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeDown->SetBitmapSelected(wxBitmap(m_ResourcefilePath + wxT("image/linuxdown_down.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapVolumeDown->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/linuxdown_over.png"),
        wxBITMAP_TYPE_PNG));

    m_pBitMute->SetBitmapFocus(wxBitmap(m_ResourcefilePath + wxT("image/button_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitMute->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/button_over.png"), wxBITMAP_TYPE_PNG));
    m_pBitMute->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/button_disable.png"), wxBITMAP_TYPE_PNG));
    m_pBitShowCursor->SetBitmapFocus(wxBitmap(m_ResourcefilePath + wxT("image/button_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitShowCursor->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/button_over.png"), wxBITMAP_TYPE_PNG));
    m_pBitShowCursor->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/button_disable.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitSwitchDisplay->SetBitmapFocus(wxBitmap(m_ResourcefilePath + wxT("image/button_down.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitSwitchDisplay->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/button_over.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitSwitchDisplay->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/button_disable.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitCalScreen->SetBitmapFocus(wxBitmap(m_ResourcefilePath + wxT("image/button_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitCalScreen->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/button_over.png"), wxBITMAP_TYPE_PNG));
    m_pBitCalScreen->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/button_disable.png"),
        wxBITMAP_TYPE_PNG));
    m_pBtnRotation->SetBitmapFocus(wxBitmap(m_ResourcefilePath + wxT("image/rotation_down.png"), wxBITMAP_TYPE_PNG));
    m_pBtnRotation->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/rotation_over.png"), wxBITMAP_TYPE_PNG));
    m_pBtnRotation->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/rotation_disable.png"),
        wxBITMAP_TYPE_PNG));

    m_pBitmapCW->SetBitmapFocus(wxBitmap(m_ResourcefilePath + wxT("image/button90_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapCW->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/button90_over.png"), wxBITMAP_TYPE_PNG));
    //m_pBitmapCW->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/left90_disable.png"),
        //wxBITMAP_TYPE_PNG));
    m_pBitmapCW->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/button90_disable.png"),
        wxBITMAP_TYPE_PNG));

    m_pBitmapCCW->SetBitmapFocus(wxBitmap(m_ResourcefilePath + wxT("image/button90_down.png"), wxBITMAP_TYPE_PNG));
    m_pBitmapCCW->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/button90_over.png"), wxBITMAP_TYPE_PNG));
    //m_pBitmapCCW->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/right90_disable.png"),
        //wxBITMAP_TYPE_PNG));
    m_pBitmapCCW->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/button90_disable.png"),
        wxBITMAP_TYPE_PNG));

    m_pBitmapBtn180Degree->SetBitmapFocus(wxBitmap(m_ResourcefilePath + wxT("image/button90_down.png"),
        wxBITMAP_TYPE_PNG));
    m_pBitmapBtn180Degree->SetBitmapHover(wxBitmap(m_ResourcefilePath + wxT("image/button90_over.png"),
        wxBITMAP_TYPE_PNG));
    //m_pBitmapBtn180Degree->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/180_disable.png"),
        //wxBITMAP_TYPE_PNG));
    m_pBitmapBtn180Degree->SetBitmapDisabled(wxBitmap(m_ResourcefilePath + wxT("image/button90_disable.png"),
        wxBITMAP_TYPE_PNG));

    //Show contents of buttons on buttons
    m_pStaticTextSwitchDisplay = new wxStaticText(this, ID_STATICTEXTSWITCHDISPLAY, _("Switch\nDisplay"),
        wxPoint(184, 59), wxDefaultSize, 0, _T("ID_STATICTEXTSWITCHDISPLAY"));
    m_pStaticTextSwitchDisplay->SetForegroundColour(wxColour(71, 83, 107));
    //m_pStaticTextSwitchDisplay->SetForegroundColour(wxColour(190, 190, 190));
    wxFont m_pStaticTextSwitchDisplayFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("FreeSans"),
        wxFONTENCODING_DEFAULT);
    m_pStaticTextSwitchDisplay->SetFont(m_pStaticTextSwitchDisplayFont);

    m_pStaticTextCalScreen  = new wxStaticText(this, ID_STATICTEXTCALSCREEN, _("Calibrate\nScreen"),
        wxPoint(184, 112), wxDefaultSize, 0, _T("ID_STATICTEXTCALSCREEN"));
    m_pStaticTextCalScreen->SetForegroundColour(wxColour(71, 83, 107));
    //  m_pStaticTextCalScreen->SetForegroundColour(wxColour(190, 190, 190));
    wxFont m_pStaticTextCalScreenFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("FreeSans"),
        wxFONTENCODING_DEFAULT);
    m_pStaticTextCalScreen->SetFont(m_pStaticTextCalScreenFont);

    m_pStaticTextMute = new wxStaticText(this, ID_STATICTEXTMUTE, _("Mute"), wxPoint(184, 174),
        wxDefaultSize, 0, _T("ID_STATICTEXTMUTE"));
    m_pStaticTextMute->SetForegroundColour(wxColour(71, 83, 107));
    // m_pStaticTextMute->SetForegroundColour(wxColour(190, 190, 190));
    wxFont m_pStaticTextMuteFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("FreeSans"),
        wxFONTENCODING_DEFAULT);
    m_pStaticTextMute->SetFont(m_pStaticTextMuteFont);

    m_pStaticTextShowCursor = new wxStaticText(this, ID_STATICTEXTSHOWCURSOR, _("Show\nCursor"),
        wxPoint(184, 222), wxDefaultSize, 0, _T("ID_STATICTEXTSHOWCURSOR"));
    m_pStaticTextShowCursor->SetForegroundColour(wxColour(71, 83, 107));
    // m_pStaticTextShowCursor->SetForegroundColour(wxColour(190, 190, 190));
    wxFont m_pStaticTextShowCursorFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("FreeSans"),
        wxFONTENCODING_DEFAULT);
    m_pStaticTextShowCursor->SetFont(m_pStaticTextShowCursorFont);

    m_pStaticTextManualRotation = new wxStaticText(this, ID_STATICTEXTMANUALROTATION, _("Auto\nRotation"),
        wxPoint(45, 289), wxDefaultSize, 0, _T("ID_STATICTEXTMANUALROTATION"));
    m_pStaticTextManualRotation->SetForegroundColour(wxColour(71, 83, 107));
    // m_pStaticTextManualRotation->SetForegroundColour(wxColour(190, 190, 190));
    wxFont m_pStAutoRotationFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("FreeSans"),
        wxFONTENCODING_DEFAULT);
    m_pStaticTextManualRotation->SetFont(m_pStAutoRotationFont);
    #endif

    //Windows&Linux common code, setting the content of QCP title
    m_pStaticTextTitle->SetLabel(_("Quick Controller"));
    m_pStaticTextTitle->SetForegroundColour(wxColour(45, 45, 57));
    m_pStaticTextTitle->SetFont(m_pStaticTextTitleFont);

    //Avoid the bounce of title when the mouse click the title and drag the QCP UI
    m_pStaticTextTitle->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnMouseMove), NULL, this);
    m_pStaticTextTitle->Connect(wxEVT_LEFT_DOWN, wxMouseEventHandler(CMPC_QCPDialog::OnLeftDown), NULL, this);

    #if defined(__WXMSW__)
    //Controling the click event of button
    m_pBitmapClose->Connect(wxEVT_LEAVE_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitmapClose->Connect(wxEVT_ENTER_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitmapAbout->Connect(wxEVT_LEAVE_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitmapAbout->Connect(wxEVT_ENTER_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitmapBrightnessUp->Connect(wxEVT_LEAVE_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton),
        NULL, this);
    m_pBitmapBrightnessUp->Connect(wxEVT_ENTER_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitmapBrightnessDown->Connect(wxEVT_LEAVE_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton),
        NULL, this);
    m_pBitmapBrightnessDown->Connect(wxEVT_ENTER_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter),
        NULL, this);
    for (m_iCount = 0; m_iCount < BRIGHTLEVEL; m_iCount++)
    {
        m_pStBitmapBtnBrightnessLevel[m_iCount]->Connect(wxEVT_LEAVE_WINDOW ,
            wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
        m_pStBitmapBtnBrightnessLevel[m_iCount]->Connect(wxEVT_ENTER_WINDOW ,
            wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    }
    m_pBitmapVolumeUp->Connect(wxEVT_LEAVE_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitmapVolumeUp->Connect(wxEVT_ENTER_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitmapVolumeDown->Connect(wxEVT_LEAVE_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitmapVolumeDown->Connect(wxEVT_ENTER_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    for (m_iCount = 0; m_iCount < VOLUMELEVEL; m_iCount++)
    {
        m_pStBitmapBtnVolumeLevel[m_iCount]->Connect(wxEVT_LEAVE_WINDOW ,
            wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
        m_pStBitmapBtnVolumeLevel[m_iCount]->Connect(wxEVT_ENTER_WINDOW ,
            wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    }
    m_pBitMute->Connect(wxEVT_LEAVE_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitMute->Connect(wxEVT_ENTER_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitShowCursor->Connect(wxEVT_LEAVE_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitShowCursor->Connect(wxEVT_ENTER_WINDOW , wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitSwitchDisplay->Connect(wxEVT_LEAVE_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitSwitchDisplay->Connect(wxEVT_ENTER_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitCalScreen->Connect(wxEVT_LEAVE_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitCalScreen->Connect(wxEVT_ENTER_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBtnRotation->Connect(wxEVT_LEAVE_WINDOW ,
         wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBtnRotation->Connect(wxEVT_ENTER_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitmapCW->Connect(wxEVT_LEAVE_WINDOW ,
         wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitmapCW->Connect(wxEVT_ENTER_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitmapCCW->Connect(wxEVT_LEAVE_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitmapCCW->Connect(wxEVT_ENTER_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    m_pBitmapBtn180Degree->Connect(wxEVT_LEAVE_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseLeaveButton), NULL, this);
    m_pBitmapBtn180Degree->Connect(wxEVT_ENTER_WINDOW ,
        wxMouseEventHandler(CMPC_QCPDialog::OnMouseEnter), NULL, this);
    #endif

    //Control 15 seconds when the mouse move on the button
    m_pBitmapClose->Connect(wxEVT_MOTION,
        wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitmapAbout->Connect(wxEVT_MOTION,
        wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitmapBrightnessUp->Connect(wxEVT_MOTION,
        wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitmapBrightnessDown->Connect(wxEVT_MOTION,
        wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    for (m_iCount = 0; m_iCount < BRIGHTLEVEL; m_iCount++)
    {
        m_pStBitmapBtnBrightnessLevel[m_iCount]->Connect(wxEVT_MOTION,
            wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    }
    m_pBitmapVolumeUp->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitmapVolumeDown->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    for (m_iCount = 0; m_iCount < VOLUMELEVEL; m_iCount++)
    {
        m_pStBitmapBtnVolumeLevel[m_iCount]->Connect(wxEVT_MOTION,
            wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    }
    m_pBitMute->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitShowCursor->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitSwitchDisplay->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitCalScreen->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBtnRotation->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitmapCW->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitmapCCW->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);
    m_pBitmapBtn180Degree->Connect(wxEVT_MOTION, wxMouseEventHandler(CMPC_QCPDialog::OnButtonMouseMove), NULL, this);

    //Adjust brightness level on the progress bar of brightness
    Connect(ID_STBITMAPBTNBRIGHTNESS6, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitBrightnessLev6Click);
    Connect(ID_STBITMAPBTNBRIGHTNESS5, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitBrightnessLev5Click);
    Connect(ID_STBITMAPBTNBRIGHTNESS4, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitBrightnessLev4Click);
    Connect(ID_STBITMAPBTNBRIGHTNESS3, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitBrightnessLev3Click);
    Connect(ID_STBITMAPBTNBRIGHTNESS2, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitBrightnessLev2Click);
    Connect(ID_STBITMAPBTNBRIGHTNESS1, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitBrightnessLev1Click);
    Connect(ID_STBITMAPBTNBRIGHTNESS0, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitBrightnessLev0Click);

    //Adjust volume level on the progress bar of volume
    Connect(ID_STBTNMAPVOLUMELEVEL6, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitVolumeLev6Click);
    Connect(ID_STBTNMAPVOLUMELEVEL5, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitVolumeLev5Click);
    Connect(ID_STBTNMAPVOLUMELEVEL4, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitVolumeLev4Click);
    Connect(ID_STBTNMAPVOLUMELEVEL3, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitVolumeLev3Click);
    Connect(ID_STBTNMAPVOLUMELEVEL2, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitVolumeLev2Click);
    Connect(ID_STBTNMAPVOLUMELEVEL1, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitVolumeLev1Click);
    Connect(ID_STBTNMAPVOLUMELEVEL0, wxEVT_COMMAND_BUTTON_CLICKED ,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitVolumeLev0Click);

    Connect(ID_BITMAPBUTTONMANUALROTATION, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBtnRotationClick);
    Connect(ID_BITMAPBUTTONCLOSE, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapCloseClick);
    Connect(ID_BITMAPBUTTONABOUT, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapAboutClick);
    Connect(ID_BITMAPBUTTONVOLUMEUP, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapVolumeUpClick);
    Connect(ID_BITMAPBUTTONVOLUMEDOWN, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapVolumeDownClick);
    Connect(ID_BITMAPBUTTONBRIGHTNESSUP, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapBrightnessUpClick);
    Connect(ID_BITMAPBUTTONBRIGHTNESSDOWN, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapBrightnessDownClick);

    Connect(ID_BITMAPBUTTONMUTE, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitMuteClick);

    Connect(ID_BITMAPBUTTONSHOWCURSOR, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitShowCursorClick);
    Connect(ID_BITMAPBUTTONSWITCHDISPLAY, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitSwitchDisplayClick);
    Connect(ID_BITMAPBUTTONCALSCREEN, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitCalScreenClick);
    Connect(ID_BITMAPBUTTONCW, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapCWClick);
    Connect(ID_BITMAPBUTTONCCW, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapCCWClick);
    Connect(ID_BITMAPBTN180DEGREE, wxEVT_COMMAND_BUTTON_CLICKED,
        (wxObjectEventFunction)&CMPC_QCPDialog::Onm_pBitmapBtn180DegreeClick);

    Initialize();     //QCP initialize

    m_pTimer->Start(TIME_INTERVAL + 100); //Start count times for closing QCP App after 15 seconds
   	m_pResolutionTimer->Start(TIMER_RESOLUTION);
}

/**************************************************************************************************
* Function Name : ~CMPC_QCPDialog                                                                 *
* Description  	:                                                                                 *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
CMPC_QCPDialog::~CMPC_QCPDialog()
{
    if ( NULL != m_pTimer )
    {
        delete m_pTimer;
        m_pTimer = NULL;
    }

    if ( NULL != m_pResolutionTimer )
    {
        m_pResolutionTimer->Stop();
        delete m_pResolutionTimer;
        m_pResolutionTimer = NULL;
    }

    if (NULL != g_pQCPInterface)
   {
        delete g_pQCPInterface;
        g_pQCPInterface = NULL;
   }

    delete m_pStaticTextTitle;
    delete m_pBitmapClose;
    delete m_pBitmapAbout;
    m_pStaticTextTitle = NULL;
    m_pBitmapClose = NULL;
    m_pBitmapAbout = NULL;

    delete m_pBitmapBrightnessUp;
    delete m_pBitmapBrightnessDown;
    m_pBitmapBrightnessUp   = NULL;
    m_pBitmapBrightnessDown = NULL;
    for (m_iCount = 0; m_iCount < BRIGHTLEVEL; m_iCount++)
    {
        delete m_pStBitmapBtnBrightnessLevel[m_iCount];
        m_pStBitmapBtnBrightnessLevel[m_iCount] = NULL;
    }
    #if defined(__UNIX__)
    for (m_iCount = 0; m_iCount < BRIGHTLEVEL; m_iCount++)
    {
        delete m_pStaticBitmapBrightness[m_iCount];
        m_pStaticBitmapBrightness[m_iCount] = NULL;
    }
    #endif

    delete m_pBitmapVolumeDown;
    delete m_pBitmapVolumeUp;
    m_pBitmapVolumeDown = NULL;
    m_pBitmapVolumeUp   = NULL;
    for (m_iCount = 0; m_iCount < VOLUMELEVEL; m_iCount++)
    {
        delete m_pStBitmapBtnVolumeLevel[m_iCount];
        m_pStBitmapBtnVolumeLevel[m_iCount] = NULL;
    }
    #if defined(__UNIX__)
    for (m_iCount = 0; m_iCount < VOLUMELEVEL; m_iCount++)
    {
        delete m_pStaticBitmapVolume[m_iCount];
        m_pStaticBitmapVolume[m_iCount] = NULL;
    }
    #endif
    delete m_pStMapMute;
    delete m_pBitMute;
    delete m_pBitShowCursor;
    delete m_pBitSwitchDisplay;
    delete m_pBitCalScreen;
    delete m_pBtnRotation;
    delete m_pBitmapCW;
    delete m_pBitmapCCW;
    delete m_pBitmapBtn180Degree;

    m_pStMapMute = NULL;
    m_pBitMute       = NULL;
    m_pBitShowCursor = NULL;
    m_pBitSwitchDisplay = NULL;
    m_pBitCalScreen     = NULL;
    m_pBtnRotation = NULL;
    m_pBitmapCW  = NULL;
    m_pBitmapCCW = NULL;
    m_pBitmapBtn180Degree = NULL;

    #if defined(__WXMSW__)
    delete m_pBkmapnormal;
    delete m_pBkmapover;
    delete m_pBkmapdown;
    delete m_pBkmapdisable;

    delete m_pBkmapRotationnormal;
    delete m_pBkmapRotationover;
    delete m_pBkmapRotationdown;
    delete m_pBkmapRotationdisable;
    delete m_pBkmapMute;
    delete m_pBkmapUnMute;
    delete m_pBkmapShowCursor;
    delete m_pBkmapHideCursor;
    delete m_pBkmapSwitchExternal;
    delete m_pBkmapSwitchInternal;
    delete m_pBkmapCalScreen;
    delete m_pBkmapRotation;
    delete m_pBkCWmap;
    delete m_pBkCCWmap;
    delete m_pBk180Degree;

    m_pBkmapnormal = NULL;
    m_pBkmapover   = NULL;
    m_pBkmapdown   = NULL;
    m_pBkmapdisable = NULL;
    m_pBkmapRotationnormal  = NULL;
    m_pBkmapRotationover    = NULL;
    m_pBkmapRotationdown    = NULL;
    m_pBkmapRotationdisable = NULL;
    m_pBkmapMute    = NULL;
    m_pBkmapUnMute  = NULL;
    m_pBkmapShowCursor = NULL;
    m_pBkmapHideCursor = NULL;
    m_pBkmapSwitchExternal = NULL;
    m_pBkmapSwitchInternal = NULL;
    m_pBkmapCalScreen      = NULL;
    m_pBkmapRotation = NULL;
    m_pBkCWmap   = NULL;
    m_pBkCCWmap  = NULL;
    m_pBk180Degree = NULL;

    #elif defined(__UNIX__)
    delete m_pStaticBitmapMute;
    delete m_pStaticBitmapShowCursor;
    delete m_pStaticBitmapSwitchDisplay;
    delete m_pStaticBitmapCalScreen;
    delete m_pStaticBitmapManualRotation;
    delete m_pStaticBitMapCW;
    delete m_pStaticBitMapCCW;
    delete m_pStaticBitMap180Degree;
    delete m_pStaticTextMute;
    delete m_pStaticTextShowCursor;
    delete m_pStaticTextSwitchDisplay;
    delete m_pStaticTextCalScreen;
    delete m_pStaticTextManualRotation;

    m_pStaticBitmapMute       = NULL;
    m_pStaticBitmapShowCursor = NULL;
    m_pStaticBitmapSwitchDisplay = NULL;
    m_pStaticBitmapCalScreen     = NULL;
    m_pStaticBitmapManualRotation = NULL;
    m_pStaticBitMapCW  = NULL;
    m_pStaticBitMapCCW = NULL;
    m_pStaticBitMap180Degree = NULL;
    m_pStaticTextMute  = NULL;
    m_pStaticTextShowCursor    = NULL;
    m_pStaticTextSwitchDisplay = NULL;
    m_pStaticTextCalScreen     = NULL;
    m_pStaticTextManualRotation = NULL;
    #endif


#ifdef QCP_DEBUG
    dcsLog << "Log close\n"<< endl;
    dcsLog.close();
#endif
}

/**************************************************************************************************
* Function Name : DCS_TabletSensor_Handle                                                         *
* Description  	:                                                                                 *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CALLBACK DCS_TabletSensor_Handle(DCS_Tablet_Sensor_Data *pDeviceMode)
{
    #ifdef QCP_DEBUG
    dcsLog << "DCS_TabletSensor_Handle Enter\n"<< endl;
    #endif
    ::wxGetApp().GetInstance()->UpdateCursorUI(pDeviceMode);
    #ifdef QCP_DEBUG
    dcsLog << "DCS_TabletSensor_Handle End\n"<< endl;
    #endif
}

#if defined(__WXMSW__)
//Synchronization brightness between system and QCP under Windows
/**************************************************************************************************
* Function Name : DCS_FnKey_handler                                                               *
* Description  	:                                                                                 *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CALLBACK DCS_FnKey_handler(DCS_VKbd_Data *pData)
{
    if (( NULL == pData ) || (NULL == ::wxGetApp().GetInstance()))
    {
        return;
    }

    int iLevel = 0;
    switch (*pData)//Current operate code
    {
        case FN_BRIGHTNESS_DOWN:
            iLevel = ::wxGetApp().GetInstance()->GetBrightnessLevel();
            if (iLevel > 0)
            {
                --iLevel;//Down brightness level

                //Update the brightness level of QCP UI
                ::wxGetApp().GetInstance()->UpdateBrightUI(iLevel);
            }
            break;

        case FN_BRIGHTNESS_UP:
            iLevel = ::wxGetApp().GetInstance()->GetBrightnessLevel();//Getting current brightness level
            if (iLevel < BRIGHTLEVEL)
            {
                ++iLevel;//Up brightness level

                //Update the brightness level of QCP UI
                ::wxGetApp().GetInstance()->UpdateBrightUI(iLevel);
            }
            break;

        default://Other operation
            break;
    }
}

/**************************************************************************************************
* Function Name : PM_BrightnessChange_handler                                                     *
* Description  	:                                                                                 *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CALLBACK PM_BrightnessChange_handler(int* piBright)
{
    if (NULL == piBright)//piBright is current brightness level
    {
        return;
    }

    if (true == g_bBrightSynControlUI)
    {
        g_bBrightSynControlUI = false;
        return;
    }

    if (NULL != wxGetApp().GetInstance())
    {
        CScanEvent event(ID_SCAN_BRIGHTNESS);
        event.SetBrightLevel(*piBright);
        ::wxPostEvent(wxGetApp().GetInstance(), event); //Send message for update UI
    }
}
#elif defined(__UNIX__)

//Synchronization brightness between system and QCP under Linux
/**************************************************************************************************
* Function Name : LCDBrightnessChangeCallback                                                     *
* Description  	:                                                                                 *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CALLBACK LCDBrightnessChangeCallback(int* piBright)
{
    #ifdef QCP_DEBUG
    dcsLog << "LCDBrightnessChangeCallback Enter!\n" << endl;
    #endif

    if (NULL == piBright)//piBright is current brightness level
    {
        #ifdef QCP_DEBUG
        dcsLog << "LCDBrightnessChangeCallback End piBright NULL\n" << endl;
        #endif
        return;
    }

    if (true == g_bBrightSynControlUI)
    {
        g_bBrightSynControlUI = false;
        #ifdef QCP_DEBUG
        dcsLog << "LCDBrightnessChangeCallback End g_bBrightSynControlUI false\n" << endl;
        #endif
        return;
    }

    //Update the QCP UI of brightness when brightness changed
    if (NULL != wxGetApp().GetInstance())
    {
        #ifdef QCP_DEBUG
        dcsLog << "wxGetApp\n" << endl;
        #endif
        CScanEvent event(ID_SCAN_BRIGHTNESS);
        event.SetBrightLevel(*piBright);
        ::wxPostEvent(wxGetApp().GetInstance(), event); //Send message for update UI

        #ifdef QCP_DEBUG
        dcsLog << "wxPostEvent\n" << endl;
        #endif
    }
    #ifdef QCP_DEBUG
    dcsLog << "wxEnd\n" << endl;
    dcsLog.close();
    #endif
}
#endif

/**************************************************************************************************
* Function Name : OnUpdateBrightUIForSyn                                                     *
* Description  	:                                                                                 *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnUpdateBrightUIForSyn(CScanEvent& Event)
{
    UpdateBrightUI(Event.GetBrightLevel());
}

/**************************************************************************************************
* Function Name : Initialize                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Initialize()
{
    if (NULL == g_pQCPInterface)
    {
        return;
    }

    #if defined(__WXMSW__)
    m_pStaticTextTitle->Disable();
    m_pStMapMute->Disable();
    #endif

    if (false == g_pQCPInterface->QCP_InitVolumeStatus(&m_iVolLevel, &m_bMuteState))
    {   //Can't adjust the volume and set mute when the mix device can't open
        m_bMuteState = true;
        UpdateVolumeUI();
        DisableVolumeButton();
        #if defined(__UNIX__)
        m_pStaticBitmapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes_disable.png"),
        wxBITMAP_TYPE_PNG));
        m_pStaticTextMute->SetForegroundColour(wxColour(190, 190, 190));
        #endif
        m_pBitMute->Disable();

    }
    else  //If the mix device open successfully, update current QCP UI
    {
        UpdateVolumeUI();
    }

    m_bDCSInitRet = false;
    m_bRotationStatus  = AUTOROTATION_DISABLED;
    m_RegBrightnessRet = DCS_FAIL_OPERATION;
    m_FnKeyRet     = DCS_FAIL_OPERATION;
    m_RegTabletRet = DCS_FAIL_OPERATION;

    m_bDCSInitRet = g_pQCPInterface->QCP_InitDCS();
    if ( m_bDCSInitRet )  //Launch the DCS
    {
        #if defined(__WXMSW__)
        //Register Fn Key function
        m_FnKeyRet = DCS_RegisterFnKeyCallback(DCS_FnKey_handler);
        #endif

        //Getting current brightness level only under Widows
        if( false == g_pQCPInterface->QCP_InitBrightnessStatus(&m_iBrightLevel) )
        {
            UpdateBrightUI();
            DisableBrightnessButton();
        }
        else
        {
            UpdateBrightUI();
            #if defined(__WXMSW__)
            //The brightnesss synchronization bewteen QCP and system
            m_RegBrightnessRet = DCS_RegisterLCDBrightnessChangedCallback(PM_BrightnessChange_handler);
            #elif defined(__UNIX__)
            //Register brightness callback function for synchronization bewteen QCP and system
            m_RegBrightnessRet = DCS_RegisterLCDBrightnessChangedCallback(LCDBrightnessChangeCallback);
            #endif
        }

        m_RegTabletRet = DCS_RegisterTabletSensorCallback(DCS_TabletSensor_Handle);

        if (m_RegTabletRet != DCS_SUCCESS)
        {
            #ifdef QCP_DEBUG
            dcsLog << "DCS_RegisterTabletSensorCallback Not Success " << m_RegTabletRet <<  endl;
            #endif
        }

        //Enable the rotation, default auto rotation
        if(false == g_pQCPInterface->QCP_InitRotation(&m_bRotationStatus))
        {
            //If the QCP can't enable the Auto rotation, user can use the button of auto rotation
            UpdateRotationUI();//User can manual rotation, but can't auto rotation
            #if defined(__UNIX__)
            m_pStaticTextManualRotation->SetForegroundColour(wxColour(190, 190, 190));
            #endif
            m_pBtnRotation->Disable();
        }
        else
        {
            UpdateRotationUI(); //Default mode is auto rotation
        }
    }
    else  //The DCS initializtion failed
    {
        //User can't adjust the brightness
        UpdateBrightUI();
        DisableBrightnessButton();
        //User can't auto rotation, but could manual rotation screen
        UpdateRotationUI();
        #if defined(__UNIX__)
        m_pStaticTextManualRotation->SetForegroundColour(wxColour(190, 190, 190));
        #endif
        m_pBtnRotation->Disable();
    }

    //Initialize exe file path for call external application
    CallExternalAppInit(); //Getting the exe file path of external application
}

#if defined(__WXMSW__)
//Redraw BitmapButton
/**************************************************************************************************
* Function Name : RedrawBitmapBtn                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::RedrawBitmapBtn(wxString stText, wxString stIcon, wxString stIconDisable,
    wxBitmapButton* m_pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC)
{
    if (NULL == pDC)
    {
        return;
    }

    wxBitmap IconMap(stIcon, wxBITMAP_TYPE_PNG);
    wxBitmap IconMapDisable(stIconDisable, wxBITMAP_TYPE_PNG);

    ButtonState(stText, pBitmap, &IconMap, m_pBkmapnormal, pDC);
    m_pBitmapBtn->SetBitmapLabel(*pBitmap);

    ButtonState(stText, pBitmap, &IconMap, m_pBkmapover, pDC);
    m_pBitmapBtn->SetBitmapHover(*pBitmap);

    ButtonState(stText, pBitmap, &IconMap, m_pBkmapdown, pDC);
    m_pBitmapBtn->SetBitmapSelected(*pBitmap);

    ButtonState(stText, pBitmap, &IconMapDisable, m_pBkmapdisable, pDC, TRUE);
    m_pBitmapBtn->SetBitmapDisabled(*pBitmap);
}

// Redraw Rotation BitmapButton
/**************************************************************************************************
* Function Name : RedrawRotationBitmapBtn                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::RedrawRotationBitmapBtn(wxString stText, wxString stIcon,
            wxBitmapButton* m_pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC)
{
    if (NULL == pDC)
    {
        return;
    }
    wxString stIconDisable;
    stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");

    wxBitmap IconMap(stIcon, wxBITMAP_TYPE_PNG);
    wxBitmap IconMapDisable(stIconDisable, wxBITMAP_TYPE_PNG);

    ButtonState(stText, pBitmap, &IconMap, m_pBkmapRotationnormal, pDC);
    m_pBitmapBtn->SetBitmapLabel(*pBitmap);

    ButtonState(stText, pBitmap, &IconMap, m_pBkmapRotationover, pDC);
    m_pBitmapBtn->SetBitmapHover(*pBitmap);

    ButtonState(stText, pBitmap, &IconMap, m_pBkmapRotationdown, pDC);
    m_pBitmapBtn->SetBitmapSelected(*pBitmap);

    ButtonState(stText, pBitmap, &IconMapDisable, m_pBkmapRotationdisable, pDC, TRUE);
    m_pBitmapBtn->SetBitmapDisabled(*pBitmap);
}

//Button State
/**************************************************************************************************
* Function Name : ButtonState                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::ButtonState(wxString drawtext, wxBitmap* bitmap, wxBitmap* bitmap_icon,
        wxBitmap* bitmap_back, wxMemoryDC* dc, bool bDisable)
{
    if ((NULL == dc) || (NULL == bitmap)
        || (NULL == bitmap_icon) || (NULL == bitmap_back))
    {
        return;
    }
    wxColour *pColour;
    if (bDisable != TRUE)
    {
        pColour = new wxColour(71, 83, 107);
    }
    else
    {
        pColour = new wxColour(215, 215, 230);
    }
    if (NULL == pColour)
    {
        return;
    }

    dc->Clear();
    dc->SelectObject(*bitmap);
    dc->SetTextForeground(*pColour);
    dc->SetTextBackground(*wxWHITE);
    dc->DrawBitmap(*bitmap_back, 0, 0, TRUE);
    if (true == m_bRotationIcon)
    {
        dc->DrawBitmap(*bitmap_icon, 10, 7, TRUE);
    }
    else
    {
        dc->DrawBitmap(*bitmap_icon, 5, 9, TRUE);
    }

    if (drawtext != _T(""))
    {
        wxFont BtnFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);

        dc->SetFont(BtnFont);
        dc->DrawLabel(wxStripMenuCodes(drawtext),
                     wxRect(43, 0, bitmap->GetWidth()/2, bitmap->GetHeight()),
                     wxALIGN_CENTER_VERTICAL|wxALIGN_LEFT);

    }

    dc->SelectObject( wxNullBitmap );
}
#endif

/**************************************************************************************************
* Function Name : Onm_pBitmapAboutClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapAboutClick(wxMouseEvent& event)
{
    //Get current volume level again
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }
    //m_pTimer->Stop();
    m_bAboutState = true;//Controling QCP don't exit when the About Dialog closed
    AboutDialog* pAboutQCP = new AboutDialog(this);
    if ( !pAboutQCP )
    {
        return;
    }
    m_pTimer->Stop();
    int iRetCode = pAboutQCP->ShowModal();//Show About Dialog of QCP
    pAboutQCP->EndModal(iRetCode);

    if ( pAboutQCP )
    {
        delete pAboutQCP;
        pAboutQCP = NULL;
    }

    //Change the status of button when current tools haven't been existed under .
    #if defined(__WXMSW__)
    if (false == wxFileExists(m_AppShowCursorExePath))
    {
        m_pBitShowCursor->Disable();
    }

    //The parameter m_AppSwitchDisplayExePath is current path of Display Switch tool
    if (false == wxFileExists(m_AppSwitchDisplayExePath))
    {
        m_pBitSwitchDisplay->Disable();
    }
    else
    {
        m_pBitSwitchDisplay->Enable();
    }

    if (false == wxFileExists(m_AppTouchToolExePath))
    {
        m_pBitCalScreen->Disable();
    }
    else
    {
        m_pBitCalScreen->Enable();
    }

    #elif defined(__UNIX__)

    wxString sFilePath = m_ResourcefilePath + wxT("resource/hidecursor.sh");
    wxString sFilePathShow = m_ResourcefilePath + wxT("resource/showcursor.sh");
    if ( (false == wxFileExists(sFilePath)) || (false == wxFileExists(sFilePathShow)) )
    {
        m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes_disable.png"),
        wxBITMAP_TYPE_PNG));
        m_pStaticTextShowCursor->SetForegroundColour(wxColour(190, 190, 190));
        #ifdef QCP_DEBUG
        dcsLog << "m_pBitShowCursor->Disable();" << endl;
        #endif
        m_pBitShowCursor->Disable();
    }

    sFilePath = wxT("/usr/bin/dcs/DisplayToggle");
    if (false == wxFileExists(sFilePath))
    {
        m_pStaticBitmapSwitchDisplay->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/display_disable.png"),
        wxBITMAP_TYPE_PNG));
        m_pStaticTextSwitchDisplay->SetForegroundColour(wxColour(190, 190, 190));
        m_pBitSwitchDisplay->Disable();
    }
    else
    {
        m_pStaticBitmapSwitchDisplay->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/display.png"),
        wxBITMAP_TYPE_PNG));
        m_pStaticTextSwitchDisplay->SetForegroundColour(wxColour(71, 83, 107));
        m_pBitSwitchDisplay->Enable();
    }

    sFilePath = wxT("/usr/local/bin/LinearAp");
    if (false == wxFileExists(sFilePath))
    {
        m_pStaticBitmapCalScreen->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/calibrate_screen_disable.png"),
        wxBITMAP_TYPE_PNG));
        m_pStaticTextCalScreen->SetForegroundColour(wxColour(190, 190, 190));
        m_pBitCalScreen->Disable();
    }
    else
    {
        m_pStaticBitmapCalScreen->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/calibrate_screen.png"),
        wxBITMAP_TYPE_PNG));
        m_pStaticTextCalScreen->SetForegroundColour(wxColour(71, 83, 107));
        m_pBitCalScreen->Enable();
    }
    #endif

    m_pTimer->Start(TIME_INTERVAL);
    m_bAboutState = false;
    m_bNeedUpdate = true;
    //CallExternalAppInit();
}

/**************************************************************************************************
* Function Name : Onm_pBitmapBrightnessUpClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapBrightnessUpClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    int iTempLevel = 0;
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_LCDBrightnessUp(m_iBrightLevel, &iTempLevel))
    {
        //If the brightness up successfully, update brightness UI
        UpdateBrightUI(iTempLevel);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitmapBrightnessDownClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapBrightnessDownClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    int iTempLevel = 0;
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_LCDBrightnessDown(m_iBrightLevel, &iTempLevel))
    {
        //If the brightness down successfully, update brightness UI
        UpdateBrightUI(iTempLevel);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitBrightnessLev6Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitBrightnessLev6Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_SetLCDBrightnessLevel(7))
    {
        //If the brigntness value set successfully, update volume UI
        UpdateBrightUI(7);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitBrightnessLev5Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitBrightnessLev5Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_SetLCDBrightnessLevel(6))
    {
        //If the brigntness value set successfully, update volume UI
        UpdateBrightUI(6);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitBrightnessLev4Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitBrightnessLev4Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_SetLCDBrightnessLevel(5))
    {
        //If the brigntness value set successfully, update volume UI
        UpdateBrightUI(5);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitBrightnessLev3Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitBrightnessLev3Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_SetLCDBrightnessLevel(4))
    {
        //If the brigntness value set successfully, update volume UI
        UpdateBrightUI(4);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitBrightnessLev2Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitBrightnessLev2Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_SetLCDBrightnessLevel(3))
    {
        //If the brigntness value set successfully, update volume UI
        UpdateBrightUI(3);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitBrightnessLev1Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitBrightnessLev1Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_SetLCDBrightnessLevel(2))
    {
        //If the brigntness value set successfully, update volume UI
        UpdateBrightUI(2);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitBrightnessLev0Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitBrightnessLev0Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_bBrightSynControlUI = true;
    if (true == g_pQCPInterface->QCP_SetLCDBrightnessLevel(1))
    {
        //If the brigntness value set successfully, update volume UI
        UpdateBrightUI(1);
    }
    else
    {
        g_bBrightSynControlUI = false;
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitmapVolumeUpClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapVolumeUpClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();

    if ((m_iVolLevel > 0) || (m_iVolLevel < 7))
    {
        if (true == g_pQCPInterface->QCP_SetVolumeLevel(m_iVolLevel + 1))
        {
            m_iVolLevel = m_iVolLevel + 1;
            //If the volume value set successfully, update volume UI
            UpdateVolumeUI();
        }
    }

//    if  (true == g_pQCPInterface->QCP_VolumeUp(&m_iVolLevel))
//    {
//        //If the volume up successfully, update volume UI
//        UpdateVolumeUI();
//    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitmapVolumeDownClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapVolumeDownClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();

    if ((m_iVolLevel > 0) || (m_iVolLevel < 7))
    {
        if (true == g_pQCPInterface->QCP_SetVolumeLevel(m_iVolLevel - 1))
        {
            m_iVolLevel = m_iVolLevel - 1;
            //If the volume value set successfully, update volume UI
            UpdateVolumeUI();
        }
    }

//    if (true == g_pQCPInterface->QCP_VolumeDown(&m_iVolLevel))
//    {
//        //If the volume down successfully, update volume UI
//        UpdateVolumeUI();
//    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitVolumeLev6Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitVolumeLev6Click(wxMouseEvent& event)
{
    #ifdef QCP_DEBUG
    dcsLog << " Onm_pBitVolumeLev6Click !" << endl;
    #endif
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    if (true == g_pQCPInterface->QCP_SetVolumeLevel(7))
    {

        m_iVolLevel = 7;
        //If the volume value set successfully, update volume UI
        UpdateVolumeUI();
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitVolumeLev5Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitVolumeLev5Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    if (true == g_pQCPInterface->QCP_SetVolumeLevel(6))
    {
        m_iVolLevel = 6;
        //If the volume value set successfully, update volume UI
        UpdateVolumeUI();
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitVolumeLev4Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitVolumeLev4Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    if (true == g_pQCPInterface->QCP_SetVolumeLevel(5))
    {
        m_iVolLevel = 5;
       //If the volume value set successfully, update volume UI
        UpdateVolumeUI();
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitVolumeLev3Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitVolumeLev3Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    if (true == g_pQCPInterface->QCP_SetVolumeLevel(4))
    {
        m_iVolLevel = 4;
        //If the volume value set successfully, update volume UI
        UpdateVolumeUI();
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitVolumeLev2Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitVolumeLev2Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    if (true == g_pQCPInterface->QCP_SetVolumeLevel(3))
    {
        m_iVolLevel = 3;
        //If the volume value set successfully, update volume UI
        UpdateVolumeUI();
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitVolumeLev1Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitVolumeLev1Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    if  (true == g_pQCPInterface->QCP_SetVolumeLevel(2))
    {
        m_iVolLevel = 2;
        //If the volume value set successfully, update volume UI
        UpdateVolumeUI();
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitVolumeLev0Click                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitVolumeLev0Click(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    if  (true == g_pQCPInterface->QCP_SetVolumeLevel(1))
    {
        m_iVolLevel = 1;
        //If the volume value set successfully, update volume UI
        UpdateVolumeUI();
    }
    m_pTimer->Start(TIME_INTERVAL);
}

/**************************************************************************************************
* Function Name : Onm_pBitMuteClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitMuteClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }
    m_pTimer->Stop();

    //Setting the mute
    if (false == g_pQCPInterface->QCP_VolumeMute(&m_iVolLevel, &m_bMuteState))
    {
        m_pTimer->Start();
        return;
    }

    //Checking the current mute status
    if (true == m_bMuteState)
	{     //Setting mute mode
        #if defined(__WXMSW__)  //Update UI for mute mode when the QCP application run on windows

        wxMemoryDC dc;
        wxString stIconDisable;
        stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Mute"), m_ResourcefilePath + wxT("image/status_yes.png"), stIconDisable,
            m_pBitMute, m_pBkmapUnMute, &dc);

        #elif defined(__UNIX__) //Update UI for mute mode when the QCP application run on Linux

        m_pStaticBitmapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes.png"),
            wxBITMAP_TYPE_PNG));
        DisableVolumeButton();
        m_iVolLevel = 0;

	    if (true == g_pQCPInterface->QCP_SetVolumeLevel(0))
        {
//            m_iVolLevel = 0;
            //If the volume value set successfully, update volume UI
            UpdateVolumeUI();
        }

        #endif
        m_pStMapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/mute.png"), wxBITMAP_TYPE_PNG));
	}
	else  //Setting UnMute mode
	{
        #if defined(__WXMSW__)

        wxMemoryDC dc;
        wxString stIconDisable;
        stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Mute"), m_ResourcefilePath + wxT("image/status_no.png"), stIconDisable,
            m_pBitMute, m_pBkmapMute, &dc);

        #elif defined(__UNIX__)


	    if (true == g_pQCPInterface->QCP_SetVolumeLevel(0))
        {
            m_iVolLevel = 0;
            //If the volume value set successfully, update volume UI
//            UpdateVolumeUI();
        }
        UpdateVolumeUI();//

        #endif
        m_pStMapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/unmute.png"), wxBITMAP_TYPE_PNG));
	}
    m_pTimer->Start(TIME_INTERVAL);

    return;
}

/**************************************************************************************************
* Function Name : Onm_pBitShowCursorClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitShowCursorClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();

    //Launch external application(Show Cursor)
    if (true == m_bCursorState)
	{
	    //Show the cursor
        #if defined(__WXMSW__)

        g_pQCPInterface->QCP_ShowCursor(m_AppShowCursorExePath + wxT(" FALSE"));

        wxMemoryDC dc;
        wxString stIconDisable;
        stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath + wxT("image/status_yes.png"),
            stIconDisable, m_pBitShowCursor, m_pBkmapHideCursor, &dc);

        #elif defined(__UNIX__)

        g_pQCPInterface->QCP_ShowCursor(wxT("FALSE"));
        m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes.png"),
            wxBITMAP_TYPE_PNG));

        #endif
        m_bCursorState = false;
	}
	else
	{
	    //Hide the cursor

        #if defined(__WXMSW__)

        g_pQCPInterface->QCP_ShowCursor(m_AppShowCursorExePath + wxT(" TRUE"));

        wxMemoryDC dc;
        wxString stIconDisable;
        stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath + wxT("image/status_no.png"),
            stIconDisable, m_pBitShowCursor, m_pBkmapShowCursor, &dc);

        #elif defined(__UNIX__)

        g_pQCPInterface->QCP_ShowCursor(wxT("TRUE"));
        m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_no.png"),
            wxBITMAP_TYPE_PNG));

        #endif
        m_bCursorState = true;
	}
  	m_pTimer->Start(TIME_INTERVAL);

  	return;
}

/**************************************************************************************************
* Function Name : Onm_pBitSwitchDisplayClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitSwitchDisplayClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();

    //Launch external application(Switch Display)
    g_pQCPInterface->QCP_LaunchDisplayApp(m_AppSwitchDisplayExePath);

    #if defined(__WXMSW__)
    m_bPreventExit = false;
    #endif

//    int iScreenWidth  = GetSystemMetrics(SM_CXSCREEN);
//    int iScreenHeight = GetSystemMetrics(SM_CYSCREEN);
//
//    wxPoint Dlgpos((iScreenWidth - QCP_UI_WIDTH), (iScreenHeight - QCP_UI_HEIGHT) / 2);
//    this->SetPosition(Dlgpos); //Set the position of QCP on screen

//    SetQCPPosition();// Setting the position of QCP on screen
    m_pTimer->Start(TIME_INTERVAL);

    return;
}

/**************************************************************************************************
* Function Name : Onm_pBitCalScreenClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitCalScreenClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();

    //Launch external application(Calibrate Screen)
    bool bFlag = g_pQCPInterface->QCP_LaunchScreenCalApp(m_AppTouchToolExePath);
    #if defined(__UNIX__)
    if (bFlag)
    {
        bFlag = false;
        ExitQCP();
    }
    #endif
    m_pTimer->Start(TIME_INTERVAL);

    return;
}

/**************************************************************************************************
* Function Name : Onm_pBtnRotationClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBtnRotationClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }
    m_pTimer->Stop();

    //Maunal or Auto rotation switch.
    if( true == g_pQCPInterface->QCP_ScreenRotationSwitch(&m_bRotationStatus))
    {
        //If switch successfully, update current UI
        UpdateRotationUI();
    }
    m_pTimer->Start(TIME_INTERVAL);

    return;
}

/**************************************************************************************************
* Function Name : Onm_pBitmapCWClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapCWClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {

        return;
    }
    #ifdef QCP_DEBUG
    dcsLog << "--------------------" << endl;
    dcsLog << "Stop Timer 1" << endl;
    #endif

    m_pTimer->Stop();
    g_pQCPInterface->QCP_SetCW(this); //Left rotation
    m_pTimer->Start(TIME_INTERVAL);

    #ifdef QCP_DEBUG
    dcsLog << "Onm_pBitmapCWClick 2" << endl;
    dcsLog << "--------------------" << endl;
    #endif

    return;
}

/**************************************************************************************************
* Function Name : Onm_pBitmapCCWClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapCCWClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_pQCPInterface->QCP_SetCCW(this); //Right rotation
    m_pTimer->Start(TIME_INTERVAL);

    return;
}

/**************************************************************************************************
* Function Name : Onm_pBitmapBtn180DegreeClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapBtn180DegreeClick(wxMouseEvent& event)
{
    if ((false == m_bControlClick)
        || (NULL == m_pTimer)
        || (NULL == g_pQCPInterface))
    {
        return;
    }

    m_pTimer->Stop();
    g_pQCPInterface->QCP_Rotation180Degree(this); //Right rotation
    m_pTimer->Start(TIME_INTERVAL);

    return;
}

//close dialog
/**************************************************************************************************
* Function Name : Onm_pBitmapCloseClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::Onm_pBitmapCloseClick(wxMouseEvent& event)
{
    if (false == m_bControlClick)
    {
        return;
    }

    #ifdef QCP_DEBUG
    dcsLog << "--------------------------------------" << endl;
    dcsLog << "Onm_pBitmapCloseClick" << endl;
    #endif
    ExitQCP();  //Click the Close button to close QCP
}

//Update state of the Volume
/**************************************************************************************************
* Function Name : UpdateVolumeUI                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::UpdateVolumeUI()
{
    //According to current volume level show the UI level of volume
	for (m_iCount = 0; m_iCount < m_iVolLevel; m_iCount++)
	{
	    if ((m_iCount >= 0) && (m_iCount <= 2))
        {
            #if defined(__WXMSW__)
            m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                wxT("image/volumestate0_2.png"), wxBITMAP_TYPE_PNG));
            #elif defined(__UNIX__)
            m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                wxT("image/volumestate0_2.png"), wxBITMAP_TYPE_PNG));
            #endif
        }
        else
        {
            #if defined(__WXMSW__)
            m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                wxT("image/volumestate.png"), wxBITMAP_TYPE_PNG));
            #elif defined(__UNIX__)
            m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                wxT("image/volumestate.png"), wxBITMAP_TYPE_PNG));
            #endif
        }
	}

    //According to current volume level update the UI
	for (m_iCount = m_iVolLevel; m_iCount < VOLUMELEVEL; m_iCount++)
	{
	    if ((m_iCount >= 0) && (m_iCount <= 2))
        {
            #if defined(__WXMSW__)
            m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
            #elif defined(__UNIX__)
            m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
            #endif
        }
        else
        {
            #if defined(__WXMSW__)
            m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
            #elif defined(__UNIX__)
            m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
            #endif
        }
	}

	if (true == m_bMuteState) //According to current mode, switch the update UI
	{ //when the system is mute mode, the UI switch to mute mode
        #if defined(__WXMSW__)

        wxMemoryDC dc;
        wxString stIconDisable;
        stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Mute"), m_ResourcefilePath + wxT("image/status_yes.png"),
                stIconDisable, m_pBitMute, m_pBkmapUnMute, &dc);
        m_pStMapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/mute.png"), wxBITMAP_TYPE_PNG));

        #elif defined(__UNIX__)
        #ifdef QCP_DEBUG
        dcsLog << "Update UI Mute DisableVolumeButton:" << endl;
        #endif
        DisableVolumeButton();//Disable the button of volume
        m_pStaticBitmapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes.png"), wxBITMAP_TYPE_PNG));
	    m_pStMapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/mute.png"), wxBITMAP_TYPE_PNG));
        return;
        #endif
	}
	else
	{ //when the system is Unmute mode, the UI switch to Unmute mode
        #if defined(__WXMSW__)

        wxMemoryDC dc;
        wxString stIconDisable;
        stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Mute"), m_ResourcefilePath + wxT("image/status_no.png"),
                stIconDisable, m_pBitMute, m_pBkmapMute, &dc);

        #elif defined(__UNIX__)
        #ifdef QCP_DEBUG
        dcsLog << "Update UI unMute EnableVolumeButton:" << endl;
        #endif
        EnableVolumeButton(); //Enable the button of volume
        m_pStaticBitmapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_no.png"), wxBITMAP_TYPE_PNG));
        #endif
        m_pStMapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/unmute.png"), wxBITMAP_TYPE_PNG));
	}

	for (m_iCount = 0; m_iCount < VOLUMELEVEL; m_iCount++)
	{
	    #if defined(__WXMSW__)
	    m_pStBitmapBtnVolumeLevel[m_iCount]->SetBackgroundColour(wxColour(255, 255, 255));
	    #elif defined(__UNIX__)
	    m_pStaticBitmapVolume[m_iCount]->SetBackgroundColour(wxColour(255, 255, 255));
	    #endif
	}

	if (0 == m_iVolLevel)
    { //If current volume level is 0, user can't adjust again
        m_pBitmapVolumeDown->Disable();
    }
    if (VOLUMELEVEL == m_iVolLevel)
    { //If current volume level is maximum level, user can't adjust again
        m_pBitmapVolumeUp->Disable();
    }

    if (m_iVolLevel > 0)
    {
        m_pBitmapVolumeDown->Enable();//User can adjust volume when the volume level > 0
    }

    if (m_iVolLevel < VOLUMELEVEL)
    {
        m_pBitmapVolumeUp->Enable(); //User can adjust volume when the volume level < VOLUMELEVEL
    }
}

/**************************************************************************************************
* Function Name : UpdateVolumeUI                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::UpdateVolumeUI(int iVolChangeLevel)
{
    if (iVolChangeLevel == m_iVolLevel)
    {
        return;
    }
    else if (iVolChangeLevel > m_iVolLevel)
    {
        //According to current volume level show the UI level of volume
        for (m_iCount = m_iVolLevel; m_iCount < iVolChangeLevel; m_iCount++)
        {
            if ((m_iCount >= 0) && (m_iCount <= 2))
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/volumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/volumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
            else
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/volumestate.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/volumestate.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
        }
        m_iVolLevel = iVolChangeLevel; //Setting current level of volume
    }
    else if (iVolChangeLevel < m_iVolLevel)
    {
        //According to current volume level update the UI
        for (m_iCount = iVolChangeLevel; m_iCount < m_iVolLevel; m_iCount++)
        {
            if ((m_iCount >= 0) && (m_iCount <= 2))
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
            else
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
        }
        m_iVolLevel = iVolChangeLevel; //Setting current level of volume
    }

	if (0 == m_iVolLevel)
    { //If current volume level is 0, user can't adjust again
        m_pBitmapVolumeDown->Disable();
    }
    if (VOLUMELEVEL == m_iVolLevel)
    { //If current volume level is maximum level, user can't adjust again
        m_pBitmapVolumeUp->Disable();
    }

    if (m_iVolLevel > 0)
    {
        m_pBitmapVolumeDown->Enable();//User can adjust volume when the volume level > 0
    }

    if (m_iVolLevel < VOLUMELEVEL)
    {
        m_pBitmapVolumeUp->Enable(); //User can adjust volume when the volume level < VOLUMELEVEL
    }
}

/**************************************************************************************************
* Function Name : UpdateMuteUI                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::UpdateMuteUI()
{
    if (true == m_bMuteState) //According to current mode, switch the update UI
	{ //when the system is mute mode, the UI switch to mute mode
        #if defined(__WXMSW__)
        wxMemoryDC dc;
 	 wxString stIconDisable;
	 stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Mute"), m_ResourcefilePath + wxT("image/status_yes.png"),
                    stIconDisable, m_pBitMute, m_pBkmapUnMute, &dc);
        m_pStMapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/mute.png"), wxBITMAP_TYPE_PNG));
        #elif defined(__UNIX__)
        DisableVolumeButton();//Disable the button of volume
        m_pStaticBitmapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes.png"), wxBITMAP_TYPE_PNG));
	    m_pStMapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/mute.png"), wxBITMAP_TYPE_PNG));

        #endif
	}
	else
	{ //when the system is Unmute mode, the UI switch to Unmute mode
        #if defined(__WXMSW__)
        wxMemoryDC dc;
 	 wxString stIconDisable;
	 stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Mute"), m_ResourcefilePath + wxT("image/status_no.png"),
                    stIconDisable, m_pBitMute, m_pBkmapMute, &dc);
        #elif defined(__UNIX__)
        EnableVolumeButton(); //Enable the button of volume
        m_pStaticBitmapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_no.png"), wxBITMAP_TYPE_PNG));
//        if (true == g_pQCPInterface->QCP_SetVolumeLevel(0))
//        {
//            m_iVolLevel = 0;
//            //If the volume value set successfully, update volume UI
//            UpdateVolumeUI();
//        }
        #endif
        m_pStMapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/unmute.png"), wxBITMAP_TYPE_PNG));
	}
}

/**************************************************************************************************
* Function Name : UpdateCursorUI                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::UpdateCursorUI(DCS_Tablet_Sensor_Data *pDeviceMode)
{
    //DCS_Return_Code rGetTabletModeRes = DCS_FAIL_OPERATION;
    DCS_Tablet_Sensor_Data DeviceMode = *pDeviceMode;
    #if defined(__WXMSW__)
    if (false == wxFileExists(m_AppShowCursorExePath))
    {
        m_pBitShowCursor->Disable();
        return;
    }
    if (DeviceMode != DCS_TABLET_MODE)
    {
        m_bCursorState = false;
        m_pBitShowCursor->Disable();
        wxMemoryDC dc;
 	 wxString stIconDisable;
	 stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath + wxT("image/status_yes.png"),
                    stIconDisable, m_pBitShowCursor, m_pBkmapHideCursor, &dc);
    }
    else
    {
        m_pBitShowCursor->Enable();
        //The hide cursor is initialize status
        bool bHideCursor = FALSE;
        bHideCursor = g_pQCPInterface->QCP_GetCursorStatus();
        if (bHideCursor)
        {
            m_bCursorState = true; //hide cursor
            wxMemoryDC dc;
 	     wxString stIconDisable;
	     stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
            RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath + wxT("image/status_no.png"),
                    stIconDisable, m_pBitShowCursor, m_pBkmapHideCursor, &dc);
            //m_bControlCursorOnSwitchDisplay = false;
        }
        else
        {
            m_bCursorState = false; //show cursor
            wxMemoryDC dc;
 	     wxString stIconDisable;
	     stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
            RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath + wxT("image/status_yes.png"),
                    stIconDisable, m_pBitShowCursor, m_pBkmapHideCursor, &dc);
            //m_bControlCursorOnSwitchDisplay = true;
        }
    }
    #elif defined(__UNIX__)
    wxString sFilePath = m_ResourcefilePath + wxT("resource/hidecursor.sh");
    wxString sFilePathShow = m_ResourcefilePath + wxT("resource/showcursor.sh");

    if (DeviceMode != DCS_TABLET_MODE)
    {
        m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/status_yes_disable.png"), wxBITMAP_TYPE_PNG));
        m_pStaticTextShowCursor->SetForegroundColour(wxColour(190, 190, 190));
        m_pBitShowCursor->Disable();
        m_bCursorState = false;
    }
    else if ( (false == wxFileExists(sFilePath)) || (false == wxFileExists(sFilePathShow)) )
    {
        m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/status_yes_disable.png"), wxBITMAP_TYPE_PNG));
        m_pStaticTextShowCursor->SetForegroundColour(wxColour(190, 190, 190));
        m_pBitShowCursor->Disable();
        m_bCursorState = false;
    }
    else
    {
        bool bCursorHide = g_pQCPInterface->QCP_GetCursorStatus();
        m_pStaticTextShowCursor->SetForegroundColour(wxColour(71, 83, 107));
        m_pBitShowCursor->Enable();

        if (TRUE == bCursorHide)
        {
            m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/status_no.png"), wxBITMAP_TYPE_PNG));
            m_bCursorState = true; //hide cursor
        }
        else
        {
            m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/status_yes.png"), wxBITMAP_TYPE_PNG));
            m_bCursorState = false; //show cursor
        }
    }
    #endif
}

/**************************************************************************************************
* Function Name : EnableVolumeButton                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::EnableVolumeButton(void)
{
    #ifdef QCP_DEBUG
    dcsLog << " EnableVolumeButton m_bNeedEnableBar:" << m_bNeedEnableBar << endl;
    #endif
    if (m_bNeedEnableBar != true)
    {
        return;
    }
    m_bNeedEnableBar = false;
    #if defined(__WXMSW__)
    UpdateVolumeUI();
    #elif defined(__UNIX__)
    m_pBitmapVolumeUp->Enable();
    m_pBitmapVolumeDown->Enable();
    UpdateVolumeUI();
    #endif

#ifndef DEL
    for (m_iCount = 0; m_iCount < VOLUMELEVEL; m_iCount++)
    {
        #ifdef QCP_DEBUG
        dcsLog << " EnableVolumeButton m_iCount:" << m_iCount << endl;
        #endif
        m_pStBitmapBtnVolumeLevel[m_iCount]->Enable();
    }
    #endif
}

/**************************************************************************************************
* Function Name : DisableVolumeButton                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::DisableVolumeButton(void)
{
    #ifdef QCP_DEBUG
    dcsLog << " DisableVolumeButton m_bNeedEnableBar:" << m_bNeedEnableBar << endl;
    #endif

    #if defined(__UNIX__)
    if (m_bMuteState != true)
    {
        return;
    }
    #endif
    m_bNeedEnableBar = true;
    m_pBitmapVolumeUp->Disable();
    m_pBitmapVolumeDown->Disable();

    for (m_iCount = 0; m_iCount < VOLUMELEVEL; m_iCount++)
        {
            if ((m_iCount >= 0) && (m_iCount <= 2))
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
            else
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnVolumeLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapVolume[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
        }
}

//Update state of the Brightness
/**************************************************************************************************
* Function Name : UpdateBrightUI                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::UpdateBrightUI()
{
    //According to current brightness level show the UI level of brightness
	for (m_iCount = 0; m_iCount < m_iBrightLevel; m_iCount++)
	{
	    if ((m_iCount >= 0) && (m_iCount <= 2))
        {
            #if defined(__WXMSW__)
            m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightstate0_2.png"), wxBITMAP_TYPE_PNG));
            #elif defined(__UNIX__)
            m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightstate0_2.png"), wxBITMAP_TYPE_PNG));
            #endif
        }
        else
        {
            #if defined(__WXMSW__)
            m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightstate.png"), wxBITMAP_TYPE_PNG));
            #elif defined(__UNIX__)
            m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightstate.png"), wxBITMAP_TYPE_PNG));
            #endif
        }
	}

    //According to current volume level update the UI
	for (m_iCount = m_iBrightLevel; m_iCount < BRIGHTLEVEL; m_iCount++)
	{
	    if ((m_iCount >= 0) && (m_iCount <= 2))
        {
            #if defined(__WXMSW__)
            m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
            #elif defined(__UNIX__)
            m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
            #endif
        }
	    else
	    {
	        #if defined(__WXMSW__)
            m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
            #elif defined(__UNIX__)
            m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
            #endif
	    }
	}

    if (0 == m_iBrightLevel)
    {   //If current brightness level is 0, user can't adjust again
        m_pBitmapBrightnessDown->Disable();//User can adjust volume when the volume level > 0
    }
    if (BRIGHTLEVEL == m_iBrightLevel)
    {   //If current brightness level is maximum level, user can't adjust again
        m_pBitmapBrightnessUp->Disable();
    }

    if (m_iBrightLevel > 0)
    {
        m_pBitmapBrightnessDown->Enable();//User can adjust volume when the volume level > 0
    }

    if (m_iBrightLevel < BRIGHTLEVEL)
    {
        m_pBitmapBrightnessUp->Enable();//User can adjust volume when the volume level < VOLUMELEVEL
    }
}

/**************************************************************************************************
* Function Name : UpdateBrightUI                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::UpdateBrightUI(int iChangeLevel)
{
    if (iChangeLevel == m_iBrightLevel)
    {
        return;
    }
    else if (iChangeLevel > m_iBrightLevel)
    {
        for (m_iCount = m_iBrightLevel; m_iCount < iChangeLevel; m_iCount++)
        {
            if ((m_iCount >= 0) && (m_iCount <= 2))
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightstate0_2.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightstate0_2.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
            else
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightstate.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightstate.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
        }
        m_iBrightLevel = iChangeLevel;
    }
    else if (iChangeLevel < m_iBrightLevel)
    {
        for (m_iCount = iChangeLevel; m_iCount < m_iBrightLevel; m_iCount++)
        {
            if ((m_iCount >= 0) && (m_iCount <= 2))
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
            else
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
        }
        m_iBrightLevel = iChangeLevel;
    }

    if (0 == m_iBrightLevel)
    {   //If current brightness level is 0, user can't adjust again
        m_pBitmapBrightnessDown->Disable();//User can adjust volume when the volume level > 0
    }

    if (BRIGHTLEVEL == m_iBrightLevel)
    {   //If current brightness level is maximum level, user can't adjust again
        m_pBitmapBrightnessUp->Disable();
    }

    if (m_iBrightLevel > 0)
    {
        m_pBitmapBrightnessDown->Enable();//User can adjust volume when the volume level > 0
    }

    if (m_iBrightLevel < BRIGHTLEVEL)
    {
        m_pBitmapBrightnessUp->Enable();//User can adjust volume when the volume level < VOLUMELEVEL
    }
}

/**************************************************************************************************
* Function Name : GetBrightnessLevel                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
int CMPC_QCPDialog::GetBrightnessLevel()
{
    return m_iBrightLevel;
}

/**************************************************************************************************
* Function Name : SetBrightnessLevel                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::SetBrightnessLevel(int iBrightness)
{
    m_iBrightLevel = iBrightness;  //Setting the brightness level
}

/**************************************************************************************************
* Function Name : EnableBrightnessButton                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::EnableBrightnessButton(void)
{
    m_pBitmapBrightnessUp->Enable();
    m_pBitmapBrightnessDown->Enable();
    for (m_iCount = 0; m_iCount < BRIGHTLEVEL; m_iCount++)
    {
        m_pStBitmapBtnBrightnessLevel[m_iCount]->Enable();
    }
}

/**************************************************************************************************
* Function Name : DisableBrightnessButton                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::DisableBrightnessButton(void)
{
    m_pBitmapBrightnessUp->Disable();
    m_pBitmapBrightnessDown->Disable();

    for (m_iCount = 0; m_iCount < BRIGHTLEVEL; m_iCount++)
        {
            if ((m_iCount >= 0) && (m_iCount <= 2))
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate0_2.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
            else
            {
                #if defined(__WXMSW__)
                m_pStBitmapBtnBrightnessLevel[m_iCount]->SetBitmapLabel(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
                #elif defined(__UNIX__)
                m_pStaticBitmapBrightness[m_iCount]->SetBitmap(wxBitmap(m_ResourcefilePath +
                    wxT("image/brightvolumestate.png"), wxBITMAP_TYPE_PNG));
                #endif
            }
        }
}

//Update state of the Rotation button
/**************************************************************************************************
* Function Name : UpdateRotationUI                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::UpdateRotationUI()
{
	//Checking the current rotation mode, default value is auto rotation
    if (AUTOROTATION_DISABLED == m_bRotationStatus)
    {   //Manual rotation
        #if defined(__WXMSW__)

        wxMemoryDC dc;
        RedrawRotationBitmapBtn(_("Auto\nRotation"), m_ResourcefilePath + wxT("image/status_no.png"),
                    m_pBtnRotation, m_pBkmapRotation, &dc);

        #elif defined(__UNIX__)

        m_pStaticBitmapManualRotation->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_no.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticBitMapCW->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/left90_normal.png"), wxBITMAP_TYPE_PNG));
        m_pStaticBitMapCCW->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/right90_normal.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticBitMap180Degree->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/180_normal.png"),
                    wxBITMAP_TYPE_PNG));

        #endif
        m_pBitmapCW->Enable();
        m_pBitmapCCW->Enable();
        m_pBitmapBtn180Degree->Enable();
        m_bRotationStatus = AUTOROTATION_ENABLED;  //Switch to auto rotation mode
    }
    else   //Auto rotation
    {
        #if defined(__WXMSW__)

        wxMemoryDC dc;
        RedrawRotationBitmapBtn(_("Auto\nRotation"), m_ResourcefilePath + wxT("image/status_yes.png"),
                    m_pBtnRotation, m_pBkmapRotation, &dc);

        #elif defined(__UNIX__)

        m_pStaticBitmapManualRotation->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticBitMapCW->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/left90_disable.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticBitMapCCW->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/right90_disable.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticBitMap180Degree->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/180_disable.png"),
                    wxBITMAP_TYPE_PNG));

        #endif
        m_pBitmapCW->Disable();
        m_pBitmapCCW->Disable();
        m_pBitmapBtn180Degree->Disable();
        m_bRotationStatus = AUTOROTATION_DISABLED; //Switch to manual rotation mode
    }
}

//Getting the exe file path of external application
/**************************************************************************************************
* Function Name : CallExternalAppInit                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::CallExternalAppInit()
{

    DCS_Return_Code rGetTabletModeRes = DCS_FAIL_OPERATION;
    DCS_Tablet_Sensor_Data DeviceMode = DCS_CLAMSHELL_MODE;
    #ifdef QCP_DEBUG
    dcsLog << "DCS_GetTabletSensorMode Enter\n"<< endl;
    #endif
    if ( m_bDCSInitRet )
    {

        rGetTabletModeRes = DCS_GetTabletSensorMode(&DeviceMode);
    }

    if (rGetTabletModeRes != DCS_SUCCESS)
    {
        #ifdef QCP_DEBUG
        dcsLog << "rGetTabletModeRes Not Success " << rGetTabletModeRes
        << "\n" << endl;
        #endif
    }

    #if defined(__WXMSW__)
    m_AppShowCursorExePath = m_ResourcefilePath + wxT("resource\\HideCursor.exe");

    if (DeviceMode != DCS_TABLET_MODE)
    {
        m_bCursorState = false;
        m_pBitShowCursor->Disable();
        wxMemoryDC dc;
        wxString stIconDisable;
        stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
        RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath + wxT("image/status_yes.png"), stIconDisable,
                    m_pBitShowCursor, m_pBkmapHideCursor, &dc);
    }
    else if (false == wxFileExists(m_AppShowCursorExePath))
    {
        m_pBitShowCursor->Disable();
    }
    else
    {
        //The hide cursor is initialize status
        bool bHideCursor = FALSE;
        bHideCursor = g_pQCPInterface->QCP_GetCursorStatus();
        if (bHideCursor)
        {
            m_bCursorState = true; //hide cursor
            wxMemoryDC dc;
 	     wxString stIconDisable;
	     stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
            RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath + wxT("image/status_no.png"), stIconDisable,
                    m_pBitShowCursor, m_pBkmapHideCursor, &dc);
            //m_bControlCursorOnSwitchDisplay = false;
        }
        else
        {
            m_bCursorState = false; //show cursor
            wxMemoryDC dc;
 	     wxString stIconDisable;
	     stIconDisable = m_ResourcefilePath + wxT("image/status_yes_disable.png");
            RedrawBitmapBtn(_("Show\nCursor"), m_ResourcefilePath + wxT("image/status_yes.png"), stIconDisable,
                     m_pBitShowCursor, m_pBkmapHideCursor, &dc);
            //m_bControlCursorOnSwitchDisplay = true;
        }
    }
    //Search the external application
    /*LPCTSTR lpRun = _T("SOFTWARE\\Intel\\dcs");
    if (false == GetAppPath(HKEY_LOCAL_MACHINE, &m_AppShowCursorExePath, lpRun, _T("DCSPath")))
    {
        m_pBitShowCursor->Disable();
    }
    else
    {
        m_AppShowCursorExePath += wxT("\\HideCursor.exe");
        if (false == wxFileExists(m_AppShowCursorExePath))
        {
            m_pBitShowCursor->Disable();
        }
        else
        {
            //The hide cursor is initialize status
            g_pQCPInterface->QCP_ShowCursor(m_AppShowCursorExePath + wxT(" TRUE"));//Default hide cursor
            m_bCursorState = true; //hide cursor
            m_bControlCursorOnSwitchDisplay = true;
        }
    }
*/
    LPCTSTR lpRunDisplay = _T("SOFTWARE\\Intel\\dcs");
    if (false == GetAppPath(HKEY_LOCAL_MACHINE, &m_AppSwitchDisplayExePath, lpRunDisplay, _T("DCSPath")))
    {
        m_pBitSwitchDisplay->Disable();
    }
    else
    {
        m_AppSwitchDisplayExePath += wxT("\\DisplayToggle.exe");
        if (false == wxFileExists(m_AppSwitchDisplayExePath))
        {
            m_pBitSwitchDisplay->Disable();
        }
        else
        {
        //    m_AppSwitchDisplayExePath += wxT(" Toggle");
        }
    }

    LPCTSTR lpRunTouch = _T("SOFTWARE\\TouchPack");//_T("Software\\Microsoft\\Windows\\ShellNoRoam\\MUICache");
    if (false == GetAppPath(HKEY_LOCAL_MACHINE, &m_AppTouchToolExePath, lpRunTouch, _T("ProgramPath")))//Touchpack
    {
        m_pBitCalScreen->Disable();
    }
    else
    {
        m_AppTouchToolExePath += wxT("\\Linearize.exe");
        if (false == wxFileExists(m_AppTouchToolExePath))
        {
            m_pBitCalScreen->Disable();
        }
    }

    #elif defined(__UNIX__)
    //Call the external application
    wxString sFilePath = m_ResourcefilePath + wxT("resource/hidecursor.sh");
    wxString sFilePathShow = m_ResourcefilePath + wxT("resource/showcursor.sh");

    if (DeviceMode != DCS_TABLET_MODE)
    {
        m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes_disable.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticTextShowCursor->SetForegroundColour(wxColour(190, 190, 190));
        m_pBitShowCursor->Disable();
        m_bCursorState = false;
    }
    else if ( (false == wxFileExists(sFilePath)) || (false == wxFileExists(sFilePathShow)) )
    {
        m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes_disable.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticTextShowCursor->SetForegroundColour(wxColour(190, 190, 190));
        m_pBitShowCursor->Disable();
        m_bCursorState = false;
    }
    else
    {
        bool bCursorHide = g_pQCPInterface->QCP_GetCursorStatus();

        if (TRUE == bCursorHide)
        {
            m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_no.png"),
                    wxBITMAP_TYPE_PNG));
            m_bCursorState = true; //hide cursor
        }
        else
        {
            m_pStaticBitmapShowCursor->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes.png"),
                    wxBITMAP_TYPE_PNG));
            m_bCursorState = false; //show cursor
        }
    }

    sFilePath = wxT("/usr/bin/dcs/DisplayToggle");
    if (false == wxFileExists(sFilePath))
    {
        m_pStaticBitmapSwitchDisplay->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/display_disable.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticTextSwitchDisplay->SetForegroundColour(wxColour(190, 190, 190));
        m_pBitSwitchDisplay->Disable();
    }
    else
    {
        m_AppSwitchDisplayExePath = wxT("/usr/bin/dcs/DisplayToggle Toggle &");
    }

    sFilePath = wxT("/usr/local/bin/LinearAp");
    if (false == wxFileExists(sFilePath))
    {
        m_pStaticBitmapCalScreen->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/calibrate_screen_disable.png"),
                    wxBITMAP_TYPE_PNG));
        m_pStaticTextCalScreen->SetForegroundColour(wxColour(190, 190, 190));
        m_pBitCalScreen->Disable();
    }
    else
    {
        m_AppTouchToolExePath = wxT("/usr/local/bin/LinearAp  /dev/usb/hiddev0 9 &");
    }
    #endif
}

//Starting the timer for QCP fade in
/**************************************************************************************************
* Function Name : FStartUpdateUITimer                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::FStartUpdateUITimer(int iMilliseconds)
{
    if (NULL == m_pTRefreshUI)
    {
        return;
    }

    m_pTRefreshUI->Start(iMilliseconds); //Start timer
}

//QCP fade in
/**************************************************************************************************
* Function Name : OnRefreshUITimer                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnRefreshUITimer(wxTimerEvent& event)
{
    if (NULL == m_pTRefreshUI)
    {
        return;
    }

    if (m_iFadeInCounter >= 254)
    {
        SetTransparent(254); //Set transparent for QCP UI
        m_pTRefreshUI->Stop();
        if (m_pTRefreshUI)
        {
            delete m_pTRefreshUI;
            m_pTRefreshUI = NULL;
        }
    }
    else
    {
        SetTransparent(m_iFadeInCounter);//Set transparent for QCP UI
        m_iFadeInCounter += 15;
    }
}

// exit QCP after 15 seconds
/**************************************************************************************************
* Function Name : OnTimer                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnTimer(wxTimerEvent& f_event)
{
	ExitQCP();
}

// common event handlers
/**************************************************************************************************
* Function Name : OnActivate                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnActivate(wxActivateEvent &event)
{

    //If the focus hasn't been got on QCP UI, exit the QCP
    if((false == event.GetActive())
        && (false == m_bAboutState)
        #if defined(__WXMSW__)
        && (true == m_bPreventExit) //Prevent QCP exit for switch display
        #endif
        )
    {
        ExitQCP();
    }
    #if defined(__WXMSW__)
    else
    {
        m_bPreventExit = true;
    }
    #endif
}

//kill focus
/**************************************************************************************************
* Function Name : OnActivateApp                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnActivateApp(wxActivateEvent &event)
{

    //User can touch any blank area of the screen to close QCP
    if((false == event.GetActive())
        && (false == m_bAboutState)
        #if defined(__WXMSW__)
        && (true == m_bPreventExit)
        #endif
        )
    {
        ExitQCP();
    }
    #if defined(__WXMSW__)
    else
    {
        m_bPreventExit = true;
    }
    #endif
}

//Controling the mouse event on panel
/**************************************************************************************************
* Function Name : OnMouseOver                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnMouseOver(wxMouseEvent& event)
{
    if (NULL == m_pTimer)
    {
        return;
    }
    #ifdef QCP_DEBUG
    dcsLog << "--------------------" << endl;
    dcsLog << "Stop Timer OnMouseOver1" << endl;
    #endif
	m_pTimer->Stop();

	//#if defined(__UNIX__)
	m_pTimer->Start(TIME_INTERVAL);
    //#endif
    #ifdef QCP_DEBUG
    dcsLog << "--------------------" << endl;
    dcsLog << "Start Timer OnMouseOver1" << endl;
    #endif
    m_bAboutState = false;  //control About Dialog show status

    return;
}

//Controling the mouse event on panel
/**************************************************************************************************
* Function Name : OnMouseLeave                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnMouseLeave(wxMouseEvent& event)
{
    if (NULL == m_pTimer)
    {
        return;
    }

    m_pTimer->Start(TIME_INTERVAL); //Start timer when mouse leave

    return;
}

/**************************************************************************************************
* Function Name : OnLeftDown                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnLeftDown(wxMouseEvent& evt)
{
    if (NULL == m_pTimer)
    {
        return;
    }

    CaptureMouse();
    wxPoint pos = ClientToScreen(evt.GetPosition());//Get screen width and height
    wxPoint origin = GetPosition();
    int dx = pos.x - origin.x;
    int dy = pos.y - origin.y;
    m_delta = wxPoint(dx, dy);
    #ifdef QCP_DEBUG
    dcsLog << "--------------------" << endl;
    dcsLog << "Stop Timer OnLeftDown" << endl;
    #endif
    m_pTimer->Stop();
}

/**************************************************************************************************
* Function Name : OnLeftUp                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnLeftUp(wxMouseEvent& evt)
{
    if (NULL == m_pTimer)
    {
        return;
    }

    if (HasCapture())
    {   //If the mouse captured, release the mouse
        ReleaseMouse();
    }
    m_pTimer->Start(TIME_INTERVAL);
}

//Drag the QCP when QCP move on screen
/**************************************************************************************************
* Function Name : OnMouseMove                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnMouseMove(wxMouseEvent& evt)
{
    if (m_bMoving !=  false)
    {
        return;
    }
    if (NULL == m_pTimer)
    {
        return;
    }

    #if defined(__UNIX__)
    m_pTimer->Stop();
    m_pTimer->Start(TIME_INTERVAL);
    #endif

    /*Control the title bar of QCP move in the screen*/
    if (m_delta.y > 40)//Height of QCP title bar is 38
    {
        return;
    }
    m_bMoving = true;
    wxPoint pt = evt.GetPosition();       //Get current mouse position
    if (evt.Dragging() && evt.LeftIsDown())
    {
        wxPoint pos = ClientToScreen(pt);  //Get mouse position on screen
        Move(wxPoint(pos.x - m_delta.x, pos.y - m_delta.y));  //Get current position of mouse move
    }
    m_bMoving = false;
}

//Control 15 seconds when the mouse move on the button
/**************************************************************************************************
* Function Name : OnButtonMouseMove                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnButtonMouseMove(wxMouseEvent& event)
{
    //If the mouse move on buttons, the timer stop
    if (NULL == m_pTimer)
    {
        return;
    }

    #ifdef QCP_DEBUG
    dcsLog << "--------------------" << endl;
    dcsLog << "Stop Timer OnButtonMouseMove1" << endl;
    #endif
    m_pTimer->Stop();
    m_pTimer->Start(TIME_INTERVAL);

    return;
}

#if defined(__WXMSW__)
//Controling the mouse event on the button
/**************************************************************************************************
* Function Name : OnMouseEnter                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnMouseEnter(wxMouseEvent& event)
{
    if (NULL == m_pTimer)
    {
        return;
    }

    m_bControlClick = true;//Spring to the click event of button
    if(event.LeftIsDown())
    {
        if (m_pTimer->IsRunning())
        {
            m_pTimer->Stop(); //Stop timer when mouse enter to button area
        }
    }

    return;
}

//Controling the mouse event on the button
/**************************************************************************************************
* Function Name : OnMouseLeaveButton                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnMouseLeaveButton(wxMouseEvent& event)
{
    if (NULL == m_pTimer)
    {
        return;
    }

    if(event.LeftIsDown())
    {
        m_bControlClick = false;//Blocking the click event of button
        if (m_pTimer->IsRunning())
        {
            m_pTimer->Stop(); //Stop timer when mouse enter to button area
        }
    }

    return;
}

//Getting the exe file path of external application from registry
/**************************************************************************************************
* Function Name : GetAppPath                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
bool CMPC_QCPDialog::GetAppPath(HKEY thKey, wxString* AppPath, wxString lpSubKeyPath, LPTSTR FileName)
{
    HKEY hKey;
	DWORD dwSize=200;
	wxChar szTempPath[256] = {};

    //Open the key value.
    if ( ERROR_SUCCESS != RegOpenKeyEx(thKey, lpSubKeyPath, NULL, KEY_READ, &hKey) )
    {
        return false;
    }
    DWORD dwType = REG_SZ;  //Get type

    //Get the path of execute file from register
    if ( ERROR_SUCCESS != RegQueryValueEx(hKey, FileName, NULL, &dwType, (BYTE *)szTempPath, &dwSize) )
    {
        return false;
    }
    *AppPath = szTempPath;  //Save the path of execute file
    RegCloseKey(hKey);
    hKey = NULL;

    return true;
}
#endif

//Set the QCP position on screen only under windows when Auto Rotation screen
/**************************************************************************************************
* Function Name : OnResolution                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::OnResolution(wxTimerEvent& f_event)
{
    //Get the width and height of screen
    SetQCPPosition();

    #ifdef QCP_DEBUG
   // dcsLog << " OnResolution enter !\n" << endl;
    #endif

    if (false == m_bAboutState)
    {
        bool bMuteSyn = false;
        int iVolumeSynLevel = 0;
        //Volume synchronization
        if (false == g_pQCPInterface->QCP_InitVolumeStatus(&iVolumeSynLevel, &bMuteSyn))
        {
            //Can't adjust the volume and set mute when the mix device can't be opened
            m_bNeedUpdate = false;
            if (  false == m_bVolumeSynControl )
            {
                m_bVolumeSynControl = true;
                m_bMuteState = true;
                UpdateVolumeUI();
                DisableVolumeButton();
                #if defined(__UNIX__)
                m_pStaticBitmapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes_disable.png"),
                    wxBITMAP_TYPE_PNG));
                m_pStaticTextMute->SetForegroundColour(wxColour(190, 190, 190));
                #endif
                m_pBitMute->Disable();
            }
        }
        else  //If the mix device open successfully, update current QCP UI
        {
            if ( (m_iVolLevel != iVolumeSynLevel) || (bMuteSyn != m_bMuteState) || (true == m_bNeedUpdate))
            {
                m_bVolumeSynControl = false;
                m_bMuteState = bMuteSyn;
                #if defined(__UNIX__)
                m_pStaticBitmapMute->SetBitmap(wxBitmap(m_ResourcefilePath + wxT("image/status_yes_disable.png"),
                    wxBITMAP_TYPE_PNG));
                m_pStaticTextMute->SetForegroundColour(wxColour(71, 83, 107));
                #endif
                m_pBitMute->Enable();
                if (true == m_bNeedUpdate)
                {
                    m_iVolLevel = iVolumeSynLevel;
                    EnableVolumeButton();
                    UpdateVolumeUI();
                }
                else
                {
                    EnableVolumeButton();
                    UpdateVolumeUI(iVolumeSynLevel);
                }
                UpdateMuteUI();
                m_bNeedUpdate = false;
            }
        }
    }
}

/**************************************************************************************************
* Function Name : SetQCPPosition                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::SetQCPPosition(void)
{
    //Get the width and height of screen
    #if defined(__WXMSW__)
    int iScreenWidth  = GetSystemMetrics(SM_CXSCREEN);
    int iScreenHeight = GetSystemMetrics(SM_CYSCREEN);
    #elif defined(__UNIX__)
    Display* pDisplay = XOpenDisplay(NULL);
    if (NULL == pDisplay)
    {
        return;
    }
    XLockDisplay(pDisplay);
    int iScreen = DefaultScreen(pDisplay);//Getting Current Screen
    if (iScreen >= ScreenCount(pDisplay))
    {
        XUnlockDisplay(pDisplay);
        XCloseDisplay(pDisplay);     //Close the display
        return;                //Invalid screen number
    }
    int iScreenWidth  = DisplayWidth(pDisplay, iScreen);
    int iScreenHeight = DisplayHeight(pDisplay, iScreen);
    XUnlockDisplay(pDisplay);
    XCloseDisplay(pDisplay);     //Close the display
    #endif

    #ifdef QCP_DEBUG
   // dcsLog << "Screen Width is : "<< iScreenWidth << endl;
    //dcsLog << "Screen Height is : "<< iScreenHeight << endl;
    #endif

    if ((iScreenWidth != m_iScreenWidth) || (iScreenHeight != m_iScreenHeight))
    {
        #ifdef QCP_DEBUG
       // dcsLog << "-----------------------"<< endl;
       // dcsLog << "Screen Solution Changed"<< endl;
        #endif
        wxPoint Dlgpos((iScreenWidth - QCP_UI_WIDTH), (iScreenHeight - QCP_UI_HEIGHT) / 2);
        this->SetPosition(Dlgpos); //Set the position of QCP on screen
        m_iScreenWidth  = iScreenWidth;
        m_iScreenHeight = iScreenHeight;
    }
}

//judge the button whether is pressed
/**************************************************************************************************
* Function Name : fCheckButtonState                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
bool CMPC_QCPDialog::fCheckButtonState(void)
{
    //Whether current mouse captured on buttons
    if (m_pBitmapClose->HasCapture())
    {
        return true;
    }
    if (m_pBitmapAbout->HasCapture())
    {
        return true;
    }
    if (m_pBitmapBrightnessUp->HasCapture())
    {
        return true;
    }
    if (m_pBitmapBrightnessDown->HasCapture())
    {
        return true;
    }
    for (m_iCount = 0; m_iCount < BRIGHTLEVEL; m_iCount++)
    {
        if (m_pStBitmapBtnBrightnessLevel[m_iCount]->HasCapture())
        {
            return true;
        }
    }
    if (m_pBitmapVolumeDown->HasCapture())
    {
        return true;
    }
    if (m_pBitmapVolumeUp->HasCapture())
    {
        return true;
    }
    for (m_iCount = 0; m_iCount < VOLUMELEVEL; m_iCount++)
    {
        if (m_pStBitmapBtnVolumeLevel[m_iCount]->HasCapture())
        {
            return true;
        }
    }
    if (m_pBitMute->HasCapture())
    {
        return true;
    }
    if (m_pBitShowCursor->HasCapture())
    {
        return true;
    }
    if (m_pBitSwitchDisplay->HasCapture())
    {
        return true;
    }
    if (m_pBitCalScreen->HasCapture())
    {
        return true;
    }
    if (m_pBtnRotation->HasCapture())
    {
        return true;
    }
    if (m_pBitmapCW->HasCapture())
    {
        return true;
    }
    if (m_pBitmapCCW->HasCapture())
    {
        return true;
    }

    return false;
}

//exit the QCP
/**************************************************************************************************
* Function Name : ExitQCP                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::ExitQCP()
{
    // If About dialog Open, return;
    if (m_bAboutState)
    {
        m_pTimer->Stop();
        return;
    }
    //If the QCP Panel captured, can't exited after 15 seconds
    if (HasCapture())
    {
        return;
    }

    //If a button captured, can't exited after 15 seconds
    if (true == fCheckButtonState())
    {
        return;
    }

    /*Unregister interface of DCS*/

    if (DCS_SUCCESS == m_FnKeyRet)
    {
        DCS_UnregisterFnKeyCallback();//Unregister Fn key
    }

    if ( DCS_SUCCESS == m_RegBrightnessRet )
    {
        DCS_UnregisterLCDBrightnessChangedCallback();
    }

    if ( DCS_SUCCESS == m_RegTabletRet )
    {
        DCS_UnregisterTabletSensorCallback();
    }

    if ( true == m_bDCSInitRet )
    {
        DCS_Uninitialize();
    }

    wxExit();         //Exit QCP application
}

#if defined (__UNIX__)
/**************************************************************************************************
* Function Name : SetLocale                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPDialog::SetLocale()
{
    int langCode = wxLocale::GetSystemLanguage();
    wxString resource;
    int iRet = ::wxGetApp().GetLocaleFileName(langCode, resource);

    m_locale.AddCatalogLookupPathPrefix(m_ResourcefilePath + wxT("resource/"));
    wxString filePath = m_ResourcefilePath + wxT("resource/") + resource + wxT(".mo");

    if (wxFileExists(filePath) && (iRet > 0))
    {
        m_locale.AddCatalog(resource);
    }
    else
    {
        m_locale.AddCatalog(wxT("en"));
    }
}
#endif
