/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          CMPC_QCPTypeTransfer.h

Description:
    This file implements type transfer
        This class has following functions.

         1.StringToWxString        String transfer to wxString type
         2.WxStringToString        wxString transfer to string type
         3.GetHomeDir              Getting path for check multi instance
         4.GetLock                 Add lock for QCP application

Environment (opt):
    OS: Ubuntu
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================

  0.1        Create                         Deng Jing   2008-7-20

  =====================================================================

****************************************************************************/
#ifndef CMPC_QCPTYPETRANSFER_H_INCLUDED
#define CMPC_QCPTYPETRANSFER_H_INCLUDED

#include "wx/string.h"
#include <string>
using namespace std;

class CTypeTransfer
{
    public:
        wxString fStringToWxString(string stringValue);
        string fWxStringToString(wxString wxStringValue);
        #if defined(__UNIX__)
        string GetHomeDir();
        int GetLock();
        #endif
};

#endif // CMPC_QCPTYPETRANSFER_H_INCLUDED
