# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Authors: Alessandro Decina <alessandro@fluendo.com>

import gobject
gobject.threads_init()
import sys

from elisa.core import log
log.init()
log.logTwisted()

try:
    from twisted.internet import glib2reactor
    glib2reactor.install()
except AssertionError:
    # reactor already installed
    pass

import sys
from twisted.internet import reactor
from twisted.spread.jelly import globalSecurity
from twisted.spread import pb, flavors, jelly
from twisted.internet.stdio import StandardIO

from elisa.plugins.gstreamer.gst_metadata import GstMetadata, GstMetadataFast
from elisa.core.media_uri import MediaUri

globalSecurity.allowInstancesOf(MediaUri)

class GstMetadataBroker(pb.Broker):
    def __init__(self, isClient=False, security=globalSecurity):
        pb.Broker.__init__(self, isClient=isClient, security=security)

    def connectionLost(self, reason):
        pb.Broker.connectionLost(self, reason)

        reactor.stop()

class GstMetadataPBRoot(flavors.Root):
    def __init__(self):
        self.component = GstMetadataFast()
        self._requests = {}

    def remote_initialize(self):
        dfr = self.component.initialize()
        dfr.addCallback(lambda result: None)

        return dfr

    def remote_clean(self):
        dfr = self.component.clean()
        dfr.addCallback(lambda result: None)

        return dfr

    def remote_able_to_handle(self, metadata):
        return self.component.able_to_handle(metadata)
        
    def remote_set_process_interval(self, value):
        return self.component.set_process_interval(value)
        
    def remote_get_metadata(self, metadata):
        request_id = metadata['request_id']
        dfr = self.component.get_metadata(metadata)
        self._requests[request_id] = dfr
        return dfr

    def remote_cancel_get_metadata(self, request_id):
        try:
            dfr = self._requests.pop(request_id)
        except KeyError:
            return

        dfr.cancel()

def main():
    # we are being run out of process, run perspective broker over stdin/stdout
    # to communicate with elisa
    root = GstMetadataPBRoot()
    factory = pb.PBServerFactory(root)
    factory.protocol = GstMetadataBroker
    protocol = factory.buildProtocol(None)
    transport = StandardIO(protocol)
    reactor.run()

if __name__ == '__main__':
    sys.exit(main())

