# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.pigment_controller import PigmentController

class ListSwitcherController(PigmentController):

    # list of classes inheriting from
    # elisa.plugins.poblesec.list.ListController
    modes = []
    default_mode = None

    def initialize(self, **kwargs):
        dfr = super(ListSwitcherController, self).initialize()
        self.kwargs = kwargs

        def list_created(controller):
            self.list_controller = controller
            if self.widget.focus:
                controller.widget.focus = self.widget.focus
            return self

        self.widget.connect('focus', self._on_focus)

        dfr.addCallback(self.default_mode.create, **kwargs)
        dfr.addCallback(list_created)
        return dfr

    def _on_focus(self, widget, focus):
        if focus:
            self.list_controller.widget.focus = focus

    def set_frontend(self, frontend):
        super(ListSwitcherController, self).set_frontend(frontend)
        self.list_controller.set_frontend(frontend)
        self._show_controller(self.list_controller)

    def set_path(self, path):
        super(ListSwitcherController, self).set_path(path)
        self.list_controller.path = self.path

    def _show_controller(self, controller):
        controller.widget.visible = False
        self.widget.add(controller.widget)
        controller.widget.x, controller.widget.y = (0.0, 0.0)
        controller.widget.width, controller.widget.height = (1.0, 1.0)
        controller.prepare()
        controller.widget.regenerate()
        controller.widget.visible = True

    def _hide_controller(self, controller):
        self.widget.remove(controller.widget)
        controller.removed()

    def switch_mode(self, new_class):
        if isinstance(self.list_controller, new_class):
            return False

        if self.list_controller.nothing_to_display_widget.visible:
            return False

        def list_created(new_list):
            new_list.path = self.path
            self._hide_controller(self.list_controller)
            new_list.set_frontend(self.frontend)
            self._show_controller(new_list)

            # pass the model and the current index across
            index = self.list_controller.nodes.selected_item_index
            model = self.list_controller.model
            new_list.nodes.selected_item_index = index
            new_list.nodes.focus = True

            self.list_controller = new_list

        self.list_controller.clean()
        dfr = new_class.create(**self.kwargs)
        dfr.addCallback(list_created)

    def handle_input(self, manager, input_event):
        return self.list_controller.handle_input(manager, input_event)

    def prepare(self):
        self.list_controller.prepare()

    def removed(self):
        if self.list_controller:
            self.list_controller.removed()

    def clean(self):
        return self.list_controller.clean()
