/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_CATEGORY_EDITOR_H_
#define _LAUNCHER_CATEGORY_EDITOR_H_

#include <glib-object.h>
#include <gtk/gtk.h>

#include "launcher-menu.h"


#define LAUNCHER_TYPE_CATEGORY_EDITOR (launcher_category_editor_get_type ())

#define LAUNCHER_CATEGORY_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_CATEGORY_EDITOR, LauncherCategoryEditor))

#define LAUNCHER_CATEGORY_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_CATEGORY_EDITOR, LauncherCategoryEditorClass))

#define LAUNCHER_IS_CATEGORY_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_CATEGORY_EDITOR))

#define LAUNCHER_IS_CATEGORY_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_CATEGORY_EDITOR))

#define LAUNCHER_CATEGORY_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_CATEGORY_EDITOR, LauncherCategoryEditorClass))

typedef struct _LauncherCategoryEditor        LauncherCategoryEditor;
typedef struct _LauncherCategoryEditorClass   LauncherCategoryEditorClass;
typedef struct _LauncherCategoryEditorPrivate LauncherCategoryEditorPrivate;
 
struct _LauncherCategoryEditor
{
  GtkDialog        parent;	

  LauncherCategoryEditorPrivate *priv;
};

struct _LauncherCategoryEditorClass
{
  GtkDialogClass   parent_class;
};

GType       launcher_category_editor_get_type (void) G_GNUC_CONST;

GtkWidget * launcher_category_editor_new      ();


#endif /* _LAUNCHER_CATEGORY_EDITOR_H_ */

