/*
 * Copyright (C) 2007 Intel
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <njp@o-hand.com>
 *             Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include "launcher-menu-application.h"

#include "launcher-config.h"
#include "launcher-defines.h"
#include "launcher-util.h"

 
const gchar *
launcher_menu_application_get_name (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, NULL);

  return application->name;
}


const gchar *
launcher_menu_application_get_comment (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, NULL);

  return application->comment;
}

GdkPixbuf*
launcher_menu_application_get_icon (LauncherMenuApplication *application)
{
  LauncherConfig *cfg = launcher_config_get_default ();

  g_return_val_if_fail (application, NULL);

  if (application->pixbuf)
    return application->pixbuf;

  return launcher_menu_application_get_pixbuf (application, 
                                               cfg->iconview_height);
}

const gchar *
launcher_menu_application_get_icon_name (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, NULL);

  return application->icon;
}

  LauncherMenuCategory*
launcher_menu_application_get_category (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, NULL);

  return application->category;
}

GdkPixbuf *
launcher_menu_application_get_pixbuf (LauncherMenuApplication *application,
                                      guint                    size)
{
  const gchar *name;
  LauncherConfig *cfg = launcher_config_get_default ();
  
  g_return_val_if_fail (application, NULL);

  name = application->icon;

  if (!GDK_IS_PIXBUF (application->pixbuf))
    application->pixbuf = get_icon (name, cfg->icon_height);

  return application->pixbuf;
}


const gchar*
launcher_menu_application_get_exec (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, NULL);

  return application->exec;
}

const gchar *
launcher_menu_application_get_desktop_filename (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, NULL);

  return application->path;
}

gboolean
launcher_menu_application_is_new (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, FALSE);

  return application->isnew;
}

void
launcher_menu_application_set_new (LauncherMenuApplication *application, 
                                   gboolean                 is_new)
{
  g_return_if_fail (application);
  application->isnew = FALSE;
}

gint
launcher_menu_application_get_pid (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, -1);

  return application->pid;
}

void
launcher_menu_application_set_pid (LauncherMenuApplication *application,  
                                   gint                     pid)
{
  g_return_if_fail (application);

  application->pid = pid;
}

WnckWindow *
launcher_menu_application_get_window (LauncherMenuApplication *application)
{
  g_return_val_if_fail (application, NULL);

  return application->window;
}

void
launcher_menu_application_set_window (LauncherMenuApplication *application,
                                      WnckWindow              *window)
{
  g_return_if_fail (application);

  application->window = window;
}

