/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include "launcher-menu-category.h"

#include "launcher-config.h"
#include "launcher-defines.h"
#include "launcher-util.h"

const gchar *
launcher_menu_category_get_name (LauncherMenuCategory *category)
{
  g_return_val_if_fail (category, NULL);

  return category->name;
}

const gchar *
launcher_menu_category_get_comment (LauncherMenuCategory *category)
{
  g_return_val_if_fail (category, NULL);

  return category->comment;
}

GdkPixbuf*
launcher_menu_category_get_icon (LauncherMenuCategory *category)
{
  gint cat_height = (launcher_config_get_default ())->cat_height;
  g_return_val_if_fail (category, NULL);

  return launcher_menu_category_get_pixbuf (category, CAT_ICON_SIZE());
}

const gchar *
launcher_menu_category_get_icon_name (LauncherMenuCategory *category)
{
  g_return_val_if_fail (category, NULL);

  return category->icon;
}

GList*
launcher_menu_category_get_applications (LauncherMenuCategory *category)
{
  g_return_val_if_fail (category, NULL);

  return category->applications;

}

GdkPixbuf *
launcher_menu_category_get_pixbuf (LauncherMenuCategory *category,
                                   guint                 size)
{
  const gchar *name;
  gint cat_height = (launcher_config_get_default ())->cat_height;
  
  g_return_val_if_fail (category, NULL);

  name = category->icon;

  if (!GDK_IS_PIXBUF (category->pixbuf))
    category->pixbuf = get_icon (name, CAT_ICON_SIZE());

  return category->pixbuf;
}
 
