/*
 * Copyright (C) 2007 Intel
 * Copyright (C) Dell Inc.
 * Copyright (C) Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <njp@o-hand.com>
 *             Neil Jagdish Patel <neil.patel@canonical>
 *
 */

#ifndef _HAVE_LAUNCHER_MENU_H
#define _HAVE_LAUNCHER_MENU_H

#include <glib.h>
#include <gtk/gtk.h>

#include <libwnck/window.h>
#include <clutter/clutter.h>

#include "launcher-menu-category.h"
#include "launcher-menu-application.h"

G_BEGIN_DECLS

#define LAUNCHER_TYPE_MENU (launcher_menu_get_type ())

#define LAUNCHER_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        LAUNCHER_TYPE_MENU, LauncherMenu))

#define LAUNCHER_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
        LAUNCHER_TYPE_MENU, LauncherMenuClass))

#define LAUNCHER_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        LAUNCHER_TYPE_MENU))

#define LAUNCHER_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        LAUNCHER_TYPE_MENU))

#define LAUNCHER_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
        LAUNCHER_TYPE_MENU, LauncherMenuClass))

typedef struct _LauncherMenu LauncherMenu;
typedef struct _LauncherMenuClass LauncherMenuClass;
typedef struct _LauncherMenuPrivate LauncherMenuPrivate;

struct _LauncherMenu
{
  GObject         parent;

  /*< private >*/
  LauncherMenuPrivate   *priv;
};

struct _LauncherMenuClass 
{
  /*< private >*/
  GObjectClass    parent_class;

  /*< public >*/
  void (*menu_changed) (LauncherMenu *menu);
  
 /*< private >*/
  void (*_launcher_menu_1) (void);
  void (*_launcher_menu_2) (void);
  void (*_launcher_menu_3) (void);
  void (*_launcher_menu_4) (void);
};

GType launcher_menu_get_type (void) G_GNUC_CONST;

LauncherMenu*
launcher_menu_get_default (void);

GList*
launcher_menu_get_categories (LauncherMenu           *menu);

void
launcher_menu_set_categories (LauncherMenu           *menu, 
                              GList                  *categories);

gint 
launcher_menu_get_n_categories (LauncherMenu         *menu);

GList*
launcher_menu_get_applications (LauncherMenu         *menu);

void
launcher_menu_set_applications (LauncherMenu         *menu, 
                                LauncherMenuCategory *category,
                                GList                *applications);


/* Menu editing */
void
launcher_menu_add_application  (LauncherMenu         *menu,
                                LauncherMenuCategory *category,
                                const gchar          *name,
                                const gchar          *exec,
                                const gchar          *icon);

void
launcher_menu_edit_application  (LauncherMenu            *menu,
                                 LauncherMenuApplication *application,
                                 LauncherMenuCategory    *cat,
                                 const gchar             *name,
                                 const gchar             *exec,
                                 const gchar             *icon);

void
launcher_menu_add_category  (LauncherMenu         *menu,
                             const gchar          *name,
                             const gchar          *icon);

void
launcher_menu_edit_category  (LauncherMenu            *menu,
                              LauncherMenuCategory    *cat,
                              const gchar             *name,
                              const gchar             *icon);

G_END_DECLS

#endif /* _HAVE_LAUNCHER_MENU_H */
