/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "launcher-wm.h"

#include "launcher-menu.h"

G_DEFINE_TYPE (LauncherWm, launcher_wm, G_TYPE_OBJECT);

#define LAUNCHER_WM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  LAUNCHER_TYPE_WM, \
  LauncherWmPrivate))

struct _LauncherWmPrivate
{
  WnckScreen *screen;

  GtkWidget *window;
};

enum
{
  SHOW_DECS,
  HIDE_DECS,

  LAST_SIGNAL
};
static guint _wm_signals[LAST_SIGNAL] = { 0 };

static void
on_active_window_changed (WnckScreen *screen, 
                          WnckWindow *prev_window,
                          LauncherWm *wm)
{
  WnckWindow *window;
  WnckWindowType type;

  window = wnck_screen_get_active_window (screen);

  if (!WNCK_IS_WINDOW (window))
  {
    g_signal_emit (wm, _wm_signals[HIDE_DECS], 0);
    return;
  }
  
  type = wnck_window_get_window_type (window);
  switch (type)
  {
    case WNCK_WINDOW_DESKTOP:
      wnck_screen_toggle_showing_desktop (screen, TRUE); 
      g_signal_emit (wm, _wm_signals[HIDE_DECS], 0);
      return;
    case WNCK_WINDOW_DOCK:
      g_signal_emit (wm, _wm_signals[HIDE_DECS], 0);
      return;
    default:
      break;
   }
  
  g_signal_emit (wm, _wm_signals[SHOW_DECS], 0, window);
}

static void
on_window_opened (WnckScreen *screen, WnckWindow *window, LauncherWm *wm)
{
  LauncherWmPrivate *priv;
  WnckWindowType type;
  GList *list, *l;
  gint pid;

  g_return_if_fail (LAUNCHER_IS_WM (wm));
  priv = wm->priv;

  type = wnck_window_get_window_type (window);
  pid = wnck_window_get_pid (window);

  if (type != WNCK_WINDOW_NORMAL)
    return;
  
  list = launcher_menu_get_applications (launcher_menu_get_default ());
  for (l = list; l; l = l->next)
  {
    if (pid == launcher_menu_application_get_pid (l->data))
    {
      launcher_menu_application_set_window (l->data, window);
      wnck_window_activate (window, GDK_CURRENT_TIME);
      return;
    }
  }
}

/* GObject stuff */
static void
launcher_wm_class_init (LauncherWmClass *klass)
{
  GObjectClass        *obj_class = G_OBJECT_CLASS (klass);

	_wm_signals[SHOW_DECS] =
		g_signal_new ("show-windec",
			      G_OBJECT_CLASS_TYPE (obj_class),
			      G_SIGNAL_RUN_LAST,
			      G_STRUCT_OFFSET (LauncherWmClass, show_windec),
			      NULL, NULL,
			      g_cclosure_marshal_VOID__OBJECT, 
			      G_TYPE_NONE,
			      1, WNCK_TYPE_WINDOW);

  _wm_signals[HIDE_DECS] =
		g_signal_new ("hide-windec",
			      G_OBJECT_CLASS_TYPE (obj_class),
			      G_SIGNAL_RUN_LAST,
			      G_STRUCT_OFFSET (LauncherWmClass, hide_windec),
			      NULL, NULL,
			      g_cclosure_marshal_VOID__VOID, 
			      G_TYPE_NONE, 0);  

  g_type_class_add_private (obj_class, sizeof (LauncherWmPrivate));
}

static void
launcher_wm_init (LauncherWm *wm)
{
  LauncherWmPrivate *priv;
	
  priv = wm->priv = LAUNCHER_WM_GET_PRIVATE (wm);

  priv->screen = wnck_screen_get_default ();
 
  g_signal_connect (priv->screen, "active-window-changed",
                    G_CALLBACK (on_active_window_changed), (gpointer)wm);
  g_signal_connect (priv->screen, "window-opened",
                    G_CALLBACK (on_window_opened), (gpointer)wm);
}

LauncherWm *
launcher_wm_get_default (void)
{
  static LauncherWm *wm = NULL;

  if (!wm)
    wm = g_object_new (LAUNCHER_TYPE_WM, 
                       NULL);

  return wm;
}
