#include <stdio.h>
#include "dump-dvbscan.h"
#include <linux/dvb/frontend.h>

static const char *fec_name [] = {
	"NONE",
	"1/2",
	"2/3",
	"3/4",
	"4/5",
	"5/6",
	"6/7",
	"7/8",
	"8/9",
	"AUTO"
};


static const char *qam_name [] = {
	"QPSK",	/* FIXME: sometimes Modulation cannot be found, returns QPSK */
	"QAM16",
	"QAM32",
	"QAM64",
	"QAM128",
	"QAM256",
	"AUTO"
};


static const char *bw_name [] = {
	"8MHz",
	"7MHz",
	"6MHz",
	"AUTO"
};


static const char *mode_name [] = {
	"2k",
	"8k",
	"AUTO"
};

static const char *guard_name [] = {
	"1/32",
	"1/16",
	"1/8",
	"1/4",
	"AUTO"
};


static const char *hierarchy_name [] = {
	"NONE",
	"1",
	"2",
	"4",
	"AUTO"
};

void dvbscan_dump_tuningdata (	FILE *f, 
				fe_type_t type,
				struct dvb_frontend_parameters *p,
				uint16_t index) {
	if (index == 0) {
		fprintf (f, "# file automatically generated by w_scan\n");
		fprintf (f, "# (http://wirbel.htpc-forum.de/w_scan/index2.html)\n");
		switch (type) {
			case FE_QAM:
				fprintf (f, "# freq sr fec mod\n");
				break;
			case FE_OFDM:
				fprintf (f, "# T freq bw fec_hi fec_lo mod");
				fprintf (f, " transmission-mode guard-interval hierarchy\n");
				break;
			default:
				;
			};
		}	/* end if index == 0 */

	switch (type) {
		case FE_QAM:
			fprintf (f, "C ");
			fprintf (f, "%i ", p->frequency);
			fprintf (f, "%i ", p->u.qpsk.symbol_rate);
			fprintf (f, "%s ", fec_name[p->u.qpsk.fec_inner]);
			fprintf (f, "%s\n",  qam_name[p->u.qam.modulation]);
			break;
		case FE_OFDM:
			fprintf (f, "T ");
			fprintf (f, "%i ", p->frequency);
			fprintf (f, "%s ", bw_name[p->u.ofdm.bandwidth]);
			fprintf (f, "%s ", fec_name[p->u.ofdm.code_rate_HP]);
			fprintf (f, "%s ", fec_name[p->u.ofdm.code_rate_LP]);
			fprintf (f, "%s ", qam_name[p->u.ofdm.constellation]);
			fprintf (f, "%s ", mode_name[p->u.ofdm.transmission_mode]);
			fprintf (f, "%s ", guard_name[p->u.ofdm.guard_interval]);
			fprintf (f, "%s\n",  hierarchy_name[p->u.ofdm.hierarchy_information]);
			break;

		default:
			;
		};
}

