# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Authors: Guido Amoruso <guidonte@fluendo.com>


from elisa.core import common

from elisa.core.media_uri import MediaUri

from elisa.core.utils.cancellable_defer import cancellable_deferred_iterator, \
        CancellableDeferred

from elisa.plugins.base.models.media import PlayableModel

from elisa.plugins.poblesec.actions import Action
from elisa.plugins.poblesec.actions import PlayAllAction, ShuffleAction
from elisa.plugins.poblesec.actions import AddToFavoritesAction, AddToPlaylistAction
from elisa.plugins.poblesec.actions import ViewSlideshowAction

from elisa.plugins.favorites.models import FavoritesItem
from elisa.plugins.database.models import Image, File

from twisted.internet import defer

import datetime
import os.path

# pute
from elisa.core.utils.i18n import install_translation

from elisa.plugins.poblesec.base.hierarchy import HierarchyController
from elisa.plugins.poblesec.base.list import GenericListViewMode
from elisa.plugins.poblesec.base.list_switcher import ListSwitcherController
from elisa.plugins.poblesec.base.preview_list import \
    MenuItemPreviewListController, DoubleLineMenuItemPreviewListController
from elisa.plugins.poblesec.base.coverflow import \
    ImageWithReflectionCoverflowController
from elisa.plugins.poblesec.base.grid import GridItemGridController
from elisa.plugins.poblesec.link import Link

from elisa.plugins.favorites.models import FavoritesItem

from elisa.plugins.base.models.media import PlayableModel

from elisa.plugins.database.models import Video, File

from twisted.internet import defer
from twisted.internet import task

import os, datetime
from random import shuffle


class ArtistPlayAllAction(PlayAllAction):
    pass

class AlbumPlayAllAction(PlayAllAction):
    pass

class TrackPlayAllAction(PlayAllAction):

    def run(self):
        track = self.controller.track
        if track is not None:
            # Enqueue all the media after 'track' and play
            tracks = self.controller.tracks
            index = tracks.index(track)
            self.play(tracks[index:])
            return defer.succeed(None)
        else:
            dfr = super(TrackPlayAllAction, self).run()

        return dfr


class ArtistShuffleAction(ArtistPlayAllAction, ShuffleAction):
    pass

class AlbumShuffleAction(AlbumPlayAllAction, ShuffleAction):
    pass

class TrackShuffleAction(TrackPlayAllAction, ShuffleAction):
    pass


class AlbumAddToFavoritesAction(AddToFavoritesAction):

    def run(self):
        if self.toggled:
            if self.controller.artist:
                uri = getattr(self.controller.artist, 'uri', None)
                if uri:
                    dfr = common.application.store.find(FavoritesItem,
                                                        FavoritesItem.uri == unicode(uri),
                                                        FavoritesItem.type == u'artist')
                else:
                    dfr = common.application.store.find(FavoritesItem,
                                                        FavoritesItem.foreign_id == self.controller.artist.name,
                                                        FavoritesItem.foreign_class == u'Artist')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
        else:
            favorite = FavoritesItem()
            favorite.added_time = datetime.datetime.now()

            # expecting an AlbumsController
            if self.controller.artist:
                uri = getattr(self.controller.artist, 'uri', None)
                if uri:
                    favorite.uri = unicode(uri)
                else:
                    favorite.foreign_id = self.controller.artist.name
                    favorite.foreign_class = u'Artist'
                favorite.type = u'artist'
                favorite.title = self.controller.artist.name
                self.store(favorite)


class TrackAddToFavoritesAction(AddToFavoritesAction):

    def run(self):
        if self.toggled:
            if self.controller.track:
                uri = getattr(self.controller.track, 'uri', None)
                if uri:
                    dfr = common.application.store.find(FavoritesItem,
                                                        FavoritesItem.uri == unicode(uri),
                                                        FavoritesItem.type == u'music_track')
                else:
                    dfr = common.application.store.find(FavoritesItem,
                                                        FavoritesItem.foreign_id == self.controller.track.file_path,
                                                        FavoritesItem.foreign_class == u'MusicTrack')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
            elif self.controller.album:
                uri = getattr(self.controller.album, 'uri', None)
                if uri:
                    dfr = common.application.store.find(FavoritesItem,
                                                        FavoritesItem.uri == unicode(uri),
                                                        FavoritesItem.type == u'music_album')
                else:
                    dfr = common.application.store.find(FavoritesItem,
                                                        FavoritesItem.foreign_id == self.controller.album.name,
                                                        FavoritesItem.foreign_class == u'MusicAlbum')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
        else:
            favorite = FavoritesItem()
            favorite.added_time = datetime.datetime.now()

            # expecting a TracksController
            if self.controller.track:
                uri = getattr(self.controller.track, 'uri', None)
                if uri:
                    favorite.uri = unicode(uri)
                else:
                    favorite.foreign_id = self.controller.track.file_path
                    favorite.foreign_class = u'MusicTrack'
                favorite.type = u'music_track'
                favorite.title = self.controller.track.title
                self.store(favorite)
            elif self.controller.album:
                uri = getattr(self.controller.album, 'uri', None)
                if uri:
                    favorite.uri = unicode(uri)
                else:
                    favorite.foreign_id = self.controller.album.name
                    favorite.foreign_class = u'MusicAlbum'
                favorite.type = u'music_album'
                favorite.title = self.controller.album.name
                self.store(favorite)

class PhotoAddToFavoritesAction(AddToFavoritesAction):

    def run(self):
        if self.toggled:
            if self.controller.album:
                dfr = common.application.store.find(FavoritesItem,
                                                    FavoritesItem.foreign_id == self.controller.album.name,
                                                    FavoritesItem.foreign_class == u'PhotoAlbum')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
            elif self.controller.photo:
                dfr = common.application.store.find(FavoritesItem,
                                                    FavoritesItem.foreign_id == self.controller.photo.file_path,
                                                    FavoritesItem.foreign_class == u'Image')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
        else:
            favorite = FavoritesItem()
            favorite.added_time = datetime.datetime.now()

            # expecting a TracksController
            if self.controller.album:
                favorite.foreign_id = self.controller.album.name
                favorite.foreign_class = u'PhotoAlbum'
                favorite.title = self.controller.album.name
                self.store(favorite)
            elif self.controller.photo:
                favorite.foreign_id = self.controller.photo.file_path
                favorite.foreign_class = u'Image'
                # FIXME: find a better title
                favorite.title = os.path.basename(self.controller.photo.file_path)
                self.store(favorite)


class ArtistAddToPlaylistAction(AddToPlaylistAction):

    def run(self):
        raise NotImplementedError()

class AlbumAddToPlaylistAction(AddToPlaylistAction):

    def run(self):
        raise NotImplementedError()

class TrackAddToPlaylistAction(AddToPlaylistAction):

    def run(self):
        raise NotImplementedError()


class ViewPhotoAlbumSlideshowAction(ViewSlideshowAction):

    def order_photos(self, rs):
        # copied and pasted the ordering from database.PhotosController
        rs.order_by(Image.shot_time, Image.file_path)
        return rs.all()

    def get_items(self, item):
        dfr = common.application.store.find(Image, Image.album_name == item.name)
        dfr.addCallback(self.order_photos)
        return dfr

class ViewPhotoDateSlideshowAction(ViewSlideshowAction):

    def order_photos(self, rs):
        # copied and pasted the ordering from database.PhotosController
        rs.order_by(Image.shot_time)
        return rs.all()

    def run(self):
        dfr = common.application.store.find(Image, Image.shot_time != None)
        dfr.addCallback(self.order_photos)
        dfr.addCallback(self.play)
        return dfr

class RemoveAction(Action):

    def hide_stuff(self, dfr):
        def got_file(result):
            if result:
                result.hidden = True
            browser = self.controller.frontend.retrieve_controllers('/poblesec/browser')[0]
            browser.history.go_back()

            prev_controller = browser.history.current
            list_controller = prev_controller.list_controller
            del list_controller.model[list_controller.nodes.selected_item_index]

        dfr.addCallback(got_file)
        return dfr

class PhotoRemoveAction(RemoveAction):
    icon = 'elisa.plugins.poblesec.remove'

    def run(self):
        return self.hide_stuff(self.controller.photo.file)

class TrackRemoveAction(RemoveAction):
    icon = 'elisa.plugins.poblesec.remove'

    def run(self):
        return self.hide_stuff(self.controller.track.file)

class VideoPlayAllAction(Action):

    icon = 'elisa.plugins.poblesec.play_all'
    
    @cancellable_deferred_iterator
    def _build_playlist(self, videos):
        if hasattr(self.controller, 'file_path'):
            playable_model = PlayableModel()
            playable_model.uri = MediaUri("file://%s" % 
                                          self.controller.file_path) 
            dfr = defer.succeed(playable_model)
            videos.append(playable_model)
            yield None
        else:    
            for item in self.controller.model:
                if isinstance(item, Action):
                    continue
                        
                playable_model = PlayableModel()
                playable_model.uri = MediaUri("file://%s" % item.file_path) 
                dfr = defer.succeed(playable_model)
                videos.append(playable_model)
                yield None
    
    def run(self):
        videos = []
        cancellable_iterator = self._build_playlist(videos)
        def canceller(dfr):
            cancellable_iterator.cancel()
        cancellable = CancellableDeferred(canceller)

        dfr = task.coiterate(iter(cancellable_iterator))
        dfr.addCallback(lambda result: self.order_videos(videos))
        dfr.addCallback(self.play)

        dfr.chainDeferred(cancellable)
        return cancellable
    
    def play(self, items):
    
        if not items:
            return items
    
        poblesec = self.controller.frontend.retrieve_controllers('/poblesec')[0]
        player = poblesec.video_player.player
        poblesec.show_video_player()
        self.controller.stop_loading_animation()

        player.play_model(items[0])
        for item in items[1:]:
            player.enqueue_to_playlist(item)
   
    def order_videos(self, videos):
        return videos

class VideoShuffleAction(VideoPlayAllAction):

    icon = 'elisa.plugins.poblesec.shuffle'
    
    def order_videos(self, videos):
        shuffle(videos)
        return videos
                
class VideoAddToFavoritesAction(AddToFavoritesAction):

    def run(self):
        if self.toggled:
            if self.controller.name:
                dfr = common.application.store.find(FavoritesItem,
                                                    FavoritesItem.foreign_id == self.controller.file_path,
                                                    FavoritesItem.foreign_class == u'Video')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
        else:
            favorite = FavoritesItem()
            favorite.added_time = datetime.datetime.now()

            if self.controller.name:
                favorite.foreign_id = self.controller.file_path
                favorite.foreign_class = u'Video'
                favorite.title = self.controller.name
                self.store(favorite)
        
class VideoRemoveAction(RemoveAction):
    icon = 'elisa.plugins.poblesec.remove'
