# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Guido Amoruso <guidonte@fluendo.com>

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

#FIXME: add dependency on storm/twisted-wrapper

setup(name='elisa-plugin-favorites',
    version='0.1',
    description="Favorites items management.",
    long_description="""Allow to mark items as favorites for quick access""",
    license='GPL3',
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.mo', '*.po', '*.conf'],
                  'elisa.plugins.favorites.i18n': ['*/LC_MESSAGES/*.po', '*.pot'],
                 },
    entry_points="",
    controller_mappings=[('/poblesec/music/favorites',
                         'elisa.plugins.favorites.controller:FavoritesController'),
                         ('/poblesec/music/favorites/albums',
                         'elisa.plugins.favorites.controller:FavoritesAlbumsListSwitcher'),
                         ('/poblesec/music/favorites/artists',
                         'elisa.plugins.favorites.controller:FavoritesArtistsListSwitcher'),
                         ('/poblesec/music/internet/favorites',
                         'elisa.plugins.favorites.controller:FavoritesRadiosListSwitcher'),
                         ('/poblesec/music/favorites/tracks',
                         'elisa.plugins.favorites.controller:FavoritesTracksListSwitcher'),
                         ('/poblesec/pictures/favorites',
                         'elisa.plugins.favorites.controller:FavoritesController'),
                         ('/poblesec/pictures/favorites/albums',
                         'elisa.plugins.favorites.controller:FavoritesPhotoAlbumsListSwitcher'),
                         ('/poblesec/pictures/favorites/photos',
                         'elisa.plugins.favorites.controller:FavoritesPhotosListSwitcher'),
                         ('/poblesec/videos/favorites',
                         'elisa.plugins.favorites.controller:FavoritesController'),
                         ('/poblesec/videos/favorites/videos',
                         'elisa.plugins.favorites.controller:FavoritesVideosListSwitcher'),],
#    decorator_mappings=[('/poblesec/music/favorites',
#                        'elisa.plugins.favorites.controller:music_internet_decorator'),],
    cmdclass=cmdclass,
)
