# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.media_uri import MediaUri
from elisa.core.utils.i18n import install_translation
from elisa.core.common import application

from elisa.plugins.poblesec.link import Link

from twisted.internet import defer


_ = install_translation('poblesec')


def search_decorator(controller):
    link = Link()
    media_type = 'music'
    link.controller_path = '/poblesec/search/%s' % media_type
    link.controller_args = {'mediatype': media_type}
    link.label = _('Search')
    link.icon = 'elisa.plugins.poblesec.search'
    controller.model.append(link)
    return defer.succeed(None)


def music_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/music_menu"
    link.label = _("Music")
    link.icon = "elisa.plugins.poblesec.music_section"
    controller.model.append(link)
    return defer.succeed(None)


def albums_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/music/albums"
    link.label = _("Albums")
    link.icon = "elisa.plugins.poblesec.album"
    # FIXME: temporarily deactivated
#    controller.model.append(link)
    return defer.succeed(None)


def artists_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/music/artists"
    link.label = _("Artists")
    link.icon = "elisa.plugins.poblesec.artist"
    # FIXME: temporarily deactivated
#    controller.model.append(link)
    return defer.succeed(None)


def filesystem_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/music/directory_list"
    link.label = _("Folders")
    link.icon = "elisa.plugins.poblesec.music_folders"
    link.controller_args = {'media_type': 'music'}
    controller.model.append(link)
    return defer.succeed(None)


def internet_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/music/internet"
    link.label = _("Internet")
    link.icon = "elisa.plugins.poblesec.internet"
    return defer.succeed(None)


def network_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/music/network"
    link.label = _("Home network")
    link.icon = "elisa.plugins.poblesec.network"
    link.controller_args = {'media_type': 'music'}
    return defer.succeed(None)
