# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.text import Text
from elisa.plugins.pigment.graph.image import Image

from elisa.plugins.poblesec.widgets.loadable_mixin import LoadableMixin
from elisa.plugins.poblesec.widgets.button import IconButton

import pgm
import gobject


# we must inherit from LoadableMixin first because of
# http://bugzilla.gnome.org/show_bug.cgi?id=554443
class MenuItemWidget(LoadableMixin, Widget):

    loading_attribute = 'icon'

    def __init__(self):
        super(MenuItemWidget, self).__init__()
        self._create_widgets()
        self._update_style_properties(self._style.get_items())

    def _create_widgets(self):
        label = Text()
        self.label = label
        self.add(label)
        label.weight = pgm.TEXT_WEIGHT_BOLD
        label.ellipsize = pgm.TEXT_ELLIPSIZE_MIDDLE
        label.bg_a = 0

        icon = Image()
        self.icon = icon
        self.add(icon)
        icon.bg_a = 0

        # background drawable taking the full size of the widget; used to
        # catch mouse events
        background = Image()
        self.background = background
        self.add(background)
        background.bg_a = 0
        background.position = (0.0, 0.0, 0.0)
        background.size = (1.0, 1.0)

        label.visible = True
        icon.visible = True
        background.visible = True

    def _update_style_properties(self, props=None):
        super(MenuItemWidget, self)._update_style_properties(props)

        if props is None:
            return

        for key, value in props.iteritems():
            if key == 'font-family':
                self.label.font_family = value
            elif key == 'label-x':
                self.label.x = value
            elif key == 'label-y':
                self.label.y = value
            elif key == 'label-width':
                self.label.width = value
            elif key == 'label-height':
                self.label.height = value
            elif key == 'icon-x':
                self.icon.x = value
            elif key == 'icon-y':
                self.icon.y = value
            elif key == 'icon-width':
                self.icon.width = value
            elif key == 'icon-height':
                self.icon.height = value

    def clean(self):

        self.label.clean()
        self.label = None
        self.icon.clean()
        self.icon = None
        self.background.clean()
        self.background = None

        return super(MenuItemWidget, self).clean()
        

class MenuItemWidgetWithAction(MenuItemWidget):

    __gsignals__ = {
        'action': (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,)),
        }

    def _create_widgets(self):
        super(MenuItemWidgetWithAction, self)._create_widgets()

        self.action_button = IconButton()
        self.action_button.text.weight = pgm.TEXT_WEIGHT_BOLD
        self.action_button.connect('clicked', self._action_clicked)
        self.add(self.action_button, forward_signals=False)
        self.action_button.visible = True

    def _action_clicked(self, *args):
        self.emit('action', None)
        return True

    def _update_style_properties(self, props=None):
        super(MenuItemWidgetWithAction, self)._update_style_properties(props)

        if props is None:
            return

        for key, value in props.iteritems():
            if key == 'action-x':
                self.action_button.x = value
            elif key == 'action-y':
                self.action_button.y = value
            elif key == 'action-width':
                self.action_button.width = value
            elif key == 'action-height':
                self.action_button.height = value

    def clean(self):
        self.action_button.clean()
        self.action_button = None

        return super(MenuItemWidgetWithAction, self).clean()


class DoubleLineMenuItemWidget(MenuItemWidget):

    def _create_widgets(self):
        super(DoubleLineMenuItemWidget, self)._create_widgets()
        sublabel = Text()
        self.sublabel = sublabel
        self.add(sublabel)
        sublabel.weight = pgm.TEXT_WEIGHT_NORMAL
        sublabel.ellipsize = pgm.TEXT_ELLIPSIZE_MIDDLE
        sublabel.bg_a = 0
        sublabel.fg_color = (195, 194, 194, 255)
        sublabel.visible = True


    def _update_style_properties(self, props=None):
        super(DoubleLineMenuItemWidget, self)._update_style_properties(props)

        if props is None:
            return

        for key, value in props.iteritems():
            if key == 'font-family':
                self.label.font_family = value
            elif key == 'label-x':
                self.label.x = value
            elif key == 'label-y':
                self.label.y = value
            elif key == 'label-width':
                self.label.width = value
            elif key == 'label-height':
                self.label.height = value
            elif key == 'sublabel-x':
                self.sublabel.x = value
            elif key == 'sublabel-y':
                self.sublabel.y = value
            elif key == 'sublabel-width':
                self.sublabel.width = value
            elif key == 'sublabel-height':
                self.sublabel.height = value
            elif key == 'icon-x':
                self.icon.x = value
            elif key == 'icon-y':
                self.icon.y = value
            elif key == 'icon-width':
                self.icon.width = value
            elif key == 'icon-height':
                self.icon.height = value

    def clean(self):
        self.sublabel.clean()
        self.sublabel = None

        return super(DoubleLineMenuItemWidget, self).clean()

