# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'

from elisa.core.components.view import View
import pgm
from pgm.timing import implicit
from pgm.graph.group import Group

from elisa.core.utils.classinit import ClassInitMeta
from pgm.utils.classinit import GClassInitMeta

class ViewClassInitMeta(GClassInitMeta,ClassInitMeta):
    pass

class PigmentView(View):
    """
    DOCME
    """

    __metaclass__ = ViewClassInitMeta

    context_path = 'pigment:pigment_context'

    def __init__(self):
        super(PigmentView, self).__init__()
        self.context_handle = Group()
        self.context_handle.visible = True

    def parent__set(self, parent):
        if self.parent != None and self.context_handle != None:
            self.parent.context_handle.remove(self.context_handle)

        super(PigmentView, self).parent__set(parent)

        if parent != None and self.context_handle != None:
            parent.context_handle.add(self.context_handle)

    def frontend_changed(self, previous_frontend, new_frontend):
        if previous_frontend != None:
            previous_frontend.context.canvas_resized.disconnect(self.canvas_resized)

        if new_frontend == None:
            return
 
        self.create_widgets()

        if self.parent == None:
            viewport = new_frontend.context.viewport_handle
            canvas = viewport.get_canvas()
            self.context_handle.canvas = canvas

        # connects to the signals of the new frontend and context
        new_frontend.context.canvas_resized.connect(self.canvas_resized)

    def create_widgets(self):
        """
        DOCME
        """
        pass

    def canvas_resized(self, new_size):
        """
        DOCME
        """
        pass

    def attribute_set(self, origin, key, old_value, new_value):
        super(PigmentView, self).attribute_set(origin, key, old_value, new_value)

        if key == 'fullscreen':
            gtk_window = self.frontend.context.gtk_window
            if gtk_window is None:
                self.frontend.context.viewport_handle.fullscreen = new_value
            else:
                if new_value:
                    gtk_window.fullscreen()
                else:
                    gtk_window.unfullscreen()

    def load_from_theme(self, icon, image):
        """
        Loads an icon from the theme into a Pigment image.

        @param icon:  icon to load
        @type icon:   str
        @param image: drawable into which the icon will be loaded
        @type image:  L{pgm.Image}
        """
        # FIXME: unused masters are never released
        if not self.frontend.context.master_drawables.has_key(icon):
            # create a master drawable
            master = pgm.Image()
            master.visible = False
            image_path = self.frontend.theme.get_media(icon)
            master.set_from_file(image_path)
            canvas = self.frontend.context.viewport_handle.get_canvas()
            canvas.add(pgm.DRAWABLE_FAR, master)

            self.frontend.context.master_drawables[icon] = master
        else:
            # reuse an existent master drawable
            master = self.frontend.context.master_drawables[icon]

        image.set_from_image(master)
