# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Authors: Benjamin Kampmann <benjamin@fluendo.com>
#          Olivier Tilloy <olivier@fluendo.com>
#          Philippe Normand <philippe@fluendo.com>

"""
Common models related to image.
"""

from elisa.core.components.model import Model


class ImageModel(Model):

    """
    Representation of an image.

    An image model contains a list of references to image files that are in
    fact one image in various dimensions.
    This list is ordered by increasing size of image.
    This allows to easily retrieve the largest or the smallest representation
    of an image.

    'A simple example': the image is used as the cover art of an
    L{elisa.plugins.base.models.audio.AlbumModel}. A resource provider fills
    this image model with a thumbnail and a huge high contrast image. Now the
    UI can decide that it does not want to show such a high quality image
    because it is going to be used as an icon in a list. It uses
    C{model.cover.references[0]} (the first one, the smallest image) and the
    amount of data to load is minimal. Later the user decides to play a track
    of the album and the UI wants to show it in fullscreen, it always uses the
    last image in the list because it is the largest one (and very probably the
    one with the best quality for a huge picture):
    C{model.cover.references[-1]}.

    @ivar references: images ordered by increasing size of raw data
    @type references: C{list} of L{elisa.core.media_uri.MediaUri}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(ImageModel, self).__init__()
        self.references = []
