# -*- coding: utf-8 -*-
#
# (c) Copyright 2003-2008 Hewlett-Packard Development Company, L.P.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Author: Don Welch
#

# Local
from g import *
from codes import *
import status, pml
from prnt import pcl, ldl, colorcal


# ********************** Color Cal **********************


def colorCalType1(dev, loadpaper_ui, colorcal_ui, photopenreq_ui): # 450
    value, state = 4, 0
    ok = False
    while state != -1:

        if state == 0:
            if colorCalType1PenCheck(dev):
                state = 1
            else:
                state = 100

        elif state == 1:
            state = -1
            ok = loadpaper_ui()
            if ok:
                colorCalType1Phase1(dev)
                state = 2

        elif state == 2:
            state = -1
            ok, value = colorcal_ui()
            if ok:
                state = 3

        elif state == 3:
            colorCalType1Phase2(dev, value)
            state = -1

        elif state == 100:
            ok = False
            photopenreq_ui()
            state = -1

    return ok


def colorCalType1PenCheck(dev): # 450
    pens = dev.getStatusFromDeviceID()['agents']
    pen_types = [pens[x]['type'] for x in range(len(pens))]

    if AGENT_TYPE_KCM in pen_types:
        return True

    else:
        log.error("Cannot perform color calibration with no photo pen installed.")
        return False


def colorCalType1Phase1(dev): # 450
    dev.closePrint()
    dev.printGzipFile(os.path.join(prop.home_dir, 'data', 'pcl', 'colorcal1_450.pcl.gz'))


def colorCalType1Phase2(dev, value): # 450
    color_cal = {1 : ('\x0f\x3c', '\x17\x0c'),
                  2 : ('\x10\xcc', '\x15\x7c'),
                  3 : ('\x12\x5c', '\x13\xec'),
                  4 : ('\x13\xec', '\x12\x5c'),
                  5 : ('\x15\x7c', '\x10\xcc'),
                  6 : ('\x17\x0c', '\x0f\x3c'),
                  7 : ('\x18\x9c', '\x0d\xac'),
                }

    s = ''.join([pcl.UEL,
                  '@PJL ENTER LANGUAGE=PCL3GUI\n',
                  pcl.RESET,
                  pcl.ESC, '*o5W\x1a\x0c\x00', color_cal[value][0],
                  pcl.ESC, '*o5W\x1a\x0b\x00', color_cal[value][1],
                  pcl.RESET,
                  pcl.UEL])

    dev.printData(s)
    dev.closePrint()

#
# COLOR CAL TYPE 2
#

def colorCalType2(dev, loadpaper_ui, colorcal_ui, photopenreq_ui):
    value, state = 4, 0
    ok = True
    while state != -1:

        if state == 0:
            if colorCalType2PenCheck(dev):
                state = 1
            else:
                state = 100

        elif state == 1:
            state = -1
            ok = loadpaper_ui()
            if ok:
                colorCalType2Phase1(dev)
                state = 2

        elif state == 2:
            state = -1
            ok, value = colorcal_ui()
            if ok:
                state = 3

        elif state == 3:
            colorCalType2Phase2(dev, value)
            state = -1

        elif state == 100:
            photopenreq_ui()
            ok = False
            state = -1

    return ok

def colorCalType2PenCheck(dev):
    pens = dev.getStatusFromDeviceID()['agents']
    pen_types = [pens[x]['type'] for x in range(len(pens))]

    if not AGENT_TYPE_NONE in pen_types:
        return True

    else:
        log.error("Cannot perform color calibration with pens missing.")
        return False

def colorCalType2Phase1(dev):
    dev.writeEmbeddedPML(pml.OID_PRINT_INTERNAL_PAGE,
                         pml.PRINT_INTERNAL_PAGE_COLOR_CAL)

    dev.closePrint()


def colorCalType2Phase2(dev, value):
    c = colorcal.COLOR_CAL_TABLE
    p = ''.join(['\x1b&b19WPML \x04\x00\x06\x01\x04\x01\x05\x01\t\x08\x04',
                   chr(c[value*4]+100), chr(c[value*4+1]+100),
                   chr(c[value*4+2]+100), chr(c[value*4+3]+100),
                   '\x1b%-12345X'])

    dev.printData(p)
    dev.closePrint()


#
# COLOR CAL TYPE 3
#

def colorCalType3(dev, loadpaper_ui, colorcal_ui, photopenreq_ui):
    value, state = 4, 0
    ok = True
    while state != -1:

        if state == 0:
            if colorCalType3PenCheck(dev):
                state = 1
            else:
                state = 100

        elif state == 1:
            state = -1
            ok = loadpaper_ui()
            if ok:
                colorCalType3Phase1(dev)
                state = 2

        elif state == 2:
            state = -1
            ok, valueA = colorcal_ui('A', 21)
            if ok:
                state = 3

        elif state == 3:
            state = -1
            ok, valueB = colorcal_ui('B', 21)
            if ok:
                state = 4

        elif state == 4:
            colorCalType3Phase2(dev, valueA, valueB)
            state = -1

        elif state == 100:
            photopenreq_ui()
            ok = False
            state = -1

    return ok

def colorCalType3PenCheck(dev):
    pens = dev.getStatusFromDeviceID()['agents']
    pen_types = [pens[x]['type'] for x in range(len(pens))]

    if AGENT_TYPE_KCM in pen_types or \
      AGENT_TYPE_BLUE in pen_types:
        return True

    else:
        log.error("Cannot perform color calibration with no photo (or photo blue) pen installed.")
        return False


def colorCalType3Phase1(dev):
    dev.writeEmbeddedPML(pml.OID_PRINT_INTERNAL_PAGE,
                         pml.PRINT_INTERNAL_PAGE_COLOR_CAL)
    dev.closePrint()

def colorCalType3Phase2(dev, A, B):
    photo_adj = colorcal.PHOTO_ALIGN_TABLE[A-1][B-1]
    color_adj = colorcal.COLOR_ALIGN_TABLE[A-1][B-1]
    adj_value = (color_adj << 8L) + photo_adj

    dev.writeEmbeddedPML(pml.OID_COLOR_CALIBRATION_SELECTION, adj_value)
    dev.closePrint()

def colorCalType4(dev, loadpaper_ui, colorcal_ui, wait_ui):
    state = 0
    ok = True

    while state != -1:
        if state == 0:
            state = -1
            ok = loadpaper_ui()
            if ok:
                colorCalType4Phase1(dev)
                state = 2

        elif state == 2:
            state = -1
            #wait_ui(90)
            ok, values = colorcal_ui()
            if ok:
                state = 3

        elif state == 3:
            colorCalType4Phase2(dev, values)
            #wait_ui(5)
            state = 4

        elif state == 4:
            state = -1
            ok = loadpaper_ui()
            if ok:
                colorCalType4Phase3(dev)
                state = -1

    return ok


def colorCalType4Phase1(dev):
    dev.setPML(pml.OID_PRINT_INTERNAL_PAGE,
              pml.PRINT_INTERNAL_PAGE_COLOR_CAL)
              
    dev.closePML()


def colorCalType4AdjValue(value):
    if value >= 100:
        return 200
    return value+100


def colorCalType4Phase2(dev, values):
    if -1 in values:
        Cadj, Madj, Yadj, cadj, madj, kadj = 244, 244, 244, 244, 244, 244
    else:
        sel1, sel2, sel3, sel4 = values
        tmp1 = colorcal.TYPE_4_C_TABLE[sel1][sel2]
        tmp2 = colorcal.TYPE_4_LC_TABLE[sel3][sel4]

        Cadj = colorCalType4AdjValue(tmp1)
        cadj = colorCalType4AdjValue(tmp1+tmp2)

        tmp1 = colorcal.TYPE_4_M_TABLE[sel1][sel2]
        tmp2 = colorcal.TYPE_4_LM_TABLE[sel3][sel4]

        Madj = colorCalType4AdjValue(tmp1)
        madj = colorCalType4AdjValue(tmp1+tmp2)

        Yadj = colorCalType4AdjValue(colorcal.TYPE_4_Y_TABLE[sel1][sel2])
        kadj = colorCalType4AdjValue(0)

    log.debug("C=%d, M=%d, Y=%d, c=%d, m=%d, k=%d\n" % (Cadj, Madj, Yadj, cadj, madj, kadj))

    dev.setPML(pml.OID_COLOR_CALIBRATION_ARRAY_1,
                            kadj)
                            
    dev.setPML(pml.OID_COLOR_CALIBRATION_ARRAY_2,
                            Cadj)
                            
    dev.setPML(pml.OID_COLOR_CALIBRATION_ARRAY_3,
                            Madj)
    
    dev.setPML(pml.OID_COLOR_CALIBRATION_ARRAY_4,
                            Yadj)
                            
    dev.setPML(pml.OID_COLOR_CALIBRATION_ARRAY_5,
                            cadj)
    
    dev.setPML(pml.OID_COLOR_CALIBRATION_ARRAY_6,
                            madj)
                            
    dev.closePML()


def colorCalType4Phase3(dev):
    dev.setPML(pml.OID_PRINT_INTERNAL_PAGE,
                         pml.PRINT_INTERNAL_PAGE_COLOR_PALETTE_CMYK_PAGE)
                         
    dev.closePML()


def colorCalType5(dev, loadpaper_ui):
    if loadpaper_ui():
        dev.printData("""\x1b%-12345X@PJL ENTER LANGUAGE=PCL3GUI\n\x1bE\x1b%Puifp.multi_button_push 20;\nudw.quit;\x1b*rC\x1bE\x1b%-12345X""")
        dev.closePrint()

        
def colorCalType6(dev, loadpaper_ui):
    if loadpaper_ui():
        dev.setPML(pml.OID_PRINT_INTERNAL_PAGE, pml.PRINT_INTERNAL_PAGE_COLOR_CAL)
        dev.closePML()
        
def colorCalType7(dev, loadpaper_ui):
    if loadpaper_ui():
        dev.setPML(pml.OID_PRINT_INTERNAL_PAGE, pml.PRINT_INTERNAL_PAGE_AUTOMATIC_COLOR_CALIBRATION)
        dev.closePML()
