# -*- coding: utf-8 -*-
#
# (c) Copyright 2001-2006 Hewlett-Packard Development Company, L.P.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Authors: Don Welch
#

from base.g import *
from qt import *
from cvscommitform_base import cvscommitform_base
import os, os.path, sys
import commands
from base import utils, pexpect


def run(cmd, callback=None, passwd='', timeout=1.0):
    try:
        child = pexpect.spawn(cmd, timeout=timeout)
    except pexpect.ExceptionPexpect:
        return 1

    try:
        while True:
            update_spinner()
            i = child.expect(["[pP]assword:", pexpect.EOF, pexpect.TIMEOUT])

            if child.before and callback is not None:
                if callback(child.before): # cancel
                    break

            if i == 0: # Password:
                child.sendline(passwd)

            elif i == 1: # EOF
                break

            elif i == 2: # TIMEOUT
                continue

    except Exception:
        pass

    cleanup_spinner()
    child.close()

    return child.exitstatus

class CheckItem(QCheckListItem):
    def __init__(self, parent, s, typ):
        QCheckListItem.__init__(self, parent, s, QCheckListItem.CheckBox)
        self.typ = typ


class cvscommitform(cvscommitform_base):
    def __init__(self,parent = None,name = None,modal = 0,fl = 0):
        cvscommitform_base.__init__(self,parent,name,modal,fl)
        self.output = ''
        self.ouputwidget.setReadOnly(True)
        self.ouputwidget.setTextFormat(Qt.PlainText)
        self.updating = False
        self.kompare_on_diff = True
        
        try:
            self.comments.setText(file('comments', 'r').read())
        except:
            pass
        
        QTimer.singleShot(0, self.initialupdate)

    def heading(self, t):
        t = '| ' + t + ' |'
        print
        print log.bold('-' * len(t))
        print log.bold(t)
        print log.bold('-' * len(t))
        print
        
    
    def display(self, thelist, heading, highlight = log.bold, get_stat=False, show_diff=False):
        if len(thelist) > 0:
            self.heading(heading)
            for f in thelist:
                print highlight(f.strip())
        
        
    def initialupdate(self):
        self.runupdate()
        
    def callback(self, t):
        t = t.replace('\r', '')
        
        if not t.startswith('?'):
            print t
            self.ouputwidget.append(t)
            self.output = ''.join([self.output, t])
            self.ouputwidget.scrollToBottom()
        
        qApp.processEvents()
        
        
    def runupdate(self):
        self.updating = True
        self.filelist.clear()
        status = self.run("cvs -z3 update -d -P")
        lines = self.output.splitlines()
        
        unknown = []
        modified = []
        patched = []
        conflicted = []
        updated = []
        errors = []
        leftover = []
        added = []
        removed = []
        
        for x in lines:
            #print x
            #update_spinner()
            try:
                remainder = x.split(' ', 1)[1]
            except IndexError:
                remainder = x
                
            if x.startswith('?') or x.startswith('cvs server:') or x.startswith("RCS"):
                unknown.append(remainder)
            
            elif x.startswith('M') and not x.endswith('.e3p'):
                modified.append(remainder)
            
            elif x.startswith('A'):
                added.append(remainder)
            
            elif x.startswith('U'):
                updated.append(remainder)
            
            elif x.startswith('R'):
                removed.append(remainder)
            
            elif x.startswith('C'):
                conflicted.append(remainder)
            
            elif x.startswith('P'):
                patched.append(remainder)
            
            elif x.startswith('cvs server:'):
                errors.append(remainder)
            
            else:
                leftover.append(x)
            
        if updated + patched:
            i = QListViewItem(self.filelist, "Updated or patched:")
            
            for x in updated + patched:
                QListViewItem(i, x)
                
            self.filelist.setOpen(i, True)
            
        
        if modified:
            i = QListViewItem(self.filelist, "Modified (need commit):")
            
            for x in modified:
                j = CheckItem(i, x, "M")
                j.setOn(True)
                
            self.filelist.setOpen(i, True)
            
        if removed:
            i = QListViewItem(self.filelist, "Removed (need commit):")
            
            for x in removed:
                j = CheckItem(i, x, "R")
                j.setOn(True)
                
            self.filelist.setOpen(i, True)
            
        if added:
            i = QListViewItem(self.filelist, "Added (need commit):")
            
            for x in added:
                j = CheckItem(i, x, "A")
                j.setOn(True)
                
            self.filelist.setOpen(i, True)
            
        if conflicted:
            i = QListViewItem(self.filelist, "Conflicted (need edit and commit):")
            
            for x in conflicted:
                QListViewItem(i, x)
                
            self.filelist.setOpen(i, True)
            
            
        self.display(modified, "LOCALLY MODIFIED FILES", utils.blue, False, False)
        self.display(patched + updated, "UPDATED AND/OR PATCHED FILES", utils.purple, False, True)
        self.display(conflicted, "CONFLICTED FILES", utils.red, True)
        self.display(added, "LOCALLY ADDED FILES (NEED COMMIT)", utils.darkgreen)
        self.display(removed, "LOCALLY REMOVED FILES (NEED COMMIT)", utils.red)
        
        if modified or added or removed:
            self.display(["cvs -z3 commit -m*** " + " ".join(modified+added+removed)], "CVS COMMIT COMMAND")
            
        self.updating = False
            
    
    def refreshlist_clicked(self):
        self.runupdate()

    def commitchecked_clicked(self):
        commits = []
        
        item = self.filelist.firstChild()
        while item is not None:
            child = item.firstChild()
            while child is not None:
                try:
                    typ = child.typ
                except:
                    pass
                else:
                    if child.isOn():
                        commits.append(str(child.text()))
                
                child = child.nextSibling()
            item = item.nextSibling()
            
        comments = str(self.comments.text())
        
        if commits:
            if comments:
                cmd = """cvs -z3 commit -m"%s" %s""" % (comments,  " ".join(commits))
            else:
                cmd = """cvs -z3 commit -m*** %s""" % " ".join(commits)
            
            self.display([cmd], "CVS COMMIT COMMAND")
            self.run(cmd)
            
        try:
            file('comments', 'w').write(comments)
        except:
            pass
            
        self.runupdate()
        
    def filelist_currentChanged(self, item):
        if not self.updating:
            try:
                typ = item.typ
            except:
                # updated or patched 
                name = str(item.text(0))
                #self.heading("STAT: %s" % name)
                self.run("""cvs stat %s""" % name)
                #print self.output
                
                if self.kompare_on_diff:
                    os.system("cvs diff %s | kompare -o -" % name)
                
                return
                
            # modified, removed, or added
            if typ == 'M':
                name = str(item.text())
                #self.heading("DIFF: %s" % name)
                self.run("""cvs diff -b -B -u %s""" % name)
                #print self.output
                
                if self.kompare_on_diff:
                    os.system("cvs diff %s | kompare -o -" % name)
                
                

    def run(self, cmd):
        QApplication.setOverrideCursor(QApplication.waitCursor)
        self.heading(cmd)
        self.ouputwidget.append("\n" + cmd + "\n")
        #self.ouputwidget.setText(cmd + "\n")
        self.output = ''
        status = run(cmd, self.callback)
        
        #if status == 0:
        #    self.ouputwidget.setCursorPosition(0, 0)
        #    self.ouputwidget.ensureCursorVisible()
        self.ouputwidget.scrollToBottom()
        #self.ouputwidget.setCursorPosition(self.ouputwidget.paragraphs(), 1)
        #self.ouputwidget.ensureCursorVisible()
            
        QApplication.restoreOverrideCursor()
        
        return status
        
    def kompare_toggled(self,a0):
        self.kompare_on_diff = bool(a0)
        
    
    def __tr(self,s,c = None):
        return qApp.translate("cvscommitform_base",s,c)
