# -*- coding: utf-8 -*-
#
# (c) Copyright 2003-2007 Hewlett-Packard Development Company, L.P.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#
# Author: Don Welch
#

# StdLib
import sys
import pprint
import os, os.path
import cStringIO
import tempfile
import time, socket
import re, pwd
import pprint
import urllib2
import urllib
import socket

# Local
from base.g import *
from base.codes import *
from base import utils, device, models, demjson
#from ui_utils import load_pixmap

# Qt
from qt import *
from qttable import QTable
from modeleditorform2_base import modeleditorform2_base
from choosedevicedlg import ChooseDeviceDlg

try:
    import datetime
except ImportError:
    log.error("Model editor requires Python 2.3+")
    sys.exit(1)


MAX_UI_DATE = QDate(8000, 12, 31)
MAX_DATE = datetime.date(8000, 12, 31)

socket.setdefaulttimeout(5)

preamble = """# (c) Copyright 2003-2008 Hewlett-Packard Development Company, L.P.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#
# NOTICE:
#
# This file automatically generated by model_editor_dat.py.
# Please do not hand edit this file.
#
# Last written on %s by %s
# using model_editor_dat version %s."""


epilogue = """
# align-type:
# 0 = Not needed
# 1 = Auto
# 2 = 8xx
# 3 = 9xx
# 4 = LIDIL 0.3.8
# 5 = LIDIL 0.4.3
# 6 = LIDIL AiO
# 7 = LIDIL VIP
# 8 = deskjet 450
# 9 = 9XX without edge aligment
# 10 = PS7850, DJ5440, etc.
# 11 = LIDIL 0.5.4
# 12 = OJ Pro L7xxx
# 13 = AiO Non-LIDIL (Yellowtail, OJ 4500/4600)
#
# clean-type:
# 0 = Not needed
# 1 = PCL
# 2 = LIDIL
# 3 = PCL with Printout
#
# color-cal-type:
# 0 = Not needed
# 1 = Deskjet 450
# 2 = BIJ 1xxx (81 patches)
# 3 = PS 8750, DJ 6540, DJ 57xx, DJ 5850 (2 bars of 21 patches)
# 4 = PS 8250, PS3310AiO
# 5 = OJ K550
# 6 = OJ Pro L7XXX
# 7 = PS Pro B8800
#
# copy-types:
# -1 = Not supported
# 0 = Not present
# 1 = Device (LaserJet MFP PML)
# 2 = Scan to Print (Not used)
# 3 = Device (Inkjet AiO PML)
#
# embedded-server-type:
# 0 = None (not present)
# 1 = HTTP Server Present (accessable via bus=net only)
#
# fax-type:
# -1 = Not supported
# 0 = Not present
# 1 = B&W fax send (early channel open)
# 2 = B&W fax send (late channel open)
# 3 = Color fax send (future)
# 4 = SOAP fax send (LJ M2727)
#
# fw-download:
# 0 = None
# 1 = Required
#
# icon:
# name of icon in data/images
#
# io-mode:
# 0 = uni
# 1 = raw
# 2 = DEPRECATED in 2.7.5
# 3 = 1284.4 (std)
# 4 = 1284.4 (alt 1)
# 5 = 1284.4 "bridge" (alt 2)
# 6 = MLC gusher
# 7 = MLC miser
#
# io-mfp-mode:
# 0 = not used
# 1 = not used
# 2 = DEPRECATED in 2.7.5
# 3 = 1284.4 (std)
# 4 = 1284.4 (alt 1)
# 5 = 1284.4 "bridge" (alt 2)
# 6 = MLC gusher
# 7 = MLC miser
#
# io-support: (bitfield)
# 1 = parallel
# 2 = usb
# 4 = ethernet
# 8 = wireless 802.11
# 16 = bluetooth
#
# job-storage:
# 0 = Disable
# 1 = Enable
#
# linefeed-cal-type:
# 0 = None
# 1 = OJ K550
# 2 = OJ Pro L7XXX
#
# model(1-x):
# friendly model names 1-x
#
# monitor-type:
# 0 = None/disable
# 1 = Enable (TBD)
#
# panel-check-type:
# 0 = None
# 1 = Perform panel check
#
# pcard-types:
# 0 = None
# 1 = mlc
# 2 = usb mass storage
#
# plugin:
# 0 = None
# 1 = Required
# 2 = Optional
#
# plugin-reason (bitfield)
# 0 = None
# >0 - see base/codes.py for list of values
#
# power-settings:
# 0 - None
# 1 - EPML (DJ450/460)
# 2 - PML (OJ H470)
#
# pq-diag-type:
# 0 = None
# 1 = OJ K550
# 2 = OJ Pro L7XXX
#
# r-type:
# regional supplies flag
#
# Supply info (x=region, y=supply index (1 based):
# rx-agenty-kind
# rx-agenty-type
# rx-agenty-sku
#
# agent-kind:
# 0 = None
# 1 = Inkjet Head (sep. head like on BIJ 1100, cp1160, etc.)
# 2 = Inkjet Supply (sep. supply like on BIJ 1100, cp1160, etc.)
# 3 = Inkjet Head+Supply (standard inkjet cartridge)
# 4 = LaserJet Toner Cart.
# 5 = LaserJet Fuser (Maint. Kit)
# 6 = LaserJet ADF Kit
# 7 = LaserJet Drum Kit
# 8 = LaserJet Transfer Kit
# 9 = Battery
#
# agent-type:
# 0 = None
# 1 = Black
# 2 = CMY (Tricolor)
# 3 = KCM (Photo)
# 4 = Cyan
# 5 = Magenta
# 6 = Yellow
# 7 = Cyan Low
# 8 = Magenta Low
# 9 = Yellow Low
# 10 = GGK
# 11 = Blue
# 12 = ???
# 13 = Light magenta and light cyan
# 14 = Black and yellow
# 15 = Magenta and cyan
# 16 = Light grey and photo black
# 17 = Light grey
# 18 = Medium grey
# 19 = Photo grey
# 62 = Unspecified
#
# scan-style:
# 0 = None (or unknown)
# 1 = Flatbed
# 2 = Scrollfed (does not support fit to page for copy)
#
# scan-type:
# -1 = Not supported
# 0 = Not present
# 1 = SCL
# 2 = PML
# 3 = SOAP (cm1017mfp)
# 4 = Marvel (m1005)
# 5 = SOAP2 (m2727)
#
# status-battery-check:
# 0 = Not avail. (do not check battery)
# 1 = Std. battery check PML/Dyn Ctrs (Deskjet 450/460)
# 2 = PML only battery check (OJ H470)
#
# status-dynamic-counters:
# 0 = None
# 1 = PCL (embedded PML)
# 2 = PML/SNMP
# 3 = LIDIL 0.5.4 (Deskjet D4100)
#
# status-type:
# 0 = Not avail. (do not perform status)
# 1 = Deskjet VSTATUS field
# 2 = Deskjet standard S/Z fields
# 3 = PML (LaserJet)
# 4 = (DEPRECATED)
# 5 = (DEPRECATED)
# 6 = XML (LaserJet)
# 7 = (DEPRECATED)
# 8 = PJL (LaserJet)
# 9 = PJL (hp:) + PML (toolbox) (LaserJet)
#
#
# support-released:
# 0 = No released
# 1 = Released
#
# support-type:
# 0 = Not supported
# 1 = Supported by HPIJS only (print only)
# 2 = Supported by HPLIP
#
# support-ver:
# Min. HPLIP version for support
#
# tech-class: [list]
# APDK printer class(es)
#
# tech-subclass: [list]
# HPLIP printer subclass(es)
#
# tech-types:
# 0 = None (Unknown)
# 1 = Mono Inkjet
# 2 = Color Inkjet
# 3 = Mono Laser
# 4 = Color Laser
#
# usb-pid:
# 4 digit hex value, left zero padded
#
# usb-vid:
# 4 digit hex value.
#
"""


class modeleditorform2(modeleditorform2_base):
    def __init__(self, version, home_dir, icons, parent=None, name=None, fl=0):
        modeleditorform2_base.__init__(self,parent,name,fl)
        self.using_default_icon = False
        self.lookup_icons = icons
        self.version = version
        self.versions = []
        self.filter = ''
        self.change_log = []
        self.updating = False
        self.current_model = ''
        self.pic_cache = {}

        self.saveGooglePushButton.setEnabled(icons)
        self.nextGooglePushButton.setEnabled(icons)
        self.prevGooglePushButton.setEnabled(icons)

        self.setCaption("Model DAT Editor v%s" % self.version)

        if home_dir is None:
            cur_dir = os.path.realpath(os.path.normpath(os.getcwd()))
        else:
            cur_dir = home_dir

        log.info("Home Directory: %s" % cur_dir)

        self.models_dir = os.path.join(cur_dir, "data", "models")
        self.released_dir = os.path.join(cur_dir, "data", "models")
        self.unreleased_dir = os.path.join(cur_dir, "data", "models", "unreleased")
        self.images_dir = os.path.join(cur_dir, 'data', 'images')
        self.ppd_ps_dir = os.path.join(cur_dir, 'prnt', 'ps')
        self.ppd_drv_dir = os.path.join(cur_dir, 'ppd')
        self.ppd_plugin_dir = os.path.join(cur_dir, 'prnt', 'plugins')
        #self.plugin_spec = os.path.join(cur_dir, 'plugin.spec')


        plugin_spec = Config(os.path.join(cur_dir, 'plugin.spec'), True)
        self.plugin_products = plugin_spec['products'].keys()

        #print self.plugin_products
        #sys.exit(1)

        if self.unreleased_dir.startswith("/usr"):
            QMessageBox.critical(self,
             self.caption(),
             "<b>Error: The .dat file you are attempting to edit is located under /usr.</b><p>This is probably not the file you want to edit. Open the file from your CVS sandbox instead (set home= to your sandbox /src directory in /etc/hp/hplip.conf).",
              QMessageBox.Ok,
              QMessageBox.NoButton,
              QMessageBox.NoButton)

        self.released_dat = os.path.join(self.released_dir, "models.dat")
        self.unreleased_dat = os.path.join(self.unreleased_dir, "unreleased.dat")

        if not os.path.exists(self.released_dat):
            log.error("Could not find release file: %s" % self.released_dat)
            sys.exit(1)

        if not os.path.exists(self.unreleased_dat):
            log.error("Could not find release file: %s" % self.unreleased_dat)
            sys.exit(1)

        #log.info("Using files:")
        log.info("Released File: %s" % self.released_dat)
        log.info("Unreleased File: %s" % self.unreleased_dat)

        self.released_data_changed = False
        self.unreleased_data_changed = False

        self.default_pics = \
        {
         'deskjet'    : 'default_deskjet.png',
         'business'   : 'default_business_inkjet.png',
         'psc'        : 'default_psc.png',
         'laserjet'   : 'default_laserjet.png',
         'officejet'  : 'default_officejet.png',
         'photosmart' : 'default_photosmart.png',
         'default'    : 'default_printer.png',
        }

        self.agent_kinds = \
        {0: "None",
          1: "InkJet Head",
          2: "InkJet Supply",
          3: "InkJet Head+Supply (Cart.)",
          4: "LaserJet Toner Cart.",
          5: "LaserJet Fuser/Maint. Kit",
          6: "LaserJet ADF Kit",
          7: "LaserJet Drum Kit",
          8: "LaserJet Transfer Kit",
          9: "Internal Battery",
        }

        self.agent_types = \
        {0: "None",
          1: "Black",
          2: "CMY (Tri-color)",
          3: "KCM (Photo)",
          4: "Cyan",
          5: "Magenta",
          6: "Yellow",
          7: "Photo Cyan",
          8: "Photo Magenta",
          9: "Photo Yellow",
          10: "GgK (2 Grey + Black)",
          11: "Blue",
          12: "???",
          13: "Light Magenta and Light Cyan",
          14: "Yellow and Magenta",
          15: "Cyan and Black",
          16: "Light Grey (g/LG) and Photo Black (PK)",
          17: "Light Grey (g/LG)",
          18: "Medium Grey (G/MK)",
          19: "Photo Grey (PK)",
          20: "Cyan and Magenta", # OJ Pro
          21: "Black and Yellow", # OJ Pro
          62: "Unspecified", # Use with kind = 5-9
        }

        self.warning_pix =self.load_pixmap('warning', '32x32')
        self.error_pix = self.load_pixmap('error', '32x32')
        self.ok_pix = self.load_pixmap('ok', '32x32')
        self.lowink_pix = self.load_pixmap('inkdrop', '32x32')
        self.lowtoner_pix = self.load_pixmap('toner', '32x32')
        self.busy_pix = self.load_pixmap('busy', '32x32')
        self.lowpaper_pix = self.load_pixmap('paper', '32x32')

        self.index = 0
        self.rgn = 0

        self.agent_table.setColumnWidth(0, 50)
        self.agent_table.setColumnWidth(1, 200)
        self.agent_table.setColumnWidth(2, 250)
        self.agent_table.setColumnWidth(3, 200)

        self.splitter3.setSizes([500,500])

#        self.eol_date.setOrder(QDateEdit.DMY)
#        self.eol_date.setMaxValue(MAX_UI_DATE)
#        self.obsolescence_date.setOrder(QDateEdit.DMY)
#        self.obsolescence_date.setMaxValue(MAX_UI_DATE)

        self.loadModels()
        self.loadVersions()
        self.loadPPDs()
        self.loadModelListbox()


    def load_pixmap(self, name, subdir=None, resize_to=None):
        name = ''.join([os.path.splitext(name)[0], '.png'])

        if subdir is None:
            dir = self.images_dir
        else:
            dir = os.path.join(self.images_dir, subdir)

        log.debug("Loading pixmap '%s' from %s" % (name, dir))

        f = os.path.join(dir, name)
        if os.path.exists(f):
            if resize_to is not None:
                img = QImage(f)
                pm = QPixmap()
                pm.convertFromImage(img.smoothScale(*resize_to), 0)
                return pm
            else:
                return QPixmap(f)

        for w in utils.walkFiles(dir, recurse=True, abs_paths=True, return_folders=False, pattern=name):
            if resize_to is not None:
                img = QImage(w)
                pm = QPixmap()
                pm.convertFromImage(img.smoothScale(*resize_to), 0)
                return pm
            else:
                return QPixmap(w)

        log.error("Pixmap '%s' not found!" % name)
        return None

    #
    # GET/SET MODEL DATA
    #

    def data(self, key, default=None):
        try:
            return self.current_model_data[key]
        except KeyError:
            if default is not None:
                return default
            else:
                typ = self.m.get_data_type(key)

                if typ in (models.TYPE_INT, models.TYPE_BITFIELD):
                    return 0

                elif typ == models.TYPE_BOOL:
                    return False

                elif typ == models.TYPE_LIST:
                    return []

                else:
                    return ''


    def setData(self, key, data, add_to_change_log=True):
        #data = str(data)
        log.debug("%s: %s = '%s'" % (self.current_model, key, data))

        typ = self.m.get_data_type(key)

        if typ == models.TYPE_BOOL:
            data = int(data)

        elif typ in (models.TYPE_BITFIELD, models.TYPE_INT):
            data = int(data)

        elif typ == models.TYPE_LIST:
            data = list(data)

        elif typ == models.TYPE_DATE:
            data = data # QDate

        else:
            data = str(data)

        try:
            old_value = self.current_model_data[key]
        except KeyError:
            old_value = '(key not found)'

        self.current_model_data[key] = data

        if not self.updating and old_value != data:
            if add_to_change_log:
                self.change_log.append("%s: Changed %s from '%s' to '%s'" % (self.current_model, key, old_value, data))

            if self.data('support-released') == 1:
                self.released_data_changed = True
            else:
                self.unreleased_data_changed = True

            if key == 'support-released':
                self.released_data_changed = self.unreleased_data_changed = True

        self.updateDynamicTabs()


    #
    # MODEL ICONVIEW
    #

    def loadModelListbox(self):
        self.iconView.clear()

        k = self.models.keys()
        k.sort()

        error = False

        filters = {}
        if self.filter:
            try:
                for f in self.filter.split(','):
                    key, value = f.split('=')
                    filters[key] = value

            except ValueError:
                error = True

        j = None
        first = True
        device_count = 0

        self.print_heading("DISPLAYED MODEL LIST")

        for x in k:

            if not error:
                include = True
                for f in filters:
                    try:
                        filter_pat = re.compile(filters[f], re.IGNORECASE)
                        if filter_pat.search(str(self.models[x][f]).lower()) is None:
                            include = False
                            break
                    except KeyError:
                        include = False
                        error = True
                        break

                if not include:
                    continue

            device_count += 1

            print x

            filename = self.models[x]['icon']
            pixmap = self.load_pixmap(filename, 'devices')
            if pixmap:
            #if os.path.exists(f):
                i = QIconViewItem(self.iconView, x, pixmap)
                if first:
                    j = i
                    first = False
            else:
                i = QIconViewItem(self.iconView, x)
                if first:
                    j = i
                    first = False

        #if not self.current_model and j is not None:
        if j is not None:
            self.iconView.setSelected(j, True)
            self.iconView.setCurrentItem(j)

        if error:
            self.FailureUI("<b>Invalid filter!</b><p>%s" % self.filter)

        print
        print "Filter: %s" % (self.filter or '(none)')
        print "Num. Models: %d" % device_count

        #if self.current_model:
        #    self.ActivateModel(self.current_model)


    def loadModels(self):
        self.m = models.ModelData(self.models_dir)
        self.m.read_all_files()
        self.models = self.m.all_models()

        # template for adding new data fields to files
        #for m in self.models:
        #    del self.models[m]['plugin-library'] # = 0

        for m in self.models:
            if not self.models[m]['usb-vid'] or self.models[m]['usb-vid'] == '0000':
                self.models[m]['usb-vid'] = '03f0'

            #self.models[m]['plugin-reason'] = PLUGIN_REASON_NONE
            #self.models[m]['monitor-type'] = 0
            #self.models[m]['support-eol-date'] = MAX_DATE
            #del self.models[m]['support-eol-date']

        #self.released_data_changed = True
        #self.unreleased_data_changed = True

        #print self.models


    def loadPPDs(self):
        self.ppds = []
        paths = [self.ppd_ps_dir,
                 self.ppd_drv_dir,
                 self.ppd_plugin_dir]

        for p in paths:
            print "Loading PPDs from %s..." % p
            for w in utils.walkFiles(p, recurse=True, abs_paths=True, return_folders=False, pattern='*.ppd*'):
                if '.svn' not in w:
                    self.ppds.append(w)

        print "Loaded %d ppds" % len(self.ppds)


    def iconView_selectionChanged(self, a0):
        self.current_model = str(a0.text())
        self.current_model_data = self.models[self.current_model]

        print self.current_model
        #pprint.pprint(self.current_model_data)

        self.updating = True
        warnings = self.updateTabs()

        if warnings > 0:
            self.setCaption("Model DAT Editor v%s - %s !!! THERE ARE WARNINGS FOR THIS DEVICE !!!" % (self.version,
                                                             self.current_model))
        else:
            self.setCaption("Model DAT Editor v%s - %s" % (self.version,
                                                             self.current_model))


        self.updating = False


    def ActivateModel(self, model):
        print "activate: %s" % model
        i = self.iconView.findItem(model, Qt.ExactMatch)

        if i is not None:
            self.iconView.setCurrentItem(i)
            self.iconView.setSelected(i, True)
            self.iconView.ensureItemVisible(i)



    def findModelPushButton_clicked(self):
        term, ok = QInputDialog.getText("Find Model", "Search Term:", QLineEdit.Normal, '', self)

        if ok:
            term = str(term)

            if len(term):
                try:
                    term_pat = re.compile(term, re.IGNORECASE)
                except:
                    log.error("Invalid search term RE")
                    return

                matches = []
                for m in self.models:
                    match = term_pat.search(m)

                    if match is not None:
                        matches.append(m)

                if len(matches) == 0:
                    log.error("Not found.")
                    self.FailureUI("<b>No matching model found.</b>")

                elif len(matches) == 1:
                    self.ActivateModel(matches[0])

                else:
                    l = QStringList()

                    for m in matches:
                        l.append(m)

                    choice, ok = QInputDialog.getItem("%d Matching Models Found" % len(matches), "Choose Model:", l)

                    if ok:
                        choice = str(choice)
                        self.ActivateModel(choice)

    #
    # TAB UPDATING
    #

    def updateTabs(self):
        self.updateSupportTab()
        self.updateIOModeTab()
        self.updateFuncTab()
        self.updateAlignCleanTab()
        self.updateMQDataTab()
        self.updateStatusTab()
        self.updateAgentsTab()
        self.updateTechTab()
        self.updateMiscTab()
        self.updatePluginTab()
        self.updateIconTab()

        return self.updateWarningsTab()


    def updateDynamicTabs(self):
        self.updateMQDataTab()
        self.updateChangeLogTab()
        return self.updateWarningsTab()

    #
    # SUPPORT TAB
    #

    def updateSupportTab(self):
        support_type = self.data('support-type', 2)
        self.support_type.setButton(support_type)

        self.supportedModelsListBox.clear()

        num_models, a = 0, 1

        while True:
            m = self.data('model%d' % a, -1)
            if m == -1:
                break
            num_models += 1
            a += 1

        if num_models:
            a = 1
            while True:
                m = self.data('model%d' % a, -1)
                if m == -1:
                    break

                self.supportedModelsListBox.insertItem(m)
                a += 1

        self.deleteSupportedModelPushButton.setEnabled(num_models)
        self.addSupportedModelPushButton.setEnabled(False)

        released = self.data('support-released')
        self.support_released.setButton(released)

        support_version = self.data('support-ver')
        self.versionComboBox.setCurrentText(support_version)

#        self.eol_update = 0
#        t = self.data('support-eol-date') # datetime.date
#        support_eol_date = QDate(t.year, t.month, t.day) # datetime.date -> QDate
#        self.obsolescence_date.setDate(support_eol_date.addYears(-5))
#        self.eol_date.setDate(support_eol_date)



    def obsolescence_date_valueChanged(self, d):
        self.eol_update += 1
        if self.eol_update < 2:
            self.eol_date.setDate(d.addYears(5))
        else:
            self.eol_update = 0

        t = d.addYears(5)
        x = datetime.date(t.year(), t.month(), t.day())
        self.setData('support-eol-date', x)


    def eol_date_valueChanged(self, d):
        self.eol_update += 1
        if self.eol_update < 2:
            self.obsolescence_date.setDate(d.addYears(-5))
        else:
            self.eol_update = 0

        x = datetime.date(d.year(), d.month(), d.day())
        self.setData('support-eol-date', x)


    def obsolescence_date_today_clicked(self):
        self.obsolescence_date.setDate(QDate.currentDate())


    def eol_date_today_clicked(self):
        self.eol_date.setDate(QDate.currentDate())


    def loadVersions(self):
        self.versions = []
        for m in self.models:
            if self.models[m]['support-ver'] not in self.versions:
                self.versions.append(self.models[m]['support-ver'])

        self.versions.sort()
        self.updateVersions()

    def updateVersions(self):
        self.versionComboBox.clear()
        for v in self.versions:
            self.versionComboBox.insertItem(v)

    def support_released_clicked(self,a0):
        self.setData('support-released', a0)

    def versionComboBox_activated(self, a0):
        self.setData('support-ver', str(a0))

    def newVersionPushButton_clicked(self):
        version, ok = QInputDialog.getText("New Version", "Version (major.year.month):", QLineEdit.Normal, '', self)

        if ok:
            print "OK"
            version = str(version)

            if version in self.versions:
                log.error("Duplicate version!")
                return

            self.versions.append(version)
            self.setData('support-ver', version)
            self.updateVersions()
            self.updateSupportTab()



    def deleteSupportedModelPushButton_clicked(self):
        m1 = str(self.supportedModelsListBox.currentText())

        if m1:
            models = []
            a = 1

            while True:
                m2 = self.data('model%d' % a, -1)
                if m2 == -1:
                    break

                if m2 != m1:
                    models.append(m2)

                a += 1

            a = 1
            for m in models:
                self.setData('model%d' % a, m)
                a += 1

            try:
                del self.current_model_data['model%d' % a]
            except KeyError:
                pass

            self.updateSupportTab()


    def addSupportedModelPushButton_clicked(self):
        model = str(self.supportedModelLineEdit.text())
        num_models, a = 0, 1

        while True:
            m = self.data('model%d' % a, -1)
            if m == -1:
                break
            num_models += 1
            a += 1

        index = num_models+1

        self.setData('model%d' % index, model)

        self.updateSupportTab()


    def supportedModelLineEdit_textChanged(self,a0):
        self.addSupportedModelPushButton.setEnabled(len(str(a0)))

    def support_type_clicked(self,a0):
        self.setData('support-type', a0)



    #
    # I/O TAB
    #

    def updateIOModeTab(self):
        io_mode = self.data('io-mode')
        self.io_mode.setButton(io_mode)

        io_mfp_mode = self.data('io-mfp-mode', 2)
        self.io_mfp_mode.setButton(io_mfp_mode)

        io_support = self.data('io-support')

        self.io_support_parallel.setChecked(io_support & 0x1 == 0x1)
        self.io_support_usb.setChecked(io_support & 0x2 == 0x2)
        self.io_support_ethernet.setChecked(io_support & 0x4 == 0x4)
        self.io_support_wireless.setChecked(io_support & 0x8 == 0x8)
        self.io_support_bluetooth.setChecked(io_support & 0x10 == 0x10)

        self.usb_pid.setText(str(self.data('usb-pid')))
        self.usb_vid.setText(str(self.data('usb-vid')))

    def io_mode_clicked(self,a0):
        self.setData('io-mode', a0)

    def io_mfp_mode_clicked(self,a0):
        self.setData('io-mfp-mode', a0)

    def io_support_parallel_toggled(self,a0):
        self.updateIOSupport()

    def io_support_usb_toggled(self,a0):
        self.updateIOSupport()

    def io_support_ethernet_toggled(self,a0):
        self.updateIOSupport()

    def io_support_wireless_toggled(self,a0):
        self.updateIOSupport()

    def io_support_bluetooth_toggled(self,a0):
        self.updateIOSupport()

    def updateIOSupport(self):
        io_support = self.io_support_parallel.isChecked() + \
                     self.io_support_usb.isChecked() * 2 + \
                     self.io_support_ethernet.isChecked() * 4 + \
                     self.io_support_wireless.isChecked() * 8 + \
                     self.io_support_bluetooth.isChecked() * 16

        self.setData('io-support', io_support)

    def usb_pid_textChanged(self,a0):
        value = str(a0).lower()

        if len(value) == 4:
            try:
                int(value, 16)
            except ValueError:
                value = '0000'
                self.usb_pid.setText(value)

        self.setData('usb-pid', value.rjust(4, '0'))

    def usb_vid_textChanged(self,a0):
        value = str(a0).lower()

        if len(value) == 4:
            try:
                int(value, 16)
            except ValueError:
                value = '03f0'
                self.usb_vid.setText(value)

        self.setData('usb-vid', value.rjust(4, '0'))



    #
    # TECH TAB
    #

    def updateTechTab(self):
        tech_type = self.data('tech-type')
        self.tech_type.setButton(tech_type)

        tech_class = self.data('tech-class')

        self.apdkListBox.clear()
        for tc in models.TECH_CLASSES:
            if tc not in tech_class:
                self.apdkListBox.insertItem(QString(tc))

        self.apdkListBox.sort()

        self.tech_class.clear()
        for tc in tech_class:
            self.tech_class.insertItem(QString(tc))

        self.tech_class.sort()

        self.updateAddButton()
        self.updateRemoveButton()

        # **********
        tech_subclass = self.data('tech-subclass')

        self.hplipListBox.clear()
        for tc in models.TECH_SUBCLASSES:
            if tc not in tech_subclass:
                self.hplipListBox.insertItem(QString(tc))

        self.hplipListBox.sort()

        self.tech_subclass.clear()
        for tc in tech_subclass:
            self.tech_subclass.insertItem(QString(tc))

        self.tech_subclass.sort()


    def anySelection(self, box):
        x = 0
        i = box.item(x)
        while i:
            if i.isSelected():
                return True

            x += 1
            i = box.item(x)

        return False

    def tech_type_clicked(self, a0):
        self.setData('tech-type', a0)


    # TECH-CLASS

    def apdkListBox_currentChanged(self,item):
        self.updateAddButton()


    def addTechClassPushButton_clicked(self):
        x = 0
        i = self.apdkListBox.item(x)
        removes = []

        while i:
            if i.isSelected():
                self.tech_class.insertItem(QString(i.text()))
                removes.append(i)

            x += 1
            i = self.apdkListBox.item(x)

        [self.apdkListBox.takeItem(i) for i in removes]

        i = self.tech_class.findItem(QString("Undefined"))
        if i:
            self.tech_class.takeItem(i)
            self.apdkListBox.insertItem(QString("Undefined"))
            self.apdkListBox.sort()

        self.tech_class.sort()

        self.updateAddButton()
        self.updateTechClass()


    def removeTechClassPushButton_clicked(self):
        x = 0
        i = self.tech_class.item(x)
        removes = []

        while i:
            if i.isSelected():
                self.apdkListBox.insertItem(QString(i.text()))
                removes.append(i)

            x += 1
            i = self.tech_class.item(x)

        [self.tech_class.takeItem(i) for i in removes]

        if not self.tech_class.count():
            self.tech_class.insertItem(QString("Undefined"))
            self.apdkListBox.takeItem(self.apdkListBox.findItem(QString("Undefined")))

        self.apdkListBox.sort()

        self.updateRemoveButton()
        self.updateTechClass()


    def tech_class_currentChanged(self,a0):
        self.updateRemoveButton()


    def updateTechClass(self):
        data = []
        x = 0
        i = self.tech_class.item(x)

        while i:
            data.append(str(i.text()))

            x += 1
            i = self.tech_class.item(x)

        self.setData('tech-class', data)


    def updateAddButton(self):
        self.addTechClassPushButton.setEnabled(self.apdkListBox.count() and self.anySelection(self.apdkListBox))


    def updateRemoveButton(self):
        self.removeTechClassPushButton.setEnabled(self.tech_class.count() and self.anySelection(self.tech_class))


    def apdkListBox_doubleClicked(self, i):
        if i and i.text():
            self.apdkListBox.takeItem(i)
            self.tech_class.insertItem(QString(i.text()))

        i = self.tech_class.findItem(QString("Undefined"))
        if i:
            self.tech_class.takeItem(i)
            self.apdkListBox.insertItem(QString("Undefined"))
            self.apdkListBox.sort()

        self.tech_class.sort()

        self.updateAddButton()
        self.updateTechClass()


    def tech_class_doubleClicked(self, i):
        if i and i.text():
            self.tech_class.takeItem(i)
            self.apdkListBox.insertItem(QString(i.text()))

        if not self.tech_class.count():
            self.tech_class.insertItem(QString("Undefined"))
            self.apdkListBox.takeItem(self.apdkListBox.findItem(QString("Undefined")))

        self.apdkListBox.sort()

        self.updateRemoveButton()
        self.updateTechClass()

    def apdkListBox_currentChanged(self,item):
        self.updateAddButton()

    # TECH-SUBCLASS

    def hplipListBox_currentChanged(self,item):
        self.updateAddButton2()

    def addSubclassPushButton_clicked(self):
        x = 0
        i = self.hplipListBox.item(x)
        removes = []

        while i:
            if i.isSelected():
                self.tech_subclass.insertItem(QString(i.text()))
                removes.append(i)

            x += 1
            i = self.hplipListBox.item(x)

        [self.hplipListBox.takeItem(i) for i in removes]

        i = self.tech_subclass.findItem(QString("Normal"))
        if i:
            self.tech_subclass.takeItem(i)
            self.hplipListBox.insertItem(QString("Normal"))
            self.hplipListBox.sort()

        self.tech_subclass.sort()

        self.updateAddButton2()
        self.updateTechSubClass()


    def removeSubclassPushButton_clicked(self):
        x = 0
        i = self.tech_subclass.item(x)
        removes = []

        while i:
            if i.isSelected():
                self.hplipListBox.insertItem(QString(i.text()))
                removes.append(i)

            x += 1
            i = self.tech_subclass.item(x)

        [self.tech_subclass.takeItem(i) for i in removes]

        if not self.tech_subclass.count():
            self.tech_subclass.insertItem(QString("Normal"))
            self.hplipListBox.takeItem(self.apdkListBox.findItem(QString("Normal")))

        self.hplipListBox.sort()

        self.updateRemoveButton2()
        self.updateTechSubClass()


    def tech_subclass_currentChanged(self,a0):
        self.updateRemoveButton2()


    def updateTechSubClass(self):
        data = []
        x = 0
        i = self.tech_subclass.item(x)

        while i:
            data.append(str(i.text()))

            x += 1
            i = self.tech_subclass.item(x)

        self.setData('tech-subclass', data)


    def updateAddButton2(self):
        self.addSubclassPushButton.setEnabled(self.hplipListBox.count() and self.anySelection(self.hplipListBox))


    def updateRemoveButton2(self):
        self.removeSubclassPushButton.setEnabled(self.tech_subclass.count() and self.anySelection(self.tech_subclass))


    def hplipListBox_doubleClicked(self, i):
        if i and i.text():
            self.hplipListBox.takeItem(i)
            self.tech_subclass.insertItem(QString(i.text()))

        i = self.tech_subclass.findItem(QString("Normal"))
        if i:
            self.tech_subclass.takeItem(i)
            self.hplipListBox.insertItem(QString("Normal"))
            self.hplipListBox.sort()

        self.tech_subclass.sort()

        self.updateAddButton2()
        self.updateTechSubClass()


    def tech_subclass_doubleClicked(self, i):
        if i and i.text():
            self.tech_subclass.takeItem(i)
            self.hplipListBox.insertItem(QString(i.text()))

        if not self.tech_subclass.count():
            self.tech_subclass.insertItem(QString("Normal"))
            self.hplipListBox.takeItem(self.hplipListBox.findItem(QString("Normal")))

        self.hplipListBox.sort()

        self.updateRemoveButton2()
        self.updateTechSubClass()

    #
    # FUNCTIONS TAB (NOW: SCAN, FAX, COPY AND PCARD TABS)
    #

    def updateFuncTab(self):
        scan_type = self.data('scan-type')

        if scan_type == -1:
            scan_type = 999
        elif scan_type == -2:
            scan_type = 998

        scan_style = self.data('scan-style')
        copy_type = self.data('copy-type')

        if copy_type == -1:
            copy_type = 999

        fax_type = self.data('fax-type')

        if fax_type == -1:
            fax_type = 999

        pcard_type = self.data('pcard-type')

        self.scan_type.setButton(scan_type)
        self.scan_style.setButton(scan_style)
        self.copy_type.setButton(copy_type)
        self.fax_type.setButton(fax_type)
        self.pcard_type.setButton(pcard_type)


    def scan_type_clicked(self,a0):
        if a0 == 999:
            a0 = -1
        elif a0 == 998:
            a0 = -2

        self.setData('scan-type', a0)

    def scan_style_clicked(self,a0):
        self.setData('scan-style', a0)

    def pcard_type_clicked(self,a0):
        self.setData('pcard-type', a0)

    def fax_type_clicked(self,a0):
        if a0 == 999: a0 = -1
        self.setData('fax-type', a0)

    def copy_type_clicked(self,a0):
        if a0 == 999: a0 = -1
        self.setData('copy-type', a0)

    #
    # MAINT TAB
    #

    def updateAlignCleanTab(self):
        align_type = self.data('align-type')
        clean_type = self.data('clean-type')
        color_cal_type = self.data('color-cal-type')
        linefeed_cal_type = self.data('linefeed-cal-type')
        pq_diag_type = self.data('pq-diag-type')

        if align_type == -1:
            align_type = 999
        if clean_type == -1:
            clean_type = 999
        if color_cal_type == -1:
            color_cal_type = 999
        if linefeed_cal_type == -1:
            linefeed_cal_type = 999
        if pq_diag_type == -1:
            pq_diag_type = 999

        self.align_type.setButton(align_type)
        self.clean_type.setButton(clean_type)
        self.color_cal_type.setButton(color_cal_type)
        self.linefeed_cal_type.setButton(linefeed_cal_type)
        self.pq_diag_type.setButton(pq_diag_type)

    def align_type_clicked(self,a0):
        if a0 == 999: a0 = -1
        self.setData('align-type', a0)

    def clean_type_clicked(self,a0):
        if a0 == 999: a0 = -1
        self.setData('clean-type', a0)

    def color_cal_type_clicked(self,a0):
        if a0 == 999: a0 = -1
        self.setData('color-cal-type', a0)

    def linefeed_cal_type_clicked(self,a0):
        if a0 == 999: a0 = -1
        self.setData('linefeed-cal-type', a0)

    def pq_diag_type_clicked(self,a0):
        if a0 == 999: a0 = -1
        self.setData('pq-diag-type', a0)



    #
    # DAT TAB
    #

    def updateMQDataTab(self):
        s = cStringIO.StringIO()
        self.createDATModel(s, self.current_model)
        self.mq_data.setText(s.getvalue())
        s.close()

    #
    # PLUGIN TAB
    #

    def updatePluginTab(self):
        plugin = self.data('plugin')
        self.plugin.setButton(plugin)

        fw_download = self.data('fw-download')
        self.fw_download.setChecked(fw_download)

        plugin_reason = self.data('plugin-reason')
        self.plugin_reason_0x01.setChecked(plugin_reason & PLUGIN_REASON_PRINTING_SUPPORT == PLUGIN_REASON_PRINTING_SUPPORT)
        self.plugin_reason_0x02.setChecked(plugin_reason & PLUGIN_REASON_FASTER_PRINTING == PLUGIN_REASON_FASTER_PRINTING)
        self.plugin_reason_0x04.setChecked(plugin_reason & PLUGIN_REASON_BETTER_PRINTING_PQ == PLUGIN_REASON_BETTER_PRINTING_PQ)
        self.plugin_reason_0x08.setChecked(plugin_reason & PLUGIN_REASON_PRINTING_FEATURES == PLUGIN_REASON_PRINTING_FEATURES)
        self.plugin_reason_0x40.setChecked(plugin_reason & PLUGIN_REASON_SCANNING_SUPPORT == PLUGIN_REASON_SCANNING_SUPPORT)
        self.plugin_reason_0x80.setChecked(plugin_reason & PLUGIN_REASON_FASTER_SCANNING == PLUGIN_REASON_FASTER_SCANNING)
        self.plugin_reason_0x100.setChecked(plugin_reason & PLUGIN_REASON_BETTER_SCANNING_IQ == PLUGIN_REASON_BETTER_SCANNING_IQ)
        self.plugin_reason_0x800.setChecked(plugin_reason & PLUGIN_REASON_FAXING_SUPPORT == PLUGIN_REASON_FAXING_SUPPORT)
        self.plugin_reason_0x1000.setChecked(plugin_reason & PLUGIN_REASON_FAX_FEATURES == PLUGIN_REASON_FAX_FEATURES)
        self.plugin_reason_0x4000.setChecked(plugin_reason & PLUGIN_REASON_IO_SUPPORT == PLUGIN_REASON_IO_SUPPORT)
        self.plugin_reason_0x8000.setChecked(plugin_reason & PLUGIN_REASON_UI_FEATURES == PLUGIN_REASON_UI_FEATURES)
        self.plugin_reason_0x10000.setChecked(plugin_reason & PLUGIN_REASON_OTHER_FEATURES == PLUGIN_REASON_OTHER_FEATURES)


    def plugin_clicked(self, a0):
        self.setData('plugin', a0)

    def fw_download_toggled(self,a0):
        self.setData('fw-download', a0)

    def plugin_reason_0x01_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x02_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x04_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x08_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x10_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x20_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x40_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x80_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x100_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x200_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x400_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x800_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x1000_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x2000_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x4000_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x8000_toggled(self, b):
        self.recalc_plugin_reason()

    def plugin_reason_0x10000_toggled(self, b):
        self.recalc_plugin_reason()

    def recalc_plugin_reason(self):
        r = 0
        if self.plugin_reason_0x01.isChecked(): r += PLUGIN_REASON_PRINTING_SUPPORT
        if self.plugin_reason_0x02.isChecked(): r += PLUGIN_REASON_FASTER_PRINTING
        if self.plugin_reason_0x04.isChecked(): r += PLUGIN_REASON_BETTER_PRINTING_PQ
        if self.plugin_reason_0x08.isChecked(): r += PLUGIN_REASON_PRINTING_FEATURES
        #if self.plugin_reason_0x10.isChecked(): r += PLUGIN_REASON_RESERVED_10
        #if self.plugin_reason_0x20.isChecked(): r += PLUGIN_REASON_RESERVED_20
        if self.plugin_reason_0x40.isChecked(): r += PLUGIN_REASON_SCANNING_SUPPORT
        if self.plugin_reason_0x80.isChecked(): r += PLUGIN_REASON_FASTER_SCANNING
        if self.plugin_reason_0x100.isChecked(): r += PLUGIN_REASON_BETTER_SCANNING_IQ
        #if self.plugin_reason_0x200.isChecked(): r += PLUGIN_REASON_RESERVED_200
        #if self.plugin_reason_0x400.isChecked(): r += PLUGIN_REASON_RESERVED_400
        if self.plugin_reason_0x800.isChecked(): r += PLUGIN_REASON_FAXING_SUPPORT
        if self.plugin_reason_0x1000.isChecked(): r += PLUGIN_REASON_FAX_FEATURES
        #if self.plugin_reason_0x2000.isChecked(): r += PLUGIN_REASON_RESERVED_2000
        if self.plugin_reason_0x4000.isChecked(): r += PLUGIN_REASON_IO_SUPPORT
        if self.plugin_reason_0x8000.isChecked(): r += PLUGIN_REASON_UI_FEATURES
        if self.plugin_reason_0x10000.isChecked(): r += PLUGIN_REASON_OTHER_FEATURES

        self.setData('plugin-reason', r)


    #
    # MISC TAB
    #

    def updateMiscTab(self):
        embedded_server_type = self.data('embedded-server-type')
        self.embedded_server.setButton(embedded_server_type)

        panel_check_type = self.data('panel-check-type')
        self.panel_check.setButton(panel_check_type)

        power_settings = self.data('power-settings')
        self.power_settings.setButton(power_settings)

        job_storage = self.data('job-storage')
        self.job_storage.setButton(job_storage)

    def embedded_server_clicked(self,a0):
        self.setData('embedded-server-type', a0)

    def panel_check_clicked(self,a0):
        self.setData('panel-check-type', a0)

    def fw_download_clicked(self,a0):
        self.setData('fw-download', a0)

    def power_settings_clicked(self, a0):
        self.setData('power-settings', a0)

    def job_storage_clicked(self,a0):
        self.setData('job-storage', a0)


    #
    # WARNINGS TAB
    #

    def updateWarningsTab(self):
        warnings, num_warnings = self.get_warnings_text()
        self.warnings.setText(warnings)

        if not num_warnings:
            self.tabWidget2.setTabLabel(self.WarningPage, "Warnings")
        else:
            self.tabWidget2.setTabLabel(self.WarningPage, "!!! WARNINGS !!!")

        return num_warnings


    def get_warnings_text(self):
        i = 1
        s = cStringIO.StringIO()

        support_released = self.data('support-released')
        support_ver = self.data('support-ver')
        support_type = self.data('support-type')

        if ' ' in self.current_model:
            s.write("%d. Invalid character ' ' (space) in model name\n" % i)
            i += 1

        if '/' in self.current_model:
            s.write("%d. Invalid character '/' (slash) in model name\n" % i)
            i += 1

        for x in self.current_model:
            if x != x.lower():
                s.write("%d. Invalid character '%s' (capital) in model name\n" % i)
                i += 1

        is_laser = self.data('tech-type') in (TECH_TYPE_MONO_LASER, TECH_TYPE_COLOR_LASER)

        if support_type > SUPPORT_TYPE_NONE:

            if self.using_default_icon:
                s.write('%d. Using default icon.\n' % i)
                i += 1

            tech_type = self.data('tech-type')
            if tech_type == 0:
                s.write("%d. Invalid tech-type (==0).\n" % i)
                i += 1

            align_type = self.data('align-type')
            clean_type = self.data('clean-type')
            color_cal_type = self.data('color-cal-type')

            if is_laser and align_type > ALIGN_TYPE_NONE:
                s.write("%d. LaserJet and align-type != 0\n" % i)
                i += 1

            if is_laser and clean_type > CLEAN_TYPE_NONE:
                s.write("%d. LaserJet and clean-type != 0\n" % i)
                i += 1

            if is_laser and color_cal_type > COLOR_CAL_TYPE_NONE:
                s.write("%d. LaserJet and color-cal-type != 0\n" % i)
                i += 1

            status_type = self.data('status-type')
            dynamic_counters = self.data('status-dynamic-counters')

            if is_laser:
                if status_type in (STATUS_TYPE_VSTATUS, STATUS_TYPE_S):
                    s.write("%d. Invalid status-type for LaserJet\n" % i)
                    i += 1

                if dynamic_counters != STATUS_DYNAMIC_COUNTERS_NONE:
                    s.write("%d. Invalid dynamic counters value for LaserJet\n" % i)
                    i += 1

            else:
                if status_type in (STATUS_TYPE_LJ, STATUS_TYPE_LJ_XML):
                    s.write("%d. Invalid status-type for non-LaserJet\n" % i)
                    i += 1

            if status_type in (4,5,7): # DEPRECATED status-types
                s.write("%d. Deprecated status-type!\n" % i)
                i += 1

            scan_type = self.data('scan-type')
            scan_style = self.data('scan-style')

            if scan_type not in (SCAN_TYPE_NONE, SCAN_TYPE_NOT_SUPPORTED, SCAN_TYPE_DIGITAL_SENDER) and \
                scan_style == SCAN_STYLE_NONE:

                s.write("%d. Invalid scan-style (==0) (when scan-type=%d)\n" % (i, scan_type))
                i += 1

            copy_type = self.data('copy-type')

            if copy_type == COPY_TYPE_SCAN_TO_PRINT:
                s.write("%d. Invalid copy-type (==2). (Value not being used).\n" % i)
                i += 1

            io_mode = self.data('io-mode')
            if io_mode == 2:
                s.write("%d. Invalid io-mode (==2). This value is deprecated.\n" % i)
                i += 1

            io_mfp_mode = self.data('io-mfp-mode')
            if io_mfp_mode == 2:
                s.write("%d. Invalid io-mfp-mode (==2). This value is deprecated.\n" % i)
                i += 1

            usb_vid = self.data('usb-vid')
            if usb_vid:
                if usb_vid.lower() != '03f0':
                    s.write("%d. USB vendor ID (usb_vid) is not 03f0 or blank.\n" % i)
                    i += 1


            if support_released and support_ver == '0.0.0' and support_type != 0:
                s.write("%d. support_released == 1 and support-type =! 0 and support_ver == 0.0.0\n" % i)
                i += 1


            rgn = 0
            index = 1
            rgn_w_pens = 0

            while True:
                index = 1
                kind = self.data('r%d-agent%d-kind' % (rgn, index), AGENT_KIND_NONE)

                if kind == AGENT_KIND_NONE:
                    break

                if rgn > 31:
                    break

                if int(kind) == AGENT_KIND_NONE:
                    rgn += 1
                    continue

                rgn_w_pens += 1
                while True:

                    kind = self.data('r%d-agent%d-kind' % (rgn, index), AGENT_KIND_NONE)

                    if kind == AGENT_KIND_NONE:
                        break

                    if index > 20:
                        break

                    typ = self.data('r%d-agent%d-type' % (rgn, index))
                    sku = self.data('r%d-agent%d-sku' % (rgn, index), '')

                    if kind == 0:
                        s.write("%d. r%d agent%d invalid kind=0\n" % (i, rgn, index))
                        i += 1

                    if kind in (5, 6, 7, 8, 9) and typ != 62:
                        s.write("%d. r%d agent%d invalid type for kind=%d (must be 62:Unspecified) (TODO: Needs to be verified)\n" % (i, rgn, index, kind))
                        i += 1

                    if is_laser:
                        if kind in (1,2,3,9):
                            s.write("%d. r%d agent%d invalid kind for LaserJet supply (must be 4,5,6,7, or 8)\n" % (i, rgn, index))
                            i += 1
                    else:
                        if kind in (4,5,6,7,8):
                            s.write("%d. r%d agent%d invalid kind for non-LaserJet supply (must be 1,2,3, or 9)\n" % (i, rgn, index))
                            i += 1

                    if type(sku) == type(0):
                        if sku == 0:
                            s.write("%d. r%d agent%d invalid product sku (blank or 0)\n" % (i, rgn, index))
                            i += 1
                    else:
                        if not sku or sku.find('?')>=0:
                            s.write("%d. r%d agent%d invalid product sku (blank or ?)\n" % (i, rgn, index))
                            i += 1

                    index += 1
                rgn += 1


            if rgn_w_pens > 1 and dynamic_counters == 0:
                s.write("%d. # regions > 1 (%d total) and dynamic-counters == 0\n" % (i, rgn_w_pens))
                i += 1

            io_support = self.data('io-support')
            pid = self.data('usb-pid', '')

            # Uncomment to check for missing USB PIDs
            #if io_support & 0x2 == 0x2 and (not pid or pid == '0000' or len(pid) != 4):
            #    s.write("%d. USB I/O suppported and invalid or missing USB PID value.\n" % i)
            #    i += 1

            if io_support == 0 and support_type != 0:
                s.write("%d. Invalid io-support (== 0)\n" % i)
                i += 1

            plugin = self.data('plugin')

            if plugin > PLUGIN_NONE and self.current_model not in self.plugin_products:
                s.write("%d. Missing plugin entry in plugin.spec file" % i)
                i += 1

            tech_class = self.data('tech-class')

            if not tech_class:
                s.write("%d. Invalid (blank) tech-class\n" % i)
                i += 1

            if "Undefined" in tech_class:
                s.write("%d. Invalid (undefined) tech-class\n" % i)
                i += 1

            if len(tech_class) > 3:
                s.write("%d. Invalid (too many classes (>3)) tech-class\n" % i)
                i += 1

            for p in self.ppds:
                c = self.current_model.replace('hp_', '').replace('hp-', '')

                if c in p:
                    break
            else:
                s.write("%d. No PPD file found for this model\n" % i)
                i += 1


        # end

        i -= 1

        if i == 0:
            s.write("No warnings.\n")
        else:
            if i == 1:
                s.write("1 warning!\n")
            else:
                s.write("%d warnings!\n" % i)

        return (s.getvalue(), i)

    #
    # WARNINGS AT EXIT
    #
    def warnings_at_exit(self):
        total_warnings = 0

        self.print_heading("WARNINGS")
        models = self.models.keys()
        models.sort()

        for self.current_model in models:
            self.current_model_data = self.models[self.current_model]
            warnings, num_warnings = self.get_warnings_text()

            total_warnings += num_warnings

            if num_warnings:
                print log.bold("*"*10 + self.current_model + "*"*10)
                print warnings

        if total_warnings:
            self.print_heading("TOTAL WARNINGS/ERRORS")
            log.error("%d total warnings/errors!!!" % total_warnings)

##        count = 0
##        for m in models:
##            c = self.models[m]
##            scan_type = c['scan-type']
##            pid = c['usb-pid']
##
##            if scan_type and (pid or pid != '0000'):
##                print m
##                count += 1
##
##        print count

##        print
##
##        self.print_heading("MISSING PIDs")
##        count = 0
##        for self.current_model in models:
##            self.current_model_data = self.models[self.current_model]
##
##            #if int(self.current_model_data['io-support']) & 0x02 == 0x02:
##            if self.data('io-support') & 0x02 == 0x02:
##
##                #pid = self.current_model_data['usb-pid']
##                pid = self.data('usb-pid')
##
####                if type(pid) == type(''):
####                    try:
####                        pid = int(pid, 16)
####                    except ValueError:
####                        pid = 0
####                else:
####                    try:
####                        pid = int(str(pid), 16)
####
####                    except (ValueError, TypeError):
####                        pid = 0
####
####                #print "pid=", pid
##
##                if not pid or pid == '0000':
##                    print self.current_model
##                    count += 1
##
##        print "Total missing PIDs = %d" % count

    #
    # STATUS TAB
    #

    def updateStatusTab(self):
        status_type = self.data('status-type')
        self.status_type.setButton(status_type)

        status_battery_check = self.data('status-battery-check')
        self.status_battery_check.setButton(status_battery_check)

        status_dynamic_counters = self.data('status-dynamic-counters')
        self.status_dynamic_counters.setButton(status_dynamic_counters)

    def status_type_clicked(self,a0):
        self.setData('status-type', a0)

    def status_battery_check_clicked(self,a0):
        self.setData('status-battery-check', a0)

    def status_dynamic_counters_clicked(self,a0):
        self.setData('status-dynamic-counters', a0)


    #
    # ICON TAB
    #

    def updateIconTab(self):
        f, icon_normal, icon_not_avail, icon_ok, icon_warning, icon_lowink, icon_lowtoner = \
            self.createPixmap()

        self.iconEdit.setText(self.data('icon'))

        if icon_normal:
            self.icon_normal.setPixmap(icon_normal)
            self.icon_not_avail.setPixmap(icon_not_avail)
            self.icon_ok.setPixmap(icon_ok)
            self.icon_warning.setPixmap(icon_warning)
            self.icon_lowink.setPixmap(icon_lowink)
            self.icon_lowtoner.setPixmap(icon_lowtoner)
            self.filename_text.setText(f)


        else:
            self.icon_normal.setText("NOT FOUND!")
            self.icon_not_avail.setText("NOT FOUND!")
            self.icon_ok.setText("NOT FOUND!")
            self.icon_warning.setText("NOT FOUND!")
            self.icon_lowink.setText("NOT FOUND!")
            self.icon_lowtoner.setText("NOT FOUND!")

            self.filename_text.setText(f + " (NOT FOUND!)")

        self.url_index = 0

        if self.lookup_icons:

            if self.pic_cache.get(self.current_model, None) is None:

                self.pic_cache[self.current_model] = []

                url_model = self.current_model.replace("_", " ")
                if "apollo" not in url_model:
                    if "hp" not in url_model:
                        url_model = ' '.join(["hp", url_model])

                url_model = url_model.replace("series", "")

                for p in self.default_pics.keys():
                    if p in url_model:
                        break

                else:
                    url_model = ' '.join(["printer", url_model])

                url_model = urllib.quote(url_model)

                url = 'http://ajax.googleapis.com/ajax/services/search/images?v=1.0&rsz=large&q=%s' % url_model
                print url
                req = urllib2.Request(url)
                req.add_header('Referer', 'http://hplip.sourceforge.net/')

                ok = False
                QApplication.setOverrideCursor(QApplication.waitCursor)
                try:
                    try:
                        r = urllib2.urlopen(req)
                    except (urllib2.HTTPError, urllib2.URLError), e:
                        log.error("Error retrieving search results: %s" % e)
                    else:
                        try:
                            x = r.read()
                        except socket.timeout:
                            log.error("Timeout reading search results!")
                        else:
                            obj = demjson.decode( x )
                            ok = True
                finally:
                    QApplication.restoreOverrideCursor()

                if ok:
                    status = obj[u'responseStatus']
                    if  status == 200:
                        for res in obj[u'responseData'][u'results']:
                            self.pic_cache[self.current_model].append(res[u'url'])
                    else:
                        log.error("Google search error status: %d" % status)

                    self.nextGooglePushButton.setEnabled(True)
                    self.prevGooglePushButton.setEnabled(True)
                    self.loadImage()
                    self.showImage()
                else:
                    self.nextGooglePushButton.setEnabled(False)
                    self.prevGooglePushButton.setEnabled(False)
                    QToolTip.add(self.google, QString("Google image search failed!"))

        else:
            QToolTip.add(self.google, QString("Google image search turned off. Use -i/--icon to turn on."))

    def loadImage(self):
        length = len(self.pic_cache[self.current_model])
        if not length:
            return

        if self.url_index < 0:
            self.url_index = length-1

        elif self.url_index > length-1:
            self.url_index = 0

        if type(self.pic_cache[self.current_model][self.url_index]) == type(u''):

            # load the image
            print self.pic_cache[self.current_model][self.url_index]
            req = urllib2.Request(self.pic_cache[self.current_model][self.url_index])

            QApplication.setOverrideCursor(QApplication.waitCursor)
            try:
                try:
                    r = urllib2.urlopen(req)
                except (urllib2.HTTPError, urllib2.URLError), e:
                    log.error("Error retrieving image: %s" % e)
                    self.imageSizeLabel.setText(QString("???px wide x ???px high"))
                else:
                    try:
                        x = r.read()
                    except socket.timeout:
                        log.error("Timeout reading image!")
                        self.imageSizeLabel.setText(QString("???px wide x ???px high"))
                    else:
                        img = QImage()
                        img.loadFromData(x)
                        #if img.width() > 256 or img.height() > 256:
                        #    img.smoothScale(256, 256, QImage.ScaleMin)
                        self.imageSizeLabel.setText(QString("%1px wide x %2px high").arg(img.width()).arg(img.height()))
                        self.pic_cache[self.current_model][self.url_index] = img

            finally:
                QApplication.restoreOverrideCursor()


        else:
            pass


    def showImage(self):
        length = len(self.pic_cache[self.current_model])

        if not length:
            return

        last_index = length-1

        if self.url_index < 0:
            self.url_index = last_index

        elif self.url_index > last_index:
            self.url_index = 0

        self.textLabel1_4.setText(QString("Google image search results (%1 of %1):").\
            arg(self.url_index+1).arg(last_index+1))

        if type(self.pic_cache[self.current_model][self.url_index]) != type(u''):
            px = QPixmap(self.pic_cache[self.current_model][self.url_index])
            self.google.setPixmap(px)
            QToolTip.add(self.google, QString("Pic %1 of %2").arg(self.url_index+1).arg(last_index+1))

        else:
            icon = QPixmap(256, 256)
            p = QPainter(icon)
            p.eraseRect(0, 0, icon.width(), icon.height())
            p.drawLine(0, 0, 255, 255)
            p.drawLine(0, 255, 255, 0)
            p.drawLine(0, 0, 255, 0)
            p.drawLine(255, 0, 255, 255)
            p.drawLine(255, 255, 0, 255)
            p.drawLine(0, 255, 0, 0)
            p.end()
            self.google.setPixmap(icon)
            QToolTip.add(self.google, QString("ERROR: %1 failed to load.").arg(self.pic_cache[self.current_model][self.url_index]))

    def saveGooglePushButton_clicked(self):
        d = os.path.join(prop.cur_dir, 'data', 'images', 'devices')
        s = str(QFileDialog.getSaveFileName(d, "Device Image (*.png)", self, "save icon dialog", "Choose a device icon name"))
        self.saveImage(s)

    def saveImage(self, filename):
        if not filename:
            log.error("No filename to save to!")
            return

        if not filename.endswith('.png'):
            filename += '.png'

        img = self.pic_cache[self.current_model][self.url_index]
        if type(img) != type(u''):
            img.save(filename, "PNG")

    def nextGooglePushButton_clicked(self):
        self.url_index += 1
        self.loadImage()
        self.showImage()

    def prevGooglePushButton_clicked(self):
        self.url_index -= 1
        self.loadImage()
        self.showImage()


    def iconBrowse_clicked(self):
        model = self.current_model
        s = str(QFileDialog.getOpenFileName(os.path.join(self.images_dir, 'devices'),
                "PNG files (*.png)", self, "openfile", self.caption()))
        if s:
            t = os.path.split(s)[-1]
            self.iconEdit.setText(t)
            self.setData('icon', t)

            self.loadModelListbox()
            self.ActivateModel(model)
            self.updateIconTab()


    def iconSet_clicked(self):
        model = self.current_model
        f = str(self.iconEdit.text())
        self.setData('icon', f)
        self.loadModelListbox()
        self.ActivateModel(model)
        self.updateIconTab()



    def createPixmap(self) :
        filename = self.data('icon')
        f = os.path.join(self.images_dir, 'devices', filename)
        pix = self.load_pixmap(filename, 'devices')

        if pix is not None:
            icon_normal = QPixmap(pix.width(), pix.height())
            p = QPainter(icon_normal)
            p.eraseRect(0, 0, icon_normal.width(), icon_normal.height())
            p.drawPixmap(0, 0, pix)
            p.end()

            icon_not_avail = QPixmap(pix.width(), pix.height())
            p = QPainter(icon_not_avail)
            p.eraseRect(0, 0, icon_not_avail.width(), icon_not_avail.height())
            p.drawPixmap(0, 0, pix)
            p.drawPixmap(0, 0, self.error_pix)
            p.end()

            icon_warning = QPixmap(pix.width(), pix.height())
            p = QPainter(icon_warning)
            p.eraseRect(0, 0, icon_warning.width(), icon_warning.height())
            p.drawPixmap(0, 0, pix)
            p.drawPixmap(0, 0, self.warning_pix)
            p.end()

            icon_ok = QPixmap(pix.width(), pix.height())
            p = QPainter(icon_ok)
            p.eraseRect(0, 0, icon_ok.width(), icon_ok.height())
            p.drawPixmap(0, 0, pix)
            p.drawPixmap(0, 0, self.ok_pix)
            p.end()

            icon_lowink = QPixmap(pix.width(), pix.height())
            p = QPainter(icon_lowink)
            p.eraseRect(0, 0, icon_lowink.width(), icon_lowink.height())
            p.drawPixmap(0, 0, pix)
            p.drawPixmap(0, 0, self.lowink_pix)
            p.end()

            icon_lowtoner = QPixmap(pix.width(), pix.height())
            p = QPainter(icon_lowtoner)
            p.eraseRect(0, 0, icon_lowtoner.width(), icon_lowtoner.height())
            p.drawPixmap(0, 0, pix)
            p.drawPixmap(0, 0, self.lowtoner_pix)
            p.end()

            return f, icon_normal, icon_not_avail, icon_ok, icon_warning, icon_lowink, icon_lowtoner

        else:
            return f, None, None, None, None, None, None


    #
    # ID TAB (DEFUNCT)
    #

    def updateDeviceID(self):
        #device_id = self.data('id', '')
        #self.device_id.setText(device_id)
        pass

    def device_id_textChanged(self):
        self.setData('id', str(self.device_id.text()))

    #
    # AGENTS TAB
    #

    def updateAgentsTab(self):
        self.rgn = self.region.value()
        self.agent_table.setNumRows(0)
        existing_region_list, max_rgn = self.get_region_info()
        QToolTip.add(self.region, "Active regions: %s" % ", ".join([str(x) for x in existing_region_list]))
        self.region.setMaxValue(max_rgn)

        num_agents = 0
        while True:
            kind = self.data('r%d-agent%d-kind' % (self.rgn, num_agents+1), -1)

            if kind == -1:
                break

            num_agents += 1

        self.agent_table.insertRows(0, num_agents)

        index = 1

        while True:
            kind = self.data('r%d-agent%d-kind' % (self.rgn, index), -1)
            if kind == -1:
                break
            typ = self.data('r%d-agent%d-type' % (self.rgn, index), '0')
            sku = self.current_model_data.get('r%d-agent%d-sku' % (self.rgn, index), '')


            self.agent_table.setText(index-1, 0, str(index))
            self.agent_table.setText(index-1, 1, "%d: %s" % (kind, self.agent_kinds[kind]))
            self.agent_table.setText(index-1, 2, "%d: %s" % (typ, self.agent_types[typ]))
            self.agent_table.setText(index-1, 3, str(sku))

            index += 1

    def get_region_info(self):
        existing_region_list = []

        max_rgn = 0
        rgn = 0
        while True:

            if rgn > 31:
                break

            kind = self.data('r%d-agent1-kind' % rgn, -1)
            #typ = self.data('r%d-agent1-typ' % rgn, AGENT_TYPE_NONE)

            #print kind, typ

            if kind != -1: #AGENT_KIND_NONE and typ != AGENT_TYPE_NONE:
                max_rgn = rgn
                existing_region_list.append(rgn)

            rgn += 1

        return existing_region_list, max_rgn


    def newRegionPushButton_clicked(self):
        existing_region_list, max_rgn = self.get_region_info()

        existing_region_set = set(existing_region_list)
        all_regions_set = set(range(32))

        open_regions_set = all_regions_set - existing_region_set

        l = QStringList()
        for r in open_regions_set:
            l.append(str(r))

        new_region, ok = QInputDialog.getItem("New Region", "Choose Region:", l)

        if ok:
            new_region = int(str(new_region))

            self.change_log.append("%s: Added new region %d" % (self.current_model, new_region))

            index = 1
            while True:
                kind = self.data('r0-agent%d-kind' % index, -1)

                if kind == -1:
                    break

                typ = self.data('r0-agent%d-type' % index, '0')

                #self.change_log.append("%s: Added new agent r%d-agent%d" % (self.current_model, new_region, index))

                self.setData('r%d-agent%d-kind' % (new_region, index), kind, False)
                self.setData('r%d-agent%d-type' % (new_region, index), typ, False)
                self.setData('r%d-agent%d-sku' % (new_region, index), '', False)

                index += 1

            self.change_log.append("%s: Region 0 agent data copied to new region %d" % (self.current_model, new_region))

            if new_region > max_rgn:
                self.region.setMaxValue(new_region)

            self.region.setValue(new_region)
            self.updateAgentsTab()
            self.updateDynamicTabs()



    def region_valueChanged(self, new_region):
        existing_region_list = []

        max_rgn = 0
        rgn = 0
        while True:

            if rgn > 31:
                break

            kind = self.data('r%d-agent1-kind' % rgn, -1)

            if kind != -1:
                max_rgn = rgn
                existing_region_list.append(rgn)

            rgn += 1

        if new_region not in existing_region_list:
            index = existing_region_list.index(self.rgn)

            if new_region > self.rgn:
                index = existing_region_list.index(self.rgn)
                try:
                    new_region = existing_region_list[index+1]
                except IndexError:
                    new_region = 0
            else:
                try:
                    new_region = existing_region_list[index-1]
                except IndexError:
                    new_region = existing_region_list[-1]

            self.region.setValue(new_region)

        self.updateAgentsTab()

    def type_textChanged(self,a0):
        pass

    def kind_textChanged(self,a0):
        pass

    def sku_textChanged(self,a0):
        pass

    def sku_lostFocus(self):
        d = str(self.sku.text())
        self.setData('r%d-agent%d-sku' % (self.rgn, self.index), d, True)
        self.agent_table.setText(self.index-1, 3, d)

    def new_agent_clicked(self):
        num_agents = 0
        while True:
            kind = self.data('r%d-agent%d-kind' % (self.rgn, num_agents+1), -1)

            if kind == -1:
                break

            num_agents += 1

        index = num_agents+1

        print self.current_model, self.rgn, index

        self.change_log.append("%s: Added new agent r%d-agent%d" % (self.current_model, self.rgn, index))

        self.setData('r%d-agent%d-sku' % (self.rgn, index), '', False)
        self.setData('r%d-agent%d-kind' % (self.rgn, index), AGENT_KIND_NONE, False)
        self.setData('r%d-agent%d-type' % (self.rgn, index), AGENT_TYPE_UNSPECIFIED, False)

        self.updateAgentsTab()

    def kind_activated(self,a0):
        d = str(a0).split(':')[0]
        self.setData('r%d-agent%d-kind' % (self.rgn, self.index), d)
        self.agent_table.setText(self.index-1, 1, str(a0))

    def type_activated(self,a0):
        d =  str(a0).split(':')[0]
        self.setData('r%d-agent%d-type' % (self.rgn, self.index), d)
        self.agent_table.setText(self.index-1, 2, str(a0))

    def table1_currentChanged(self,a0,a1):
        self.index = a0+1
        self.updateAgentInfo()

    def delete_agent_clicked(self):
        num_agents = 0
        while True:
            kind = self.data('r%d-agent%d-kind' % (self.rgn, num_agents+1), -1)

            if kind == -1:
                break

            num_agents += 1

        if num_agents:
            try:
                del self.models[self.current_model]['r%d-agent%d-kind' % (self.rgn, self.index)]
                del self.models[self.current_model]['r%d-agent%d-type' % (self.rgn, self.index)]
                del self.models[self.current_model]['r%d-agent%d-sku' % (self.rgn, self.index)]
            except KeyError:
                log.error("Key error")
                return

            self.change_log.append("%s: Removed agent r%d-agent%d" % (self.current_model, self.rgn, self.index))

            i = self.index
            j = self.index+1
            while True:
                kind = self.data('r%d-agent%d-kind' % (self.rgn, j), -1)

                if kind == -1:
                    break

                self.setData('r%d-agent%d-sku' % (self.rgn, i), self.data('r%d-agent%d-sku' % (self.rgn, j)), False)
                self.setData('r%d-agent%d-kind' % (self.rgn, i), self.data('r%d-agent%d-kind' % (self.rgn, j)), False)
                self.setData('r%d-agent%d-type' % (self.rgn, i), self.data('r%d-agent%d-type' % (self.rgn, j)), False)
                self.change_log.append("%s: Moved r%d-agent%d to r%d-agent%d" % (self.current_model, self.rgn, j, self.rgn, i))

                del self.models[self.current_model]['r%d-agent%d-kind' % (self.rgn, j)]
                del self.models[self.current_model]['r%d-agent%d-type' % (self.rgn, j)]
                del self.models[self.current_model]['r%d-agent%d-sku' % (self.rgn, j)]
                self.change_log.append("%s: Removed agent r%d-agent%d" % (self.current_model, self.rgn, j))

                i += 1
                j += 1

            self.updateDynamicTabs()
            self.updateAgentsTab()

        else:
            log.error("No agents to delete")

    def updateAgentInfo(self):
        kind = self.data('r%d-agent%d-kind' % (self.rgn, self.index), 0)
        typ = self.data('r%d-agent%d-type' % (self.rgn, self.index), 0)
        sku = self.current_model_data.get('r%d-agent%d-sku' % (self.rgn, self.index), '')

        self.kind.setCurrentItem(kind)

        # Adjust for the combo box index
        if typ == AGENT_TYPE_UNSPECIFIED:
            typ = 20

        elif typ == AGENT_TYPE_ERROR:
            typ = 21

        self.typ.setCurrentItem(typ)
        self.sku.setText(str(sku))



    #
    # CHANGE_LOG TAB
    #

    def change_log_text(self):
        s = cStringIO.StringIO()

        s.write("%s %s\n" % (time.strftime("%Y-%m-%d"), pwd.getpwuid(os.getuid())[0]))

        for c in self.change_log:
            s.write("    * %s\n" % c)

        s.write('\n\n')

        if self.released_data_changed:
            s.write("# models.dat has changed\n")

        if self.unreleased_data_changed:
            s.write("# unreleased/unreleased.dat has changed\n")

        return s.getvalue()

    def updateChangeLogTab(self):
        self.changeLogTextEdit.setText(self.change_log_text())


    #
    # DELETE MODEL
    #

    def delete_model_clicked(self):
        x = QMessageBox.critical(self,
                                 self.caption(),
                                 "<b>Annoying Confirmation: Are you sure you want to delete model '%s'</b><p>If you mistakenly delete a model, you will have to exit the tool without saving and restart the tool." % self.current_model,
                                  QMessageBox.Yes  | QMessageBox.Default,
                                  QMessageBox.No,
                                  QMessageBox.NoButton)
        if x == QMessageBox.Yes:
            print "Yes"
            self.change_log.append("%s: Model deleted" % self.current_model)

            if int(self.current_model_data['support-released']) == 1:
                self.released_data_changed = True
            else:
                self.unreleased_data_changed = True

            del self.models[self.current_model]
            self.current_model = None
            self.loadModelListbox()
            self.updateDynamicTabs()
        else:
            QMessageBox.critical(self,
                                 self.caption(),
                                 "<b>Delete Aborted: Cancelled at user's request.</b>",
                                  QMessageBox.Ok,
                                  QMessageBox.NoButton,
                                  QMessageBox.NoButton)

    #
    # NEW MODEL
    #

    def new_slurp_clicked(self):
        pass

    def new_model_clicked(self):
        model, ok = QInputDialog.getText("New Model", "Model name (MDL: field from Device ID) (use all lower case):", QLineEdit.Normal, '', self)
        if ok:
            model =  models.normalizeModelName(str(model)).lower()

            if model not in self.models:

                self.models[model] = {
                'align-type' : ALIGN_TYPE_NONE,
                'model1' : model,
                'clean-type' : CLEAN_TYPE_NONE,
                'color-cal-type': COLOR_CAL_TYPE_NONE,
                'copy-type' : COPY_TYPE_NONE,
                'embedded-server-type': EWS_NONE,
                'fax-type' : FAX_TYPE_NONE,
                'fw-download' : 0,
                'icon': 'default_printer.png',
                'io-mfp-mode' : IO_MODE_RAW,
                'io-mode' : IO_MODE_RAW,
                'io-support' : IO_SUPPORT_USB & IO_SUPPORT_NETWORK,
                'linefeed-cal-type' : LINEFEED_CAL_TYPE_NONE,
                'panel-check-type' : PANEL_CHECK_TYPE_NONE,
                'pcard-type' : PCARD_TYPE_NONE,
                'plugin' : PLUGIN_NONE,
                'plugin-reason' : PLUGIN_REASON_NONE,
                'plugin-library': '',
                'pq-diag-type' :PQ_DIAG_TYPE_NONE,
                'r-type' : 0,
                'scan-style' : SCAN_STYLE_NONE,
                'scan-type' : SCAN_TYPE_NONE,
                'status-battery-check' : STATUS_BATTERY_CHECK_NONE,
                'status-dynamic-counters' : STATUS_DYNAMIC_COUNTERS_NONE,
                #'support-eol-date' : MAX_DATE,
                'status-type' : STATUS_TYPE_NONE,
                'support-released' : True,
                'support-type' : SUPPORT_TYPE_HPLIP,
                'support-ver': '0.9.5',
                'tech-class' : ['Undefined'],
                'tech-subclass' : ['Normal'],
                'tech-type': TECH_TYPE_NONE,
                'r0-agent1-kind' : AGENT_KIND_NONE,
                'r0-agent1-type' : AGENT_TYPE_NONE,
                'r0-agent1-sku' : 'Unknown`',
                'usb-vid' : '03f0',
                'usb-pid' : '',
                }

                self.change_log.append("%s: New model added" % model)

                #if int(self.current_model_data['support-released']) == 1:
                self.released_data_changed = True
                #else:
                #    self.unreleased_data_changed = True


                self.loadModelListbox()
                self.ActivateModel(model)

            else:
                self.FailureUI("<b>Failed: Duplicate model name!</b>")
                log.error("Duplicate model name.")

    #
    # COPY/CLONE MODEL
    #

    def clone_button_clicked(self):
        model, ok = QInputDialog.getText("Copy Model", "Model name (use MDL: field from Device ID) (use all lower case):", QLineEdit.Normal, '', self)
        if ok:
            model =  models.normalizeModelName(str(model)).lower()

            if model not in self.models:
                self.models[model] = self.models[self.current_model].copy()

                self.change_log.append("Model %s copied to %s" % (self.current_model, model))

                if int(self.current_model_data['support-released']) == 1:
                    self.released_data_changed = True
                else:
                    self.unreleased_data_changed = True

                self.loadModelListbox()
                self.ActivateModel(model)
                self.updateDynamicTabs()

            else:
                self.FailureUI("<b>Failed: Duplicate model name!</b>")
                log.error("Duplicate model name.")


    #
    # CLOSE/SAVE/DAT OUTPUT
    #

    def save_and_close_button_clicked(self):
        self.save_button_clicked()

        if len(self.change_log):
            self.print_heading("CHANGE_LOG")
            print self.change_log_text()
            print

        self.warnings_at_exit()

        self.close()

    def save_button_clicked(self):
        self.createDATs()

    def view_button_clicked(self):
        self.createDATs(sys.stdout)

    def close_button_clicked(self):
        self.warnings_at_exit()
        self.close()


    def createDATModel(self, output, model):
        tab = ' '*4
        d = self.models[model]

        output.write("[%s]\n" % model)

        rgn = 0
        index = 1
        rgn_w_pens = 0

        while True:
            index = 1
            kind = d.get('r%d-agent%d-kind' % (rgn, index), AGENT_KIND_NONE)

            if rgn > 31:
                break

            if int(kind) == AGENT_KIND_NONE:
                rgn += 1
                continue

            rgn_w_pens += 1
            rgn += 1

        if rgn_w_pens > 1:
            d['r-type'] = 1
        else:
            d['r-type'] = 0

        kk = d.keys()
        kk.sort()

        for k in kk:
            if self.m.FIELD_TYPES.get(k, models.TYPE_STR) == models.TYPE_LIST:
                output.write("%s=%s\n" % (k, ','.join(d.get(k, ''))))

            elif self.m.FIELD_TYPES.get(k, models.TYPE_STR) == models.TYPE_DATE:
                #output.write("%s=%s\n" % (k, d.get(k, MAX_DATE).toString("dd/MM/yyyy")))
                output.write("%s=%s\n" % (k, d.get(k, MAX_DATE).strftime("%d/%m/%Y")))
            else:
                output.write("%s=%s\n" % (k, d.get(k, '')))


    def createDATs(self):
        log.info("\nWriting to files...")

        if self.released_data_changed:

            if not bool(QFileInfo(self.released_dat).isWritable()):
                log.warn("File %s is write-only. Setting to rw-r-r (0644)" % self.released_dat)
                os.chmod(self.released_dat, 0644)

            log.info("Writing to %s." % self.released_dat)
            f = file(self.released_dat, 'w')
            self.createDAT(f, True)
            f.close()
        else:
            log.error("Released data for file 'models.dat' has not changed. Not writing to file.")

        if self.unreleased_data_changed:
            if not bool(QFileInfo(self.unreleased_dat).isWritable()):
                log.warn("File %s is write-only. Setting to rw-r-r (0644)" % self.unreleased_dat)
                os.chmod(self.unreleased_dat, 0644)

            log.info("\nWriting to %s" % self.unreleased_dat)
            g = file(self.unreleased_dat, 'w')
            self.createDAT(g, False)
            g.close()
        else:
            log.error("Unreleased data for file 'unreleased.dat' has not changed. Not writing to file.")


    def createDAT(self, output, released=True):
        tab = ' '*4
        output.write(preamble % (time.strftime("%a, %d %b %Y %H:%M:%S"), prop.username, self.version))
        output.write("\n\n")

        mm = self.models.keys()
        mm.sort()

        num_written = 0
        for m in mm:
            is_released = bool(int(self.models[m]['support-released']) == 1)

            if is_released == released:
                output.write("\n")
                self.createDATModel(output, m)
                num_written += 1

        output.write("\n")
        output.write(epilogue)

        log.info("Wrote %d models to file." % num_written)

    def changes_button_clicked(self): # Diff
        #f = tempfile.NamedTemporaryFile()
        #name = f.name
        #self.createXML(f)
        #f.flush()
        #os.system("kompare %s %s" % (current_xml_file, name))
        pass


    #
    # RELEASE MODEL
    #

    def releasePushButton_clicked(self):
        unreleased_versions = []

        for m in self.models:
            if int(self.models[m]['support-released']) == 0 and int(self.models[m]['support-type']) > 0:
                ver = self.models[m]['support-ver']

                if ver not in unreleased_versions:
                    unreleased_versions.append(ver)

        unreleased_versions.sort()

        l = QStringList()
        for v in unreleased_versions:
            l.append(v)

        version, ok = QInputDialog.getItem("Mark Version as Released", "Choose Version:", l)

        if ok:
            version = str(version)

            released_list = []

            for m in self.models:
                ver = self.models[m]['support-ver']
                released = bool(int(self.models[m]['support-released']) == 1)

                if ver == version and released:
                    self.models[m]['support-released'] = 1
                    self.change_log.append("%s: Model released (support-released=1)" % m)

                    released_list.append(m)

            print released_list

            if released_list:
                self.released_data_changed = self.unreleased_data_changed = True

            QMessageBox.information(self,
             "Release Printers",
             "<b>The following printers were marked as released:</b><p>%s " % ', '.join(released_list),
              QMessageBox.Ok,
              QMessageBox.NoButton,
              QMessageBox.NoButton)

            self.loadModelListbox()
            self.updateDynamicTabs()


    #
    # FILTER MODELS
    #

    def filterPushButton_clicked(self):
        filter, ok = QInputDialog.getText("Device List Filter", "Input Filter (key=value,key=value,...)(Null string will display all):", QLineEdit.Normal, self.filter)

        if ok:
            self.filter = str(filter)

            self.loadModelListbox()

    #
    # MISC
    #

    def FailureUI(self, error_text):
        QMessageBox.critical(self,
                             self.caption(),
                             error_text,
                              QMessageBox.Ok,
                              QMessageBox.NoButton,
                              QMessageBox.NoButton)


    #
    # MODEL GROUPS
    #

    def create_model_groups(self):
        match_list = []

        for m1 in self.models:
            update_spinner()

            for t in match_list:
                if m1 in t:
                    break
            else:
                match_list.append([m1])

            match = False

            for m2 in self.models:
                if m1 != m2:

                    k1 = self.models[m1]
                    k2 = self.models[m2]

                    match = True
                    keys = set()
                    keys.update(k1.keys())
                    keys.update(k2.keys())

                    for k in keys:
                        if k not in ('id', 'icon', 'support-ver', 'support-released') and \
                            not k.endswith('sku') and \
                            not k.startswith('model'):

                            try:
                                match = k1[k] == k2[k]
                            except KeyError:
                                match = False
                                break

                            if not match:
                                break

                    if not match:
                        continue

                    for t in match_list:
                        if m1 in t and m2 not in t:
                            t.append(m2)
                            break

        cleanup_spinner()
        print

        self.print_heading("GROUPED")

        for m in match_list:
            if len(m) > 1:
                print ", ".join(m)
                print

        self.print_heading("UNGROUPED")

        for m in match_list:
            if len(m) == 1:
                print m[0]


    def groupsPushButton_clicked(self):
        self.create_model_groups()

    #
    # EXPORT MODELS
    #

    def exportPushButton_clicked(self):
        export = file("model_export.csv", "w")

        all_keys = []
        for m in self.models:
            for k in self.models[m]:
                if k not in all_keys and 'agent' not in k and 'tech-class' not in k and 'tech-subclass' not in k:
                    all_keys.append(k)

        all_keys.sort()
        export.write(','.join(['model'] + all_keys))
        export.write('\n')

        for m in self.models:
            data = []
            for k in ['model'] + all_keys:
                try:
                    value = str(self.models[m][k])
                except KeyError:
                    if k == 'model':
                        value = m
                    else:
                        value = ''

                data.append(value)

            export.write(','.join(data))
            export.write('\n')

        self.print_heading("EXPORT")
        print "Output written to model_export.csv\n"

        export.close()


    #
    # COMPARE MODELS
    #

    def comparePushButton_clicked(self):
        models = self.models.keys()
        models.sort()

        l = QStringList()
        for m in models:
            if m != self.current_model:
                l.append(m)

        compare_model, ok = QInputDialog.getItem("Compare to Model", "Choose Model for Comparison:", l)

        if ok:
            compare_model = str(compare_model)

            self.print_heading("COMPARE")
            print "Compare model %s with model %s (only fields that differ are shown):" % (self.current_model, compare_model)
            print

            all_keys = []

            all_keys = []
            for m in [self.current_model, compare_model]:
                for k in self.models[m]:
                    if k not in all_keys:
                        all_keys.append(k)

            all_keys.sort()

            formatter = utils.TextFormatter(
                (
                    {'width': 28, 'margin' : 2},
                    {'width': 48, 'margin' : 2},
                    {'width': 48, 'margin' : 2},
                )
            )

            print log.bold(formatter.compose(("Key", self.current_model, compare_model)))
            print formatter.compose(('-'*28, '-'*48, '-'*48))

            for k in all_keys:
                try:
                    current_model_value = str(self.models[self.current_model][k])
                except KeyError:
                    current_model_value = '(key not found)'

                try:
                    compare_model_value = str(self.models[compare_model][k])
                except KeyError:
                    compare_model_value = '(key not found)'

                if current_model_value != compare_model_value:
                    print formatter.compose((k, current_model_value, compare_model_value))

            print

    def print_heading(self, heading):
        heading = '| ' + heading + ' |'
        print
        print log.bold('-' * len(heading))
        print log.bold(heading)
        print log.bold('-' * len(heading))
        print
