# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.media_uri import MediaUri
from elisa.core.common import application
from elisa.core.resource_manager import NoMatchingResourceProvider, \
                                        ResourceProviderNotFound

from elisa.core.utils.i18n import install_translation

from twisted.internet import defer
from elisa.plugins.poblesec.link import Link
from elisa.plugins.poblesec.actions import GoToNode, GoToAction

_ = install_translation('poblesec')

def flickr_settings_decorator(controller):

    provider_path = 'elisa.plugins.flickr.resource_provider:FlickrResourceProvider'
    manager = application.resource_manager
    try:
        # the name of this method is way to long!
        provider = manager.get_resource_provider_by_path(provider_path)
    except ResourceProviderNotFound:
        return defer.fail(ResourceProviderNotFound('for Flickr'))

    link = Link()
    link.controller_path = "/poblesec/settings/flickr/username"
    link.label = _("Flickr Account")
    link.icon = "elisa.plugins.flickr.logo"

    login_actions = []

    flickr_section_action = GoToAction(controller)
    flickr_section_action.label = _("Go To Flickr Section")
    flickr_section_node = GoToNode()
    flickr_section_node.path = '/poblesec/flickr/home'
    flickr_section_node.title = _("Flickr")
    flickr_section_action.nodes.append(flickr_section_node)
    login_actions.append(flickr_section_action)

    link.controller_args = {
        'service': 'Flickr',
        'password_controller': '/poblesec/settings/flickr/password',
        'login_result_controller': '/poblesec/settings/flickr/login_result',
        'try_login': lambda username, password: provider.login(username, password),
        'login_actions': login_actions}

    controller.model.append(link)

    return defer.succeed(None)
