import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-shoutcast',
    version='0.1', 
    description='Shoutcast.com website support',
    long_description='Can access the shoutcast-server for radio streams',
    license='UNKNOWN', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['elisa-plugin-poblesec'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.mo', '*.po', '*.conf'],
                  'elisa.plugins.shoutcast.i18n': ['*/LC_MESSAGES/*.po', '*.pot'],
                 },
    entry_points="""\
    [elisa.core.components.resource_provider]
    ShoutcastResource = elisa.plugins.shoutcast.shoutcast_resource:ShoutcastResource
    """,
    controller_mappings=[('/poblesec/shoutcast',
                          'elisa.plugins.shoutcast.controller:ShoutcastListSwitcherController')],
    decorator_mappings=[('/poblesec/music/internet',
                         'elisa.plugins.shoutcast.controller:shoutcast_decorator')],
    cmdclass=cmdclass)
