import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

#FIXME: add dependency on storm/twisted-wrapper

setup(name='elisa-plugin-database',
    version='0.1', 
    description="Database management support",
    long_description="""Scan the media and store it in the database to make it easier""",
    license='UNKNOWN', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    entry_points="",
    controller_mappings=[('/poblesec/database/artists',
                          'elisa.plugins.database.controller:ArtistsListSwitcher'),
                         ('/poblesec/database/albums',
                          'elisa.plugins.database.controller:AlbumsListSwitcher'),
                         ('/poblesec/database/played',
                          'elisa.plugins.database.playlists_controller:PlayedListSwitcher'),
                         ('/poblesec/database/added',
                          'elisa.plugins.database.playlists_controller:AddedListSwitcher'),
                         ('/poblesec/database/genre',
                          'elisa.plugins.database.controller:GenreListSwitcher'),
                         ('/poblesec/database/genres',
                          'elisa.plugins.database.controller:GenresController'),
                         ('/poblesec/database/time',
                          'elisa.plugins.database.controller:TimeListSwitcher'),
                        ('/poblesec/database/playlists',
                          'elisa.plugins.poblesec.section:SectionMenuController'),
                         ('/poblesec/database/decades',
                          'elisa.plugins.database.controller:DecadesController'),
                         ('/poblesec/database/music_library',
                          'elisa.plugins.poblesec.section:SectionMenuController'),
                         ('/poblesec/database/tracks',
                          'elisa.plugins.database.controller:TracksListSwitcher'),],
    decorator_mappings=[
                        # FIXME: this decorator should not be here but in the
                        # poblesec plugin; this works around an ordering issue
                        # in the menus.
                        ('/poblesec/database/music_library',
                        'elisa.plugins.poblesec.music:filesystem_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.controller:music_lib_decades_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.controller:music_lib_genres_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.controller:music_lib_tracks_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.controller:music_lib_albums_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.controller:music_lib_artists_decorator'),
                        ('/poblesec/database/playlists',
                         'elisa.plugins.database.playlists_controller:recently_added_tracks_decorator'),
                        ('/poblesec/database/playlists',
                         'elisa.plugins.database.playlists_controller:most_played_tracks_decorator'),
                        ('/poblesec/database/playlists',
                         'elisa.plugins.database.playlists_controller:last_played_tracks_decorator'),
                        ('/poblesec/database/artists',
                         'elisa.plugins.database.scanning_widget:scanning_decorator'),
                        ('/poblesec/database/tracks',
                         'elisa.plugins.database.scanning_widget:scanning_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.scanning_widget:scanning_decorator'),
                        ('/poblesec/database/genres',
                         'elisa.plugins.database.scanning_widget:scanning_decorator'),
                        ('/poblesec/database/genre',
                         'elisa.plugins.database.scanning_widget:scanning_decorator'),
                        ('/poblesec/database/albums',
                         'elisa.plugins.database.scanning_widget:scanning_decorator'),],
    cmdclass=cmdclass,
)
