# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.poblesec.sliced_image import SlicedImageHorizontal
from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.poblesec.list_controller import ListController
from elisa.plugins.pigment.widgets.list_vertical import ListVertical

from elisa.core.input_event import *

class VerticalListController(ListController):
    
    node_widget = None
    list_widget = ListVertical

    def nodes_setup(self):
        super(VerticalListController, self).nodes_setup()
        # FIXME: bad naming: looks like a model not a widget
        self.nodes = self.list_widget(self.node_widget, visible_range_size=9)
        self.widget.add(self.nodes)
        self.nodes.width, self.nodes.height = (0.5, 0.8)
        self.nodes.x, self.nodes.y = (0.05, (1.0-self.nodes.height)/2.0)
        self.nodes.visible = True
        self.nodes.focus = True

        # selector setup
        selector = SlicedImageHorizontal()
        theme = self.frontend.get_theme()
        left_cap = theme.get_resource('elisa.plugins.poblesec.selector_left_cap')
        right_cap = theme.get_resource('elisa.plugins.poblesec.selector_right_cap')
        body = theme.get_resource('elisa.plugins.poblesec.selector_body')
        selector.left_cap.set_from_file(left_cap)
        selector.right_cap.set_from_file(right_cap)
        selector.body.set_from_file(body)

        self.nodes.set_selector(selector)

    def handle_input(self, manager, input_event):
        if self.nothing_to_display_widget.visible:
            return False

        if input_event.value == EventValue.KEY_GO_UP:
            self.nodes.selected_item_index -= 1
            return True
        elif input_event.value == EventValue.KEY_GO_DOWN:
            self.nodes.selected_item_index += 1
            return True
        else:
            return super(VerticalListController, self).handle_input(manager, input_event)
