# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

import pgm, math

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.pigment.graph.text import Text

from pgm.timing import implicit


from elisa.core.resource_manager import NoMatchingResourceProvider
from elisa.core.media_uri import MediaUri
from elisa.core import common

# i18n
from elisa.core.utils.i18n import install_translation
_ = install_translation('database')

from twisted.internet import reactor, defer

class ScannerWidget(Widget):
    def __init__(self):
        super(ScannerWidget, self).__init__()
        
        self.image = Image()
        self.add(self.image)
        self.image.bg_a = 0
        self.image.visible = True
        self.image.x = 0.85
        self.image.y = 0.0
        self.image.width = 0.15
        self.image.height = 1
        self.text = Text()
        self.add(self.text)
        self.text.bg_a = 0
        self.text.font_family = "Liberation Sans"
        self.text.font_height = 1
        self.text.alignment = pgm.TEXT_ALIGN_RIGHT
        self.text.y = 0.25
        self.text.width = 0.80
        self.text.height = 0.5
        self.text.visible = True
        self.text.fg_color = (102, 102, 102, 255)
       
        # create animation stuff
        self.animated = implicit.AnimatedObject(self)
        self._rotation_matrix = pgm.mat4x4_new_identity()
        self._rotation_matrix.translate(0.5, 0.5, 0.0)
        self._rotation_matrix.rotate_z(-math.pi / 30.0)
        self._rotation_matrix.translate(-0.5, -0.5, 0.0)

    def running__set(self, running):
        if running:
            self.opacity = 255
            # possible bug: running = false and running = true could lead to
            # having the loop running twice
            self._transform_mapping_matrix_cb()
        else:
            self.opacity = 0

    running = property(fset=running__set)

    def _transform_mapping_matrix_cb(self):
        if self.opacity and self.visible:
            # only do the animation as long as we are shown
            self.image.mapping_matrix *= self._rotation_matrix
            reactor.callLater(0.017, self._transform_mapping_matrix_cb)

def scanning_decorator(controller):
    uri = MediaUri("media_scanner://localhost/statistic")
    try:
        model, dfr = common.application.resource_manager.get(uri)
    except NoMatchingResourceProvider, e:
        # Media Scanner not installed
        return defer.fail(e)

    widget = ScannerWidget()
    controller.widget.add(widget)

    theme = controller.frontend.get_theme()

    wait_icon = theme.get_resource("elisa.plugins.poblesec.waiting_icon")
    widget.opacity = 0
    widget.visible = True
    widget.image.set_from_file(wait_icon)
    widget.width = 0.20
    widget.height = 0.075
    widget.x = 0.78
    widget.y = 0.925
    widget.text.label = _('Scanning Media')

    model.bind('running', widget, 'running')

    return defer.succeed(widget)

