# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


from elisa.plugins.base.models.file_model import FileModel

class DirectoryModel(FileModel):
    """
    A directory model is a certain type of 
    L{elisa.plugins.base.models.file_model.FileModel} with the difference that
    it can contain other FileModels. They get stored in C{files}.

    You can identify a DirectoryModel by doing the isinstance on it or check
    the C{media_type}. This always returns 'directory' on directory models.

    Another slight difference between a Directory and a FileModel is that the
    size of a directory is always 0 (platform independent).
    """
    def __init__(self):
        super(DirectoryModel, self).__init__()
        self.files = []

    def get_media_type(self):
        return u"directory"

    def get_size(self):
        return 0

    def _null(self, *args):
        pass

    # ignore setting of media_type and size
    size = property(fget=get_size, fset=_null)
    media_type = property(fget=get_media_type, fset=_null)
