# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

"""
The device based models
"""


from elisa.core.components.model import Model

class VolumesModel(Model):
    """
    Retrieved Volumes.

    @ivar filter: the filters that are applied as comma separated values
    @type filter: C{str}
    @ivar volumes: the volumes applying to the filter
    @type volues: C{list}
    """
    def __init__(self):
        super(VolumesModel, self).__init__()
        self.filter = None
        self.volumes = []

class DeviceModel(Model):
    """
    A generic description of a device.

    *Note*: A DeviceModel is considered the same, if the udi is the same.

    @ivar udi:      the unique id for that certain device
    @type udi:      C{str}
    @ivar protocol: the protocol to access this device (like dvd or cdda)
    @type protocol: C{str}
    @ivar device:   string to identify the device (on linux /dev/something)
    @type device:   C{str}
    """
    def __init__(self):
        super(DeviceModel, self).__init__()
        self.udi = None
        self.protocol = None
        self.device = None

    def __eq__(self, other):
        if not isinstance(other, DeviceModel):
            return False
        return other.udi == self.udi

    def __ne__(self, other):
        return not self.__eq__(other)

class VolumeModel(DeviceModel):
    """
    A Volume found. Beside the informations of the L{DeviceModel} it has a:

    @ivar mount_point:  the path to access it
    @type mount_point:  C{elisa.core.media_uri.MediaUri}
    @ivar label:        (optional) if the filesystem has a label
    @type label:        C{str}
    """
    def __init__(self, udi=None):
        super(VolumeModel, self).__init__()
        self.mount_point = None
        self.label = None
        self.protocol = "file"

