import sys
import os
import os.path
import glob
import shutil

try:
    import epydoc
except ImportError:
    print "To get better layout docstrings Epydoc is required"
try:
    from pydoctor.driver import main
except ImportError:
    print "pydoctor is required to generate the API reference, please install it"
    sys.exit(1)

def clean():
    for element in glob.glob(os.path.join('docs', 'api', '*')):
        if os.path.isfile(element):
            os.remove(element)
        elif os.path.isdir(element):
            shutil.rmtree(element)

if __name__ == '__main__':
    clean()
    config_file = os.path.join("elisa-core", "data", "pydoctor.cfg")
    args = ["--make-html", "-c"+config_file]
    sys.exit(main(args))
