# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
This module provides access to the singleton application.

@var  application: the Elisa application
@type application: L{elisa.core.application.Application}
"""

__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'

application = None

def set_application(app):
    """
    Set the L{application} singleton's value. Overrides previous value.

    @param app: the new singleton's value
    @type app:  L{Application}
    """
    global application
    application = app
