/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _EXPO_OPTIONS_H
#define _EXPO_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    ExpoDisplayOptionExpoKey,
    ExpoDisplayOptionExpoButton,
    ExpoDisplayOptionExpoEdge,
    ExpoDisplayOptionDoubleClickTime,
    ExpoDisplayOptionDndButton,
    ExpoDisplayOptionExitButton,
    ExpoDisplayOptionNextVpButton,
    ExpoDisplayOptionPrevVpButton,
    ExpoDisplayOptionZoomTime,
    ExpoDisplayOptionExpoImmediateMove,
    ExpoDisplayOptionExpoAnimation,
    ExpoDisplayOptionDeform,
    ExpoDisplayOptionDistance,
    ExpoDisplayOptionVpDistance,
    ExpoDisplayOptionAspectRatio,
    ExpoDisplayOptionCurve,
    ExpoDisplayOptionHideDocks,
    ExpoDisplayOptionMipmaps,
    ExpoDisplayOptionMultioutputMode,
    ExpoDisplayOptionVpBrightness,
    ExpoDisplayOptionVpSaturation,
    ExpoDisplayOptionReflection,
    ExpoDisplayOptionGroundColor1,
    ExpoDisplayOptionGroundColor2,
    ExpoDisplayOptionGroundSize,
    ExpoDisplayOptionScaleFactor,
    ExpoDisplayOptionNum
} ExpoDisplayOptions;

typedef void (*expoDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, ExpoDisplayOptions num);

CompOption *expoGetDisplayOption (CompDisplay *d, ExpoDisplayOptions num);

typedef enum
{
    ExpoScreenOptionNum
} ExpoScreenOptions;

typedef void (*expoScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, ExpoScreenOptions num);

CompOption *expoGetScreenOption (CompScreen *s, ExpoScreenOptions num);

typedef enum
{
    ExpoAnimationZoom = 0,
    ExpoAnimationFadeZoom = 1,
    ExpoAnimationVortex = 2,
} ExpoExpoAnimationEnum;

typedef enum
{
    DeformNone = 0,
    DeformTilt = 1,
    DeformCurve = 2,
} ExpoDeformEnum;

typedef enum
{
    MultioutputModeOneBigWall = 0,
    MultioutputModeOneWallPerOutput = 1,
} ExpoMultioutputModeEnum;

CompAction *     expoGetExpoKey (CompDisplay *d);
void             expoSetExpoKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             expoSetExpoKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     expoGetExpoKeyOption (CompDisplay *d);
void             expoSetExpoKeyNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

CompAction *     expoGetExpoButton (CompDisplay *d);
void             expoSetExpoButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             expoSetExpoButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     expoGetExpoButtonOption (CompDisplay *d);
void             expoSetExpoButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

CompAction *     expoGetExpoEdge (CompDisplay *d);
void             expoSetExpoEdgeInitiate (CompDisplay *d, CompActionCallBackProc init);
void             expoSetExpoEdgeTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     expoGetExpoEdgeOption (CompDisplay *d);
void             expoSetExpoEdgeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

int              expoGetDoubleClickTime (CompDisplay *d);
CompOption *     expoGetDoubleClickTimeOption (CompDisplay *d);
void             expoSetDoubleClickTimeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

CompAction *     expoGetDndButton (CompDisplay *d);
void             expoSetDndButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             expoSetDndButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     expoGetDndButtonOption (CompDisplay *d);
void             expoSetDndButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

CompAction *     expoGetExitButton (CompDisplay *d);
void             expoSetExitButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             expoSetExitButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     expoGetExitButtonOption (CompDisplay *d);
void             expoSetExitButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

CompAction *     expoGetNextVpButton (CompDisplay *d);
void             expoSetNextVpButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             expoSetNextVpButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     expoGetNextVpButtonOption (CompDisplay *d);
void             expoSetNextVpButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

CompAction *     expoGetPrevVpButton (CompDisplay *d);
void             expoSetPrevVpButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             expoSetPrevVpButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     expoGetPrevVpButtonOption (CompDisplay *d);
void             expoSetPrevVpButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetZoomTime (CompDisplay *d);
CompOption *     expoGetZoomTimeOption (CompDisplay *d);
void             expoSetZoomTimeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

Bool             expoGetExpoImmediateMove (CompDisplay *d);
CompOption *     expoGetExpoImmediateMoveOption (CompDisplay *d);
void             expoSetExpoImmediateMoveNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

int              expoGetExpoAnimation (CompDisplay *d);
CompOption *     expoGetExpoAnimationOption (CompDisplay *d);
void             expoSetExpoAnimationNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

int              expoGetDeform (CompDisplay *d);
CompOption *     expoGetDeformOption (CompDisplay *d);
void             expoSetDeformNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetDistance (CompDisplay *d);
CompOption *     expoGetDistanceOption (CompDisplay *d);
void             expoSetDistanceNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetVpDistance (CompDisplay *d);
CompOption *     expoGetVpDistanceOption (CompDisplay *d);
void             expoSetVpDistanceNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetAspectRatio (CompDisplay *d);
CompOption *     expoGetAspectRatioOption (CompDisplay *d);
void             expoSetAspectRatioNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetCurve (CompDisplay *d);
CompOption *     expoGetCurveOption (CompDisplay *d);
void             expoSetCurveNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

Bool             expoGetHideDocks (CompDisplay *d);
CompOption *     expoGetHideDocksOption (CompDisplay *d);
void             expoSetHideDocksNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

Bool             expoGetMipmaps (CompDisplay *d);
CompOption *     expoGetMipmapsOption (CompDisplay *d);
void             expoSetMipmapsNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

int              expoGetMultioutputMode (CompDisplay *d);
CompOption *     expoGetMultioutputModeOption (CompDisplay *d);
void             expoSetMultioutputModeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetVpBrightness (CompDisplay *d);
CompOption *     expoGetVpBrightnessOption (CompDisplay *d);
void             expoSetVpBrightnessNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetVpSaturation (CompDisplay *d);
CompOption *     expoGetVpSaturationOption (CompDisplay *d);
void             expoSetVpSaturationNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

Bool             expoGetReflection (CompDisplay *d);
CompOption *     expoGetReflectionOption (CompDisplay *d);
void             expoSetReflectionNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

unsigned short * expoGetGroundColor1 (CompDisplay *d);
unsigned short   expoGetGroundColor1Red (CompDisplay *d);
unsigned short   expoGetGroundColor1Green (CompDisplay *d);
unsigned short   expoGetGroundColor1Blue (CompDisplay *d);
unsigned short   expoGetGroundColor1Alpha (CompDisplay *d);
CompOption *     expoGetGroundColor1Option (CompDisplay *d);
void             expoSetGroundColor1Notify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

unsigned short * expoGetGroundColor2 (CompDisplay *d);
unsigned short   expoGetGroundColor2Red (CompDisplay *d);
unsigned short   expoGetGroundColor2Green (CompDisplay *d);
unsigned short   expoGetGroundColor2Blue (CompDisplay *d);
unsigned short   expoGetGroundColor2Alpha (CompDisplay *d);
CompOption *     expoGetGroundColor2Option (CompDisplay *d);
void             expoSetGroundColor2Notify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetGroundSize (CompDisplay *d);
CompOption *     expoGetGroundSizeOption (CompDisplay *d);
void             expoSetGroundSizeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

float            expoGetScaleFactor (CompDisplay *d);
CompOption *     expoGetScaleFactorOption (CompDisplay *d);
void             expoSetScaleFactorNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
