/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undodat.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 16:31:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_UNDODAT_HXX
#define SC_UNDODAT_HXX

#ifndef SC_UNDOBASE_HXX
#include "undobase.hxx"
#endif

#ifndef SC_RANGEUTL_HXX
#include "rangeutl.hxx"		// ScArea
#endif

#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"		// ScRangeListRef
#endif

#ifndef SC_MARKDATA_HXX
#include "markdata.hxx"
#endif

#ifndef SC_SORTPARAM_HXX
#include "sortparam.hxx"
#endif
namespace binfilter {


class ScDocShell;
class ScDocument;
class ScOutlineTable;
class ScRangeName;
class ScDBData;
class ScDBCollection;
class ScPivot;
class ScDPObject;

//----------------------------------------------------------------------------



















class ScUndoDBData: public ScSimpleUndo
{
public:
					ScUndoDBData( ScDocShell* pNewDocShell,
							ScDBCollection* pNewUndoColl, ScDBCollection* pNewRedoColl );
	virtual 		~ScUndoDBData();

	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;

private:
	ScDBCollection* pUndoColl;
	ScDBCollection* pRedoColl;
};












class ScUndoChartData: public ScSimpleUndo
{
public:
						ScUndoChartData( ScDocShell* pNewDocShell,
								const String& rName, const ScRange& rNew,
								BOOL bColHdr, BOOL bRowHdr, BOOL bAdd );
						ScUndoChartData( ScDocShell* pNewDocShell,
								const String& rName, const ScRangeListRef& rNew,
								BOOL bColHdr, BOOL bRowHdr, BOOL bAdd );
	virtual 			~ScUndoChartData();



private:
	String				aChartName;
	ScRangeListRef		aOldRangeListRef;
	BOOL				bOldColHeaders;
	BOOL				bOldRowHeaders;
//	ScRange				aNewRange;
	ScRangeListRef		aNewRangeListRef;
	BOOL				bNewColHeaders;
	BOOL				bNewRowHeaders;
	BOOL				bAddRange;

};




} //namespace binfilter
#endif

