/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ToolBarController.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 16:12:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_FRAMEWORK_TOOL_BAR_CONTROLLER_HXX
#define SD_FRAMEWORK_TOOL_BAR_CONTROLLER_HXX

#include "MutexOwner.hxx"

#include "ToolBarManager.hxx"

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XTOOLBARCONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XToolBarController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XCONFIGURATIONCONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XConfigurationController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XMODULECONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XModuleController.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _CPPUHELPER_COMPBASE3_HXX_
#include <cppuhelper/compbase3.hxx>
#endif

#include <boost/scoped_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/function.hpp>



namespace {

typedef ::cppu::WeakComponentImplHelper3 <
    ::com::sun::star::drawing::framework::XToolBarController,
    ::com::sun::star::lang::XInitialization,
    ::com::sun::star::lang::XEventListener
    > ToolBarControllerInterfaceBase;

} // end of anonymous namespace.

namespace sd {
class ViewShellBase;
}

namespace sd { namespace framework {

class FactoryContainer;

/** At the moment this class is a placeholder.  It soon will take over the
    work from view/ToolBarManager.
*/
class ToolBarController
    : private sd::MutexOwner,
      public ToolBarControllerInterfaceBase      
{
public:
    ToolBarController (
        const ::com::sun::star::uno::Reference<com::sun::star::uno::XComponentContext>& rxContext)
        throw();
    virtual void SAL_CALL disposing (void);

    
    // XToolbarController

    virtual void SAL_CALL addToolBarFactory (
        const ::rtl::OUString& rsToolBarURL,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XToolBarFactory>& rxToolBarFactory)
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL removeToolBarFactoryForURL (
        const ::rtl::OUString& rsToolBarURL)
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL removeToolBarFactoryForReference (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XToolBarFactory>& rxToolBarFactory)
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XToolBar>
        SAL_CALL getToolBar (
            const ::com::sun::star::uno::Reference<
                com::sun::star::drawing::framework::XResourceId>& rxToolBarId)
        throw (::com::sun::star::uno::RuntimeException);


    // XResourceController

    virtual void SAL_CALL updateStart (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxRequestedConfiguration,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxCurrentConfiguration,
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId> >& rxResourcesToDeactivate)
        throw (::com::sun::star::uno::RuntimeException);
    
    virtual void SAL_CALL updateEnd (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxRequestedConfiguration,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxCurrentConfiguration,
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId> >& rxResourcesToActivate)
        throw (::com::sun::star::uno::RuntimeException);

    // XInitialization
    
    virtual void SAL_CALL initialize(
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Any>& aArguments)
        throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);

    
    // XEventListener
    
    virtual void SAL_CALL disposing (const com::sun::star::lang::EventObject& rEventObject)
        throw (com::sun::star::uno::RuntimeException);

private:
    ViewShellBase* mpBase;
    ::boost::scoped_ptr<ToolBarManager::UpdateLock> mpToolBarManagerLock;
    ::com::sun::star::uno::Reference<
        com::sun::star::frame::XController> mxController;
    ::com::sun::star::uno::Reference<
        com::sun::star::drawing::framework::XConfigurationController> mxConfigurationController;

    ::boost::scoped_ptr<FactoryContainer> mpFactoryContainer;

    class ToolBarDescriptor;
    class ToolBarContainer;
    ::boost::scoped_ptr<ToolBarContainer> mpToolBarContainer;

    bool mbMainViewSwitchUpdatePending;
    
    ToolBarController (void); // Not implemented.
	virtual ~ToolBarController (void) throw();

    /** Create the specified tool bar and return wether the creation was
        successfull.
    */
    bool CreateToolBar (const ::com::sun::star::uno::Reference<
        com::sun::star::drawing::framework::XResourceId>& rxToolBarId);

    /** Release the specified tool bar and return if that was successfull.
    */
    bool ReleaseToolBar(
        const ::com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId>& rxToolBarId);

    /** Return the descriptor of the specified tool bar.  If the tool bar
        can not be found then an empty descriptor is returned.
    */
    ToolBarDescriptor GetActiveToolBar (
        const ::com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId>& rxToolBarId) const;

    void ThrowIfDisposed (void) const
        throw (::com::sun::star::lang::DisposedException);
};

} } // end of namespace sd::framework

#endif
