/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: commandenvironment.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: ihi $ $Date: 2007/06/05 14:47:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _UCBHELPER_COMMANDENVIRONMENT_HXX
#define _UCBHELPER_COMMANDENVIRONMENT_HXX

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMMANDENVIRONMENT_HPP_
#include <com/sun/star/ucb/XCommandEnvironment.hpp>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _UCBHELPER_MACROS_HXX
#include <ucbhelper/macros.hxx>
#endif
#ifndef INCLUDED_UCBHELPERDLLAPI_H
#include "ucbhelper/ucbhelperdllapi.h"
#endif

namespace ucbhelper
{

struct CommandEnvironment_Impl;

//=========================================================================

/**
  * This class implements the interface
  * com::sun::star::ucb::XCommandEnvironement. Instances of this class can
  * be used to supply environments to commands executed by UCB contents.
  */
class UCBHELPER_DLLPUBLIC CommandEnvironment : public cppu::OWeakObject,
						   public com::sun::star::lang::XTypeProvider,
						   public com::sun::star::ucb::XCommandEnvironment
{
	CommandEnvironment_Impl* m_pImpl;

private:
	UCBHELPER_DLLPRIVATE CommandEnvironment( const CommandEnvironment& ); 				// n.i.
    UCBHELPER_DLLPRIVATE CommandEnvironment& operator=( const CommandEnvironment& ); 	// n.i.

public:
	/**
	  * Constructor.
	  *
	  * @param rxInteractionHandler is the implementation of an Interaction
	  *        Handler or an empty reference.
	  * @param rxProgressHandler is the implementation of a Progress
	  *        Handler or an empty reference.
	  */
	CommandEnvironment(
			const com::sun::star::uno::Reference<
				com::sun::star::task::XInteractionHandler >&
					rxInteractionHandler,
			const com::sun::star::uno::Reference<
				com::sun::star::ucb::XProgressHandler >&
					rxProgressHandler );
	/**
	  * Destructor.
	  */
	virtual ~CommandEnvironment();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

 	// XCommandEnvironemnt
	virtual com::sun::star::uno::Reference<
				com::sun::star::task::XInteractionHandler > SAL_CALL
	getInteractionHandler()
		throw ( com::sun::star::uno::RuntimeException );

	virtual com::sun::star::uno::Reference<
				com::sun::star::ucb::XProgressHandler > SAL_CALL
	getProgressHandler()
		throw ( com::sun::star::uno::RuntimeException );
};

} /* namespace ucbhelper */

#endif /* !_UCBHELPER_COMMANDENVIRONMENT_HXX */
