/*
 * Decompiled with CFR 0.152.
 */
package writer2latex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import writer2latex.api.Converter;
import writer2latex.api.ConverterFactory;
import writer2latex.api.ConverterResult;
import writer2latex.api.OutputFile;
import writer2latex.util.Config;
import writer2latex.util.L10n;
import writer2latex.util.Misc;
import writer2latex.xhtml.XhtmlDocument;

public final class Application {
    private String sTargetMIME = "application/x-latex";
    private boolean bRecurse = false;
    private String sConfigFileName = null;
    private String sTemplateFileName = null;
    private Hashtable options = new Hashtable();
    private String sSource = null;
    private String sTarget = null;
    private String sOutputFormat = null;
    private String sOutPathName = null;
    private String sOutFileName = null;
    private String sOutFileExtension = null;
    private byte[] templateBytes = null;
    private XhtmlDocument template = null;
    private Config config;
    L10n l10n;
    boolean bBatch = false;
    String sDefaultLang = null;
    String sDefaultCountry = null;

    public static final void main(String[] args) {
        try {
            Application app = new Application();
            app.parseCommandLine(args);
            app.doConversion();
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage();
            Application.showUsage(msg);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg != null) {
                System.out.println("\n" + msg);
            }
            ex.printStackTrace();
        }
    }

    private void doConversion() {
        String sFullOutFileName;
        String sOutputFormat = "application/x-latex".equals(this.sTargetMIME) ? "LaTeX" : ("application/x-bibtex".equals(this.sTargetMIME) ? "BibTeX" : "xhtml");
        System.out.println();
        System.out.println("This is Writer2" + sOutputFormat + ", Version " + ConverterFactory.getVersion() + " (" + ConverterFactory.getDate() + ")");
        System.out.println();
        System.out.println("Starting conversion...");
        this.config = new Config();
        if (this.sConfigFileName != null) {
            File f = new File(this.sConfigFileName);
            if (!f.exists()) {
                System.err.println("The configuration file '" + this.sConfigFileName + "' does not exist.");
            } else {
                try {
                    this.config.read(new FileInputStream(this.sConfigFileName));
                }
                catch (Throwable t) {
                    System.err.println("I had trouble reading the configuration file " + this.sConfigFileName);
                    t.printStackTrace();
                }
            }
        }
        String string = sFullOutFileName = this.sTarget != null ? this.sTarget : Misc.removeExtension(this.sSource);
        if (sFullOutFileName.endsWith(File.separator)) {
            this.sOutPathName = sFullOutFileName;
            this.sOutFileName = new File(this.sSource).getName();
        } else {
            File f = new File(sFullOutFileName);
            this.sOutPathName = f.getParent();
            this.sOutPathName = this.sOutPathName == null ? "" : this.sOutPathName + File.separator;
            this.sOutFileName = f.getName();
        }
        this.sOutFileName = Misc.removeExtension(this.sOutFileName);
        Enumeration keys = this.options.keys();
        while (keys.hasMoreElements()) {
            String sKey = (String)keys.nextElement();
            String sValue = (String)this.options.get(sKey);
            this.config.setOption(sKey, sValue);
        }
        this.l10n = new L10n();
        this.sDefaultLang = System.getProperty("user.language");
        this.sDefaultCountry = System.getProperty("user.country");
        this.l10n.setLocale(this.sDefaultLang, this.sDefaultCountry);
        File f = new File(this.sSource);
        if (!f.exists()) {
            System.out.println("I'm sorry, I can't find " + this.sSource);
            System.exit(1);
        }
        if (!f.canRead()) {
            System.out.println("I'm sorry, I can't read " + this.sSource);
            System.exit(1);
        }
        if (this.sTemplateFileName != null) {
            try {
                this.templateBytes = Misc.inputStreamToByteArray(new FileInputStream(this.sTemplateFileName));
                this.template = new XhtmlDocument("Template", 0);
                this.template.read(new ByteArrayInputStream(this.templateBytes));
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.template = null;
            }
        }
        if (f.isDirectory()) {
            this.convertDirectory(f, this.sOutPathName);
        } else if (f.isFile()) {
            this.convertFile(f, this.sOutPathName);
        }
        System.out.println("Done!");
    }

    private String convertFile(File file, String sOutPathName) {
        File dir;
        String sFileName = file.getName();
        String sLocalOutFileName = this.bBatch ? Misc.removeExtension(sFileName) : this.sOutFileName;
        System.out.println("Converting " + sFileName);
        ConverterResult dataOut = null;
        ConverterFactory factory = new ConverterFactory();
        factory.setConfig(this.config);
        Converter converter = factory.createConverter(this.sTargetMIME);
        if (converter != null) {
            try {
                if (this.templateBytes != null) {
                    converter.readTemplate(new ByteArrayInputStream(this.templateBytes));
                }
                dataOut = converter.convert(new FileInputStream(file), sLocalOutFileName);
            }
            catch (Exception e) {
                System.out.println(" --> Conversion failed");
                e.printStackTrace();
            }
        }
        if (!(dir = new File(sOutPathName)).exists()) {
            dir.mkdirs();
        }
        Enumeration docEnum = dataOut.getDocumentEnumeration();
        while (docEnum.hasMoreElements()) {
            OutputFile docOut = (OutputFile)docEnum.nextElement();
            String fileName = sOutPathName + docOut.getFileName();
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                docOut.write(fos);
                fos.flush();
                fos.close();
            }
            catch (Exception writeExcept) {
                System.out.println("\nThere was an error writing out file <" + fileName + ">");
                writeExcept.printStackTrace();
            }
        }
        return sLocalOutFileName + this.sOutFileExtension;
    }

    private void convertDirectory(File dir, String sOutPathName) {
        boolean bUseIcon;
        this.bBatch = true;
        XhtmlDocument htmlDoc = new XhtmlDocument("index", 0);
        htmlDoc.setEncoding(this.config.xhtmlEncoding());
        htmlDoc.setNoDoctype(this.config.xhtmlNoDoctype());
        if (this.templateBytes != null) {
            htmlDoc.readFromTemplate(this.template);
        } else {
            htmlDoc.createHeaderFooter();
        }
        Document htmlDOM = htmlDoc.getContentDOM();
        htmlDoc.getTitleNode().appendChild(htmlDOM.createTextNode(dir.getName()));
        Element meta = htmlDOM.createElement("meta");
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", "text/html; charset=" + htmlDoc.getEncoding().toLowerCase());
        htmlDoc.getHeadNode().appendChild(meta);
        if (this.config.xhtmlCustomStylesheet().length() > 0) {
            Element htmlStyle = htmlDOM.createElement("link");
            htmlStyle.setAttribute("rel", "stylesheet");
            htmlStyle.setAttribute("type", "text/css");
            htmlStyle.setAttribute("media", "all");
            htmlStyle.setAttribute("href", this.config.xhtmlCustomStylesheet());
            htmlDoc.getHeadNode().appendChild(htmlStyle);
        }
        Element header = htmlDoc.getHeaderNode();
        if (this.config.getXhtmlUplink().length() > 0) {
            Element a = htmlDOM.createElement("a");
            a.setAttribute("href", this.config.getXhtmlUplink());
            a.appendChild(htmlDOM.createTextNode(this.l10n.get(0)));
            header.appendChild(htmlDOM.createTextNode("["));
            header.appendChild(a);
            header.appendChild(htmlDOM.createTextNode("] "));
        } else {
            header.appendChild(htmlDOM.createTextNode("[" + this.l10n.get(0) + "]"));
        }
        header.appendChild(htmlDOM.createElement("hr"));
        Element footer = htmlDoc.getFooterNode();
        footer.appendChild(htmlDOM.createElement("hr"));
        if (this.config.getXhtmlUplink().length() > 0) {
            Element a = htmlDOM.createElement("a");
            a.setAttribute("href", this.config.getXhtmlUplink());
            a.appendChild(htmlDOM.createTextNode(this.l10n.get(0)));
            footer.appendChild(htmlDOM.createTextNode("["));
            footer.appendChild(a);
            footer.appendChild(htmlDOM.createTextNode("] "));
        } else {
            footer.appendChild(htmlDOM.createTextNode("[" + this.l10n.get(0) + "]"));
        }
        if (sOutPathName.length() > 0) {
            Element h1 = htmlDOM.createElement("h1");
            htmlDoc.getContentNode().appendChild(h1);
            String sSeparator = File.separator;
            if (sSeparator.equals("\\")) {
                sSeparator = "\\\\";
            }
            String sHeading = sOutPathName.substring(0, sOutPathName.length() - 1).replaceAll(sSeparator, " - ");
            h1.appendChild(htmlDOM.createTextNode(sHeading));
        }
        File[] contents = dir.listFiles();
        int nLen = contents.length;
        Collator collator = Collator.getInstance(new Locale(this.sDefaultLang, this.sDefaultCountry));
        int i = 0;
        while (i < nLen) {
            int j = i + 1;
            while (j < nLen) {
                File entryi = contents[i];
                File entryj = contents[j];
                if (collator.compare(entryi.getName(), entryj.getName()) > 0) {
                    contents[i] = entryj;
                    contents[j] = entryi;
                }
                ++j;
            }
            ++i;
        }
        if (this.bRecurse) {
            bUseIcon = this.config.getXhtmlDirectoryIcon().length() > 0;
            int i2 = 0;
            while (i2 < nLen) {
                if (contents[i2].isDirectory()) {
                    this.config.setOption("xhtml_uplink", "../index.html");
                    this.convertDirectory(contents[i2], sOutPathName + contents[i2].getName() + File.separator);
                    Element p = htmlDOM.createElement("p");
                    htmlDoc.getContentNode().appendChild(p);
                    if (bUseIcon) {
                        Element img = htmlDOM.createElement("img");
                        p.appendChild(img);
                        img.setAttribute("src", this.config.getXhtmlDirectoryIcon());
                        img.setAttribute("alt", "Directory icon");
                        p.appendChild(htmlDOM.createTextNode(" "));
                    }
                    Element a = htmlDOM.createElement("a");
                    p.appendChild(a);
                    a.setAttribute("href", Misc.makeHref(contents[i2].getName() + "/index.html"));
                    a.appendChild(htmlDOM.createTextNode(contents[i2].getName()));
                }
                ++i2;
            }
        }
        bUseIcon = this.config.getXhtmlDocumentIcon().length() > 0;
        int i3 = 0;
        while (i3 < nLen) {
            if (contents[i3].isFile()) {
                this.config.setOption("xhtml_uplink", "index.html");
                String sLinkFile = this.convertFile(contents[i3], sOutPathName);
                if (sLinkFile != null) {
                    Element p = htmlDOM.createElement("p");
                    htmlDoc.getContentNode().appendChild(p);
                    if (bUseIcon) {
                        Element img = htmlDOM.createElement("img");
                        p.appendChild(img);
                        img.setAttribute("src", this.config.getXhtmlDocumentIcon());
                        img.setAttribute("alt", "Document icon");
                        p.appendChild(htmlDOM.createTextNode(" "));
                    }
                    Element a = htmlDOM.createElement("a");
                    p.appendChild(a);
                    a.setAttribute("href", Misc.makeHref(sLinkFile));
                    a.appendChild(htmlDOM.createTextNode(Misc.removeExtension(sLinkFile)));
                }
            }
            ++i3;
        }
        File outdir = new File(sOutPathName);
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        String sFileName = sOutPathName + htmlDoc.getFileName();
        try {
            FileOutputStream fos = new FileOutputStream(sFileName);
            htmlDoc.write(fos);
            fos.flush();
            fos.close();
        }
        catch (Exception writeExcept) {
            System.out.println("\nThere was an error writing out file <" + sFileName + ">");
            writeExcept.printStackTrace();
        }
    }

    private static void showUsage(String msg) {
        System.out.println();
        System.out.println("This is Writer2LaTeX, Version " + ConverterFactory.getVersion() + " (" + ConverterFactory.getDate() + ")");
        System.out.println();
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println();
        System.out.println("Usage:");
        System.out.println("   java -jar <path>/writer2latex.jar <options> <source file/directory> [<target file/directory>]");
        System.out.println("where the available options are:");
        System.out.println("   -latex");
        System.out.println("   -bibtex");
        System.out.println("   -xhtml");
        System.out.println("   -xhtml+mathml");
        System.out.println("   -xhtml+mathml+xsl");
        System.out.println("   -recurse");
        System.out.println("   -config[=]<configuration file>");
        System.out.println("   -template[=]<template file>");
        System.out.println("   -<configuration option>[=]<value>");
        System.out.println("See the documentation for the full list of options");
    }

    private void parseCommandLine(String[] sArgs) throws IllegalArgumentException {
        int i = 0;
        while (i < sArgs.length) {
            String sArgument;
            String sArg;
            if ((sArg = this.getArg(i++, sArgs)).startsWith("-")) {
                String sArg2;
                if ("-latex".equals(sArg)) {
                    this.sTargetMIME = "application/x-latex";
                    continue;
                }
                if ("-bibtex".equals(sArg)) {
                    this.sTargetMIME = "application/x-bibtex";
                    continue;
                }
                if ("-xhtml".equals(sArg)) {
                    this.sTargetMIME = "text/html";
                    continue;
                }
                if ("-xhtml+mathml".equals(sArg)) {
                    this.sTargetMIME = "application/xhtml+xml";
                    continue;
                }
                if ("-xhtml+mathml+xsl".equals(sArg)) {
                    this.sTargetMIME = "application/xml";
                    continue;
                }
                if ("-recurse".equals(sArg)) {
                    this.bRecurse = true;
                    continue;
                }
                int j = sArg.indexOf("=");
                if (j > -1) {
                    sArg2 = sArg.substring(j + 1);
                    sArg = sArg.substring(0, j);
                } else {
                    sArg2 = this.getArg(i++, sArgs);
                }
                if ("-config".equals(sArg)) {
                    this.sConfigFileName = sArg2;
                    continue;
                }
                if ("-template".equals(sArg)) {
                    this.sTemplateFileName = sArg2;
                    continue;
                }
                this.options.put(sArg.substring(1), sArg2);
                continue;
            }
            this.sSource = sArg;
            if (i < sArgs.length && (sArgument = this.getArg(i++, sArgs)).length() > 0) {
                this.sTarget = sArgument;
            }
            while (i < sArgs.length) {
                if ((sArgument = this.getArg(i++, sArgs)).length() <= 0) continue;
                throw new IllegalArgumentException("I didn't expect " + sArgument + "?");
            }
        }
        if (this.sSource == null) {
            throw new IllegalArgumentException("Please specify a source document/directory!");
        }
    }

    private String getArg(int i, String[] args) throws IllegalArgumentException {
        if (i < args.length) {
            return args[i];
        }
        throw new IllegalArgumentException("I'm sorry, the commandline ended abnormally");
    }
}

