/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.Vector;
import org.w3c.dom.Element;
import writer2latex.bibtex.BibTeXDocument;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.Context;
import writer2latex.office.BibMark;
import writer2latex.office.IndexMark;
import writer2latex.office.OfficeReader;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class IndexConverter
extends ConverterHelper {
    private BibTeXDocument bibDoc;
    private boolean bContainsAlphabeticalIndex = false;
    private Vector postponedIndexMarks = new Vector();

    public IndexConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bContainsAlphabeticalIndex) {
            pack.append("\\usepackage{makeidx}").nl();
            decl.append("\\makeindex").nl();
        }
    }

    public void handleTOC(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.noIndex()) {
            return;
        }
        Element source = Misc.getChildByTagName(node, "text:table-of-content-source");
        if (source != null) {
            if ("chapter".equals(source.getAttribute("text:index-source"))) {
                ldp.append("[Warning: Table of content (for this chapter) ignored!]").nl().nl();
            } else {
                int nLevel = Misc.getPosInteger(source.getAttribute("text:outline-level"), 1);
                ldp.append("\\setcounter{tocdepth}{" + nLevel + "}").nl();
                Element title = Misc.getChildByTagName(source, "text:index-title-template");
                if (title != null) {
                    ldp.append("\\renewcommand\\contentsname{");
                    this.palette.getInlineCv().traversePCDATA(title, ldp, oc);
                    ldp.append("}").nl();
                }
            }
        }
        ldp.append("\\tableofcontents").nl();
    }

    public void handleLOF(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.noIndex()) {
            return;
        }
        ldp.append("\\listoffigures").nl();
    }

    public void handleLOT(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.noIndex()) {
            return;
        }
        ldp.append("\\listoftables").nl();
    }

    public void handleObjectIndex(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.noIndex()) {
            return;
        }
        ldp.append("[Warning: Object index ignored]").nl().nl();
    }

    public void handleUserIndex(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.noIndex()) {
            return;
        }
        ldp.append("[Warning: User index ignored]").nl().nl();
    }

    public void handleBibliography(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.noIndex()) {
            return;
        }
        if (this.config.useBibtex()) {
            if (this.bibDoc == null) {
                this.bibDoc = new BibTeXDocument(this.palette.getOutFileName());
            }
            ldp.append("\\bibliographystyle{").append(this.config.bibtexStyle()).append("}").nl();
            ldp.append("\\bibliography{").append(this.bibDoc.getName()).append("}").nl();
        } else {
            Element body = Misc.getChildByTagName(node, "text:index-body");
            if (body != null) {
                Element title = Misc.getChildByTagName(body, "text:index-title");
                if (title != null) {
                    this.palette.getBlockCv().traverseBlockText(title, ldp, oc);
                }
                this.palette.getBlockCv().traverseBlockText(body, ldp, oc);
            }
        }
    }

    public void handleBibliographyMark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.useBibtex()) {
            String sIdentifier;
            if (this.bibDoc == null) {
                this.bibDoc = new BibTeXDocument(this.palette.getOutFileName());
            }
            if ((sIdentifier = node.getAttribute("text:identifier")) != null) {
                if (!this.bibDoc.containsKey(sIdentifier)) {
                    this.bibDoc.put(new BibMark(node));
                }
                ldp.append("\\cite{").append(this.bibDoc.getExportName(sIdentifier)).append("}");
            }
        } else {
            this.palette.getInlineCv().traverseInlineText(node, ldp, oc, false);
        }
    }

    public BibTeXDocument getBibTeXDocument() {
        return this.bibDoc;
    }

    public void handleAlphabeticalIndex(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.noIndex()) {
            return;
        }
        ldp.append("\\printindex").nl();
        this.bContainsAlphabeticalIndex = true;
    }

    public void handleAlphabeticalIndexMark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (!(oc.isInSection() || oc.isInCaption() || oc.isVerbatim())) {
            String sValue = IndexMark.getIndexValue(node);
            if (sValue != null) {
                String sKey2;
                ldp.append("\\index{");
                String sKey1 = IndexMark.getKey1(node);
                if (sKey1 != null) {
                    this.writeIndexText(sKey1.trim(), ldp, oc);
                    ldp.append("!");
                }
                if ((sKey2 = IndexMark.getKey2(node)) != null) {
                    this.writeIndexText(sKey2.trim(), ldp, oc);
                    ldp.append("!");
                }
                this.writeIndexText(sValue.trim(), ldp, oc);
                ldp.append("}");
            }
        } else {
            this.postponedIndexMarks.add(node);
        }
    }

    public void flushIndexMarks(LaTeXDocumentPortion ldp, Context oc) {
        if (!(oc.isInSection() || oc.isInCaption() || oc.isVerbatim())) {
            int n = this.postponedIndexMarks.size();
            int i = 0;
            while (i < n) {
                this.handleAlphabeticalIndexMark((Element)this.postponedIndexMarks.get(i), ldp, oc);
                ++i;
            }
            this.postponedIndexMarks.clear();
        }
    }

    private void writeIndexText(String sText, LaTeXDocumentPortion ldp, Context oc) {
        String sTextOut = this.palette.getI18n().convert(sText, false, oc.getLang());
        int nLen = sTextOut.length();
        boolean bBackslash = false;
        int i = 0;
        while (i < nLen) {
            if (bBackslash) {
                ldp.append(sTextOut.substring(i, i + 1));
                bBackslash = false;
            } else {
                switch (sTextOut.charAt(i)) {
                    case '\\': {
                        bBackslash = true;
                        ldp.append("\\");
                        break;
                    }
                    case '~': 
                    case '\u00a0': {
                        ldp.append(" ");
                        break;
                    }
                    case '!': 
                    case '\"': 
                    case '@': 
                    case '|': {
                        ldp.append("\"");
                    }
                    default: {
                        ldp.append(sTextOut.substring(i, i + 1));
                    }
                }
            }
            ++i;
        }
    }
}

