/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.util;

import org.w3c.dom.Element;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class Info
extends ConverterHelper {
    public Info(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void addDebugInfo(Element node, LaTeXDocumentPortion ldp) {
        if (this.config.debug()) {
            ldp.append("% ").append(node.getNodeName());
            this.addDebugInfo(node, ldp, "text:id");
            this.addDebugInfo(node, ldp, "text:name");
            this.addDebugInfo(node, ldp, "table:name");
            this.addDebugInfo(node, ldp, "text:style-name");
            if (node.getNodeName().equals("text:p") || node.getNodeName().equals("text:h")) {
                StyleWithProperties style = this.ofr.getParStyle(node.getAttribute("text:style-name"));
                if (style != null && style.isAutomatic()) {
                    ldp.append(" (" + style.getParentName() + ")");
                }
                ldp.append(" (" + this.ofr.getParStyles().getDisplayName(node.getAttribute("text:style-name")) + ")");
            }
            ldp.nl();
        }
    }

    private void addDebugInfo(Element node, LaTeXDocumentPortion ldp, String sAttribute) {
        String sValue = Misc.getAttribute(node, sAttribute);
        if (sValue != null) {
            ldp.append(" ").append(sAttribute).append("=\"").append(sValue).append("\"");
        }
    }
}

