#! /bin/bash
# Set Axyl distribution permissions
# Execute this script to set the permissions for the Axyl HOME
# distribution tree in its entirety.
#
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
set -e

# Get common funcs and config vars etc.
# Acquire the local configuration..
CONFDIR=/etc/axyl
CONF=${CONFDIR}/axyl.conf
if [ ! -f $CONF ]
then
  echo "Axyl configuration file $CONF not found!"
  exit 2
else
  . $CONF
  if [ ! -d $AXYL_HOME ] ; then
    echo "FATAL: the Axyl root directory '$AXYL_HOME' does not exist."
    exit 6
  fi
  . ${AXYL_HOME}/install/axyl-common.sh
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# ASSERT MAIN INSTALLATION PERMISSIONS and OWNERSHIP
if [ "${AXYL_HOME}" != "" ]
then
  chown -R ${AXUSER}:${AXUSER} ${AXYL_HOME}
  chmod -R 0664 ${AXYL_HOME}
  chmod -R g+sw ${AXYL_HOME}
  find ${AXYL_HOME} -type d -exec chmod a+x {} \;

  # Executable Perl scripts..
  find ${AXYL_HOME} -type f -name "*.pl" -exec chmod ug+x {} \;

  # Php executables in the scripts directory..
  if [ -d ${AXYL_HOME}/scripts ]
  then
    find ${AXYL_HOME}/scripts -type f -name "*.php" -exec chmod ug+x {} \;
  fi

  # Make all shell scripts executable..
  scripts=`find ${AXYL_HOME} -type f -exec grep -l -E -e "(\#\![[:space:]]*\/bin\/bash)|(\#\![[:space:]]*\/bin\/sh)" {} \;`
  if [ "$scripts" != "" ]
  then
    for script in $scripts
    do
      chmod ug+x $script
    done
  fi
fi

# Data area..
if [ "${AXYL_DATA}" != "" ]
then
  chown -R ${AXUSER}:${AXUSER} ${AXYL_DATA}
  find ${AXYL_DATA} -type f -exec chmod 0664 {} \;
  find ${AXYL_DATA} -type d -exec chmod 0755 {} \;
fi

# Logging area..
if [ "${AXYL_LOGS}" != "" ]
then
  chown -R ${AXUSER}:${AXUSER} ${AXYL_LOGS}
  find ${AXYL_LOGS} -type f -exec chmod 0664 {} \;
  find ${AXYL_LOGS} -type d -exec chmod 0755 {} \;
fi

# Axyl config files..
if [ "${CONFDIR}" != "" ]
then
  chown -R ${AXUSER}:${AXUSER} $CONFDIR
  chmod -R 0644 $CONFDIR
  find $CONFDIR -type d -exec chmod 0775 {} \;
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
exit 0