// -*- c-basic-offset: 4 -*-
/*
 *  This file is part of the KDE libraries
 *  Copyright (C) 2007 Maksim Orlovich (maksim@kde.org)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef REFERENCE_H
#define REFERENCE_H

#include "object.h"
#include "property_slot.h"

namespace KJS {

struct Reference {
    //### some protection here!
    PropertySlot  propertySlot;
    bool          found; //note: should fit into padding of above..

    JSObject*     base;  //This isn't the same as slot's base,
                         //as that may be different in case prototypes are involved..
    Identifier    ident;

    Reference() { }

    Reference(const Identifier& i) : ident(i) { }

    // Note: for references, we make sure the slot points to the outer
    // scope if lookup failed..
    JSValue* read(ExecState* exec) {
        return propertySlot.getValue(exec, base, ident);
    }

    void write(ExecState* exec, JSValue* val) {
         if (JSValue** loc = propertySlot.getDirectWriteLocation())
             *loc = val;
         else
            base->put(exec, ident, val);
    }

    bool deleteProperty(ExecState* exec) {
        return base->deleteProperty(exec, ident);
    }
};

}

#endif

// kate: indent-width 4; replace-tabs on; tab-width 4; space-indent on;
