
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: desktop_entry.h 1182 2006-09-22 07:53:33Z mschwerin $
 *
 */
#ifndef HAVE_DESKTOP_ENTRY_H
#define HAVE_DESKTOP_ENTRY_H
#ifdef __cplusplus
extern "C" {
#endif


char *get_localestring_from_desktop_entry (const char *mrl,
                                           const char *group_name,
                                           const char *entry_name);

char *get_string_from_desktop_entry (const char *mrl,
                                     const char *group_name,
                                     const char *entry_name);

int get_boolean_from_desktop_entry (const char *mrl,
                                    const char *group_name,
                                    const char *entry_name);

double get_numeric_from_desktop_entry (const char *mrl,
                                       const char *group_name,
                                       const char *entry_name);

#ifdef __cplusplus
}
#endif
#endif
