
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: event.h 1571 2006-11-19 17:54:55Z mschwerin $
 *
 */

#ifndef HAVE_EVENT_H
#define HAVE_EVENT_H
#ifdef __cplusplus
extern "C" {
#endif

#include <xine.h>

/*
 * oxine global events and keycodes
 */
typedef enum {
    /* xine-lib events going to the frontend */
    OXINE_EVENT_PLAYBACK_FINISHED = XINE_EVENT_UI_PLAYBACK_FINISHED,
    OXINE_EVENT_CHANNELS_CHANGED = XINE_EVENT_UI_CHANNELS_CHANGED,
    OXINE_EVENT_SET_TITLE = XINE_EVENT_UI_SET_TITLE,
    OXINE_EVENT_MESSAGE = XINE_EVENT_UI_MESSAGE,
    OXINE_EVENT_FRAME_FORMAT_CHANGED = XINE_EVENT_FRAME_FORMAT_CHANGE,
    /* xine-lib events coming from the frontend */
    OXINE_EVENT_BUTTON = XINE_EVENT_INPUT_MOUSE_BUTTON,
    OXINE_EVENT_MOTION = XINE_EVENT_INPUT_MOUSE_MOVE,
    /* oxine events going to the frontend */
    OXINE_EVENT_PLAYBACK_STARTED = 1000,
    OXINE_EVENT_PLAYBACK_STOPPED,
    OXINE_EVENT_PLAYBACK_ERROR,
    OXINE_EVENT_WAITING_FOR_ALTERNATIVE,
    OXINE_EVENT_KEY,
    OXINE_EVENT_OUTPUT_FORMAT_CHANGED, // the size of the output window has changed
    OXINE_EVENT_OSD_FORMAT_CHANGED,
} oxine_event_id_t;

typedef enum {
    /* mapped xine keys */
    OXINE_KEY_MENU1 = XINE_EVENT_INPUT_MENU1,
    OXINE_KEY_MENU2 = XINE_EVENT_INPUT_MENU2,
    OXINE_KEY_MENU3 = XINE_EVENT_INPUT_MENU3,
    OXINE_KEY_MENU4 = XINE_EVENT_INPUT_MENU4,
    OXINE_KEY_MENU5 = XINE_EVENT_INPUT_MENU5,
    OXINE_KEY_MENU6 = XINE_EVENT_INPUT_MENU6,
    OXINE_KEY_MENU7 = XINE_EVENT_INPUT_MENU7,
    OXINE_KEY_UP = XINE_EVENT_INPUT_UP,
    OXINE_KEY_DOWN = XINE_EVENT_INPUT_DOWN,
    OXINE_KEY_LEFT = XINE_EVENT_INPUT_LEFT,
    OXINE_KEY_RIGHT = XINE_EVENT_INPUT_RIGHT,
    OXINE_KEY_ACTIVATE = XINE_EVENT_INPUT_SELECT,
    OXINE_KEY_NEXT = XINE_EVENT_INPUT_NEXT,
    OXINE_KEY_PREV = XINE_EVENT_INPUT_PREVIOUS,
    OXINE_KEY_0 = XINE_EVENT_INPUT_NUMBER_0,
    OXINE_KEY_1 = XINE_EVENT_INPUT_NUMBER_1,
    OXINE_KEY_2 = XINE_EVENT_INPUT_NUMBER_2,
    OXINE_KEY_3 = XINE_EVENT_INPUT_NUMBER_3,
    OXINE_KEY_4 = XINE_EVENT_INPUT_NUMBER_4,
    OXINE_KEY_5 = XINE_EVENT_INPUT_NUMBER_5,
    OXINE_KEY_6 = XINE_EVENT_INPUT_NUMBER_6,
    OXINE_KEY_7 = XINE_EVENT_INPUT_NUMBER_7,
    OXINE_KEY_8 = XINE_EVENT_INPUT_NUMBER_8,
    OXINE_KEY_9 = XINE_EVENT_INPUT_NUMBER_9,
    /* mapped VDR keys */
    OXINE_KEY_RECORD = XINE_EVENT_VDR_RECORD,
    OXINE_KEY_RED = XINE_EVENT_VDR_RED,
    OXINE_KEY_GREEN = XINE_EVENT_VDR_GREEN,
    OXINE_KEY_YELLOW = XINE_EVENT_VDR_YELLOW,
    OXINE_KEY_BLUE = XINE_EVENT_VDR_BLUE,
    /* boundary */
    OXINE_KEY_NULL = 1000,
    /* stream */
    OXINE_KEY_PPLAY,
    OXINE_KEY_PLAY,
    OXINE_KEY_PAUSE,
    OXINE_KEY_STOP,
    OXINE_KEY_SEEK, // go to absolute position
    OXINE_KEY_SKIP, // skip relative to current position
    OXINE_KEY_FASTFWD,
    OXINE_KEY_FASTRWD,
    OXINE_KEY_SPEED,
    /* audio settings */
    OXINE_KEY_VOLUME,
    OXINE_KEY_VOLMUTE,
    OXINE_KEY_AUDIO_CHANNEL,
    OXINE_KEY_AUDIO_OFFSET,
    /* video settings */
    OXINE_KEY_SATURATION,
    OXINE_KEY_BRIGHTNESS,
    OXINE_KEY_CONTRAST,
    OXINE_KEY_HUE,
    OXINE_KEY_ZOOM,
    OXINE_KEY_ZOOM_X,
    OXINE_KEY_ZOOM_Y,
    OXINE_KEY_ZOOM_RESET,
    OXINE_KEY_ASPECT_RATIO,
    OXINE_KEY_DEINTERLACE,
    OXINE_KEY_SPU_CHANNEL,
    OXINE_KEY_SPU_OFFSET,
    /* OSD navigation */
    OXINE_KEY_FIRST,
    OXINE_KEY_LAST,
    OXINE_KEY_PAGE_UP,
    OXINE_KEY_PAGE_DOWN,
    OXINE_KEY_BACK,
    OXINE_KEY_HOME,
    OXINE_KEY_SELECT,
    OXINE_KEY_REMOVE,
    OXINE_KEY_PREV_WIDGET,
    OXINE_KEY_NEXT_WIDGET,
    /* menu access */
    OXINE_KEY_MENU_MAIN,
    OXINE_KEY_MENU_MUSIC,
    OXINE_KEY_MENU_VIDEO,
    OXINE_KEY_MENU_OSD,
    OXINE_KEY_MENU_CURRENT_TITLE,
    OXINE_KEY_PLAY_VDR,
    OXINE_KEY_PLAY_DVB,
    OXINE_KEY_PLAY_V4L,
    OXINE_KEY_HELP,
    OXINE_KEY_EJECT,
    OXINE_KEY_PLAYMODE,
    OXINE_KEY_FULLSCREEN,
    OXINE_KEY_QUIT,
    OXINE_KEY_SHUTDOWN,
    /* direct key input (for editbox) */
    OXINE_KEY_INPUT
} oxine_key_id_t;


typedef enum {
    OXINE_BUTTON_NULL,
    OXINE_BUTTON1,
    OXINE_BUTTON2,
    OXINE_BUTTON3,
    OXINE_BUTTON4,
    OXINE_BUTTON5,
} oxine_button_id_t;

typedef struct {
    oxine_event_id_t type;
    union {
        oxine_key_id_t key;
        oxine_button_id_t button;
    } source;
    union {
        /* Used for mouse events. */
        struct {
            int x;
            int y;
        } pos;
        /* Used for input events. */
        struct {
            int key;
            int modifier;
        } key;
        /* Used for key events. */
        int how;
    } data;
} oxine_event_t;

typedef void (*event_handler_t) (void *user_data, oxine_event_t * event);

void oxine_event_handler (void *oxine_p, oxine_event_t * ev);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_EVENT_H */
