//----------------------------------------------------------------------------------------
/*!
    \file       td_th_dialog.h        
    \modified                            
    \copyright  (c) Robert O'Connor ( rob@medicalmnemonics.com )    
    \licence    GPL
    \brief      Describes td_th_dialog class    
    \author     Robert O'Connor
    \date       2003/03/07
 */
// RCS-ID:      $Id: td_th_dialog.h,v 1.1 2003/03/17 17:43:20 robertoconnor Exp $
//----------------------------------------------------------------------------------------

//----------------------------------------------------------------------------------------
// Begin single inclusion of this .h file condition
//----------------------------------------------------------------------------------------

#ifndef _TD_TH_DIALOG_H_
#define _TD_TH_DIALOG_H_

//----------------------------------------------------------------------------------------
// GCC interface
//----------------------------------------------------------------------------------------

#if defined(__GNUG__) && ! defined(__APPLE__)
    #pragma interface "td_th_dialog.h"
#endif

//----------------------------------------------------------------------------------------
// Shared defines
//----------------------------------------------------------------------------------------

#include "plucker_defines.h"

//----------------------------------------------------------------------------------------
// Begin feature removal condition
//----------------------------------------------------------------------------------------

#if ( setupUSE_INTEGRATED_HTML_EDITOR )

//----------------------------------------------------------------------------------------
// Headers
//----------------------------------------------------------------------------------------

#include "wx/dialog.h"

//----------------------------------------------------------------------------------------
// Class options
//----------------------------------------------------------------------------------------

enum {
    optionTD_TH_DIALOG_IS_TD    = 1,
    optionTD_TH_DIALOG_IS_TH    = 2
};

//----------------------------------------------------------------------------------------
// Class definition: td_th_dialog
//----------------------------------------------------------------------------------------

//! A dialog for a "hr" tag for the HTML editor.
class td_th_dialog : public wxDialog
{

public:

    //! Constructor.
    /*!
        \param parent The parent window.
        \param td_verusus_th_dialog_type Whether is a TD or TH dialog.
     */
    td_th_dialog( wxWindow* parent, long td_verusus_th_dialog_type );

    //! Destructor
    ~td_th_dialog();

    //! Gets the tag strings generated by the dialog, ready to insert by parent
    /*!
        \param starting_text The text to place at the start of parent's selected text.
        \param ending_text The text to place at the end of parent's selected text.
     */
    void transfer_to( wxString& starting_text,
                      wxString& ending_text
                    );

private:

    void on_help_button( wxCommandEvent& event );
    //Override base class functions
    void OnOK( wxCommandEvent& event );

    long        m_td_versus_th_dialog_type;
    wxString    m_starting_text;
    wxString    m_ending_text;

    DECLARE_EVENT_TABLE()

};

//----------------------------------------------------------------------------------------
// End feature removal condition
//----------------------------------------------------------------------------------------

#endif // setupUSE_INTEGRATED_HTML_EDITOR

//----------------------------------------------------------------------------------------
// End single inclusion of this .h file condition
//----------------------------------------------------------------------------------------

#endif  //_TD_TH_DIALOG_H_

