/***************************************************************************
                            th-device-tracker.c
                            -------------------
    begin                : Thu Oct 14 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This is just an interface, a glorified vfunc table basically. Device  *
 *    pools that watch for a specific class of devices (e.g. the cdrom     *
 *    drive pool, or the IPod pool, or whatever) need to implement this    *
 *    and be added to the 'device pool' so that the device pool can notify *
 *    them of device stuff.                                                *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "th-device-tracker.h"

static void     th_device_tracker_base_init (gpointer g_klass);

/***************************************************************************
 *
 *   th_device_tracker_get_type
 *
 ***************************************************************************/

GType
th_device_tracker_get_type (void)
{
	static GType type = 0;

	if (!type)
	{
		static const GTypeInfo info =
		{
			sizeof (ThDeviceTrackerIface), /* class_size */
			th_device_tracker_base_init,   /* base_init */
			NULL,                       /* base_finalize */
			NULL,
			NULL,                       /* class_finalize */
			NULL,                       /* class_data */
			0,
			0,                          /* n_preallocs */
			NULL
		};

		type = g_type_register_static (G_TYPE_INTERFACE, "ThDeviceTracker", &info, 0);

		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}

	return type;
}

/***************************************************************************
 *
 *   th_device_tracker_base_init
 *
 ***************************************************************************/

static void
th_device_tracker_base_init (gpointer g_klass)
{
	return; /* nothing to do here at the moment */
}

/***************************************************************************
 *
 *   th_device_tracker_set_context
 *
 ***************************************************************************/

void  
th_device_tracker_set_context (ThDeviceTracker *tracker, 
                               LibHalContext   *ctx)
{
	g_return_if_fail (TH_IS_DEVICE_TRACKER (tracker));
	g_return_if_fail (ctx != NULL);

	if (TH_DEVICE_TRACKER_GET_IFACE (tracker)->set_context != NULL)
		TH_DEVICE_TRACKER_GET_IFACE (tracker)->set_context (tracker, ctx);
}

/***************************************************************************
 *
 *   th_device_tracker_device_added
 *
 ***************************************************************************/

void  
th_device_tracker_device_added (ThDeviceTracker *tracker, 
                                const gchar     *udi)
{
	g_return_if_fail (TH_IS_DEVICE_TRACKER (tracker));
	g_return_if_fail (udi != NULL);

	if (TH_DEVICE_TRACKER_GET_IFACE (tracker)->device_added != NULL)
		TH_DEVICE_TRACKER_GET_IFACE (tracker)->device_added (tracker, udi);
}

/***************************************************************************
 *
 *   th_device_tracker_device_removed
 *
 ***************************************************************************/

void  
th_device_tracker_device_removed (ThDeviceTracker *tracker, 
                                  const gchar     *udi)
{
	g_return_if_fail (TH_IS_DEVICE_TRACKER (tracker));
	g_return_if_fail (udi != NULL);

	if (TH_DEVICE_TRACKER_GET_IFACE (tracker)->device_removed != NULL)
		TH_DEVICE_TRACKER_GET_IFACE (tracker)->device_removed (tracker, udi);
}

/***************************************************************************
 *
 *   th_device_tracker_new_cap
 *
 ***************************************************************************/

void  
th_device_tracker_new_cap (ThDeviceTracker *tracker, 
                           const gchar     *udi, 
                           const gchar     *cap)
{
	g_return_if_fail (TH_IS_DEVICE_TRACKER (tracker));
	g_return_if_fail (udi != NULL);
	g_return_if_fail (cap != NULL);

	if (TH_DEVICE_TRACKER_GET_IFACE (tracker)->new_cap != NULL)
		TH_DEVICE_TRACKER_GET_IFACE (tracker)->new_cap (tracker, udi, cap);
}

/***************************************************************************
 *
 *   th_device_tracker_lost_cap
 *
 ***************************************************************************/

void  
th_device_tracker_lost_cap (ThDeviceTracker *tracker, 
                            const gchar     *udi, 
                            const gchar     *cap)
{
	g_return_if_fail (TH_IS_DEVICE_TRACKER (tracker));
	g_return_if_fail (udi != NULL);
	g_return_if_fail (cap != NULL);

	if (TH_DEVICE_TRACKER_GET_IFACE (tracker)->lost_cap != NULL)
		TH_DEVICE_TRACKER_GET_IFACE (tracker)->lost_cap (tracker, udi, cap);
}

/***************************************************************************
 *
 *   th_device_tracker_prop_mod
 *
 ***************************************************************************/

void  
th_device_tracker_prop_mod (ThDeviceTracker *tracker, 
                            const gchar     *udi, 
                            const gchar     *prop, 
                            gboolean         is_removed, 
                            gboolean         is_added)
{
	g_return_if_fail (TH_IS_DEVICE_TRACKER (tracker));
	g_return_if_fail (udi != NULL);
	g_return_if_fail (prop != NULL);

	if (TH_DEVICE_TRACKER_GET_IFACE (tracker)->prop_mod != NULL)
		TH_DEVICE_TRACKER_GET_IFACE (tracker)->prop_mod (tracker, udi, prop, is_removed, is_added);
}


/***************************************************************************
 *
 *   th_device_tracker_dev_condition
 *
 ***************************************************************************/

#ifndef USE_NEW_DBUS_HAL_API

void  
th_device_tracker_dev_condition (ThDeviceTracker *tracker, 
                                 const gchar     *udi, 
                                 const gchar     *cond_name,
                                 DBusMessage     *msg)
{
	g_return_if_fail (TH_IS_DEVICE_TRACKER (tracker));
	g_return_if_fail (udi != NULL);
	g_return_if_fail (cond_name != NULL);
	g_return_if_fail (msg != NULL);

	if (TH_DEVICE_TRACKER_GET_IFACE (tracker)->dev_condition != NULL)
		TH_DEVICE_TRACKER_GET_IFACE (tracker)->dev_condition (tracker, udi, cond_name, msg);
}

#else

void  
th_device_tracker_dev_condition (ThDeviceTracker *tracker, 
                                 const gchar     *udi, 
                                 const gchar     *cond_name,
                                 const gchar     *cond_detail)
{
	g_return_if_fail (TH_IS_DEVICE_TRACKER (tracker));
	g_return_if_fail (udi != NULL);
	g_return_if_fail (cond_name != NULL);

	if (TH_DEVICE_TRACKER_GET_IFACE (tracker)->dev_condition != NULL)
		TH_DEVICE_TRACKER_GET_IFACE (tracker)->dev_condition (tracker, udi, cond_name, cond_detail);
}

#endif /* USE_NEW_DBUS_HAL_API */

