# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import unittest
import sys
import gobject

from pkg_resources import resource_filename

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.style import Style
from elisa.plugins.pigment.widgets.const import *
import pgm

class TestWidget(unittest.TestCase):

    def test_simple(self):
        widget = Widget()

    def test_hierarchy(self):
        parent = Widget()
        parent.name = 'parent'
        children = []
        grandchildren = []

        for x in range(3):
            child = Widget()
            child.name = 'child_' + str(x)
            parent.add(child)
            children.append(child)

            for x in range(2):
                grandchild = Widget()
                grandchild.name = 'grandchild_' + str(x)
                child.add(grandchild)
                grandchildren.append(grandchild)

                self.assertEquals(grandchild.get_parent(), child)
                self.assertEquals(grandchild.get_root(), parent)
                self.assertEquals(len(grandchild.get_children()), 0)
                self.assertEquals(len(grandchild.get_descendants()), 0)

            self.assertEquals(child.get_parent(), parent)
            self.assertEquals(child.get_root(), parent)
            self.assertEquals(len(child.get_descendants()), 2)
            self.assertEquals(len(child.get_descendants()),
                              len(child.get_children()))

        self.assertEquals(len(parent.get_children()), 3)
        self.assertEquals(len(parent.get_descendants()), 3 + (3 * 2))

        # focus
        for item in parent.get_descendants():
            self.assertEquals(item.focus, False)

        for item in parent.get_descendants():
            item.focus = True
            self.assertEquals(item, parent.focus_child)
            for other in parent.get_descendants():
                if other != item:
                    self.assertEquals(other.focus, False)
                else:
                    self.assertEquals(other.focus, True)

    def test_state(self):
        widget = Widget()

        self.assertEquals(widget.state, STATE_NORMAL)

        def on_state_changed(widget, state):
            self.assertEquals(state, STATE_ACTIVE)

        widget.connect('state-changed', on_state_changed)
        widget.state = STATE_ACTIVE

    def test_style(self):
        widget = Widget()

        self.assertEquals(widget.style, widget._styles[STATE_NORMAL])

        new_style = Style()

        def on_style_set(widget, style):
            self.assertEquals(style, new_style)

        handler_id = widget.connect('style-set', on_style_set)
        widget.style = new_style
        widget.disconnect(handler_id)

        def on_state_changed_after(widget, state):
            self.assertEquals(widget.style, widget._styles[state])

        handler_id = widget.connect_after('state_changed', on_state_changed_after)
        widget.state = STATE_ACTIVE
        widget.disconnect(handler_id)

