/** 
 * @file stk11xx-dev-6a51.c
 * @author Nicolas VIVIEN
 * @date 2007-12-07
 * @version v1.3.x
 *
 * @brief Driver for Syntek USB video camera
 *
 * @note Copyright (C) Nicolas VIVIEN
 *
 * @par Licences
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * @par SubVersion
 *   $Date: 2007-12-11 14:50:16 +0100 (Di, 11 Dez 2007) $
 *   $Revision: 70 $
 *   $Author: nicklas79 $
 *   $HeadURL: http://syntekdriver.svn.sourceforge.net/svnroot/syntekdriver/trunk/driver/stk11xx-dev-6a51.c $
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/errno.h>
#include <linux/slab.h>
#include <linux/kref.h>

#include <linux/usb.h>
#include <media/v4l2-common.h>

#include "stk11xx.h"
#include "stk11xx-dev.h"


//=============================================================================
//
// STK-6A51 API
//
//=============================================================================


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief This function permits to initialize the device.
 *
 * This function must be called at first. It's the start of the
 * initialization process. After this process, the device is
 * completly initalized and it's ready.
 *
 * This function is written from the USB log.
 */
int dev_stk6a51_initialize_device(struct usb_stk11xx *dev)
{
	int i;
	int value;
	int retok;

	STK_INFO("Initialize USB2.0 Syntek Camera\n");

	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0002, 0x0078);
	usb_stk11xx_write_registry(dev, 0x0003, 0x0080);

	usb_stk11xx_write_registry(dev, 0x0002, 0x007f);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0002, 0x007d);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);

	for (i=0; i<16; i++) {
		usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
		usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
		usb_stk11xx_read_registry(dev, 0x0000, &value);
	
		STK_DEBUG("Loop 1 : Read 0x0000 = %02X\n", value);
	}

	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0020);

	usb_stk11xx_write_registry(dev, 0x0002, 0x007f);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0002, 0x007d);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);

	for (i=0; i<16; i++) {
		usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
		usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
		usb_stk11xx_read_registry(dev, 0x0000, &value);

		STK_DEBUG("Loop 2 : Read 0x0000 = %02X\n", value);
	}

	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0020);

	usb_stk11xx_write_registry(dev, 0x0002, 0x007f);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0027);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0026);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0002, 0x007d);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);

	for (i=0; i<16; i++) {
		usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
		usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
		usb_stk11xx_read_registry(dev, 0x0000, &value);
	
		STK_DEBUG("Loop 3 : Read 0x0000 = %02X\n", value);
	}

	usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0020);
	usb_stk11xx_write_registry(dev, 0x0002, 0x007f);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0020);

	usb_stk11xx_write_registry(dev, 0x0117, 0x0000);
	usb_stk11xx_read_registry(dev, 0x0103, &value);
	usb_stk11xx_write_registry(dev, 0x0103, 0x0001);
	usb_stk11xx_read_registry(dev, 0x0103, &value);
	usb_stk11xx_write_registry(dev, 0x0103, 0x0000);

	usb_stk11xx_write_registry(dev, 0x0000, 0x00e0);
	usb_stk11xx_write_registry(dev, 0x0002, 0x00f8);
	usb_stk11xx_write_registry(dev, 0x0002, 0x0078);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0020);

	dev_stk6a51_configure_device(dev, 0);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 1);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 2);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 3);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 4);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 5);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 6);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 7);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 8);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 9);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 10);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 11);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 12);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 13);

	dev_stk6a51_configure_device(dev, 14);

	dev_stk6a51_configure_device(dev, 15);
	retok = dev_stk11xx_check_device(dev, 65);
	usb_stk11xx_write_registry(dev, 0x0200, 0x0008);

	dev_stk6a51_configure_device(dev, 16);

	dev_stk6a51_configure_device(dev, 17);





	dev_stk6a51_camera_asleep(dev);

	usb_stk11xx_set_feature(dev, 0);

	// Device is initialized and is ready !!!
	STK_INFO("Syntek USB2.0 Camera is ready\n");

	return 0;
}


/** 
 * @param dev Device structure
 * @param step The step of configuration [0-11]
 * 
 * @returns 0 if all is OK
 *
 * @brief This function permits to configure the device.
 *
 * The configuration of device is composed of 12 steps.
 * This function is called by the initialization process.
 *
 * We don't know the meaning of these steps ! We only replay the USB log.
 */
int dev_stk6a51_configure_device(struct usb_stk11xx *dev, int step)
{
	int retok;
	int value;

	//     0,    1,    2,    3,    4,    5,    6,    7,    8,    9,   10,   11,   12,   13,   14,   15,   16,   17,   18,   19
	static const int values_001B[] = {
		0x0e, 0x03, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0e, 0x0e, 0x0e, 0x0e
	};
	static const int values_001C[] = {
		0x06, 0x02, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x46, 0x46, 0x46, 0x46
	};
	static const int values_0202[] = {
		0x1e, 0x0a, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x0a, 0x1e, 0x14, 0x1e, 0x1f, 0x0a, 0x0a, 0x0a, 0x0a
	};
	static const int values_0110[] = {
		0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	};
	static const int values_0112[] = {
		0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01
	};
	static const int values_0114[] = {
		0x87, 0x80, 0x80, 0x80, 0x80, 0x00, 0xbe, 0xbe, 0x80, 0x80, 0x84, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
	};
	static const int values_0115[] = {
		0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02
	};
	static const int values_0116[] = {
		0xe7, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe9, 0xe9, 0xe0, 0xe0, 0xe4, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe1, 0xe1, 0xe1
	};
	static const int values_0117[] = {
		0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
	};
	static const int values_0100[] = {
		0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	};


	STK_DEBUG("dev_stk6a51_configure_device : %d\n", step);

	usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
	usb_stk11xx_write_registry(dev, 0x0002, 0x0078);
	usb_stk11xx_write_registry(dev, 0x0003, 0x0080);
	usb_stk11xx_write_registry(dev, 0x0005, 0x0000);
	
	usb_stk11xx_write_registry(dev, 0x0007, 0x0003);
	usb_stk11xx_write_registry(dev, 0x000d, 0x0000);
	usb_stk11xx_write_registry(dev, 0x000f, 0x0002);
	usb_stk11xx_write_registry(dev, 0x0300, 0x0012);
	usb_stk11xx_write_registry(dev, 0x0350, 0x0041);
	
	usb_stk11xx_write_registry(dev, 0x0351, 0x0000);
	usb_stk11xx_write_registry(dev, 0x0352, 0x0000);
	usb_stk11xx_write_registry(dev, 0x0353, 0x0000);
	usb_stk11xx_write_registry(dev, 0x0018, 0x0010);
	usb_stk11xx_write_registry(dev, 0x0019, 0x0000);
	
	usb_stk11xx_write_registry(dev, 0x001b, values_001B[step]);
	usb_stk11xx_write_registry(dev, 0x001c, values_001C[step]);
	usb_stk11xx_write_registry(dev, 0x0300, 0x0080);
	usb_stk11xx_write_registry(dev, 0x001a, 0x0004);
	usb_stk11xx_write_registry(dev, 0x0202, values_0202[step]);
	
	usb_stk11xx_write_registry(dev, 0x0110, values_0110[step]);
	usb_stk11xx_write_registry(dev, 0x0111, 0x0000);
	usb_stk11xx_write_registry(dev, 0x0112, values_0112[step]);
	usb_stk11xx_write_registry(dev, 0x0113, 0x0000);
	usb_stk11xx_write_registry(dev, 0x0114, values_0114[step]);
	
	usb_stk11xx_write_registry(dev, 0x0115, values_0115[step]);
	usb_stk11xx_write_registry(dev, 0x0116, values_0116[step]);
	usb_stk11xx_write_registry(dev, 0x0117, values_0117[step]);

	usb_stk11xx_read_registry(dev, 0x0100, &value);
	usb_stk11xx_write_registry(dev, 0x0100, values_0100[step]);

//	usb_stk11xx_write_registry(dev, 0x0200, 0x0080); 
//	usb_stk11xx_write_registry(dev, 0x0200, 0x0000); 
	usb_stk11xx_write_registry(dev, 0x02ff, 0x0000); 


	switch (step) {
		case 0:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0040); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0041); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0001); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x001c); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0002); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;
	
		case 1:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0022); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0027); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00a5); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 2:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0060); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0013); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00bf); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 3:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0042); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0024); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00a5); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 4:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0042); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0013); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00e0); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0024); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00a5); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 5:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0042); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0013); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00bf); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 6:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0060); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0013); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00ff); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 7:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0060); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0013); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00ff); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 8:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0060); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0013); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00b7); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 9:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0060); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x0013); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00b7); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 10:
			usb_stk11xx_write_registry(dev, 0x0203, 0x0080); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0012); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 
			usb_stk11xx_write_registry(dev, 0x0204, 0x000a); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x00ff); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 11:
			usb_stk11xx_write_registry(dev, 0x0203, 0x00dc); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0015); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 12:
			usb_stk11xx_write_registry(dev, 0x0203, 0x00ec); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0015); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0080); 

			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 13:
			usb_stk11xx_write_registry(dev, 0x0203, 0x00ba); 

			usb_stk11xx_read_registry(dev, 0x02ff, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

			usb_stk11xx_write_registry(dev, 0x0208, 0x0020);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0020);
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

			break;

		case 14:
			usb_stk11xx_write_registry(dev, 0x0203, 0x00ba); 

			usb_stk11xx_read_registry(dev, 0x02ff, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

			usb_stk11xx_write_registry(dev, 0x0208, 0x0000);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0020);
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);
			usb_stk11xx_read_registry(dev, 0x02ff, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

			usb_stk11xx_write_registry(dev, 0x0208, 0x00f1);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0020);
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

			break;

		case 15:
			usb_stk11xx_write_registry(dev, 0x0203, 0x00ba); 

			usb_stk11xx_write_registry(dev, 0x0204, 0x0001); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0000); 
			usb_stk11xx_write_registry(dev, 0x0200, 0x0005); 

			break;

		case 16:
			usb_stk11xx_write_registry(dev, 0x0203, 0x007a); 

			usb_stk11xx_read_registry(dev, 0x02ff, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);
			usb_stk11xx_write_registry(dev, 0x0205, 0x0030); 
			usb_stk11xx_write_registry(dev, 0x0205, 0x0000); 
			usb_stk11xx_read_registry(dev, 0x0201, &value);
			usb_stk11xx_read_registry(dev, 0x0201, &value);
			usb_stk11xx_read_registry(dev, 0x0201, &value);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0020); 
			usb_stk11xx_read_registry(dev, 0x0201, &value);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0001);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

			usb_stk11xx_write_registry(dev, 0x0002, 0x007f);
			usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
			usb_stk11xx_write_registry(dev, 0x0002, 0x007d);
			usb_stk11xx_write_registry(dev, 0x0000, 0x0024);
			usb_stk11xx_write_registry(dev, 0x0000, 0x0025);
			usb_stk11xx_write_registry(dev, 0x0000, 0x0020);

			break;

		case 17:
			usb_stk11xx_write_registry(dev, 0x0203, 0x007a); 

			dev_stk6a51_sensor_settings(dev);

			usb_stk11xx_read_registry(dev, 0x02ff, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0001);

			usb_stk11xx_write_registry(dev, 0x0205, 0x0033);
			usb_stk11xx_write_registry(dev, 0x0205, 0x0090);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0061);
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0020); 
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0001);
			usb_stk11xx_read_registry(dev, 0x0201, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

			usb_stk11xx_write_registry(dev, 0x0200, 0x0080);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0000);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0001);

			break;

		case 18:
			usb_stk11xx_write_registry(dev, 0x0203, 0x007a); 

			dev_stk6a51_sensor_settings(dev);

			usb_stk11xx_read_registry(dev, 0x02ff, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0001);

			usb_stk11xx_write_registry(dev, 0x0205, 0x0033);
			usb_stk11xx_write_registry(dev, 0x0205, 0x0090);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0061);
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0020); 
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);
			break;

		case 19:
			usb_stk11xx_write_registry(dev, 0x0203, 0x007a); 

			dev_stk6a51_sensor_settings(dev);

			usb_stk11xx_read_registry(dev, 0x02ff, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0001);

			usb_stk11xx_write_registry(dev, 0x0205, 0x0033);
			usb_stk11xx_write_registry(dev, 0x0205, 0x0090);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0061);
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0020); 
			retok = dev_stk11xx_check_device(dev, 500);
			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);
			break;
	}
	
	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief Wake-up the camera.
 *
 * This function permits to wake-up the device.
 */
int dev_stk6a51_camera_asleep(struct usb_stk11xx *dev)
{
	int value;

	usb_stk11xx_write_registry(dev, 0x0203, 0x00a0); 

	usb_stk11xx_read_registry(dev, 0x0104, &value);
	usb_stk11xx_read_registry(dev, 0x0105, &value);
	usb_stk11xx_read_registry(dev, 0x0106, &value);

	usb_stk11xx_write_registry(dev, 0x0100, 0x0021);
	usb_stk11xx_write_registry(dev, 0x0116, 0x0000);
	usb_stk11xx_write_registry(dev, 0x0117, 0x0000);
	usb_stk11xx_write_registry(dev, 0x0018, 0x0000);

	usb_stk11xx_read_registry(dev, 0x0000, &value);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0049);

	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief This function initializes the device for the stream.
 *
 * It's the start. This function has to be called at first, before
 * enabling the video stream.
 */
int dev_stk6a51_init_camera(struct usb_stk11xx *dev)
{
	dev_stk6a51_camera_asleep(dev);

	usb_stk11xx_set_feature(dev, 0);

	dev_stk6a51_camera_asleep(dev);

	usb_stk11xx_write_registry(dev, 0x0000, 0x00e0);
	usb_stk11xx_write_registry(dev, 0x0002, 0x00f8);
	usb_stk11xx_write_registry(dev, 0x0002, 0x0078);
	usb_stk11xx_write_registry(dev, 0x0000, 0x0020);

	dev_stk6a51_configure_device(dev, 18);

	dev_stk11xx_camera_off(dev);

	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief This function permits to set default sensor settings.
 *
 * We set some registers in using a I2C bus.
 * WARNING, the sensor settings can be different following the situation.
 */
int dev_stk6a51_sensor_settings(struct usb_stk11xx *dev)
{
	int i;
	int retok;
	int value;

	int asize;

	static const int values_205[][4] = {
		{ 0x33, 0x86, 0x05, 0x01 },
		{ 0x33, 0x86, 0x05, 0x00 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x30, 0x1a, 0x0a, 0xcc },
		{ 0x32, 0x02, 0x00, 0x08 },
		{ 0x33, 0xf4, 0x03, 0x1d },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x34, 0x1e, 0x8f, 0x09 },
		{ 0x34, 0x1c, 0x02, 0x50 },
		{ 0x34, 0x1e, 0x8f, 0x09 },
		{ 0x34, 0x1e, 0x8f, 0x08 },
		{ 0x33, 0x8c, 0x04, 0x00 },
		{ 0x33, 0x90, 0x30, 0x8f },
		{ 0x33, 0x92, 0xc3, 0xff },
		{ 0x33, 0x94, 0xed, 0x8f },
		{ 0x33, 0x96, 0x35, 0x8f },
		{ 0x33, 0x98, 0x18, 0x8f },
		{ 0x33, 0x9a, 0x30, 0x8f },
		{ 0x33, 0x9c, 0xc3, 0x00 },
		{ 0x33, 0x9e, 0x15, 0x8f },
		{ 0x33, 0x8c, 0x04, 0x10 },
		{ 0x33, 0x90, 0xcc, 0x00 },
		{ 0x33, 0x92, 0x07, 0xbd },
		{ 0x33, 0x94, 0x04, 0xb5 },
		{ 0x33, 0x96, 0xbd, 0x9e },
		{ 0x33, 0x98, 0x9f, 0xf6 },
		{ 0x33, 0x9a, 0x03, 0x22 },
		{ 0x33, 0x9c, 0x30, 0xe7 },
		{ 0x33, 0x9e, 0x0a, 0xf6 },
		{ 0x33, 0x8c, 0x04, 0x20 },
		{ 0x33, 0x90, 0x02, 0x39 },
		{ 0x33, 0x92, 0xc1, 0x01 },
		{ 0x33, 0x94, 0x26, 0x05 },
		{ 0x33, 0x96, 0xf6, 0x03 },
		{ 0x33, 0x98, 0x23, 0xe7 },
		{ 0x33, 0x9a, 0x0a, 0x7d },
		{ 0x33, 0x9c, 0x03, 0x21 },
		{ 0x33, 0x9e, 0x27, 0x20 },
		{ 0x33, 0x8c, 0x04, 0x30 },
		{ 0x33, 0x90, 0xf6, 0x02 },
		{ 0x33, 0x92, 0x39, 0xe7 },
		{ 0x33, 0x94, 0x02, 0x8f },
		{ 0x33, 0x96, 0xc3, 0x00 },
		{ 0x33, 0x98, 0x0b, 0x30 },
		{ 0x33, 0x9a, 0xed, 0x00 },
		{ 0x33, 0x9c, 0xfe, 0x02 },
		{ 0x33, 0x9e, 0x37, 0xee },
		{ 0x33, 0x8c, 0x04, 0x40 },
		{ 0x33, 0x90, 0x04, 0x5f },
		{ 0x33, 0x92, 0xad, 0x00 },
		{ 0x33, 0x94, 0x30, 0xe6 },
		{ 0x33, 0x96, 0x0a, 0x4f },
		{ 0x33, 0x98, 0xed, 0x08 },
		{ 0x33, 0x9a, 0xec, 0x11 },
		{ 0x33, 0x9c, 0xa3, 0x08 },
		{ 0x33, 0x9e, 0xdd, 0x56 },
		{ 0x33, 0x8c, 0x04, 0x50 },
		{ 0x33, 0x90, 0x30, 0xc6 },
		{ 0x33, 0x92, 0x13, 0x3a },
		{ 0x33, 0x94, 0x35, 0x39 },
		{ 0x33, 0x96, 0x3c, 0x3c },
		{ 0x33, 0x98, 0x3c, 0xc6 },
		{ 0x33, 0x9a, 0x01, 0xf7 },
		{ 0x33, 0x9c, 0x03, 0x21 },
		{ 0x33, 0x9e, 0xc6, 0x0a },
		{ 0x33, 0x8c, 0x04, 0x60 },
		{ 0x33, 0x90, 0xf7, 0x03 },
		{ 0x33, 0x92, 0x22, 0xf7 },
		{ 0x33, 0x94, 0x03, 0x23 },
		{ 0x33, 0x96, 0xcc, 0x03 },
		{ 0x33, 0x98, 0x03, 0x30 },
		{ 0x33, 0x9a, 0xed, 0x02 },
		{ 0x33, 0x9c, 0xfe, 0x10 },
		{ 0x33, 0x9e, 0x50, 0xec },
		{ 0x33, 0x8c, 0x04, 0x70 },
		{ 0x33, 0x90, 0x04, 0xfd },
		{ 0x33, 0x92, 0x02, 0xff },
		{ 0x33, 0x94, 0xfe, 0x02 },
		{ 0x33, 0x96, 0xff, 0xec },
		{ 0x33, 0x98, 0x00, 0xfd },
		{ 0x33, 0x9a, 0x03, 0x01 },
		{ 0x33, 0x9c, 0x5f, 0x4f },
		{ 0x33, 0x9e, 0x30, 0xed },
		{ 0x33, 0x8c, 0x04, 0x80 },
		{ 0x33, 0x90, 0x04, 0xec },
		{ 0x33, 0x92, 0x04, 0x05 },
		{ 0x33, 0x94, 0xf3, 0x03 },
		{ 0x33, 0x96, 0x01, 0x8f },
		{ 0x33, 0x98, 0xec, 0x00 },
		{ 0x33, 0x9a, 0x30, 0xed },
		{ 0x33, 0x9c, 0x00, 0xec },
		{ 0x33, 0x9e, 0x04, 0x05 },
		{ 0x33, 0x8c, 0x04, 0x90 },
		{ 0x33, 0x90, 0xe3, 0x02 },
		{ 0x33, 0x92, 0x18, 0x8f },
		{ 0x33, 0x94, 0xec, 0x00 },
		{ 0x33, 0x96, 0x18, 0xed },
		{ 0x33, 0x98, 0x00, 0xec },
		{ 0x33, 0x9a, 0x04, 0xc3 },
		{ 0x33, 0x9c, 0x00, 0x01 },
		{ 0x33, 0x9e, 0xed, 0x04 },
		{ 0x33, 0x8c, 0x04, 0xa0 },
		{ 0x33, 0x90, 0x83, 0x00 },
		{ 0x33, 0x92, 0x0f, 0x25 },
		{ 0x33, 0x94, 0xdc, 0xee },
		{ 0x33, 0x96, 0x02, 0xcc },
		{ 0x33, 0x98, 0x04, 0x00 },
		{ 0x33, 0x9a, 0xed, 0x04 },
		{ 0x33, 0x9c, 0xcc, 0x03 },
		{ 0x33, 0x9e, 0x03, 0xdd },
		{ 0x33, 0x8c, 0x04, 0xb0 },
		{ 0x33, 0x90, 0x52, 0x38 },
		{ 0x33, 0x92, 0x38, 0x38 },
		{ 0x33, 0x94, 0x39, 0x37 },
		{ 0x33, 0x96, 0x36, 0x8f },
		{ 0x33, 0x98, 0x30, 0xe3 },
		{ 0x33, 0x9a, 0x00, 0x8f },
		{ 0x33, 0x9c, 0x18, 0x8f },
		{ 0x33, 0x9e, 0x18, 0x30 },
		{ 0x33, 0x8c, 0x04, 0xc0 },
		{ 0x33, 0x90, 0x18, 0xe3 },
		{ 0x33, 0x92, 0x00, 0x18 },
		{ 0x33, 0x94, 0x8f, 0x32 },
		{ 0x33, 0x96, 0x33, 0x36 },
		{ 0x33, 0x98, 0xa6, 0x00 },
		{ 0x33, 0x9a, 0x18, 0xa7 },
		{ 0x33, 0x9c, 0x00, 0x09 },
		{ 0x33, 0x9e, 0x18, 0x09 },
		{ 0x33, 0x8c, 0x04, 0xd0 },
		{ 0x33, 0x90, 0xc0, 0x01 },
		{ 0x33, 0x92, 0x24, 0xf4 },
		{ 0x33, 0x94, 0x32, 0x80 },
		{ 0x33, 0x96, 0x01, 0x24 },
		{ 0x33, 0x98, 0xee, 0x39 },
		{ 0x33, 0x8c, 0x20, 0x03 },
		{ 0x33, 0x90, 0x04, 0x56 },
		{ 0x33, 0x8c, 0xa0, 0x02 },
		{ 0x33, 0x90, 0x00, 0x01 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x34, 0xce, 0x81, 0x60 },
		{ 0x34, 0xd0, 0x66, 0x33 },
		{ 0x34, 0xd2, 0x31, 0x9a },
		{ 0x34, 0xd4, 0x94, 0x63 },
		{ 0x34, 0xd6, 0x4b, 0x25 },
		{ 0x34, 0xd8, 0x26, 0x70 },
		{ 0x34, 0xda, 0x72, 0x4c },
		{ 0x34, 0xdc, 0xff, 0x04 },
		{ 0x34, 0xde, 0x00, 0xf4 },
		{ 0x34, 0xe6, 0x00, 0xcc },
		{ 0x34, 0xee, 0x0e, 0x42 },
		{ 0x34, 0xf6, 0x0d, 0xb5 },
		{ 0x35, 0x00, 0x0a, 0xfa },
		{ 0x35, 0x08, 0x0f, 0x10 },
		{ 0x35, 0x10, 0x11, 0x22 },
		{ 0x35, 0x18, 0x0c, 0x28 },
		{ 0x35, 0x20, 0x1c, 0x2c },
		{ 0x35, 0x28, 0x17, 0x40 },
		{ 0x35, 0x30, 0x08, 0xf2 },
		{ 0x35, 0x38, 0xfb, 0xd5 },
		{ 0x35, 0x4c, 0x05, 0xc7 },
		{ 0x35, 0x44, 0x04, 0xf9 },
		{ 0x35, 0x5c, 0x05, 0xd0 },
		{ 0x35, 0x54, 0x05, 0xf4 },
		{ 0x34, 0xe0, 0x01, 0x05 },
		{ 0x34, 0xe8, 0x00, 0xa0 },
		{ 0x34, 0xf0, 0x0e, 0xa1 },
		{ 0x34, 0xf8, 0x0e, 0x01 },
		{ 0x35, 0x02, 0x0f, 0xeb },
		{ 0x35, 0x0a, 0x09, 0x0a },
		{ 0x35, 0x12, 0x10, 0x1e },
		{ 0x35, 0x1a, 0x08, 0x23 },
		{ 0x35, 0x22, 0x1c, 0x22 },
		{ 0x35, 0x2a, 0x07, 0x22 },
		{ 0x35, 0x32, 0x0b, 0x06 },
		{ 0x35, 0x3a, 0xf9, 0x16 },
		{ 0x35, 0x4e, 0x05, 0x9f },
		{ 0x35, 0x46, 0x05, 0x30 },
		{ 0x35, 0x5e, 0x06, 0x75 },
		{ 0x35, 0x56, 0x06, 0x5c },
		{ 0x34, 0xe4, 0x00, 0xc5 },
		{ 0x34, 0xec, 0x00, 0x48 },
		{ 0x34, 0xf4, 0x0f, 0x66 },
		{ 0x34, 0xfc, 0x0e, 0x61 },
		{ 0x35, 0x06, 0x1b, 0xdb },
		{ 0x35, 0x0e, 0x04, 0x0a },
		{ 0x35, 0x16, 0x11, 0x13 },
		{ 0x35, 0x1e, 0x08, 0x1f },
		{ 0x35, 0x26, 0x11, 0x19 },
		{ 0x35, 0x2e, 0xf8, 0x1a },
		{ 0x35, 0x36, 0x04, 0x0c },
		{ 0x35, 0x3e, 0xfa, 0x00 },
		{ 0x35, 0x52, 0x06, 0xf1 },
		{ 0x35, 0x4a, 0x04, 0x0e },
		{ 0x35, 0x62, 0x06, 0xa1 },
		{ 0x35, 0x5a, 0x06, 0x91 },
		{ 0x34, 0xe2, 0x00, 0xd2 },
		{ 0x34, 0xea, 0x00, 0x72 },
		{ 0x34, 0xf2, 0x0e, 0x1d },
		{ 0x34, 0xfa, 0x0e, 0x06 },
		{ 0x35, 0x04, 0x13, 0x0e },
		{ 0x35, 0x0c, 0x0f, 0x0d },
		{ 0x35, 0x14, 0x13, 0x1c },
		{ 0x35, 0x1c, 0x13, 0x29 },
		{ 0x35, 0x24, 0x0d, 0x24 },
		{ 0x35, 0x2c, 0xfd, 0x29 },
		{ 0x35, 0x34, 0x07, 0xf4 },
		{ 0x35, 0x3c, 0xee, 0xe7 },
		{ 0x35, 0x50, 0x06, 0x50 },
		{ 0x35, 0x48, 0x05, 0xc1 },
		{ 0x35, 0x60, 0x06, 0x11 },
		{ 0x35, 0x58, 0x06, 0x58 },
		{ 0x35, 0x40, 0x00, 0x00 },
		{ 0x35, 0x42, 0x00, 0x00 },
		{ 0x32, 0x10, 0x01, 0xfc },
		{ 0x33, 0x8c, 0xa3, 0x52 },
		{ 0x33, 0x90, 0x00, 0x3c },
		{ 0x33, 0x8c, 0xa1, 0x18 },
		{ 0x33, 0x90, 0x00, 0x3c },
		{ 0x33, 0x8c, 0xa1, 0x19 },
		{ 0x33, 0x90, 0x00, 0x0a },
		{ 0x33, 0x8c, 0xa7, 0x6d },
		{ 0x33, 0x90, 0x00, 0x03 },
		{ 0x33, 0x8c, 0xa7, 0x6e },
		{ 0x33, 0x90, 0x00, 0x03 },
		{ 0x33, 0x8c, 0xa7, 0x6f },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0xa7, 0x70 },
		{ 0x33, 0x90, 0x00, 0x05 },
		{ 0x33, 0x8c, 0xa7, 0x71 },
		{ 0x33, 0x90, 0x00, 0x10 },
		{ 0x33, 0x8c, 0xa7, 0x72 },
		{ 0x33, 0x90, 0x00, 0x30 },
		{ 0x33, 0x8c, 0xa7, 0x73 },
		{ 0x33, 0x90, 0x00, 0x5b },
		{ 0x33, 0x8c, 0xa7, 0x74 },
		{ 0x33, 0x90, 0x00, 0x77 },
		{ 0x33, 0x8c, 0xa7, 0x75 },
		{ 0x33, 0x90, 0x00, 0x8e },
		{ 0x33, 0x8c, 0xa7, 0x76 },
		{ 0x33, 0x90, 0x00, 0xa0 },
		{ 0x33, 0x8c, 0xa7, 0x77 },
		{ 0x33, 0x90, 0x00, 0xaf },
		{ 0x33, 0x8c, 0xa7, 0x78 },
		{ 0x33, 0x90, 0x00, 0xbc },
		{ 0x33, 0x8c, 0xa7, 0x79 },
		{ 0x33, 0x90, 0x00, 0xc7 },
		{ 0x33, 0x8c, 0xa7, 0x7a },
		{ 0x33, 0x90, 0x00, 0xd0 },
		{ 0x33, 0x8c, 0xa7, 0x7b },
		{ 0x33, 0x90, 0x00, 0xd9 },
		{ 0x33, 0x8c, 0xa7, 0x7c },
		{ 0x33, 0x90, 0x00, 0xe0 },
		{ 0x33, 0x8c, 0xa7, 0x7d },
		{ 0x33, 0x90, 0x00, 0xe8 },
		{ 0x33, 0x8c, 0xa7, 0x7e },
		{ 0x33, 0x90, 0x00, 0xee },
		{ 0x33, 0x8c, 0xa7, 0x7f },
		{ 0x33, 0x90, 0x00, 0xf4 },
		{ 0x33, 0x8c, 0xa7, 0x80 },
		{ 0x33, 0x90, 0x00, 0xfa },
		{ 0x33, 0x8c, 0xa7, 0x81 },
		{ 0x33, 0x90, 0x00, 0xff },
		{ 0x33, 0x8c, 0xa7, 0x82 },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0xa7, 0x83 },
		{ 0x33, 0x90, 0x00, 0x05 },
		{ 0x33, 0x8c, 0xa7, 0x84 },
		{ 0x33, 0x90, 0x00, 0x10 },
		{ 0x33, 0x8c, 0xa7, 0x85 },
		{ 0x33, 0x90, 0x00, 0x30 },
		{ 0x33, 0x8c, 0xa7, 0x86 },
		{ 0x33, 0x90, 0x00, 0x5b },
		{ 0x33, 0x8c, 0xa7, 0x87 },
		{ 0x33, 0x90, 0x00, 0x77 },
		{ 0x33, 0x8c, 0xa7, 0x88 },
		{ 0x33, 0x90, 0x00, 0x8e },
		{ 0x33, 0x8c, 0xa7, 0x89 },
		{ 0x33, 0x90, 0x00, 0xa0 },
		{ 0x33, 0x8c, 0xa7, 0x8a },
		{ 0x33, 0x90, 0x00, 0xaf },
		{ 0x33, 0x8c, 0xa7, 0x8b },
		{ 0x33, 0x90, 0x00, 0xbc },
		{ 0x33, 0x8c, 0xa7, 0x8c },
		{ 0x33, 0x90, 0x00, 0xc7 },
		{ 0x33, 0x8c, 0xa7, 0x8d },
		{ 0x33, 0x90, 0x00, 0xd0 },
		{ 0x33, 0x8c, 0xa7, 0x8e },
		{ 0x33, 0x90, 0x00, 0xd9 },
		{ 0x33, 0x8c, 0xa7, 0x8f },
		{ 0x33, 0x90, 0x00, 0xe0 },
		{ 0x33, 0x8c, 0xa7, 0x90 },
		{ 0x33, 0x90, 0x00, 0xe8 },
		{ 0x33, 0x8c, 0xa7, 0x91 },
		{ 0x33, 0x90, 0x00, 0xee },
		{ 0x33, 0x8c, 0xa7, 0x92 },
		{ 0x33, 0x90, 0x00, 0xf4 },
		{ 0x33, 0x8c, 0xa7, 0x93 },
		{ 0x33, 0x90, 0x00, 0xfa },
		{ 0x33, 0x8c, 0xa7, 0x94 },
		{ 0x33, 0x90, 0x00, 0xff },
		{ 0x33, 0x8c, 0xa1, 0x03 },
		{ 0x33, 0x90, 0x00, 0x05 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x33, 0x8c, 0xa2, 0x06 },
		{ 0x33, 0x90, 0x00, 0x50 },
		{ 0x33, 0x8c, 0x27, 0x03 },
		{ 0x33, 0x90, 0x02, 0x82 },
		{ 0x33, 0x8c, 0x27, 0x05 },
		{ 0x33, 0x90, 0x01, 0xe2 },
		{ 0x33, 0x8c, 0x27, 0x07 },
		{ 0x33, 0x90, 0x05, 0x02 },
		{ 0x33, 0x8c, 0x27, 0x09 },
		{ 0x33, 0x90, 0x04, 0x02 },
		{ 0x33, 0x8c, 0x27, 0x0d },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0x27, 0x0f },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0x27, 0x11 },
		{ 0x33, 0x90, 0x04, 0xbd },
		{ 0x33, 0x8c, 0x27, 0x13 },
		{ 0x33, 0x90, 0x06, 0x4d },
		{ 0x33, 0x8c, 0x27, 0x15 },
		{ 0x33, 0x90, 0x04, 0x00 },
		{ 0x33, 0x8c, 0x27, 0x17 },
		{ 0x33, 0x90, 0x21, 0x11 },
		{ 0x33, 0x8c, 0x27, 0x19 },
		{ 0x33, 0x90, 0x04, 0x6c },
		{ 0x33, 0x8c, 0x27, 0x1b },
		{ 0x33, 0x90, 0x02, 0x4f },
		{ 0x33, 0x8c, 0x27, 0x1d },
		{ 0x33, 0x90, 0x01, 0x02 },
		{ 0x33, 0x8c, 0x27, 0x1f },
		{ 0x33, 0x90, 0x02, 0x79 },
		{ 0x33, 0x8c, 0x27, 0x21 },
		{ 0x33, 0x90, 0x01, 0x55 },
		{ 0x33, 0x8c, 0x27, 0x23 },
		{ 0x33, 0x90, 0x03, 0x5b },
		{ 0x33, 0x8c, 0x27, 0x25 },
		{ 0x33, 0x90, 0x06, 0x0f },
		{ 0x33, 0x8c, 0x27, 0x27 },
		{ 0x33, 0x90, 0x20, 0x20 },
		{ 0x33, 0x8c, 0x27, 0x29 },
		{ 0x33, 0x90, 0x20, 0x20 },
		{ 0x33, 0x8c, 0x27, 0x2b },
		{ 0x33, 0x90, 0x10, 0x20 },
		{ 0x33, 0x8c, 0x27, 0x2d },
		{ 0x33, 0x90, 0x20, 0x07 },
		{ 0x33, 0x8c, 0x27, 0x2f },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0x27, 0x31 },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0x27, 0x33 },
		{ 0x33, 0x90, 0x04, 0xbb },
		{ 0x33, 0x8c, 0x27, 0x35 },
		{ 0x33, 0x90, 0x06, 0x4b },
		{ 0x33, 0x8c, 0x27, 0x37 },
		{ 0x33, 0x90, 0x04, 0xce },
		{ 0x33, 0x8c, 0x27, 0x39 },
		{ 0x33, 0x90, 0x21, 0x11 },
		{ 0x33, 0x8c, 0x27, 0x3b },
		{ 0x33, 0x90, 0x00, 0x24 },
		{ 0x33, 0x8c, 0x27, 0x3d },
		{ 0x33, 0x90, 0x01, 0x20 },
		{ 0x33, 0x8c, 0x27, 0x41 },
		{ 0x33, 0x90, 0x01, 0x69 },
		{ 0x33, 0x8c, 0x27, 0x45 },
		{ 0x33, 0x90, 0x04, 0xff },
		{ 0x33, 0x8c, 0x27, 0x47 },
		{ 0x33, 0x90, 0x08, 0x24 },
		{ 0x33, 0x8c, 0x27, 0x51 },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0x27, 0x53 },
		{ 0x33, 0x90, 0x03, 0x20 },
		{ 0x33, 0x8c, 0x27, 0x55 },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0x27, 0x57 },
		{ 0x33, 0x90, 0x02, 0x58 },
		{ 0x33, 0x8c, 0x27, 0x5f },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0x27, 0x61 },
		{ 0x33, 0x90, 0x06, 0x40 },
		{ 0x33, 0x8c, 0x27, 0x63 },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0x27, 0x65 },
		{ 0x33, 0x90, 0x04, 0xb0 },
		{ 0x33, 0x8c, 0x22, 0x2e },
		{ 0x33, 0x90, 0x00, 0xd7 },
		{ 0x33, 0x8c, 0xa4, 0x08 },
		{ 0x33, 0x90, 0x00, 0x2a },
		{ 0x33, 0x8c, 0xa4, 0x09 },
		{ 0x33, 0x90, 0x00, 0x2c },
		{ 0x33, 0x8c, 0xa4, 0x0a },
		{ 0x33, 0x90, 0x00, 0x32 },
		{ 0x33, 0x8c, 0xa4, 0x0b },
		{ 0x33, 0x90, 0x00, 0x34 },
		{ 0x33, 0x8c, 0x24, 0x11 },
		{ 0x33, 0x90, 0x00, 0xd7 },
		{ 0x33, 0x8c, 0x24, 0x13 },
		{ 0x33, 0x90, 0x01, 0x02 },
		{ 0x33, 0x8c, 0x24, 0x15 },
		{ 0x33, 0x90, 0x00, 0xa0 },
		{ 0x33, 0x8c, 0x24, 0x17 },
		{ 0x33, 0x90, 0x00, 0xc0 },
		{ 0x33, 0x8c, 0x27, 0x99 },
		{ 0x33, 0x90, 0x64, 0x08 },
		{ 0x33, 0x8c, 0x27, 0x9b },
		{ 0x33, 0x90, 0x64, 0x08 },
		{ 0x33, 0x8c, 0xa2, 0x0c },
		{ 0x33, 0x90, 0x00, 0x18 },
		{ 0x33, 0x8c, 0xa2, 0x14 },
		{ 0x33, 0x90, 0x00, 0x24 },
		{ 0x33, 0x8c, 0xa2, 0x15 },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0xa2, 0x0d },
		{ 0x33, 0x90, 0x00, 0x30 },
		{ 0x33, 0x8c, 0xa2, 0x0e },
		{ 0x33, 0x90, 0x00, 0x80 },
		{ 0x33, 0x8c, 0xa1, 0x03 },
		{ 0x33, 0x90, 0x00, 0x05 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x33, 0x8c, 0xa1, 0x03 },
		{ 0x33, 0x90, 0x00, 0x06 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x33, 0x8c, 0xa1, 0x30 },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0xa1, 0x15 },
		{ 0x33, 0x90, 0x00, 0xef },
		{ 0x33, 0x8c, 0xa1, 0x16 },
		{ 0x33, 0x90, 0x00, 0x30 },
		{ 0x33, 0x8c, 0xa1, 0x17 },
		{ 0x33, 0x90, 0x00, 0x55 },
		{ 0x33, 0x8c, 0xa1, 0x18 },
		{ 0x33, 0x90, 0x00, 0x5a },
		{ 0x33, 0x8c, 0xa1, 0x19 },
		{ 0x33, 0x90, 0x00, 0x28 },
		{ 0x33, 0x8c, 0xa1, 0x1a },
		{ 0x33, 0x90, 0x00, 0x08 },
		{ 0x33, 0x8c, 0xa1, 0x1b },
		{ 0x33, 0x90, 0x00, 0x1e },
		{ 0x33, 0x8c, 0xa1, 0x1c },
		{ 0x33, 0x90, 0x00, 0x02 },
		{ 0x33, 0x8c, 0xa1, 0x1d },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0xa1, 0x1e },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0xa1, 0x1f },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0xab, 0x05 },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0xa7, 0x6d },
		{ 0x33, 0x90, 0x00, 0x03 },
		{ 0x33, 0x8c, 0xa7, 0x6e },
		{ 0x33, 0x90, 0x00, 0x03 },
		{ 0x33, 0x8c, 0xa7, 0x6f },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0xa7, 0x70 },
		{ 0x33, 0x90, 0x00, 0x15 },
		{ 0x33, 0x8c, 0xa7, 0x71 },
		{ 0x33, 0x90, 0x00, 0x25 },
		{ 0x33, 0x8c, 0xa7, 0x72 },
		{ 0x33, 0x90, 0x00, 0x3f },
		{ 0x33, 0x8c, 0xa7, 0x73 },
		{ 0x33, 0x90, 0x00, 0x64 },
		{ 0x33, 0x8c, 0xa7, 0x74 },
		{ 0x33, 0x90, 0x00, 0x80 },
		{ 0x33, 0x8c, 0xa7, 0x75 },
		{ 0x33, 0x90, 0x00, 0x97 },
		{ 0x33, 0x8c, 0xa7, 0x76 },
		{ 0x33, 0x90, 0x00, 0xa9 },
		{ 0x33, 0x8c, 0xa7, 0x77 },
		{ 0x33, 0x90, 0x00, 0xba },
		{ 0x33, 0x8c, 0xa7, 0x78 },
		{ 0x33, 0x90, 0x00, 0xc7 },
		{ 0x33, 0x8c, 0xa7, 0x79 },
		{ 0x33, 0x90, 0x00, 0xd2 },
		{ 0x33, 0x8c, 0xa7, 0x7a },
		{ 0x33, 0x90, 0x00, 0xdc },
		{ 0x33, 0x8c, 0xa7, 0x7b },
		{ 0x33, 0x90, 0x00, 0xe4 },
		{ 0x33, 0x8c, 0xa7, 0x7c },
		{ 0x33, 0x90, 0x00, 0xea },
		{ 0x33, 0x8c, 0xa7, 0x7d },
		{ 0x33, 0x90, 0x00, 0xf0 },
		{ 0x33, 0x8c, 0xa7, 0x7e },
		{ 0x33, 0x90, 0x00, 0xf4 },
		{ 0x33, 0x8c, 0xa7, 0x7f },
		{ 0x33, 0x90, 0x00, 0xf8 },
		{ 0x33, 0x8c, 0xa7, 0x80 },
		{ 0x33, 0x90, 0x00, 0xfc },
		{ 0x33, 0x8c, 0xa7, 0x81 },
		{ 0x33, 0x90, 0x00, 0xff },
		{ 0x33, 0x8c, 0xa7, 0x82 },
		{ 0x33, 0x90, 0x00, 0x00 },
		{ 0x33, 0x8c, 0xa7, 0x83 },
		{ 0x33, 0x90, 0x00, 0x15 },
		{ 0x33, 0x8c, 0xa7, 0x84 },
		{ 0x33, 0x90, 0x00, 0x25 },
		{ 0x33, 0x8c, 0xa7, 0x85 },
		{ 0x33, 0x90, 0x00, 0x3f },
		{ 0x33, 0x8c, 0xa7, 0x86 },
		{ 0x33, 0x90, 0x00, 0x64 },
		{ 0x33, 0x8c, 0xa7, 0x87 },
		{ 0x33, 0x90, 0x00, 0x80 },
		{ 0x33, 0x8c, 0xa7, 0x88 },
		{ 0x33, 0x90, 0x00, 0x97 },
		{ 0x33, 0x8c, 0xa7, 0x89 },
		{ 0x33, 0x90, 0x00, 0xa9 },
		{ 0x33, 0x8c, 0xa7, 0x8a },
		{ 0x33, 0x90, 0x00, 0xba },
		{ 0x33, 0x8c, 0xa7, 0x8b },
		{ 0x33, 0x90, 0x00, 0xc7 },
		{ 0x33, 0x8c, 0xa7, 0x8c },
		{ 0x33, 0x90, 0x00, 0xd2 },
		{ 0x33, 0x8c, 0xa7, 0x8d },
		{ 0x33, 0x90, 0x00, 0xdc },
		{ 0x33, 0x8c, 0xa7, 0x8e },
		{ 0x33, 0x90, 0x00, 0xe4 },
		{ 0x33, 0x8c, 0xa7, 0x8f },
		{ 0x33, 0x90, 0x00, 0xea },
		{ 0x33, 0x8c, 0xa7, 0x90 },
		{ 0x33, 0x90, 0x00, 0xf0 },
		{ 0x33, 0x8c, 0xa7, 0x91 },
		{ 0x33, 0x90, 0x00, 0xf4 },
		{ 0x33, 0x8c, 0xa7, 0x92 },
		{ 0x33, 0x90, 0x00, 0xf8 },
		{ 0x33, 0x8c, 0xa7, 0x93 },
		{ 0x33, 0x90, 0x00, 0xfc },
		{ 0x33, 0x8c, 0xa7, 0x94 },
		{ 0x33, 0x90, 0x00, 0xff },
		{ 0x33, 0x8c, 0xa1, 0x03 },
		{ 0x33, 0x90, 0x00, 0x06 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x35, 0xa4, 0x05, 0x96 },
		{ 0x33, 0x8c, 0xa1, 0x18 },
		{ 0x33, 0x90, 0x00, 0x1e },
		{ 0x33, 0x8c, 0xa1, 0x19 },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0xa1, 0x1a },
		{ 0x33, 0x90, 0x00, 0x0a },
		{ 0x33, 0x8c, 0xa1, 0x1b },
		{ 0x33, 0x90, 0x00, 0x20 },
		{ 0x33, 0x8c, 0xa1, 0x3e },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0xa1, 0x3f },
		{ 0x33, 0x90, 0x00, 0x0e },
		{ 0x33, 0x8c, 0xa1, 0x40 },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0xa1, 0x41 },
		{ 0x33, 0x90, 0x00, 0x04 },
		{ 0x33, 0x8c, 0xa1, 0x42 },
		{ 0x33, 0x90, 0x00, 0x32 },
		{ 0x33, 0x8c, 0xa1, 0x43 },
		{ 0x33, 0x90, 0x00, 0x0f },
		{ 0x33, 0x8c, 0xa1, 0x44 },
		{ 0x33, 0x90, 0x00, 0x32 },
		{ 0x33, 0x8c, 0xa1, 0x45 },
		{ 0x33, 0x90, 0x00, 0x32 },
		{ 0x33, 0x8c, 0xa1, 0x46 },
		{ 0x33, 0x90, 0x00, 0x05 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x33, 0x8c, 0xa1, 0x47 },
		{ 0x33, 0x90, 0x00, 0x3a },
		{ 0x33, 0x8c, 0x27, 0x95 },
		{ 0x33, 0x90, 0x01, 0x00 },
		{ 0x33, 0x8c, 0xa1, 0x03 },
		{ 0x33, 0x90, 0x00, 0x05 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x33, 0x8c, 0x27, 0x97 },
		{ 0x33, 0x90, 0x01, 0x00 },
		{ 0x33, 0x8c, 0xa1, 0x03 },
		{ 0x33, 0x90, 0x00, 0x05 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90, -1 },
		{ 0x33, 0x8c, 0xa4, 0x04 },
		{ 0x33, 0x90, 0x00, 0x80 },
		{ 0x33, 0x8c, 0xa1, 0x03 },
		{ 0x33, 0x90, 0x00, 0x05 },
		{ 0x33, 0x8c, 0xa1, 0x04 },
		{ 0x33, 0x90 }
	};


	asize = ARRAY_SIZE(values_205);

	for(i=0; i<asize; i++) {
		usb_stk11xx_read_registry(dev, 0x02ff, &value);
		usb_stk11xx_write_registry(dev, 0x02ff, 0x0001);

		usb_stk11xx_write_registry(dev, 0x0205, values_205[i][0]);
		usb_stk11xx_write_registry(dev, 0x0205, values_205[i][1]);

		if (values_205[i][2] == -1) {
			usb_stk11xx_write_registry(dev, 0x0200, 0x0061);

			retok = dev_stk11xx_check_device(dev, 500);

			usb_stk11xx_read_registry(dev, 0x0209, &value);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0020);

			retok = dev_stk11xx_check_device(dev, 500);

			usb_stk11xx_read_registry(dev, 0x0209, &value);
		}
		else {
			usb_stk11xx_write_registry(dev, 0x0205, values_205[i][2]);
			usb_stk11xx_write_registry(dev, 0x0205, values_205[i][3]);
			usb_stk11xx_write_registry(dev, 0x0200, 0x0001);

			retok = dev_stk11xx_check_device(dev, 500);
		}

		usb_stk11xx_write_registry(dev, 0x02ff, 0x0001);
	}

	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief This function permits to modify the settings of the camera.
 *
 * This functions permits to modify the settings :
 *   - brightness
 *   - contrast
 *   - white balance
 *   - ...
 */
int dev_stk6a51_camera_settings(struct usb_stk11xx *dev)
{
	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief This function permits to modify the settings of the camera.
 *
 * This functions permits to modify the settings :
 *   - brightness
 *   - contrast
 *   - white balance
 *   - ...
 */
int dev_stk6a51_set_camera_quality(struct usb_stk11xx *dev)
{
	int ret;
	int value;

	// Contrast register
	usb_stk11xx_read_registry(dev, 0x02ff, &value);
	usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

	usb_stk11xx_write_registry(dev, 0x0204, 0x00b3);
	usb_stk11xx_write_registry(dev, 0x0205, (dev->vsettings.contrast >> 8));

	usb_stk11xx_write_registry(dev, 0x0200, 0x0001);
	ret = dev_stk11xx_check_device(dev, 500);
	usb_stk11xx_write_registry(dev, 0x02ff, 0x0000);

	STK_DEBUG("Set colour : %d\n", dev->vsettings.colour);
	STK_DEBUG("Set contrast : %d\n", dev->vsettings.contrast);
	STK_DEBUG("Set whiteness : %d\n", dev->vsettings.whiteness);
	STK_DEBUG("Set brightness : %d\n", dev->vsettings.brightness);

	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief This function permits to modify the settings of the camera.
 *
 * This functions permits to modify the frame rate per second.
 */
int dev_stk6a51_set_camera_fps(struct usb_stk11xx *dev)
{
	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief This function sets the device to start the stream.
 *
 * After the initialization of the device and the initialization of the video stream,
 * this function permits to enable the stream.
 */
int dev_stk6a51_start_stream(struct usb_stk11xx *dev)
{
	int value;
	int value_116, value_117;

	usb_stk11xx_read_registry(dev, 0x0116, &value_116);
	usb_stk11xx_read_registry(dev, 0x0117, &value_117);

	usb_stk11xx_write_registry(dev, 0x0116, 0x0000);
	usb_stk11xx_write_registry(dev, 0x0117, 0x0000);

	usb_stk11xx_read_registry(dev, 0x0100, &value); // read 0x21
	usb_stk11xx_write_registry(dev, 0x0100, 0x00a0);

	usb_stk11xx_write_registry(dev, 0x0116, value_116);
	usb_stk11xx_write_registry(dev, 0x0117, value_117);

	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief Reconfigure the camera before the stream.
 *
 * Before enabling the video stream, you have to reconfigure the device.
 */
int dev_stk6a51_reconf_camera(struct usb_stk11xx *dev)
{
	dev_stk6a51_configure_device(dev, 19);

	dev_stk11xx_camera_settings(dev);

	return 0;
}


/** 
 * @param dev Device structure
 * 
 * @returns 0 if all is OK
 *
 * @brief This function sets the device to stop the stream.
 *
 * You use the function start_stream to enable the video stream. So you
 * have to use the function stop_strem to disable the video stream.
 */
int dev_stk6a51_stop_stream(struct usb_stk11xx *dev)
{
	return 0;
}

