/* -*- Mode: C; tab-width: 5; indent-tabs-mode: t; c-basic-offset: 5 -*- */

#ifndef NM_CDMA_MODEM_H
#define NM_CDMA_MODEM_H

#include <nm-modem-device.h>

G_BEGIN_DECLS

#define NM_TYPE_CDMA_MODEM            (nm_cdma_modem_get_type ())
#define NM_CDMA_MODEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_TYPE_CDMA_MODEM, NMCdmaModem))
#define NM_CDMA_MODEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  NM_TYPE_CDMA_MODEM, NMCdmaModemClass))
#define NM_IS_CDMA_MODEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_TYPE_CDMA_MODEM))
#define NM_IS_CDMA_MODEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  NM_TYPE_CDMA_MODEM))
#define NM_CDMA_MODEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  NM_TYPE_CDMA_MODEM, NMCdmaModemClass))

typedef struct {
	NMModemDevice parent;
} NMCdmaModem;

typedef struct {
	NMModemDeviceClass parent;

	/* Signals */
	void (*signal_quality) (NMCdmaModem *modem, guint32 quality);
} NMCdmaModemClass;

GType nm_cdma_modem_get_type (void);

NMDevice *nm_cdma_modem_new (const char *path,
					    const char *data_device,
					    const char *driver);

G_END_DECLS

#endif /* NM_CDMA_MODEM_H */
