/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tp_RegressionOptions.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ihi $ $Date: 2007/11/23 11:49:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"

#include "tp_RegressionOptions.hxx"
#include "tp_RegressionOptions.hrc"
#include "ResId.hxx"
#include "chartview/ChartSfxItemIds.hxx"

// for SfxBoolItem
#include <svtools/eitem.hxx>

namespace chart
{

RegressionOptionsTabPage::RegressionOptionsTabPage(
    Window* pWindow, const SfxItemSet& rInAttrs ) :
        SfxTabPage( pWindow, SchResId( TP_REGRESSION_OPTIONS ), rInAttrs ),
        m_aCbxEquation( this, SchResId( CBX_SHOW_EQUATION )),
        m_aCbxCorrelationCoeff( this, SchResId( CBX_SHOW_CORRELATION_COEFF ))
//         m_aFlSeparator( this, SchResId( FL_SEPARATOR )),
//         m_aRbtNewline( this, SchResId( RBT_SEP_NEWLINE  )),
//         m_aRbtSemicolon( this, SchResId( RBT_SEP_SEMICOLON )),
//         m_aRbtComma( this, SchResId( RBT_SEP_COMMA )),
//         m_aRbtSlash( this, SchResId( RBT_SEP_SLASH ))
{
    FreeResource();

    m_aCbxEquation.SetToggleHdl( LINK( this, RegressionOptionsTabPage, DisplayOptionChecked ));
    m_aCbxCorrelationCoeff.SetToggleHdl( LINK( this, RegressionOptionsTabPage, DisplayOptionChecked ));

//     m_aRbtNewline.Check();
}

RegressionOptionsTabPage::~RegressionOptionsTabPage()
{}

SfxTabPage* RegressionOptionsTabPage::Create( Window* pWindow,const SfxItemSet& rOutAttrs )
{
	return new RegressionOptionsTabPage( pWindow, rOutAttrs );
}

BOOL RegressionOptionsTabPage::FillItemSet( SfxItemSet& rOutAttrs )
{
    rOutAttrs.Put( SfxBoolItem( SCHATTR_REGRESSION_SHOW_EQUATION, m_aCbxEquation.IsChecked()));
    rOutAttrs.Put( SfxBoolItem( SCHATTR_REGRESSION_SHOW_COEFF, m_aCbxCorrelationCoeff.IsChecked()));
    return TRUE;
}

void RegressionOptionsTabPage::Reset( const SfxItemSet& rInAttrs )
{
    const SfxBoolItem * pItem = dynamic_cast< const SfxBoolItem * >( rInAttrs.GetItem( SCHATTR_REGRESSION_SHOW_EQUATION ));
    if( pItem )
        m_aCbxEquation.Check( pItem->GetValue());

    pItem = dynamic_cast< const SfxBoolItem * >( rInAttrs.GetItem( SCHATTR_REGRESSION_SHOW_COEFF ));
    if( pItem )
        m_aCbxCorrelationCoeff.Check( pItem->GetValue());

    DisplayOptionChecked( 0 );
}

IMPL_LINK( RegressionOptionsTabPage, DisplayOptionChecked, CheckBox *, EMPTYARG )
{
//     bool bEnableSeparators = ( m_aCbxEquation.IsChecked() && m_aCbxCorrelationCoeff.IsChecked());

//     m_aRbtNewline.Enable( bEnableSeparators );
//     m_aRbtSemicolon.Enable( bEnableSeparators );
//     m_aRbtComma.Enable( bEnableSeparators );
//     m_aRbtSlash.Enable( bEnableSeparators );

    return 0;
}

} //  namespace chart
